/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.check.impl;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.CRCondition;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.orm.query.QFilter;
import kd.fi.arapcommon.check.base.AbnormalBillInfo;
import kd.fi.arapcommon.check.interf.AbstractDataCheckService;
import kd.fi.arapcommon.check.param.DataCheckTaskParam;
import kd.fi.arapcommon.util.StringUtils;

public class CustomCheckDefaultService
extends AbstractDataCheckService {
    @Override
    protected List<AbnormalBillInfo> doCheck(DataCheckTaskParam param, List<Long> idList) {
        ArrayList<AbnormalBillInfo> abnormalBillList = new ArrayList<AbnormalBillInfo>(idList.size());
        String customTip = param.getCustomTip();
        for (Long id : idList) {
            AbnormalBillInfo billInfo = new AbnormalBillInfo(id, "", param.getEntity(), customTip);
            abnormalBillList.add(billInfo);
        }
        return abnormalBillList;
    }

    @Override
    protected QFilter getFilter(DataCheckTaskParam param) {
        QFilter filter = super.getFilter(param);
        String customFilterJson = param.getCustomFilterDesc();
        if (StringUtils.isNotEmpty(customFilterJson)) {
            CRCondition formula = (CRCondition)SerializationUtils.fromJsonString((String)customFilterJson, CRCondition.class);
            FilterCondition filterCondition = formula.getFilterCondition();
            MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)param.getEntity());
            FilterBuilder filterBuilder = new FilterBuilder(dataEntityType, filterCondition, true);
            filterBuilder.buildFilter(false);
            QFilter customFilter = filterBuilder.getQFilter();
            filter = filter.and(customFilter);
        }
        return filter;
    }
}

