/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.check.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.arapcommon.check.base.AbnormalBillInfo;
import kd.fi.arapcommon.check.helper.FinArBillCheckHelper;
import kd.fi.arapcommon.check.interf.AbstractDataCheckService;
import kd.fi.arapcommon.check.param.DataCheckTaskParam;
import kd.fi.arapcommon.exception.AmountCheckExecption;
import kd.fi.arapcommon.helper.ArApHelper;

public class FinArLockAndSettleFieldCheckService
extends AbstractDataCheckService {
    @Override
    protected List<AbnormalBillInfo> doCheck(DataCheckTaskParam param, List<Long> idList) {
        ArrayList<AbnormalBillInfo> abnormalBillList = new ArrayList<AbnormalBillInfo>(10);
        DynamicObject[] bills = BusinessDataServiceHelper.load((String)"ar_finarbill", (String)"billno,org,recamount,unsettleamount,settleamount,settlestatus,e_recamount,e_lockedamt,e_unlockamt,e_settledamt,e_unsettleamt,planpricetax,planlockedamt,unplanlockamt,plansettledamt,unplansettleamt", (QFilter[])new QFilter[]{new QFilter("id", "in", idList)});
        HashMap<Long, Integer> arSettleParamMap = new HashMap<Long, Integer>(8);
        for (DynamicObject bill : bills) {
            try {
                Long orgId = bill.getLong("org.id");
                int arSettleParam = 0;
                if (ObjectUtils.isEmpty(arSettleParamMap.get(orgId))) {
                    arSettleParam = ArApHelper.getArSettleParam(orgId);
                    arSettleParamMap.put(orgId, arSettleParam);
                } else {
                    arSettleParam = (Integer)arSettleParamMap.get(orgId);
                }
                FinArBillCheckHelper.checkLockAndSettleField(bill, arSettleParam);
            }
            catch (AmountCheckExecption e) {
                AbnormalBillInfo billInfo = new AbnormalBillInfo(bill.getLong("id"), bill.getString("billno"), param.getEntity(), e.getMessage());
                abnormalBillList.add(billInfo);
            }
        }
        return abnormalBillList;
    }
}

