/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.check.impl;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.arapcommon.check.base.AbnormalBillInfo;
import kd.fi.arapcommon.check.helper.PayApplyBillCheckHelper;
import kd.fi.arapcommon.check.interf.AbstractDataCheckService;
import kd.fi.arapcommon.check.param.DataCheckTaskParam;
import kd.fi.arapcommon.exception.AmountCheckExecption;

public class PayApplyAmountFieldCheckService
extends AbstractDataCheckService {
    @Override
    protected List<AbnormalBillInfo> doCheck(DataCheckTaskParam param, List<Long> idList) {
        DynamicObject[] bills;
        ArrayList<AbnormalBillInfo> abnormalBillList = new ArrayList<AbnormalBillInfo>(10);
        for (DynamicObject bill : bills = BusinessDataServiceHelper.load((String)"ap_payapply", (String)"billno,applyamount,approvalamount,e_payamount,paycurrency,settlecurrency,e_applyamount,e_approvedamt,e_paidamt,lockedamt,e_approvedseleamt", (QFilter[])new QFilter[]{new QFilter("id", "in", idList)})) {
            try {
                PayApplyBillCheckHelper.checkAmountField(bill);
            }
            catch (AmountCheckExecption e) {
                AbnormalBillInfo billInfo = new AbnormalBillInfo(bill.getLong("id"), bill.getString("billno"), param.getEntity(), e.getMessage());
                abnormalBillList.add(billInfo);
            }
        }
        return abnormalBillList;
    }

    @Override
    protected QFilter getFilter(DataCheckTaskParam param) {
        long orgId = param.getOrgId();
        Date beginDate = param.getBeginDate();
        Date endDate = param.getEndDate();
        QFilter filter = new QFilter("settleorg", "=", (Object)orgId);
        filter.and("applydate", ">=", (Object)beginDate);
        filter.and("applydate", "<=", (Object)endDate);
        return filter;
    }
}

