/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.check.interf;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.arapcommon.check.base.AbnormalBillInfo;
import kd.fi.arapcommon.check.interf.AbstractDataCheckService;
import kd.fi.arapcommon.check.param.DataCheckTaskParam;
import kd.fi.arapcommon.util.DataSetUtils;

public abstract class AbstractBillSettleAmtCheckService
extends AbstractDataCheckService {
    @Override
    protected List<AbnormalBillInfo> doCheck(DataCheckTaskParam param, List<Long> idList) {
        ArrayList<AbnormalBillInfo> abnormalBillList = new ArrayList<AbnormalBillInfo>(10);
        Map<Long, BigDecimal> entrySettleMap = this.getEntrySettleMap(param, idList);
        DataSet billEntryDataSet = QueryServiceHelper.queryDataSet((String)"doCheck-querybill", (String)param.getEntity(), (String)String.join((CharSequence)",", this.getSelector()), (QFilter[])new QFilter[]{new QFilter("id", "in", idList)}, (String)"");
        HashSet<Long> abnormalIdSet = new HashSet<Long>(8);
        Set<Long> keySet = entrySettleMap.keySet();
        for (Row row : billEntryDataSet) {
            BigDecimal settleRecordAmt;
            Long id = row.getLong("id");
            String billno = row.getString("billno");
            Long entryid = row.getLong("entryid");
            if (0L == entryid) continue;
            BigDecimal entrySettleAmt = row.getBigDecimal("entrysettleamt");
            if (entrySettleAmt.compareTo(settleRecordAmt = keySet.contains(entryid) ? entrySettleMap.get(entryid) : BigDecimal.ZERO) == 0 || !abnormalIdSet.add(id)) continue;
            AbnormalBillInfo billInfo = new AbnormalBillInfo(id, billno, param.getEntity(), ResManager.loadKDString((String)"\u5206\u5f55\u5df2\u7ed3\u7b97\u91d1\u989d\u4e0e\u7ed3\u7b97\u8bb0\u5f55\u7edf\u8ba1\u7684\u7ed3\u7b97\u91d1\u989d\u4e0d\u76f8\u7b49\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"AbstractBillSettleAmtCheckService_0", (String)"fi-arapcommon", (Object[])new Object[0]));
            abnormalBillList.add(billInfo);
        }
        return abnormalBillList;
    }

    protected Map<Long, BigDecimal> getEntrySettleMap(DataCheckTaskParam param, List<Long> idList) {
        DataSet mainDataSet = QueryServiceHelper.queryDataSet((String)"doCheck-main", (String)"ap_settlerecord", (String)"mainbillid billid,mainbillentryid billentryid,totalsettleamt settleamt", (QFilter[])new QFilter[]{new QFilter("mainbillid", "in", idList)}, (String)"");
        DataSet asstDataSet = QueryServiceHelper.queryDataSet((String)"doCheck-asst", (String)"ap_settlerecord", (String)"entry.billid billid,entry.billentryid billentryid,entry.settleamt settleamt", (QFilter[])new QFilter[]{new QFilter("entry.billid", "in", idList), new QFilter("org", "=", (Object)param.getOrgId()), new QFilter("settlerelation", "not in", (Object)new Object[]{"paytrans", "transwar", "artransfer", "artranswar"})}, (String)"");
        DataSet settleDataDataSet = DataSetUtils.union(mainDataSet, asstDataSet);
        DataSet settleGroupDataSet = settleDataDataSet.groupBy(new String[]{"billid", "billentryid"}).sum("settleamt").finish();
        HashMap<Long, BigDecimal> entrySettleMap = new HashMap<Long, BigDecimal>(8);
        for (Row row : settleGroupDataSet) {
            Long billEntryid = row.getLong("billentryid");
            BigDecimal entrySettleAmt = (BigDecimal)entrySettleMap.get(billEntryid);
            entrySettleAmt = entrySettleAmt == null ? row.getBigDecimal("settleamt") : entrySettleAmt.add(row.getBigDecimal("settleamt"));
            entrySettleMap.put(billEntryid, entrySettleAmt);
        }
        return entrySettleMap;
    }

    public abstract List<String> getSelector();
}

