/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.config;

import kd.bos.algo.DataSet;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.arapcommon.consts.DBRouteConst;
import org.apache.commons.lang3.StringUtils;

public class CustomConfigUtil {
    private static DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("arapcustomConfigCache");
    private static final Log logger = LogFactory.getLog(CustomConfigUtil.class);
    private static final String CUSTOM_CACHE_PREFIX = "arapcustomConfigCache::";

    public static String get(String key) {
        String result = null;
        try {
            String value = (String)cache.get(CUSTOM_CACHE_PREFIX + key);
            if (StringUtils.isNotEmpty((CharSequence)value)) {
                result = value;
            } else {
                DataSet dataSet = DB.queryDataSet((String)"CustomConfigUtil.get", (DBRoute)DBRouteConst.AP, (String)"select fvalue from t_arap_customconfig where fkey = ?", (Object[])new Object[]{key});
                String dbValue = dataSet.next().getString("fvalue");
                if (StringUtils.isNotEmpty((CharSequence)dbValue)) {
                    result = dbValue;
                    cache.put(CUSTOM_CACHE_PREFIX + key, (Object)dbValue, 3600);
                }
                dataSet.close();
            }
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u4e32\u5e76\u884c\u6807\u5fd7\u5c5e\u6027\u51fa\u9519", (Throwable)e);
        }
        return StringUtils.trim(result);
    }
}

