/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.convert;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.ExtendedDataEntitySet;
import kd.bos.entity.botp.ConvertRuleElement;
import kd.bos.entity.botp.FieldMapItem;
import kd.bos.entity.botp.FieldMapPolicy;
import kd.bos.entity.botp.plugin.AbstractConvertPlugIn;
import kd.bos.entity.botp.plugin.args.AfterConvertEventArgs;
import kd.bos.entity.botp.plugin.args.InitVariableEventArgs;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;

public class BillToPayApplyConvertPlugin
extends AbstractConvertPlugIn {
    protected DynamicObject init = null;
    private String targetEntityNumber;

    public void initVariable(InitVariableEventArgs e) {
        this.targetEntityNumber = this.getTgtMainType().getName();
    }

    public void afterConvert(AfterConvertEventArgs e) {
        ExtendedDataEntity[] entities;
        BillEntityType srcMainType = this.getSrcMainType();
        String srcMainTypeName = srcMainType.getExtendName();
        ExtendedDataEntitySet entitySet = e.getTargetExtDataEntitySet();
        for (ExtendedDataEntity entity : entities = entitySet.FindByEntityKey(this.targetEntityNumber)) {
            DynamicObject bills = entity.getDataEntity();
            DynamicObject org = bills.getDynamicObject("settleorg");
            if (ObjectUtils.isEmpty((Object)org)) {
                return;
            }
            this.checkExRate(this.getRule(), bills);
            this.initExRate(org, "ap_init", bills, srcMainTypeName);
        }
    }

    public void checkExRate(ConvertRuleElement cre, DynamicObject targetObj) {
        BigDecimal targetExRate = (BigDecimal)targetObj.get("exchangerate");
        if (!ObjectUtils.isEmpty((Object)targetExRate) && BigDecimal.ONE.compareTo(targetExRate) == 0) {
            FieldMapPolicy fmp = cre.getFieldMapPolicy();
            List fmis = fmp.getFieldMaps();
            boolean exchangerateExist = false;
            for (FieldMapItem fmi : fmis) {
                if (!"exchangerate".equals(fmi.getTargetFieldKey())) continue;
                exchangerateExist = true;
                break;
            }
            if (!exchangerateExist) {
                targetObj.set("exchangerate", (Object)BigDecimal.ZERO);
            }
        }
    }

    public void initExRate(DynamicObject org, String entity, DynamicObject bills, String srcMainTypeName) {
        BigDecimal exchangerate;
        QFilter qFilter = new QFilter("org", "=", org.getPkValue());
        if ("ar_init".equals(entity)) {
            Object[] inits = BusinessDataServiceHelper.load((String)entity, (String)(this.getSelectors() + ", policytype.type"), (QFilter[])new QFilter[]{qFilter});
            if (!ObjectUtils.isEmpty((Object[])inits)) {
                if (inits.length == 1) {
                    this.init = inits[0];
                } else {
                    for (Object obj : inits) {
                        DynamicObject policytype = obj.getDynamicObject("policytype");
                        if (policytype == null || !"master".equals(policytype.getString("type"))) continue;
                        this.init = obj;
                    }
                    if (this.init == null) {
                        this.init = inits[0];
                    }
                }
            }
        } else {
            this.init = BusinessDataServiceHelper.loadSingle((String)entity, (String)this.getSelectors(), (QFilter[])new QFilter[]{qFilter});
        }
        if (ObjectUtils.isEmpty((Object)this.getStartDate())) {
            ErrorCode ConvertOrgNotInit = new ErrorCode("ConvertOrgNotInit", ResManager.loadKDString((String)"\u7ec4\u7ec7\u201c%1$s\u201d\u6ca1\u6709\u8fdb\u884c\u521d\u59cb\u8bbe\u7f6e\uff0c\u65e0\u6cd5\u65b0\u589e\u5355\u636e\u3002", (String)"BillToPayApplyConvertPlugin_0", (String)"fi-arapcommon", (Object[])new Object[0]));
            throw new KDBizException(ConvertOrgNotInit, new Object[]{org.getLocaleString("name").getLocaleValue()});
        }
        DynamicObject bascurrency = this.getStandardCurrency();
        bills.set("settlecurrency", (Object)bascurrency);
        DynamicObject exeatetable = null;
        if (ObjectUtils.isEmpty((Object)bills.get("exratetable"))) {
            bills.set("exratetable", (Object)this.getExrateTable());
        }
        exeatetable = bills.getDynamicObject("exratetable");
        if (ObjectUtils.isEmpty((Object)bills.get("exratedate"))) {
            bills.set("exratedate", (Object)new Date());
        }
        if (ObjectUtils.isEmpty((Object)(exchangerate = bills.getBigDecimal("exchangerate"))) || BigDecimal.ZERO.compareTo(exchangerate) == 0) {
            BigDecimal exchangeRate;
            DynamicObject currency = bills.getDynamicObject("paycurrency");
            DynamicObject basecurrency = bills.getDynamicObject("settlecurrency");
            if (currency == null || basecurrency == null) {
                ErrorCode ConvertCurrencyIsNull = new ErrorCode("ConvertCurrencyIsNull", ResManager.loadKDString((String)"\u7ed3\u7b97\u5e01\u6216\u672c\u4f4d\u5e01\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"BillToPayApplyConvertPlugin_1", (String)"fi-arapcommon", (Object[])new Object[0]));
                throw new KDBizException(ConvertCurrencyIsNull, new Object[0]);
            }
            if (currency.getLong("id") == basecurrency.getLong("id")) {
                bills.set("exchangerate", (Object)BigDecimal.valueOf(1L));
            } else if (bascurrency != null && currency != null && exeatetable != null && !ObjectUtils.isEmpty((Object)(exchangeRate = BillToPayApplyConvertPlugin.getExchangeRate(exeatetable.getLong("id"), currency.getLong("id"), bascurrency.getLong("id"), bills.getDate("exratedate"))))) {
                exchangeRate = exchangeRate.setScale(10, RoundingMode.HALF_UP);
                bills.set("exchangerate", (Object)exchangeRate);
            }
        }
    }

    private String getSelectors() {
        ArrayList<String> selectors = new ArrayList<String>();
        selectors.add("id");
        selectors.add("standardcurrency");
        selectors.add("exratetable");
        selectors.add("isfinishinit");
        selectors.add("startdate");
        return String.join((CharSequence)",", selectors);
    }

    public Date getStartDate() {
        if (this.init == null) {
            return null;
        }
        Date startDate = this.init.getDate("startdate");
        return startDate == null ? null : BillToPayApplyConvertPlugin.getDataFormat(startDate, true);
    }

    public static Date getDataFormat(Date date, boolean isStart) {
        String dateStr = new SimpleDateFormat("yyyy-MM-dd").format(date);
        String suffix = " 00:00:00";
        if (!isStart) {
            suffix = " 23:59:59";
        }
        try {
            return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(dateStr + suffix);
        }
        catch (ParseException e) {
            throw new KDException((Throwable)e, BosErrorCode.systemError, new Object[0]);
        }
    }

    public DynamicObject getStandardCurrency() {
        if (this.init == null) {
            return null;
        }
        return this.init.getDynamicObject("standardcurrency");
    }

    public DynamicObject getExrateTable() {
        if (this.init == null) {
            return null;
        }
        return this.init.getDynamicObject("exratetable");
    }

    public static BigDecimal getExchangeRate(Long exratetableId, Long srcCurrencyId, Long destCurrencyId, Date exrateDate) {
        BigDecimal exchangeRate = BigDecimal.ONE;
        if (exrateDate == null) {
            exrateDate = new Date();
        }
        if (srcCurrencyId == null || srcCurrencyId.equals(0L) || destCurrencyId == null || destCurrencyId.equals(0L) || srcCurrencyId.equals(destCurrencyId)) {
            return exchangeRate;
        }
        exchangeRate = BaseDataServiceHelper.getExchangeRate((Long)exratetableId, (Long)srcCurrencyId, (Long)destCurrencyId, (Date)exrateDate);
        return exchangeRate;
    }

    public boolean isAp() {
        return this.targetEntityNumber.contains("ap_");
    }
}

