/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.convert;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.botp.plugin.AbstractConvertPlugIn;
import kd.bos.entity.botp.plugin.args.BeforeBuildRowConditionEventArgs;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.arapcommon.helper.SystemParameterHelper;
import kd.fi.arapcommon.util.StringUtils;

public class CasRecBillToLqdBillConvertPlugin
extends AbstractConvertPlugIn {
    public void beforeBuildRowCondition(BeforeBuildRowConditionEventArgs e) {
        BillEntityType srcMainType = this.getSrcMainType();
        String srcMainTypeName = srcMainType.getExtendName();
        if ("cas_recbill".equals(srcMainTypeName)) {
            DynamicObject[] recBillInfos;
            Map variablesMap = this.getOption().getVariables();
            String orgId = (String)variablesMap.get("orgId");
            List selectedRows = e.getSelectedRows();
            HashMap<Long, BigDecimal> clearRangeAmtOrgMap = new HashMap<Long, BigDecimal>(8);
            Set casBillIds = selectedRows.stream().map(ListSelectedRow::getPrimaryKeyValue).collect(Collectors.toSet());
            QFilter filter = new QFilter("id", "in", casBillIds);
            if (!StringUtils.isEmpty(orgId)) {
                filter.and(new QFilter("entry.e_settleorg", "=", (Object)Long.parseLong(orgId)));
            }
            for (DynamicObject recBillInfo : recBillInfos = BusinessDataServiceHelper.load((String)"cas_recbill", (String)"billno,entry.e_unsettledamt,entry.e_settleorg", (QFilter[])new QFilter[]{filter})) {
                Long entrySettleOrgId;
                String recBillNo = recBillInfo.getString("billno");
                HashMap<Long, BigDecimal> unSettledAmtOrgMap = new HashMap<Long, BigDecimal>(8);
                DynamicObjectCollection entryCol = recBillInfo.getDynamicObjectCollection("entry");
                for (DynamicObject entryInfo : entryCol) {
                    entrySettleOrgId = entryInfo.getLong("e_settleorg.id");
                    if (ObjectUtils.isEmpty(clearRangeAmtOrgMap.get(entrySettleOrgId))) {
                        BigDecimal clearRangeAmt = (BigDecimal)SystemParameterHelper.getARAppParameter(entrySettleOrgId, "ar_033");
                        clearRangeAmtOrgMap.put(entrySettleOrgId, clearRangeAmt);
                    }
                    if (ObjectUtils.isEmpty(unSettledAmtOrgMap.get(entrySettleOrgId))) {
                        unSettledAmtOrgMap.put(entrySettleOrgId, entryInfo.getBigDecimal("e_unsettledamt"));
                        continue;
                    }
                    BigDecimal unSettledAmt = (BigDecimal)unSettledAmtOrgMap.get(entrySettleOrgId);
                    unSettledAmtOrgMap.put(entrySettleOrgId, unSettledAmt.add(entryInfo.getBigDecimal("e_unsettledamt")));
                }
                for (Map.Entry map : unSettledAmtOrgMap.entrySet()) {
                    BigDecimal clearRangeAmt;
                    entrySettleOrgId = (Long)map.getKey();
                    BigDecimal unSettleAmtSum = (BigDecimal)map.getValue();
                    if (unSettleAmtSum.compareTo(clearRangeAmt = clearRangeAmtOrgMap.getOrDefault(entrySettleOrgId, BigDecimal.ZERO)) <= 0) continue;
                    throw new KDBizException(ResManager.loadKDString((String)"\u6536\u6b3e\u5355%s\u6e05\u7406\u5931\u8d25\uff1a\u672a\u7ed3\u7b97\u91d1\u989d\u4e0d\u80fd\u5927\u4e8e\u6536\u6b3e\u5904\u7406\u7684\u6e05\u7406\u8303\u56f4\uff0c\u5982\u9700\u7ee7\u7eed\u6e05\u7406\uff0c\u8bf7\u4fee\u6539\u914d\u7f6e\u5de5\u5177-\u7cfb\u7edf\u53c2\u6570-\u5e94\u6536-\u6536\u6b3e\u6e05\u7406\u8303\u56f4\u3002", (String)"CasRecBillToLqdBillConvertPlugin_0", (String)"fi-arapcommon", (Object[])new Object[]{recBillNo}));
                }
            }
            if (!StringUtils.isEmpty(orgId)) {
                e.setCustFilterExpression("entry.e_settleorg = " + orgId + " and entry.e_receivingtype.ispartreceivable = true");
                QFilter cusFilter = new QFilter("entry.e_settleorg", "=", (Object)orgId);
                cusFilter.and(new QFilter("entry.e_receivingtype.ispartreceivable", "=", (Object)Boolean.TRUE));
                e.getCustQFilters().add(cusFilter);
            }
        }
    }
}

