/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.convert;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.ExtendedDataEntitySet;
import kd.bos.entity.botp.ConvertRuleElement;
import kd.bos.entity.botp.plugin.AbstractConvertPlugIn;
import kd.bos.entity.botp.plugin.args.AfterConvertEventArgs;
import kd.bos.ext.fi.plugin.ArApConvert.InitServiceHelper;
import kd.bos.ext.fi.plugin.ArApConvert.Plan.ApPlanSplitAndBuilder;
import kd.bos.ext.fi.plugin.ArApConvert.Plan.ConditionServiceHelper;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.arapcommon.business.price.FXPriceLocalCalculator;
import kd.fi.arapcommon.helper.BOTPHelper;
import kd.fi.arapcommon.helper.BookDateHelper;
import kd.fi.arapcommon.helper.UnitConvertHelper;
import kd.fi.arapcommon.service.plan.split.helper.PlanSplitSchemeServiceHelper;
import kd.fi.arapcommon.service.writeback.base.EntryCalculateParam;
import kd.fi.arapcommon.service.writeback.base.ProportionCalculator;
import kd.fi.arapcommon.util.AllocationUtils;
import kd.fi.arapcommon.util.EmptyUtils;
import kd.fi.arapcommon.util.QueryUtil;
import kd.fi.arapcommon.util.StringUtils;

public class FinApAdjustConvertPlugin
extends AbstractConvertPlugIn {
    private static final Log logger = LogFactory.getLog(FinApAdjustConvertPlugin.class);
    private boolean isTotalAdjust = false;
    private Map<Long, DynamicObject> orgInitMap;
    private DynamicObject[] needMatchSplitSchemes;
    Map<Long, DynamicObject> srcIdToSrcBillMap = new HashMap<Long, DynamicObject>(1);
    private final QueryUtil queryUtil = new QueryUtil();
    private final Map<Long, List<DynamicObject>> detailEntriesCache = new HashMap<Long, List<DynamicObject>>(1);

    public void afterConvert(AfterConvertEventArgs e) {
        logger.info("FinApAdjustConvertPlugin.afterConvert start");
        ExtendedDataEntitySet entitySet = e.getTargetExtDataEntitySet();
        ExtendedDataEntity[] extendEntites = entitySet.FindByEntityKey(this.getTgtMainType().getExtendName());
        ArrayList<DynamicObject> entities = new ArrayList<DynamicObject>(extendEntites.length);
        for (ExtendedDataEntity extendEntity : extendEntites) {
            entities.add(extendEntity.getDataEntity());
        }
        this.prepareData(entities);
        for (DynamicObject finApBill : entities) {
            DynamicObject org = finApBill.getDynamicObject("org");
            if (ObjectUtils.isEmpty((Object)org)) {
                return;
            }
            InitServiceHelper.checkOrgInit((DynamicObject)org, this.orgInitMap, (boolean)false);
            this.setHeadValue(finApBill);
            this.setDetailEntryValue(finApBill);
        }
        for (DynamicObject finApBill : entities) {
            this.setHeadAmtValue(finApBill);
            this.setPlanEntryValue(finApBill);
            this.setAllocationEntryValue(finApBill);
        }
        BookDateHelper.setBookDate(entities.toArray(new DynamicObject[0]), false);
        logger.info("FinApAdjustConvertPlugin.afterConvert end");
    }

    private void prepareData(List<DynamicObject> entities) {
        logger.info("FinApAdjustConvertPlugin.prepareData start");
        OperateOption option = this.getOption();
        Map variables = option.getVariables();
        if (variables.get("adjusttotalamt") != null) {
            this.isTotalAdjust = true;
        }
        HashSet<Long> orgIds = new HashSet<Long>(1);
        HashSet<Long> srcBillIds = new HashSet<Long>(1);
        for (DynamicObject entity : entities) {
            long orgId = entity.getLong("org.id");
            if (orgId != 0L) {
                orgIds.add(orgId);
            }
            String srcBillType = entity.getString("sourcebilltype");
            String billTypeNum = entity.getString("billtypeid.number");
            if (!"ap_finapbill".equals(srcBillType) || !"ApFin_borr_BT_S".equals(billTypeNum)) continue;
            srcBillIds.add(entity.getLong("sourcebillid"));
        }
        this.orgInitMap = InitServiceHelper.loadInitInfos(orgIds, (boolean)false);
        if (this.isTotalAdjust && srcBillIds.size() > 0) {
            DynamicObject[] srcApBills;
            for (DynamicObject srcApBill : srcApBills = BusinessDataServiceHelper.load((String)"ap_finapbill", (String)"id,currency,e_pricetaxtotal,unlockamt,pricetaxtotal", (QFilter[])new QFilter[]{new QFilter("id", "in", srcBillIds)})) {
                this.srcIdToSrcBillMap.put(srcApBill.getLong("id"), srcApBill);
            }
        }
        this.needMatchSplitSchemes = PlanSplitSchemeServiceHelper.getMatchSchemes("ap_finapbill");
        logger.info("FinApAdjustConvertPlugin.prepareData end");
    }

    private void setHeadValue(DynamicObject finApBill) {
        Date termsDate;
        OperateOption option = this.getOption();
        Map variables = option.getVariables();
        DynamicObject org = finApBill.getDynamicObject("org");
        InitServiceHelper.setBizDate((DynamicObject)finApBill, (DynamicObject)this.orgInitMap.get(org.getLong("id")), (ConvertRuleElement)this.getRule());
        boolean isSettingForExchange = BOTPHelper.ruleIsSetting(this.getRule(), true, "exchangerate");
        InitServiceHelper.setInitValue((DynamicObject)finApBill, (DynamicObject)this.orgInitMap.get(org.getLong("id")), (boolean)isSettingForExchange);
        String adjustType = finApBill.getString("adjusttype");
        if (StringUtils.isEmpty(adjustType)) {
            finApBill.set("adjusttype", variables.get("adjusttype"));
        }
        if ((termsDate = finApBill.getDate("termsdate")) == null) {
            Date basicDate = ConditionServiceHelper.getBasicDate((DynamicObject)finApBill);
            finApBill.set("termsdate", (Object)basicDate);
        }
        if (this.isTotalAdjust) {
            DataEntityPropertyCollection finPros = finApBill.getDataEntityType().getProperties();
            for (Map.Entry variablesEntrySet : variables.entrySet()) {
                String key = (String)variablesEntrySet.getKey();
                String value = (String)variablesEntrySet.getValue();
                if (finPros.get((Object)key) == null || this.adjustStandPros().contains(key)) continue;
                finApBill.set(key, (Object)value);
            }
        }
    }

    private void setDetailEntryValue(DynamicObject finApBill) {
        if (this.isTotalAdjust) {
            this.calculateDetailAmtInfoByRate(finApBill);
            this.setDetailEntryExtProps(finApBill);
        }
        this.calculateDetailEntry(finApBill);
        if (this.isPushAndSave(finApBill)) {
            List<DynamicObject> detailEntries = this.detailEntriesCache.get(finApBill.getLong("id"));
            if (detailEntries == null) {
                ArrayList finArDetailEntries = new ArrayList(8);
                finArDetailEntries.addAll(finApBill.getDynamicObjectCollection("detailentry"));
                this.detailEntriesCache.put(finApBill.getLong("id"), finArDetailEntries);
            } else {
                detailEntries.addAll((Collection<DynamicObject>)finApBill.getDynamicObjectCollection("detailentry"));
            }
        }
    }

    private void setHeadAmtValue(DynamicObject finApBill) {
        BigDecimal priceTaxTotal = BigDecimal.ZERO;
        BigDecimal priceTaxTotalBase = BigDecimal.ZERO;
        BigDecimal amount = BigDecimal.ZERO;
        BigDecimal amountBase = BigDecimal.ZERO;
        BigDecimal tax = BigDecimal.ZERO;
        BigDecimal taxLocAmt = BigDecimal.ZERO;
        BigDecimal adjustamt = BigDecimal.ZERO;
        BigDecimal adjustamtlocal = BigDecimal.ZERO;
        Object detailEntries = this.isPushAndSave(finApBill) ? this.detailEntriesCache.get(finApBill.getLong("id")) : finApBill.getDynamicObjectCollection("detailentry");
        for (DynamicObject detailEntry : detailEntries) {
            priceTaxTotal = priceTaxTotal.add(detailEntry.getBigDecimal("e_pricetaxtotal"));
            priceTaxTotalBase = priceTaxTotalBase.add(detailEntry.getBigDecimal("e_pricetaxtotalbase"));
            amount = amount.add(detailEntry.getBigDecimal("e_amount"));
            amountBase = amountBase.add(detailEntry.getBigDecimal("e_amountbase"));
            tax = tax.add(detailEntry.getBigDecimal("e_tax"));
            taxLocAmt = taxLocAmt.add(detailEntry.getBigDecimal("e_taxlocalamt"));
            adjustamt = adjustamt.add(detailEntry.getBigDecimal("e_adjustamount"));
            adjustamtlocal = adjustamtlocal.add(detailEntry.getBigDecimal("e_adjustlocalamt"));
        }
        finApBill.set("pricetaxtotal", (Object)priceTaxTotal);
        finApBill.set("pricetaxtotalbase", (Object)priceTaxTotalBase);
        finApBill.set("amount", (Object)amount);
        finApBill.set("amountbase", (Object)amountBase);
        finApBill.set("tax", (Object)tax);
        finApBill.set("taxlocamt", (Object)taxLocAmt);
        finApBill.set("uninvoicedamt", (Object)priceTaxTotal);
        finApBill.set("unverifyamount", (Object)amount);
        finApBill.set("unsettleamount", (Object)priceTaxTotal);
        finApBill.set("unsettleamountbase", (Object)priceTaxTotalBase);
        finApBill.set("adjustamount", (Object)adjustamt);
        finApBill.set("adjustlocalamt", (Object)adjustamtlocal);
    }

    private void setPlanEntryValue(DynamicObject finApBill) {
        DynamicObject matchSplitScheme = PlanSplitSchemeServiceHelper.matchSingleScheme(finApBill, this.needMatchSplitSchemes);
        finApBill.set("splitscheme", (Object)matchSplitScheme);
        if (this.isPushAndSave(finApBill)) {
            this.calculatePlanEntryByPushAndSave(finApBill, matchSplitScheme);
        } else {
            ApPlanSplitAndBuilder.splitAndBuild((DynamicObject)finApBill, (DynamicObject)matchSplitScheme);
        }
        this.setHeadDueDate(finApBill);
    }

    private void calculatePlanEntryByPushAndSave(DynamicObject finApBill, DynamicObject matchSplitScheme) {
        DynamicObject[] dbFinApBills = BusinessDataServiceHelper.load((String)"ap_finapbill", (String)"e_splitdimensionid,planentity.id", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)finApBill.getLong("id"))});
        if (dbFinApBills == null || dbFinApBills.length == 0) {
            ApPlanSplitAndBuilder.splitAndBuild((DynamicObject)finApBill, (DynamicObject)matchSplitScheme);
        } else {
            DynamicObject dbFinApBill = dbFinApBills[0];
            List<DynamicObject> detailEntries = this.detailEntriesCache.get(finApBill.getLong("id"));
            Map detailEntryIndexToSplitDimensionId = ApPlanSplitAndBuilder.splitAndBuildByPushAndSave((DynamicObject)finApBill, detailEntries, (DynamicObject)matchSplitScheme);
            DynamicObjectCollection dbDetailEntries = dbFinApBill.getDynamicObjectCollection("detailentry");
            DynamicObjectCollection curDetailEntries = finApBill.getDynamicObjectCollection("detailentry");
            int dbDetailEntrySize = dbDetailEntries.size();
            for (int i = 0; i < dbDetailEntrySize; ++i) {
                DynamicObject dbDetailEntry = (DynamicObject)dbDetailEntries.get(i);
                dbDetailEntry.set("e_splitdimensionid", detailEntryIndexToSplitDimensionId.get(i));
            }
            int curDetailEntrySize = curDetailEntries.size();
            for (int i = 0; i < curDetailEntrySize; ++i) {
                DynamicObject curDetailEntry = (DynamicObject)curDetailEntries.get(i);
                curDetailEntry.set("e_splitdimensionid", detailEntryIndexToSplitDimensionId.get(i + dbDetailEntrySize));
            }
            DynamicObjectCollection dbPlanEntries = dbFinApBill.getDynamicObjectCollection("planentity");
            dbPlanEntries.clear();
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dbFinApBill});
        }
    }

    private void setHeadDueDate(DynamicObject finApBill) {
        Date planMaxDuedate = finApBill.getDate("duedate");
        DynamicObjectCollection planEntries = finApBill.getDynamicObjectCollection("planentity");
        for (DynamicObject planEntry : planEntries) {
            Date planEntryDueDate = planEntry.getDate("planduedate");
            if (planMaxDuedate == null) {
                planMaxDuedate = planEntryDueDate;
                continue;
            }
            if (planEntryDueDate == null) continue;
            planMaxDuedate = planEntryDueDate.after(planMaxDuedate) ? planEntryDueDate : planMaxDuedate;
        }
        finApBill.set("duedate", (Object)planMaxDuedate);
    }

    private void calculateDetailAmtInfoByRate(DynamicObject finApBill) {
        BigDecimal curAdjustAmt;
        Long sourceBillId = finApBill.getLong("sourcebillid");
        DynamicObject sourceBill = this.srcIdToSrcBillMap.get(sourceBillId);
        BigDecimal sourcePriceTaxTotal = sourceBill.getBigDecimal("pricetaxtotal");
        DynamicObjectCollection sourceBillDetailEntries = sourceBill.getDynamicObjectCollection("detailentry");
        BigDecimal sourceBillUnLockAmtTotal = BigDecimal.ZERO;
        for (DynamicObject sourceBillDetailEntry : sourceBillDetailEntries) {
            BigDecimal srcUnlockAmt = sourceBillDetailEntry.getBigDecimal("unlockamt");
            if (srcUnlockAmt.compareTo(BigDecimal.ZERO) <= 0) continue;
            sourceBillUnLockAmtTotal = sourceBillUnLockAmtTotal.add(srcUnlockAmt);
        }
        OperateOption option = this.getOption();
        Map variables = option.getVariables();
        BigDecimal adjustAmt = new BigDecimal((String)variables.get("adjusttotalamt"));
        BigDecimal adjustTaxAmt = new BigDecimal((String)variables.get("adjusttotaltaxamt"));
        BigDecimal adjustTotalAmt = adjustAmt.add(adjustTaxAmt);
        boolean isByUnLock = false;
        boolean isOverPriceTaxTotal = false;
        if (adjustTotalAmt.compareTo(BigDecimal.ZERO) < 0 && adjustTotalAmt.abs().compareTo(sourceBillUnLockAmtTotal.abs()) <= 0 && sourceBillUnLockAmtTotal.compareTo(BigDecimal.ZERO) > 0 && adjustTotalAmt.abs().compareTo(sourcePriceTaxTotal) <= 0) {
            isByUnLock = true;
        } else if (sourcePriceTaxTotal.compareTo(BigDecimal.ZERO) > 0) {
            if (adjustTotalAmt.abs().compareTo(sourcePriceTaxTotal) > 0) {
                isOverPriceTaxTotal = true;
            }
        } else {
            logger.info("srcBill pricetaxtotal < 0, use simple");
            isOverPriceTaxTotal = true;
        }
        logger.info("isOverPriceTaxTotal:" + isOverPriceTaxTotal + ",isByUnLock:" + isByUnLock);
        Map<Object, Object> entryIdToAdjustTotalAmt = new HashMap<Long, BigDecimal>(sourceBillDetailEntries.size());
        Map<Object, Object> entryIdToAdjustAmt = new HashMap<Long, BigDecimal>(sourceBillDetailEntries.size());
        ArrayList<DynamicObject> noZeroSourceBillDetailEntries = new ArrayList<DynamicObject>(sourceBillDetailEntries.size());
        for (DynamicObject entry : sourceBillDetailEntries) {
            if (entry.getBigDecimal("e_pricetaxtotal").compareTo(BigDecimal.ZERO) == 0) continue;
            noZeroSourceBillDetailEntries.add(entry);
        }
        if (isOverPriceTaxTotal) {
            int count = 0;
            int scale = this.getPrecision(sourceBill);
            BigDecimal remainAdjustTotalAmt = BigDecimal.ZERO;
            BigDecimal remainAdjustAmt = BigDecimal.ZERO;
            for (DynamicObject sourceBillDetailEntry : noZeroSourceBillDetailEntries) {
                if (++count == noZeroSourceBillDetailEntries.size()) {
                    entryIdToAdjustTotalAmt.put(sourceBillDetailEntry.getLong("id"), adjustTotalAmt.abs().subtract(remainAdjustTotalAmt));
                    entryIdToAdjustAmt.put(sourceBillDetailEntry.getLong("id"), adjustAmt.abs().subtract(remainAdjustAmt));
                    continue;
                }
                BigDecimal entryPriceTaxAmt = sourceBillDetailEntry.getBigDecimal("e_pricetaxtotal");
                BigDecimal proportion = entryPriceTaxAmt.divide(sourcePriceTaxTotal, 10, RoundingMode.DOWN);
                BigDecimal curAdjustTotalAmt = adjustTotalAmt.abs().multiply(proportion).setScale(scale, RoundingMode.DOWN);
                entryIdToAdjustTotalAmt.put(sourceBillDetailEntry.getLong("id"), curAdjustTotalAmt);
                remainAdjustTotalAmt = remainAdjustTotalAmt.add(curAdjustTotalAmt);
                curAdjustAmt = adjustAmt.abs().multiply(proportion).setScale(scale, RoundingMode.DOWN);
                entryIdToAdjustAmt.put(sourceBillDetailEntry.getLong("id"), curAdjustAmt);
                remainAdjustAmt = remainAdjustAmt.add(curAdjustAmt);
            }
        } else {
            ProportionCalculator proportionCalculator = new ProportionCalculator();
            EntryCalculateParam param = new EntryCalculateParam();
            param.setEntryPriceTaxTotalKey(isByUnLock ? "unlockamt" : "e_pricetaxtotal");
            param.setCurrencyKey("currency");
            proportionCalculator.init(param);
            if (isByUnLock) {
                DynamicObjectCollection directSourceBillDetailEntries = new DynamicObjectCollection();
                for (DynamicObject sourceBillDetailEntry : sourceBillDetailEntries) {
                    BigDecimal srcUnlockAmt = sourceBillDetailEntry.getBigDecimal("unlockamt");
                    if (srcUnlockAmt.compareTo(BigDecimal.ZERO) <= 0) continue;
                    directSourceBillDetailEntries.add((Object)sourceBillDetailEntry);
                }
                entryIdToAdjustTotalAmt = proportionCalculator.loadEntryWriteBackAmtMap(sourceBill, directSourceBillDetailEntries, adjustTotalAmt.abs());
                if (adjustAmt.abs().compareTo(sourceBillUnLockAmtTotal) > 0) {
                    int count = 0;
                    int scale = this.getPrecision(sourceBill);
                    Object remainAdjustAmt = BigDecimal.ZERO;
                    for (DynamicObject sourceBillDetailEntry : directSourceBillDetailEntries) {
                        if (++count == directSourceBillDetailEntries.size()) {
                            entryIdToAdjustAmt.put(sourceBillDetailEntry.getLong("id"), adjustAmt.abs().subtract((BigDecimal)remainAdjustAmt));
                            continue;
                        }
                        BigDecimal entryPriceTaxAmt = sourceBillDetailEntry.getBigDecimal("unlockamt");
                        BigDecimal proportion = entryPriceTaxAmt.divide(sourcePriceTaxTotal, 10, RoundingMode.DOWN);
                        BigDecimal curAdjustAmt2 = adjustAmt.abs().multiply(proportion).setScale(scale, RoundingMode.DOWN);
                        entryIdToAdjustAmt.put(sourceBillDetailEntry.getLong("id"), curAdjustAmt2);
                        remainAdjustAmt = ((BigDecimal)remainAdjustAmt).add(curAdjustAmt2);
                    }
                } else {
                    entryIdToAdjustAmt = proportionCalculator.loadEntryWriteBackAmtMap(sourceBill, directSourceBillDetailEntries, adjustAmt.abs());
                }
            } else {
                entryIdToAdjustTotalAmt = proportionCalculator.loadEntryWriteBackAmtMap(sourceBill, sourceBillDetailEntries, adjustTotalAmt.abs());
                if (adjustAmt.abs().compareTo(sourcePriceTaxTotal) > 0) {
                    int count = 0;
                    int scale = this.getPrecision(sourceBill);
                    BigDecimal remainAdjustAmt = BigDecimal.ZERO;
                    for (DynamicObject sourceBillDetailEntry : noZeroSourceBillDetailEntries) {
                        if (++count == noZeroSourceBillDetailEntries.size()) {
                            entryIdToAdjustAmt.put(sourceBillDetailEntry.getLong("id"), adjustAmt.abs().subtract(remainAdjustAmt));
                            continue;
                        }
                        BigDecimal entryPriceTaxAmt = sourceBillDetailEntry.getBigDecimal("e_pricetaxtotal");
                        BigDecimal proportion = entryPriceTaxAmt.divide(sourcePriceTaxTotal, 10, RoundingMode.DOWN);
                        curAdjustAmt = adjustAmt.abs().multiply(proportion).setScale(scale, RoundingMode.DOWN);
                        entryIdToAdjustAmt.put(sourceBillDetailEntry.getLong("id"), curAdjustAmt);
                        remainAdjustAmt = remainAdjustAmt.add(curAdjustAmt);
                    }
                } else {
                    entryIdToAdjustAmt = proportionCalculator.loadEntryWriteBackAmtMap(sourceBill, sourceBillDetailEntries, adjustAmt.abs());
                }
            }
        }
        BigDecimal adjustTotalAmtSign = new BigDecimal(adjustTotalAmt.signum());
        BigDecimal adjustAmtSign = new BigDecimal(adjustAmt.signum());
        DynamicObjectCollection detailEntries = finApBill.getDynamicObjectCollection("detailentry");
        for (DynamicObject detailEntry : detailEntries) {
            long entryId = detailEntry.getLong("e_sourcebillentryid");
            BigDecimal entryAdjustTotalAmt = (BigDecimal)entryIdToAdjustTotalAmt.get(entryId);
            if (entryAdjustTotalAmt == null || entryAdjustTotalAmt.compareTo(BigDecimal.ZERO) == 0) {
                detailEntry.set("e_pricetaxtotal", (Object)BigDecimal.ZERO);
            } else {
                detailEntry.set("e_pricetaxtotal", (Object)entryAdjustTotalAmt.multiply(adjustTotalAmtSign));
            }
            BigDecimal entryAdjustAmt = (BigDecimal)entryIdToAdjustAmt.get(entryId);
            if (entryAdjustAmt == null || entryAdjustAmt.compareTo(BigDecimal.ZERO) == 0) {
                detailEntry.set("e_amount", (Object)BigDecimal.ZERO);
            } else {
                detailEntry.set("e_amount", (Object)entryAdjustAmt.multiply(adjustAmtSign));
            }
            detailEntry.set("e_tax", (Object)detailEntry.getBigDecimal("e_pricetaxtotal").subtract(detailEntry.getBigDecimal("e_amount")));
            detailEntry.set("curdeductibleamt", (Object)BigDecimal.ZERO);
            detailEntry.set("intercostamt", (Object)BigDecimal.ZERO);
        }
    }

    private void setDetailEntryExtProps(DynamicObject finApBill) {
        OperateOption option = this.getOption();
        Map variables = option.getVariables();
        DynamicObjectCollection detailEntries = finApBill.getDynamicObjectCollection("detailentry");
        DataEntityPropertyCollection entryProps = detailEntries.getDynamicObjectType().getProperties();
        boolean isExistEntryExtProp = false;
        for (Map.Entry variableEntrySet : variables.entrySet()) {
            String key = (String)variableEntrySet.getKey();
            if (entryProps.get((Object)key) == null) continue;
            isExistEntryExtProp = true;
            break;
        }
        if (isExistEntryExtProp) {
            for (DynamicObject detailEntry : detailEntries) {
                for (Map.Entry variableEntrySet : variables.entrySet()) {
                    String key = (String)variableEntrySet.getKey();
                    String value = (String)variableEntrySet.getValue();
                    if (entryProps.get((Object)key) == null) continue;
                    detailEntry.set(key, (Object)value);
                }
            }
        }
    }

    private void calculateDetailEntry(DynamicObject finApBill) {
        int baseprecision = finApBill.getInt("basecurrency.amtprecision");
        boolean includeTax = finApBill.getBoolean("isincludetax");
        BigDecimal exchangeRate = finApBill.getBigDecimal("exchangerate");
        String quotation = finApBill.getString("quotation");
        if (exchangeRate.compareTo(BigDecimal.ZERO) == 0 && "1".equals(quotation)) {
            quotation = "0";
        }
        DynamicObjectCollection detailEntries = finApBill.getDynamicObjectCollection("detailentry");
        for (DynamicObject entry : detailEntries) {
            BigDecimal e_tax = entry.getBigDecimal("e_tax");
            BigDecimal e_pricetaxtotal = entry.getBigDecimal("e_pricetaxtotal");
            BigDecimal e_amount = entry.getBigDecimal("e_amount");
            BigDecimal discountamount = entry.getBigDecimal("discountamount");
            BigDecimal eAdjustamount = entry.getBigDecimal("e_adjustamount");
            FXPriceLocalCalculator calculator = new FXPriceLocalCalculator(includeTax, e_tax, e_amount, discountamount, exchangeRate, baseprecision, eAdjustamount, quotation);
            calculator.calculate();
            BigDecimal e_amountbase = calculator.getAmountLocal();
            BigDecimal e_taxlocamt = calculator.getTaxLocal();
            BigDecimal e_pricetaxtotalbase = calculator.getPriceTaxTotalLocal();
            BigDecimal discountamountLocal = calculator.getDiscountamountLocal();
            BigDecimal e_adjustlocalamt = calculator.getAdjustamtlocal();
            entry.set("discountlocalamt", (Object)discountamountLocal);
            entry.set("e_amountbase", (Object)e_amountbase);
            entry.set("e_taxlocalamt", (Object)e_taxlocamt);
            entry.set("e_pricetaxtotalbase", (Object)e_pricetaxtotalbase);
            entry.set("unsettleamtbase", (Object)e_pricetaxtotalbase);
            entry.set("e_adjustlocalamt", (Object)e_adjustlocalamt);
            entry.set("unlockamt", (Object)e_pricetaxtotal);
            entry.set("unsettleamt", (Object)e_pricetaxtotal);
            entry.set("e_uninvoicedamt", (Object)e_pricetaxtotal);
            entry.set("e_unverifyamount", (Object)e_amount);
            entry.set("e_pricetaxtotalbase", (Object)e_pricetaxtotalbase);
            entry.set("unsettleamtbase", (Object)e_pricetaxtotalbase);
            BigDecimal quantity = entry.getBigDecimal("quantity");
            if (quantity == null) {
                quantity = BigDecimal.ZERO;
            }
            BigDecimal covertRate = entry.getBigDecimal("e_unitconvertrate");
            DynamicObject material = entry.getDynamicObject("material");
            DynamicObject measureUnit = entry.getDynamicObject("measureunit");
            DynamicObject baseUnit = entry.getDynamicObject("e_baseunit");
            if (!ObjectUtils.isEmpty((Object)material)) {
                if (ObjectUtils.isEmpty((Object)baseUnit)) {
                    baseUnit = material.getDynamicObject("baseunit");
                    entry.set("e_baseunit", (Object)baseUnit);
                }
                if (measureUnit == null) {
                    measureUnit = baseUnit;
                }
                if (covertRate == null || covertRate.compareTo(BigDecimal.ZERO) == 0) {
                    covertRate = this.queryUtil.getConvertRate(material.getLong("id"), measureUnit.getLong("id"), baseUnit.getLong("id"));
                }
            } else if (covertRate == null || covertRate.compareTo(BigDecimal.ZERO) == 0) {
                covertRate = BigDecimal.ONE;
            }
            if (EmptyUtils.isEmpty(entry.getBigDecimal("e_unitconvertrate"))) {
                entry.set("e_unitconvertrate", (Object)covertRate);
            }
            if (EmptyUtils.isEmpty(entry.getBigDecimal("e_baseunitqty"))) {
                entry.set("e_baseunitqty", (Object)UnitConvertHelper.getBaseunitqty(quantity, covertRate, baseUnit));
            }
            if (!EmptyUtils.isEmpty(entry.getBigDecimal("e_unverifybaseqty"))) continue;
            entry.set("e_unverifybaseqty", (Object)UnitConvertHelper.getBaseunitqty(entry.getBigDecimal("unverifyquantity"), covertRate, baseUnit));
        }
    }

    private void setAllocationEntryValue(DynamicObject targetBill) {
        if (this.isTotalAdjust) {
            BigDecimal billTotalAmt = this.getTargetBillHeadAmt(targetBill);
            BigDecimal billTotalLocAmt = this.getTargetBillHeadLocAmt(targetBill);
            boolean needRecalculate = AllocationUtils.isNeedRecalculate(billTotalAmt, targetBill);
            if (!needRecalculate) {
                return;
            }
            AllocationUtils.executeCalculation(billTotalAmt, billTotalLocAmt, targetBill);
        }
    }

    private BigDecimal getTargetBillHeadAmt(DynamicObject finApBill) {
        boolean isTax = finApBill.getBoolean("isintax");
        return isTax ? finApBill.getBigDecimal("pricetaxtotal") : finApBill.getBigDecimal("amount");
    }

    private BigDecimal getTargetBillHeadLocAmt(DynamicObject finApBill) {
        boolean isTax = finApBill.getBoolean("isintax");
        return isTax ? finApBill.getBigDecimal("pricetaxtotalbase") : finApBill.getBigDecimal("amountbase");
    }

    private boolean isPushAndSave(DynamicObject finArBill) {
        return BOTPHelper.isPushAndSave(this.getRule(), finArBill);
    }

    private int getPrecision(DynamicObject finBill) {
        DynamicObject currency = finBill.getDynamicObject("currency");
        return currency == null ? 2 : currency.getInt("amtprecision");
    }

    private Set<String> adjustStandPros() {
        HashSet<String> standProSet = new HashSet<String>(6);
        standProSet.add("adjusttype");
        standProSet.add("adjusttotalamt");
        standProSet.add("adjusttotaltaxamt");
        standProSet.add("adjustallamt");
        standProSet.add("currency");
        standProSet.add("currency_id");
        return standProSet;
    }
}

