/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.convert;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.ExtendedDataEntitySet;
import kd.bos.entity.botp.ConvertRuleElement;
import kd.bos.entity.botp.plugin.AbstractConvertPlugIn;
import kd.bos.entity.botp.plugin.args.AfterConvertEventArgs;
import kd.bos.entity.botp.plugin.args.InitVariableEventArgs;
import kd.bos.exception.KDBizException;
import kd.bos.ext.fi.plugin.ArApConvert.InitServiceHelper;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.arapcommon.business.price.FXPriceLocalCalculator;
import kd.fi.arapcommon.helper.BOTPHelper;
import kd.fi.arapcommon.helper.BookDateHelper;
import kd.fi.arapcommon.helper.UnitConvertHelper;
import kd.fi.arapcommon.util.EmptyUtils;
import kd.fi.arapcommon.util.QueryUtil;

public class FinApLocAmtConvertPlugin
extends AbstractConvertPlugIn {
    private static final Log logger = LogFactory.getLog(FinApLocAmtConvertPlugin.class);
    private Map<Long, DynamicObject> orgInitMap;
    private final QueryUtil queryUtil = new QueryUtil();
    private final Map<Long, DynamicObject> srcFinApContainsPremiumMap = new HashMap<Long, DynamicObject>(1);

    public void initVariable(InitVariableEventArgs e) {
        boolean autoSave = this.getRule().isAutoSave();
        String ruleId = this.getRule().getId();
        if (autoSave && "520819751337865216".equals(ruleId)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8d22\u52a1\u5e94\u4ed8\u5355\u51b2\u9500\u7684\u8f6c\u6362\u89c4\u5219\u4e0d\u5141\u8bb8\u6253\u5f00\u201c\u4e0b\u63a8\u81ea\u52a8\u4fdd\u5b58\u201d\u6309\u94ae\u3002\u5982\u679c\u6e90\u5355\u7269\u6599\u884c\u5206\u5f55\u7684\u5927\u5c0f\u8d85\u8fc7\u5e73\u53f0\u9650\u5236\u768420000\u884c\u5206\u5f55,\u8bf7\u53c2\u8003\u793e\u533a\u6587\u6863\u91c7\u7528\u540e\u53f0\u51b2\u9500\u7684\u65b9\u5f0f\u5904\u7406:https://vip.kingdee.com/knowledge/specialDetail/223800781941044992?category=433217318319929600&id=464213782940848384&productLineId=2", (String)"FinApBillSaveOp_4", (String)"fi-ap-opplugin", (Object[])new Object[0]));
        }
    }

    public void afterConvert(AfterConvertEventArgs e) {
        logger.info("FinApLocAmtConvertPlugin.afterConvert start");
        ExtendedDataEntitySet entitySet = e.getTargetExtDataEntitySet();
        ExtendedDataEntity[] extendEntites = entitySet.FindByEntityKey(this.getTgtMainType().getExtendName());
        ArrayList<DynamicObject> entities = new ArrayList<DynamicObject>(extendEntites.length);
        for (ExtendedDataEntity extendEntity : extendEntites) {
            entities.add(extendEntity.getDataEntity());
        }
        this.prepareData(entities);
        for (DynamicObject finApBill : entities) {
            DynamicObject org = finApBill.getDynamicObject("org");
            if (ObjectUtils.isEmpty((Object)org)) {
                return;
            }
            InitServiceHelper.checkOrgInit((DynamicObject)org, this.orgInitMap, (boolean)false);
            this.setHeadValue(finApBill);
            this.setDetailEntryValue(finApBill);
            this.setProjectAndContactForPremium(finApBill);
        }
        for (DynamicObject finApBill : entities) {
            this.setHeadAmtValue(finApBill);
            this.setPlanEntryValue(finApBill);
        }
        BookDateHelper.setBookDate(entities.toArray(new DynamicObject[0]), false);
        logger.info("FinApLocAmtConvertPlugin.afterConvert end");
    }

    private void prepareData(List<DynamicObject> entities) {
        logger.info("FinApLocAmtConvertPlugin.prepareData start");
        HashSet<Long> orgIds = new HashSet<Long>(1);
        HashSet<Long> srcFinApContainPremiumBillIds = new HashSet<Long>(1);
        for (DynamicObject entity : entities) {
            long orgId = entity.getLong("org.id");
            if (orgId != 0L) {
                orgIds.add(orgId);
            }
            if (!entity.getBoolean("ispremium")) continue;
            DynamicObjectCollection entries = entity.getDynamicObjectCollection("detailentry");
            for (DynamicObject entry : entries) {
                srcFinApContainPremiumBillIds.add(entry.getLong("e_sourcebillid"));
            }
        }
        this.orgInitMap = InitServiceHelper.loadInitInfos(orgIds, (boolean)false);
        if (srcFinApContainPremiumBillIds.size() > 0) {
            DynamicObject[] srcFinApBills;
            for (DynamicObject finApBill : srcFinApBills = BusinessDataServiceHelper.load((String)"ap_finapbill", (String)"id,detailentry.e_conbillentity,detailentry.e_conbillnumber,detailentry.e_conbillrownum,detailentry.e_conbillid,detailentry.e_conbillentryid,detailentry.e_contract,detailentry.project", (QFilter[])new QFilter[]{new QFilter("id", "in", srcFinApContainPremiumBillIds), new QFilter("detailentry.seq", "in", Arrays.asList(0, 1))})) {
                this.srcFinApContainsPremiumMap.putIfAbsent(finApBill.getLong("id"), (DynamicObject)finApBill.getDynamicObjectCollection("detailentry").get(0));
            }
        }
        logger.info("FinApLocAmtConvertPlugin.prepareData end");
    }

    private void setHeadValue(DynamicObject finApBill) {
        DynamicObject org = finApBill.getDynamicObject("org");
        InitServiceHelper.setBizDate((DynamicObject)finApBill, (DynamicObject)this.orgInitMap.get(org.getLong("id")), (ConvertRuleElement)this.getRule());
        boolean isSettingForExchange = BOTPHelper.ruleIsSetting(this.getRule(), true, "exchangerate");
        InitServiceHelper.setInitValue((DynamicObject)finApBill, (DynamicObject)this.orgInitMap.get(org.getLong("id")), (boolean)isSettingForExchange);
    }

    private void setDetailEntryValue(DynamicObject finApBill) {
        int baseprecision = finApBill.getInt("basecurrency.amtprecision");
        boolean includeTax = finApBill.getBoolean("isincludetax");
        BigDecimal exchangeRate = finApBill.getBigDecimal("exchangerate");
        String quotation = finApBill.getString("quotation");
        if (exchangeRate.compareTo(BigDecimal.ZERO) == 0 && "1".equals(quotation)) {
            quotation = "0";
        }
        DynamicObjectCollection detailEntries = finApBill.getDynamicObjectCollection("detailentry");
        boolean isWrittenOff = finApBill.getBoolean("iswrittenoff");
        for (DynamicObject entry : detailEntries) {
            BigDecimal quantity;
            BigDecimal e_tax = entry.getBigDecimal("e_tax");
            BigDecimal e_amount = entry.getBigDecimal("e_amount");
            BigDecimal discountamount = entry.getBigDecimal("discountamount");
            BigDecimal eAdjustamount = entry.getBigDecimal("e_adjustamount");
            FXPriceLocalCalculator calculator = new FXPriceLocalCalculator(includeTax, e_tax, e_amount, discountamount, exchangeRate, baseprecision, eAdjustamount, quotation);
            calculator.calculate();
            BigDecimal e_amountbase = calculator.getAmountLocal();
            BigDecimal e_taxlocamt = calculator.getTaxLocal();
            BigDecimal e_pricetaxtotalbase = calculator.getPriceTaxTotalLocal();
            BigDecimal discountamountLocal = calculator.getDiscountamountLocal();
            BigDecimal e_adjustlocalamt = calculator.getAdjustamtlocal();
            if (!isWrittenOff) {
                entry.set("discountlocalamt", (Object)discountamountLocal);
                entry.set("e_amountbase", (Object)e_amountbase);
                entry.set("e_taxlocalamt", (Object)e_taxlocamt);
                entry.set("e_pricetaxtotalbase", (Object)e_pricetaxtotalbase);
                entry.set("unsettleamtbase", (Object)e_pricetaxtotalbase);
                entry.set("e_adjustlocalamt", (Object)e_adjustlocalamt);
            }
            if ((quantity = entry.getBigDecimal("quantity")) == null) {
                quantity = BigDecimal.ZERO;
            }
            BigDecimal covertRate = entry.getBigDecimal("e_unitconvertrate");
            DynamicObject material = entry.getDynamicObject("material");
            DynamicObject measureUnit = entry.getDynamicObject("measureunit");
            DynamicObject baseUnit = entry.getDynamicObject("e_baseunit");
            if (!ObjectUtils.isEmpty((Object)material)) {
                if (ObjectUtils.isEmpty((Object)baseUnit)) {
                    baseUnit = material.getDynamicObject("baseunit");
                    entry.set("e_baseunit", (Object)baseUnit);
                }
                if (measureUnit == null) {
                    measureUnit = baseUnit;
                }
                if (covertRate == null || covertRate.compareTo(BigDecimal.ZERO) == 0) {
                    covertRate = this.queryUtil.getConvertRate(material.getLong("id"), measureUnit.getLong("id"), baseUnit.getLong("id"));
                }
            } else if (covertRate == null || covertRate.compareTo(BigDecimal.ZERO) == 0) {
                covertRate = BigDecimal.ONE;
            }
            if (EmptyUtils.isEmpty(entry.getBigDecimal("e_unitconvertrate"))) {
                entry.set("e_unitconvertrate", (Object)covertRate);
            }
            if (EmptyUtils.isEmpty(entry.getBigDecimal("e_baseunitqty"))) {
                entry.set("e_baseunitqty", (Object)UnitConvertHelper.getBaseunitqty(quantity, covertRate, baseUnit));
            }
            if (!EmptyUtils.isEmpty(entry.getBigDecimal("e_unverifybaseqty"))) continue;
            entry.set("e_unverifybaseqty", (Object)UnitConvertHelper.getBaseunitqty(entry.getBigDecimal("unverifyquantity"), covertRate, baseUnit));
        }
    }

    private void setHeadAmtValue(DynamicObject finApBill) {
        BigDecimal priceTaxTotalBase = BigDecimal.ZERO;
        BigDecimal amountBase = BigDecimal.ZERO;
        BigDecimal taxLocAmt = BigDecimal.ZERO;
        BigDecimal adjustamtlocal = BigDecimal.ZERO;
        DynamicObjectCollection detailEntries = finApBill.getDynamicObjectCollection("detailentry");
        for (DynamicObject detailEntry : detailEntries) {
            priceTaxTotalBase = priceTaxTotalBase.add(detailEntry.getBigDecimal("e_pricetaxtotalbase"));
            amountBase = amountBase.add(detailEntry.getBigDecimal("e_amountbase"));
            taxLocAmt = taxLocAmt.add(detailEntry.getBigDecimal("e_taxlocalamt"));
            adjustamtlocal = adjustamtlocal.add(detailEntry.getBigDecimal("e_adjustlocalamt"));
        }
        finApBill.set("pricetaxtotalbase", (Object)priceTaxTotalBase);
        finApBill.set("amountbase", (Object)amountBase);
        finApBill.set("taxlocamt", (Object)taxLocAmt);
        finApBill.set("unsettleamountbase", (Object)priceTaxTotalBase);
        finApBill.set("adjustlocalamt", (Object)adjustamtlocal);
    }

    private void setPlanEntryValue(DynamicObject finApBill) {
        boolean isWrittenOff = finApBill.getBoolean("iswrittenoff");
        DynamicObjectCollection planEntries = finApBill.getDynamicObjectCollection("planentity");
        if (planEntries.size() < 1) {
            return;
        }
        BigDecimal exchangeRate = finApBill.getBigDecimal("exchangerate");
        int baseprecision = finApBill.getInt("basecurrency.amtprecision");
        String quotation = finApBill.getString("quotation");
        BigDecimal pricetaxtotalbase = finApBill.getBigDecimal("pricetaxtotalbase");
        int count = 0;
        BigDecimal planSumAmtLoc = BigDecimal.ZERO;
        for (DynamicObject plan : planEntries) {
            BigDecimal planAmt = plan.getBigDecimal("planpricetax");
            BigDecimal planAmtLoc = quotation.equals("0") ? planAmt.multiply(exchangeRate).setScale(baseprecision, RoundingMode.HALF_UP) : planAmt.divide(exchangeRate, baseprecision, RoundingMode.HALF_UP);
            if (++count == planEntries.size()) {
                planAmtLoc = pricetaxtotalbase.subtract(planSumAmtLoc);
            }
            planSumAmtLoc = planSumAmtLoc.add(planAmtLoc);
            if (isWrittenOff) continue;
            plan.set("planpricetax", (Object)planAmt);
            plan.set("planpricetaxloc", (Object)planAmtLoc);
            plan.set("unplanlockamt", (Object)planAmt);
            plan.set("unplansettleamt", (Object)planAmt);
            plan.set("unplansettlelocamt", (Object)planAmtLoc);
        }
        this.setHeadDueDate(finApBill);
    }

    private void setHeadDueDate(DynamicObject finApBill) {
        Date planMaxDuedate = finApBill.getDate("duedate");
        DynamicObjectCollection planEntries = finApBill.getDynamicObjectCollection("planentity");
        for (DynamicObject planEntry : planEntries) {
            Date planEntryDueDate = planEntry.getDate("planduedate");
            if (planMaxDuedate == null) {
                planMaxDuedate = planEntryDueDate;
                continue;
            }
            if (planEntryDueDate == null) continue;
            planMaxDuedate = planEntryDueDate.after(planMaxDuedate) ? planEntryDueDate : planMaxDuedate;
        }
        finApBill.set("duedate", (Object)planMaxDuedate);
    }

    private void setProjectAndContactForPremium(DynamicObject finAPBill) {
        if (!finAPBill.getBoolean("ispremium")) {
            return;
        }
        DynamicObjectCollection entries = finAPBill.getDynamicObjectCollection("detailentry");
        for (DynamicObject entry : entries) {
            DynamicObject srcFinApRow;
            long sourcebillid = entry.getLong("e_sourcebillid");
            if (sourcebillid == 0L || (srcFinApRow = this.srcFinApContainsPremiumMap.get(sourcebillid)) == null) continue;
            if (ObjectUtils.isEmpty((Object)entry.get("project"))) {
                entry.set("project", srcFinApRow.get("project"));
            }
            if (ObjectUtils.isEmpty((Object)entry.get("e_contract"))) {
                entry.set("e_contract", srcFinApRow.get("e_contract"));
            }
            if (ObjectUtils.isEmpty((Object)entry.get("e_conbillentity"))) {
                entry.set("e_conbillentity", srcFinApRow.get("e_conbillentity"));
            }
            if (ObjectUtils.isEmpty((Object)entry.get("e_conbillnumber"))) {
                entry.set("e_conbillnumber", srcFinApRow.get("e_conbillnumber"));
            }
            if (!EmptyUtils.isEmpty(entry.get("e_conbillid"))) continue;
            entry.set("e_conbillid", srcFinApRow.get("e_conbillid"));
        }
    }
}

