/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.convert;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.ExtendedDataEntitySet;
import kd.bos.entity.botp.ConvertRuleElement;
import kd.bos.entity.botp.plugin.AbstractConvertPlugIn;
import kd.bos.entity.botp.plugin.args.AfterConvertEventArgs;
import kd.bos.ext.fi.plugin.ArApConvert.InitServiceHelper;
import kd.bos.ext.fi.plugin.ArApConvert.Plan.ArPlanSplitAndBuilder;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.arapcommon.business.price.FXPriceLocalCalculator;
import kd.fi.arapcommon.helper.BOTPHelper;
import kd.fi.arapcommon.helper.BookDateHelper;
import kd.fi.arapcommon.helper.UnitConvertHelper;
import kd.fi.arapcommon.service.plan.split.helper.PlanSplitSchemeServiceHelper;
import kd.fi.arapcommon.service.writeback.base.EntryCalculateParam;
import kd.fi.arapcommon.service.writeback.base.ProportionCalculator;
import kd.fi.arapcommon.util.EmptyUtils;
import kd.fi.arapcommon.util.QueryUtil;
import kd.fi.arapcommon.util.StringUtils;

public class FinArAdjustConvertPlugin
extends AbstractConvertPlugIn {
    private static final Log logger = LogFactory.getLog(FinArAdjustConvertPlugin.class);
    private boolean isTotalAdjust = false;
    private Map<Long, DynamicObject> orgInitMap;
    private DynamicObject[] needMatchSplitSchemes;
    Map<Long, DynamicObject> srcIdToSrcBillMap = new HashMap<Long, DynamicObject>(1);
    private final QueryUtil queryUtil = new QueryUtil();
    private final Map<Long, List<DynamicObject>> detailEntriesCache = new HashMap<Long, List<DynamicObject>>(1);

    public void afterConvert(AfterConvertEventArgs e) {
        logger.info("FinArAdjustConvertPlugin.afterConvert start");
        ExtendedDataEntitySet entitySet = e.getTargetExtDataEntitySet();
        ExtendedDataEntity[] extendEntites = entitySet.FindByEntityKey(this.getTgtMainType().getExtendName());
        ArrayList<DynamicObject> entities = new ArrayList<DynamicObject>(extendEntites.length);
        for (ExtendedDataEntity extendEntity : extendEntites) {
            entities.add(extendEntity.getDataEntity());
        }
        this.prepareData(entities);
        HashMap<Long, Boolean> relationPayMap = new HashMap<Long, Boolean>(8);
        for (DynamicObject finArBill : entities) {
            DynamicObject org = finArBill.getDynamicObject("org");
            if (ObjectUtils.isEmpty((Object)org)) {
                return;
            }
            InitServiceHelper.checkOrgInit((DynamicObject)org, this.orgInitMap, (boolean)true);
            this.setHeadValue(finArBill);
            this.setDetailEntryValue(finArBill);
            DynamicObject asstact = finArBill.getDynamicObject("asstact");
            finArBill.set("relationpay", (Object)this.isBizPartner(asstact, relationPayMap));
        }
        for (DynamicObject finArBill : entities) {
            this.setHeadAmtValue(finArBill);
            this.setPlanEntryValue(finArBill);
        }
        BookDateHelper.setBookDate(entities.toArray(new DynamicObject[0]), true);
        logger.info("FinArAdjustConvertPlugin.afterConvert end");
    }

    private void prepareData(List<DynamicObject> entities) {
        logger.info("FinArAdjustConvertPlugin.prepareData start");
        OperateOption option = this.getOption();
        Map variables = option.getVariables();
        if (variables.get("adjusttotalamt") != null) {
            this.isTotalAdjust = true;
        }
        HashSet<Long> orgIds = new HashSet<Long>(1);
        HashSet<Long> srcBillIds = new HashSet<Long>(1);
        for (DynamicObject entity : entities) {
            long orgId = entity.getLong("org.id");
            if (orgId != 0L) {
                orgIds.add(orgId);
            }
            String srcBillType = entity.getString("sourcebilltype");
            String billTypeNum = entity.getString("billtype.number");
            if (!"ar_finarbill".equals(srcBillType) || !"arfin_borrowar_BT_S".equals(billTypeNum)) continue;
            srcBillIds.add(entity.getLong("sourcebillid"));
        }
        this.orgInitMap = InitServiceHelper.loadInitInfos(orgIds, (boolean)true);
        if (this.isTotalAdjust && srcBillIds.size() > 0) {
            DynamicObject[] srcArBills;
            for (DynamicObject srcArBill : srcArBills = BusinessDataServiceHelper.load((String)"ar_finarbill", (String)"id,currency,e_recamount,e_unlockamt,recamount", (QFilter[])new QFilter[]{new QFilter("id", "in", srcBillIds)})) {
                this.srcIdToSrcBillMap.put(srcArBill.getLong("id"), srcArBill);
            }
        }
        this.needMatchSplitSchemes = PlanSplitSchemeServiceHelper.getMatchSchemes("ar_finarbill");
        logger.info("FinArAdjustConvertPlugin.prepareData end");
    }

    private void setHeadValue(DynamicObject finArBill) {
        String imageno;
        OperateOption option = this.getOption();
        Map variables = option.getVariables();
        DynamicObject org = finArBill.getDynamicObject("org");
        InitServiceHelper.setBizDate((DynamicObject)finArBill, (DynamicObject)this.orgInitMap.get(org.getLong("id")), (ConvertRuleElement)this.getRule());
        boolean isSettingForExchange = BOTPHelper.ruleIsSetting(this.getRule(), true, "exchangerate");
        InitServiceHelper.setInitValue((DynamicObject)finArBill, (DynamicObject)this.orgInitMap.get(org.getLong("id")), (boolean)isSettingForExchange);
        String adjustType = finArBill.getString("adjusttype");
        if (StringUtils.isEmpty(adjustType)) {
            finArBill.set("adjusttype", variables.get("adjusttype"));
        }
        if (StringUtils.isNotEmpty(imageno = finArBill.getString("imageno")) && imageno.length() > 50) {
            finArBill.set("imageno", (Object)imageno.substring(0, 50));
        }
        if (this.isTotalAdjust) {
            DataEntityPropertyCollection finPros = finArBill.getDataEntityType().getProperties();
            for (Map.Entry variablesEntrySet : variables.entrySet()) {
                String key = (String)variablesEntrySet.getKey();
                String value = (String)variablesEntrySet.getValue();
                if (finPros.get((Object)key) == null || this.adjustStandPros().contains(key)) continue;
                finArBill.set(key, (Object)value);
            }
        }
    }

    private Boolean isBizPartner(DynamicObject custsupper, Map<Long, Boolean> relationPayMap) {
        if (custsupper == null) {
            return Boolean.FALSE;
        }
        Long asstactId = custsupper.getLong("id");
        Boolean relationPay = relationPayMap.get(asstactId);
        if (relationPay == null) {
            DynamicObject asstact;
            DynamicObject intercompany;
            relationPay = Boolean.FALSE;
            if ((custsupper.getDataEntityType().getName().equals("bd_supplier") || custsupper.getDataEntityType().getName().equals("bd_customer")) && (intercompany = (asstact = BusinessDataServiceHelper.loadSingleFromCache((Object)custsupper.getPkValue(), (String)custsupper.getDynamicObjectType().getName(), (String)"internal_company")).getDynamicObject("internal_company")) != null) {
                relationPay = Boolean.TRUE;
            }
            relationPayMap.put(asstactId, relationPay);
        }
        return relationPay;
    }

    private void setDetailEntryValue(DynamicObject finArBill) {
        if (this.isTotalAdjust) {
            this.calculateDetailAmtInfoByRate(finArBill);
            this.setDetailEntryExtProps(finArBill);
        }
        this.calculateDetailEntry(finArBill);
        if (this.isPushAndSave(finArBill)) {
            List<DynamicObject> detailEntries = this.detailEntriesCache.get(finArBill.getLong("id"));
            if (detailEntries == null) {
                ArrayList finArDetailEntries = new ArrayList(8);
                finArDetailEntries.addAll(finArBill.getDynamicObjectCollection("entry"));
                this.detailEntriesCache.put(finArBill.getLong("id"), finArDetailEntries);
            } else {
                detailEntries.addAll((Collection<DynamicObject>)finArBill.getDynamicObjectCollection("entry"));
            }
        }
    }

    private void setHeadAmtValue(DynamicObject finArBill) {
        BigDecimal priceTaxTotal = BigDecimal.ZERO;
        BigDecimal priceTaxTotalBase = BigDecimal.ZERO;
        BigDecimal amount = BigDecimal.ZERO;
        BigDecimal amountBase = BigDecimal.ZERO;
        BigDecimal tax = BigDecimal.ZERO;
        BigDecimal taxLocAmt = BigDecimal.ZERO;
        BigDecimal adjustamt = BigDecimal.ZERO;
        BigDecimal adjustamtlocal = BigDecimal.ZERO;
        Object detailEntries = this.isPushAndSave(finArBill) ? this.detailEntriesCache.get(finArBill.getLong("id")) : finArBill.getDynamicObjectCollection("entry");
        for (DynamicObject detailEntry : detailEntries) {
            priceTaxTotal = priceTaxTotal.add(detailEntry.getBigDecimal("e_recamount"));
            priceTaxTotalBase = priceTaxTotalBase.add(detailEntry.getBigDecimal("e_reclocalamt"));
            amount = amount.add(detailEntry.getBigDecimal("e_amount"));
            amountBase = amountBase.add(detailEntry.getBigDecimal("e_localamt"));
            tax = tax.add(detailEntry.getBigDecimal("e_tax"));
            taxLocAmt = taxLocAmt.add(detailEntry.getBigDecimal("e_taxlocalamt"));
            adjustamt = adjustamt.add(detailEntry.getBigDecimal("e_adjustamount"));
            adjustamtlocal = adjustamtlocal.add(detailEntry.getBigDecimal("e_adjustlocalamt"));
        }
        finArBill.set("recamount", (Object)priceTaxTotal);
        finArBill.set("reclocalamt", (Object)priceTaxTotalBase);
        finArBill.set("amount", (Object)amount);
        finArBill.set("localamt", (Object)amountBase);
        finArBill.set("tax", (Object)tax);
        finArBill.set("taxlocamt", (Object)taxLocAmt);
        finArBill.set("unverifyamount", (Object)amount);
        finArBill.set("unsettleamount", (Object)priceTaxTotal);
        finArBill.set("unsettlelocalamt", (Object)priceTaxTotalBase);
        finArBill.set("adjustamount", (Object)adjustamt);
        finArBill.set("adjustlocalamt", (Object)adjustamtlocal);
        finArBill.set("uninvoicedamt", (Object)priceTaxTotal);
        finArBill.set("uninvoicedlocalamt", (Object)priceTaxTotalBase);
    }

    private void setPlanEntryValue(DynamicObject finArBill) {
        DynamicObject matchSplitScheme = PlanSplitSchemeServiceHelper.matchSingleScheme(finArBill, this.needMatchSplitSchemes);
        finArBill.set("splitscheme", (Object)matchSplitScheme);
        if (this.isPushAndSave(finArBill)) {
            this.calculatePlanEntryByPushAndSave(finArBill, matchSplitScheme);
        } else {
            ArPlanSplitAndBuilder.splitAndBuild((DynamicObject)finArBill, (DynamicObject)matchSplitScheme);
        }
        this.setHeadDueDate(finArBill);
    }

    private void calculatePlanEntryByPushAndSave(DynamicObject finArBill, DynamicObject matchSplitScheme) {
        DynamicObject[] dbFinArBills = BusinessDataServiceHelper.load((String)"ar_finarbill", (String)"e_splitdimensionid,planentity.id", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)finArBill.getLong("id"))});
        if (dbFinArBills == null || dbFinArBills.length == 0) {
            ArPlanSplitAndBuilder.splitAndBuild((DynamicObject)finArBill, (DynamicObject)matchSplitScheme);
        } else {
            DynamicObject dbFinArBill = dbFinArBills[0];
            List<DynamicObject> detailEntries = this.detailEntriesCache.get(finArBill.getLong("id"));
            Map detailEntryIndexToSplitDimensionId = ArPlanSplitAndBuilder.splitAndBuildByPushAndSave((DynamicObject)finArBill, detailEntries, (DynamicObject)matchSplitScheme);
            DynamicObjectCollection dbDetailEntries = dbFinArBill.getDynamicObjectCollection("entry");
            DynamicObjectCollection curDetailEntries = finArBill.getDynamicObjectCollection("entry");
            int dbDetailEntrySize = dbDetailEntries.size();
            for (int i = 0; i < dbDetailEntrySize; ++i) {
                DynamicObject dbDetailEntry = (DynamicObject)dbDetailEntries.get(i);
                dbDetailEntry.set("e_splitdimensionid", detailEntryIndexToSplitDimensionId.get(i));
            }
            int curDetailEntrySize = curDetailEntries.size();
            for (int i = 0; i < curDetailEntrySize; ++i) {
                DynamicObject curDetailEntry = (DynamicObject)curDetailEntries.get(i);
                curDetailEntry.set("e_splitdimensionid", detailEntryIndexToSplitDimensionId.get(i + dbDetailEntrySize));
            }
            DynamicObjectCollection dbPlanEntries = dbFinArBill.getDynamicObjectCollection("planentity");
            dbPlanEntries.clear();
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dbFinArBill});
        }
    }

    private void setHeadDueDate(DynamicObject finArBill) {
        Date planMaxDuedate = finArBill.getDate("duedate");
        DynamicObjectCollection planEntries = finArBill.getDynamicObjectCollection("planentity");
        for (DynamicObject planEntry : planEntries) {
            Date planEntryDueDate = planEntry.getDate("planduedate");
            if (planMaxDuedate == null) {
                planMaxDuedate = planEntryDueDate;
                continue;
            }
            if (planEntryDueDate == null) continue;
            planMaxDuedate = planEntryDueDate.after(planMaxDuedate) ? planEntryDueDate : planMaxDuedate;
        }
        finArBill.set("duedate", (Object)planMaxDuedate);
    }

    private void calculateDetailAmtInfoByRate(DynamicObject finArBill) {
        BigDecimal curAdjustAmt;
        Long sourceBillId = finArBill.getLong("sourcebillid");
        DynamicObject sourceBill = this.srcIdToSrcBillMap.get(sourceBillId);
        BigDecimal sourcePriceTaxTotal = sourceBill.getBigDecimal("recamount");
        DynamicObjectCollection sourceBillDetailEntries = sourceBill.getDynamicObjectCollection("entry");
        BigDecimal sourceBillUnLockAmtTotal = BigDecimal.ZERO;
        for (DynamicObject sourceBillDetailEntry : sourceBillDetailEntries) {
            BigDecimal srcUnlockAmt = sourceBillDetailEntry.getBigDecimal("e_unlockamt");
            if (srcUnlockAmt.compareTo(BigDecimal.ZERO) <= 0) continue;
            sourceBillUnLockAmtTotal = sourceBillUnLockAmtTotal.add(srcUnlockAmt);
        }
        OperateOption option = this.getOption();
        Map variables = option.getVariables();
        BigDecimal adjustAmt = new BigDecimal((String)variables.get("adjusttotalamt"));
        BigDecimal adjustTaxAmt = new BigDecimal((String)variables.get("adjusttotaltaxamt"));
        BigDecimal adjustTotalAmt = adjustAmt.add(adjustTaxAmt);
        boolean isByUnLock = false;
        boolean isOverPriceTaxTotal = false;
        if (adjustTotalAmt.compareTo(BigDecimal.ZERO) < 0 && adjustTotalAmt.abs().compareTo(sourceBillUnLockAmtTotal.abs()) <= 0 && sourceBillUnLockAmtTotal.compareTo(BigDecimal.ZERO) > 0 && adjustTotalAmt.abs().compareTo(sourcePriceTaxTotal) <= 0) {
            isByUnLock = true;
        } else if (sourcePriceTaxTotal.compareTo(BigDecimal.ZERO) > 0) {
            if (adjustTotalAmt.abs().compareTo(sourcePriceTaxTotal) > 0) {
                isOverPriceTaxTotal = true;
            }
        } else {
            logger.info("srcBill pricetaxtotal < 0, use simple");
            isOverPriceTaxTotal = true;
        }
        logger.info("isOverPriceTaxTotal:" + isOverPriceTaxTotal + ",isByUnLock:" + isByUnLock);
        Map<Object, Object> entryIdToAdjustTotalAmt = new HashMap<Long, BigDecimal>(sourceBillDetailEntries.size());
        Map<Object, Object> entryIdToAdjustAmt = new HashMap<Long, BigDecimal>(sourceBillDetailEntries.size());
        ArrayList<DynamicObject> noZeroSourceBillDetailEntries = new ArrayList<DynamicObject>(sourceBillDetailEntries.size());
        for (DynamicObject entry : sourceBillDetailEntries) {
            if (entry.getBigDecimal("e_recamount").compareTo(BigDecimal.ZERO) == 0) continue;
            noZeroSourceBillDetailEntries.add(entry);
        }
        if (isOverPriceTaxTotal) {
            int count = 0;
            int scale = this.getPrecision(sourceBill);
            BigDecimal remainAdjustTotalAmt = BigDecimal.ZERO;
            BigDecimal remainAdjustAmt = BigDecimal.ZERO;
            for (DynamicObject sourceBillDetailEntry : noZeroSourceBillDetailEntries) {
                if (++count == noZeroSourceBillDetailEntries.size()) {
                    entryIdToAdjustTotalAmt.put(sourceBillDetailEntry.getLong("id"), adjustTotalAmt.abs().subtract(remainAdjustTotalAmt));
                    entryIdToAdjustAmt.put(sourceBillDetailEntry.getLong("id"), adjustAmt.abs().subtract(remainAdjustAmt));
                    continue;
                }
                BigDecimal entryPriceTaxAmt = sourceBillDetailEntry.getBigDecimal("e_recamount");
                BigDecimal proportion = entryPriceTaxAmt.divide(sourcePriceTaxTotal, 10, RoundingMode.DOWN);
                BigDecimal curAdjustTotalAmt = adjustTotalAmt.abs().multiply(proportion).setScale(scale, RoundingMode.DOWN);
                entryIdToAdjustTotalAmt.put(sourceBillDetailEntry.getLong("id"), curAdjustTotalAmt);
                remainAdjustTotalAmt = remainAdjustTotalAmt.add(curAdjustTotalAmt);
                curAdjustAmt = adjustAmt.abs().multiply(proportion).setScale(scale, RoundingMode.DOWN);
                entryIdToAdjustAmt.put(sourceBillDetailEntry.getLong("id"), curAdjustAmt);
                remainAdjustAmt = remainAdjustAmt.add(curAdjustAmt);
            }
        } else {
            ProportionCalculator proportionCalculator = new ProportionCalculator();
            EntryCalculateParam param = new EntryCalculateParam();
            param.setEntryPriceTaxTotalKey(isByUnLock ? "e_unlockamt" : "e_recamount");
            param.setCurrencyKey("currency");
            proportionCalculator.init(param);
            if (isByUnLock) {
                DynamicObjectCollection directSourceBillDetailEntries = new DynamicObjectCollection();
                for (DynamicObject sourceBillDetailEntry : sourceBillDetailEntries) {
                    BigDecimal srcUnlockAmt = sourceBillDetailEntry.getBigDecimal("e_unlockamt");
                    if (srcUnlockAmt.compareTo(BigDecimal.ZERO) <= 0) continue;
                    directSourceBillDetailEntries.add((Object)sourceBillDetailEntry);
                }
                entryIdToAdjustTotalAmt = proportionCalculator.loadEntryWriteBackAmtMap(sourceBill, directSourceBillDetailEntries, adjustTotalAmt.abs());
                if (adjustAmt.abs().compareTo(sourceBillUnLockAmtTotal) > 0) {
                    int count = 0;
                    int scale = this.getPrecision(sourceBill);
                    Object remainAdjustAmt = BigDecimal.ZERO;
                    for (DynamicObject sourceBillDetailEntry : directSourceBillDetailEntries) {
                        if (++count == directSourceBillDetailEntries.size()) {
                            entryIdToAdjustAmt.put(sourceBillDetailEntry.getLong("id"), adjustAmt.abs().subtract((BigDecimal)remainAdjustAmt));
                            continue;
                        }
                        BigDecimal entryPriceTaxAmt = sourceBillDetailEntry.getBigDecimal("e_unlockamt");
                        BigDecimal proportion = entryPriceTaxAmt.divide(sourcePriceTaxTotal, 10, RoundingMode.DOWN);
                        BigDecimal curAdjustAmt2 = adjustAmt.abs().multiply(proportion).setScale(scale, RoundingMode.DOWN);
                        entryIdToAdjustAmt.put(sourceBillDetailEntry.getLong("id"), curAdjustAmt2);
                        remainAdjustAmt = ((BigDecimal)remainAdjustAmt).add(curAdjustAmt2);
                    }
                } else {
                    entryIdToAdjustAmt = proportionCalculator.loadEntryWriteBackAmtMap(sourceBill, directSourceBillDetailEntries, adjustAmt.abs());
                }
            } else {
                entryIdToAdjustTotalAmt = proportionCalculator.loadEntryWriteBackAmtMap(sourceBill, sourceBillDetailEntries, adjustTotalAmt.abs());
                if (adjustAmt.abs().compareTo(sourcePriceTaxTotal) > 0) {
                    int count = 0;
                    int scale = this.getPrecision(sourceBill);
                    BigDecimal remainAdjustAmt = BigDecimal.ZERO;
                    for (DynamicObject sourceBillDetailEntry : noZeroSourceBillDetailEntries) {
                        if (++count == noZeroSourceBillDetailEntries.size()) {
                            entryIdToAdjustAmt.put(sourceBillDetailEntry.getLong("id"), adjustAmt.abs().subtract(remainAdjustAmt));
                            continue;
                        }
                        BigDecimal entryPriceTaxAmt = sourceBillDetailEntry.getBigDecimal("e_recamount");
                        BigDecimal proportion = entryPriceTaxAmt.divide(sourcePriceTaxTotal, 10, RoundingMode.DOWN);
                        curAdjustAmt = adjustAmt.abs().multiply(proportion).setScale(scale, RoundingMode.DOWN);
                        entryIdToAdjustAmt.put(sourceBillDetailEntry.getLong("id"), curAdjustAmt);
                        remainAdjustAmt = remainAdjustAmt.add(curAdjustAmt);
                    }
                } else {
                    entryIdToAdjustAmt = proportionCalculator.loadEntryWriteBackAmtMap(sourceBill, sourceBillDetailEntries, adjustAmt.abs());
                }
            }
        }
        BigDecimal adjustTotalAmtSign = new BigDecimal(adjustTotalAmt.signum());
        BigDecimal adjustAmtSign = new BigDecimal(adjustAmt.signum());
        DynamicObjectCollection detailEntries = finArBill.getDynamicObjectCollection("entry");
        for (DynamicObject detailEntry : detailEntries) {
            long entryId = detailEntry.getLong("e_srcentryid");
            BigDecimal entryAdjustTotalAmt = (BigDecimal)entryIdToAdjustTotalAmt.get(entryId);
            if (entryAdjustTotalAmt == null || entryAdjustTotalAmt.compareTo(BigDecimal.ZERO) == 0) {
                detailEntry.set("e_recamount", (Object)BigDecimal.ZERO);
            } else {
                detailEntry.set("e_recamount", (Object)entryAdjustTotalAmt.multiply(adjustTotalAmtSign));
            }
            BigDecimal entryAdjustAmt = (BigDecimal)entryIdToAdjustAmt.get(entryId);
            if (entryAdjustAmt == null || entryAdjustAmt.compareTo(BigDecimal.ZERO) == 0) {
                detailEntry.set("e_amount", (Object)BigDecimal.ZERO);
            } else {
                detailEntry.set("e_amount", (Object)entryAdjustAmt.multiply(adjustAmtSign));
            }
            detailEntry.set("e_tax", (Object)detailEntry.getBigDecimal("e_recamount").subtract(detailEntry.getBigDecimal("e_amount")));
        }
    }

    private void setDetailEntryExtProps(DynamicObject finArBill) {
        OperateOption option = this.getOption();
        Map variables = option.getVariables();
        DynamicObjectCollection detailEntries = finArBill.getDynamicObjectCollection("entry");
        DataEntityPropertyCollection entryProps = detailEntries.getDynamicObjectType().getProperties();
        boolean isExistEntryExtProp = false;
        for (Map.Entry variableEntrySet : variables.entrySet()) {
            String key = (String)variableEntrySet.getKey();
            if (entryProps.get((Object)key) == null) continue;
            isExistEntryExtProp = true;
            break;
        }
        if (isExistEntryExtProp) {
            for (DynamicObject detailEntry : detailEntries) {
                for (Map.Entry variableEntrySet : variables.entrySet()) {
                    String key = (String)variableEntrySet.getKey();
                    String value = (String)variableEntrySet.getValue();
                    if (entryProps.get((Object)key) == null) continue;
                    detailEntry.set(key, (Object)value);
                }
            }
        }
    }

    private void calculateDetailEntry(DynamicObject finArBill) {
        int basePrecision = finArBill.getInt("basecurrency.amtprecision");
        boolean includeTax = finArBill.getBoolean("isincludetax");
        String quotation = finArBill.getString("quotation");
        BigDecimal exchangeRate = finArBill.getBigDecimal("exchangerate");
        if (exchangeRate.compareTo(BigDecimal.ZERO) == 0 && "1".equals(quotation)) {
            quotation = "0";
        }
        DynamicObjectCollection detailEntries = finArBill.getDynamicObjectCollection("entry");
        for (DynamicObject detailEntry : detailEntries) {
            BigDecimal e_tax = detailEntry.getBigDecimal("e_tax");
            BigDecimal e_pricetaxtotal = detailEntry.getBigDecimal("e_recamount");
            BigDecimal e_amount = detailEntry.getBigDecimal("e_amount");
            BigDecimal discountamount = detailEntry.getBigDecimal("e_discountamount");
            BigDecimal eAdjustamount = detailEntry.getBigDecimal("e_adjustamount");
            FXPriceLocalCalculator calculator = new FXPriceLocalCalculator(includeTax, e_tax, e_amount, discountamount, exchangeRate, basePrecision, eAdjustamount, quotation);
            calculator.calculate();
            BigDecimal e_amountbase = calculator.getAmountLocal();
            BigDecimal e_taxlocamt = calculator.getTaxLocal();
            BigDecimal e_pricetaxtotalbase = calculator.getPriceTaxTotalLocal();
            BigDecimal discountamountLocal = calculator.getDiscountamountLocal();
            BigDecimal e_adjustlocalamt = calculator.getAdjustamtlocal();
            detailEntry.set("e_discountlocalamt", (Object)discountamountLocal);
            detailEntry.set("e_localamt", (Object)e_amountbase);
            detailEntry.set("e_taxlocalamt", (Object)e_taxlocamt);
            detailEntry.set("e_reclocalamt", (Object)e_pricetaxtotalbase);
            detailEntry.set("e_unsettlelocalamt", (Object)e_pricetaxtotalbase);
            detailEntry.set("e_adjustlocalamt", (Object)e_adjustlocalamt);
            detailEntry.set("e_uninvoicedlocalamt", (Object)e_pricetaxtotalbase);
            detailEntry.set("e_unlockamt", (Object)e_pricetaxtotal);
            detailEntry.set("e_unsettleamt", (Object)e_pricetaxtotal);
            detailEntry.set("e_uninvoicedamt", (Object)e_pricetaxtotal);
            detailEntry.set("e_unverifyamt", (Object)e_amount);
            detailEntry.set("e_reclocalamt", (Object)e_pricetaxtotalbase);
            detailEntry.set("e_unsettlelocalamt", (Object)e_pricetaxtotalbase);
            detailEntry.set("e_unconfirmamt", (Object)e_amount);
            BigDecimal quantity = detailEntry.getBigDecimal("e_quantity");
            if (quantity == null) {
                quantity = BigDecimal.ZERO;
            }
            BigDecimal covertRate = detailEntry.getBigDecimal("e_unitcoefficient");
            DynamicObject material = detailEntry.getDynamicObject("e_material");
            DynamicObject measureUnit = detailEntry.getDynamicObject("e_measureunit");
            DynamicObject baseUnit = detailEntry.getDynamicObject("e_baseunit");
            if (!ObjectUtils.isEmpty((Object)material)) {
                if (ObjectUtils.isEmpty((Object)baseUnit)) {
                    baseUnit = material.getDynamicObject("baseunit");
                    detailEntry.set("e_baseunit", (Object)baseUnit);
                }
                if (measureUnit == null) {
                    measureUnit = baseUnit;
                }
                if (covertRate == null || covertRate.compareTo(BigDecimal.ZERO) == 0) {
                    covertRate = this.queryUtil.getConvertRate(material.getLong("id"), measureUnit.getLong("id"), baseUnit.getLong("id"));
                }
            } else if (covertRate == null || covertRate.compareTo(BigDecimal.ZERO) == 0) {
                covertRate = BigDecimal.ONE;
            }
            if (EmptyUtils.isEmpty(detailEntry.getBigDecimal("e_unitcoefficient"))) {
                detailEntry.set("e_unitcoefficient", (Object)covertRate);
            }
            if (EmptyUtils.isEmpty(detailEntry.getBigDecimal("e_baseunitqty"))) {
                detailEntry.set("e_baseunitqty", (Object)UnitConvertHelper.getBaseunitqty(quantity, covertRate, baseUnit));
            }
            if (!EmptyUtils.isEmpty(detailEntry.getBigDecimal("e_unverifybaseqty"))) continue;
            detailEntry.set("e_unverifybaseqty", (Object)UnitConvertHelper.getBaseunitqty(detailEntry.getBigDecimal("e_unverifyqty"), covertRate, baseUnit));
        }
    }

    private boolean isPushAndSave(DynamicObject finArBill) {
        return BOTPHelper.isPushAndSave(this.getRule(), finArBill);
    }

    private int getPrecision(DynamicObject finBill) {
        DynamicObject currency = finBill.getDynamicObject("currency");
        return currency == null ? 2 : currency.getInt("amtprecision");
    }

    private Set<String> adjustStandPros() {
        HashSet<String> standProSet = new HashSet<String>(6);
        standProSet.add("adjusttype");
        standProSet.add("adjusttotalamt");
        standProSet.add("adjusttotaltaxamt");
        standProSet.add("adjustallamt");
        standProSet.add("currency");
        standProSet.add("currency_id");
        return standProSet;
    }
}

