/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.eas.helper;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.arapcommon.model.BillModel;

public class MoveEasCommonHelper {
    public static void entryAmtSumToHead(DynamicObject bill, String entryName, List<Tuple<String, String>> sumAmtFieldList) {
        if (ObjectUtils.isEmpty(sumAmtFieldList)) {
            return;
        }
        for (Tuple<String, String> tuple : sumAmtFieldList) {
            bill.set((String)tuple.item2, (Object)BigDecimal.ZERO);
        }
        DynamicObjectCollection entry = bill.getDynamicObjectCollection(entryName);
        for (DynamicObject row : entry) {
            for (Tuple<String, String> tuple : sumAmtFieldList) {
                bill.set((String)tuple.item2, (Object)bill.getBigDecimal((String)tuple.item2).add(row.getBigDecimal((String)tuple.item1)));
            }
        }
    }

    public static void dealSrcBillNoSetValue(Map<String, Map<Long, String>> srcTypeAndBillNoMap, DynamicObject dataEntity, BillModel billModel) {
        Map<Long, String> idAndBillNoMap = srcTypeAndBillNoMap.get(dataEntity.getString(billModel.HEAD_SOURCEBILLTYPE));
        if (idAndBillNoMap == null) {
            return;
        }
        String srcBillNo = idAndBillNoMap.get(dataEntity.getLong(billModel.HEAD_SOURCEBILLID));
        if (srcBillNo == null) {
            return;
        }
        dataEntity.set(billModel.HEAD_SOURCEBILLNO, (Object)srcBillNo);
    }

    public static Map<String, Set<Long>> buildSrcTypeAndSrcId(DynamicObject[] dataEntities, BillModel billModel) {
        HashMap<String, Set<Long>> srcTypeAndSrcIdMap = new HashMap<String, Set<Long>>(8);
        for (DynamicObject dataEntity : dataEntities) {
            String srcType = dataEntity.getString(billModel.HEAD_SOURCEBILLTYPE);
            if (srcType == null || "".equals(srcType)) continue;
            Set srcIdSet = srcTypeAndSrcIdMap.getOrDefault(srcType, new HashSet(8));
            DynamicObjectCollection entryColl = dataEntity.getDynamicObjectCollection(billModel.ENTRY);
            for (DynamicObject entry : entryColl) {
                srcIdSet.add(entry.getLong(billModel.E_SOURCEBILLID));
            }
            srcTypeAndSrcIdMap.put(srcType, srcIdSet);
        }
        return srcTypeAndSrcIdMap;
    }

    public static Map<String, Map<Long, String>> findSrcTypeAndBillNo(Map<String, Set<Long>> srcTypeAndSrcIdMap) {
        HashMap<String, Map<Long, String>> srcTypeAndBillNoMap = new HashMap<String, Map<Long, String>>(8);
        for (Map.Entry<String, Set<Long>> entry : srcTypeAndSrcIdMap.entrySet()) {
            String billType = entry.getKey();
            if (billType == null || "".equals(billType)) continue;
            Set<Long> idSet = entry.getValue();
            DynamicObjectCollection billColl = QueryServiceHelper.query((String)billType, (String)"id,billno", (QFilter[])new QFilter[]{new QFilter("id", "in", idSet)});
            for (DynamicObject bill : billColl) {
                Map idAndBillNoMap = srcTypeAndBillNoMap.getOrDefault(billType, new HashMap(8));
                idAndBillNoMap.put(bill.getLong("id"), bill.getString("billno"));
                srcTypeAndBillNoMap.put(billType, idAndBillNoMap);
            }
        }
        return srcTypeAndBillNoMap;
    }

    public static String fromEasNotAllowedWrittenOff(String entityType, List<Object> busBillIds) {
        boolean isFromEas = false;
        DynamicObjectCollection billColl = QueryServiceHelper.query((String)entityType, (String)"billsrctype", (QFilter[])new QFilter[]{new QFilter("id", "in", busBillIds)});
        for (DynamicObject bill : billColl) {
            if (!"fromeas".equals(bill.getString("billsrctype"))) continue;
            isFromEas = true;
            break;
        }
        if (!isFromEas) {
            return "";
        }
        switch (entityType) {
            case "ap_busbill": {
                return ResManager.loadKDString((String)"\u6682\u4f30\u5e94\u4ed8\u5355\u4e3aEAS\u96c6\u6210\u7684\u6570\u636e\uff0c\u4e3a\u4fdd\u8bc1\u6570\u636e\u4e00\u81f4\u6027\uff0c\u4e0d\u5141\u8bb8\u201c\u51b2\u56de\u201d\u3002", (String)"MoveEasCommonHelper_01", (String)"fi-arapcommon", (Object[])new Object[0]);
            }
            case "ar_busbill": {
                return ResManager.loadKDString((String)"\u6682\u4f30\u5e94\u6536\u5355\u4e3aEAS\u96c6\u6210\u7684\u6570\u636e\uff0c\u4e3a\u4fdd\u8bc1\u6570\u636e\u4e00\u81f4\u6027\uff0c\u4e0d\u5141\u8bb8\u201c\u51b2\u56de\u201d\u3002", (String)"MoveEasCommonHelper_02", (String)"fi-arapcommon", (Object[])new Object[0]);
            }
        }
        return "";
    }
}

