/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.eas.opplugin;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.PrimitiveIterator;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.property.EntryProp;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class BaddebtPrepareAfterProcess4EasOp
extends AbstractOperationServicePlugIn {
    private static final Log logger = LogFactory.getLog(BaddebtPrepareAfterProcess4EasOp.class);
    private static final String ENTRY = "entry";
    private static final String AR_BADDEBTPREPAREBILL = "ar_baddebtpreparebill";
    private static final String DMW_EASIDCHANGE = "dmw_easidchange";
    private static final String EAS_AR_BADDEBT_BOSTYPE = "4696890F";
    private PrimitiveIterator.OfLong uniqueKeyIterator = Arrays.stream(DB.genGlobalLongIds((int)100)).iterator();

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        logger.info("BaddebtPrepareAfterProcess4EasOp endOperationTransaction begin.");
        DynamicObject[] dataEntities = this.getBills(e);
        HashSet<Long> orgIds = new HashSet<Long>(8);
        for (DynamicObject dataEntity : dataEntities) {
            orgIds.add(dataEntity.getLong("org.id"));
        }
        int orgDeleteSize = DeleteServiceHelper.delete((String)AR_BADDEBTPREPAREBILL, (QFilter[])new QFilter[]{new QFilter("org", "in", orgIds), new QFilter("agingrange", "!=", (Object)"2")});
        logger.info("BaddebtPrepareAfterProcess4EasOp endOperationTransaction orgDeleteSize:" + orgDeleteSize);
        Map<Long, Long> baddebtRecordPrePeriodMap = this.getBaddebtRecordPrePeriod(orgIds);
        logger.info("BaddebtPrepareAfterProcess4EasOp endOperationTransaction baddebtRecordPrePeriodMap:" + baddebtRecordPrePeriodMap);
        Map<Long, DynamicObject> initObjMap = this.getInitObjMap(orgIds);
        HashMap<Long, Date> orgAndDate = new HashMap<Long, Date>(8);
        for (Map.Entry<Long, DynamicObject> initMapEntry : initObjMap.entrySet()) {
            Long key = initMapEntry.getKey();
            DynamicObject value = initMapEntry.getValue();
            orgAndDate.put(key, value.getDate("curperiod.begindate"));
        }
        logger.info("BaddebtPrepareAfterProcess4EasOp endOperationTransaction orgAndDate:" + orgAndDate);
        Map<String, List<DynamicObject>> accrualTypeMap = Arrays.stream(dataEntities).filter(bill -> bill.getDate("accrualdate").compareTo((Date)orgAndDate.get(bill.getLong("org.id"))) < 0).collect(Collectors.groupingBy(bill -> bill.getString("agingrange")));
        ArrayList<DynamicObject> saveBillList = new ArrayList<DynamicObject>(8);
        ArrayList<DynamicObject> easIdChangeList = new ArrayList<DynamicObject>(8);
        for (Map.Entry entry : accrualTypeMap.entrySet()) {
            String key = (String)entry.getKey();
            List values = (List)entry.getValue();
            Optional<DynamicObject> targetOptional = values.stream().max(Comparator.comparing(bill -> bill.getDate("accrualdate")));
            if (!targetOptional.isPresent()) continue;
            DynamicObject value = targetOptional.get();
            if ("6".equals(key)) {
                this.rebuildByBill(value, saveBillList, baddebtRecordPrePeriodMap, initObjMap);
                easIdChangeList.addAll(this.prepareDmwDynamicObject(saveBillList));
            }
            if ("5".equals(key)) {
                this.rebuildByCus(value, saveBillList, baddebtRecordPrePeriodMap, initObjMap);
                easIdChangeList.addAll(this.prepareDmwDynamicObject(saveBillList));
            }
            if (!"2".equals(key)) continue;
            this.rebuildByAnalys(value, saveBillList, baddebtRecordPrePeriodMap, initObjMap);
            QFilter filter = new QFilter("org", "in", orgIds).and(new QFilter("agingrange", "=", (Object)"2"));
            if (!saveBillList.isEmpty()) {
                List ids = saveBillList.stream().map(bill -> bill.getLong("id")).collect(Collectors.toList());
                filter.and("id", "not in", ids);
            }
            DeleteServiceHelper.delete((String)AR_BADDEBTPREPAREBILL, (QFilter[])new QFilter[]{filter});
        }
        if (!easIdChangeList.isEmpty()) {
            logger.info("BaddebtPrepareAfterProcess4EasOp endOperationTransaction easIdChangeList:" + easIdChangeList.size());
            Throwable throwable = null;
            try (TXHandle tx = TX.requiresNew((String)"insertDmwTableData");){
                try {
                    Set easRecordIds = easIdChangeList.stream().map(bill -> bill.getString("easparentid")).collect(Collectors.toSet());
                    Set easRecordEntryIds = easIdChangeList.stream().map(bill -> bill.getString("easentryid")).collect(Collectors.toSet());
                    QFilter filter = new QFilter("easparentid", "in", easRecordIds);
                    filter.and(new QFilter("easentryid", "in", easRecordEntryIds));
                    filter.and(new QFilter("bostype", "=", (Object)EAS_AR_BADDEBT_BOSTYPE));
                    DeleteServiceHelper.delete((String)DMW_EASIDCHANGE, (QFilter[])new QFilter[]{filter});
                    SaveServiceHelper.save((DynamicObject[])easIdChangeList.toArray(new DynamicObject[0]));
                }
                catch (Exception exc) {
                    tx.markRollback();
                    logger.info("BaddebtPrepareAfterProcess4EasOp endOperationTransaction insertDmwTableData error : " + exc.getMessage());
                    throw exc;
                }
            }
            catch (Throwable throwable2) {
                Throwable throwable3 = throwable2;
                throw throwable2;
            }
        }
        if (!saveBillList.isEmpty()) {
            logger.info("BaddebtPrepareAfterProcess4EasOp endOperationTransaction saveBillList:" + saveBillList.size());
            SaveServiceHelper.save((DynamicObject[])saveBillList.toArray(new DynamicObject[0]));
        }
        logger.info("BaddebtPrepareAfterProcess4EasOp endOperationTransaction end.");
    }

    private List<String> getSelector() {
        ArrayList<String> selector = new ArrayList<String>(64);
        selector.add("id");
        selector.add("exratetable");
        selector.add("remark");
        selector.add("org");
        selector.add("billno");
        selector.add("billstatus");
        selector.add("exratetable");
        selector.add("curaccruedamt");
        selector.add("curaccrualamt");
        selector.add("standardamt");
        selector.add("offsetamt");
        selector.add("curaccruedlocalamt");
        selector.add("curaccruallocalamt");
        selector.add("basecurrency");
        selector.add("agingrange");
        selector.add("currency");
        selector.add("asstacttype");
        selector.add("exratedate");
        selector.add("accrualmethod");
        selector.add("accrualfrequency");
        selector.add("exchangerate");
        selector.add("accrualdate");
        selector.add("accrualmethod");
        selector.add("accrualfrequency");
        selector.add("accrualobj");
        selector.add("period");
        selector.add("isoffset");
        selector.add("quotation");
        selector.add("billsrctype");
        selector.add("isvoucher");
        selector.add("sourcebilltype");
        selector.add("creator");
        selector.add("modifier");
        selector.add("auditor");
        selector.add("auditdate");
        selector.add("modifytime");
        selector.add("createtime");
        selector.add("entry.id");
        selector.add("entry.seq");
        selector.add("entry.e_agingrange");
        selector.add("entry.e_standardamt");
        selector.add("entry.e_offsetamt");
        selector.add("entry.e_accrualpercent");
        selector.add("entry.e_srcentryid");
        selector.add("entry.e_srcbillid");
        selector.add("entry.e_curaccruedamt");
        selector.add("entry.e_srcsysbillid");
        selector.add("entry.e_srcsysbillentryid");
        selector.add("entry.e_curaccruedlocalamt");
        selector.add("entry.e_curaccruallocalamt");
        return selector;
    }

    private DynamicObject[] getBills(EndOperationTransactionArgs e) {
        DynamicObject[] dataEntities = e.getDataEntities();
        List billIds = Arrays.stream(dataEntities).map(bill -> bill.getLong("id")).collect(Collectors.toList());
        return BusinessDataServiceHelper.load((String)this.billEntityType.getName(), (String)String.join((CharSequence)",", this.getSelector()), (QFilter[])new QFilter[]{new QFilter("id", "in", billIds)}, (String)"accrualdate desc");
    }

    private Map<Long, Long> getBaddebtRecordPrePeriod(Set<Long> orgIds) {
        DynamicObject[] records = BusinessDataServiceHelper.load((String)"ar_baddebtaccrue", (String)"preperiod,period,org", (QFilter[])new QFilter[]{new QFilter("org", "in", orgIds), new QFilter("accrualstatus", "=", (Object)"0")}, (String)"period desc", (int)1);
        HashMap<Long, Long> baddebtRecordPrePeriodMap = new HashMap<Long, Long>(8);
        for (DynamicObject record : records) {
            baddebtRecordPrePeriodMap.put(record.getLong("org.id"), record.getLong("preperiod.id"));
        }
        return baddebtRecordPrePeriodMap;
    }

    private Map<Long, DynamicObject> getInitObjMap(Set<Long> orgIds) {
        DynamicObject[] initObjs = BusinessDataServiceHelper.load((String)"ar_init", (String)"curperiod,exratetable,standardcurrency,org", (QFilter[])new QFilter[]{new QFilter("org", "in", orgIds)});
        HashMap<Long, DynamicObject> initObjMap = new HashMap<Long, DynamicObject>(8);
        for (DynamicObject initObj : initObjs) {
            initObjMap.put(initObj.getLong("org.id"), initObj);
        }
        return initObjMap;
    }

    private void rebuildByBill(DynamicObject value, List<DynamicObject> saveBillList, Map<Long, Long> baddebtRecordPrePeriodMap, Map<Long, DynamicObject> initObjMap) {
        String accrualTypeName = ResManager.loadKDString((String)"\u6309\u5355\u8ba1\u63d0", (String)"BaddebtPrepareAfterProcess4EasOp_0", (String)"fi-arapcommon", (Object[])new Object[0]);
        ArrayList<String> srcBillNos = new ArrayList<String>(8);
        DynamicObjectCollection entries = value.getDynamicObjectCollection(ENTRY);
        for (DynamicObject entry : entries) {
            srcBillNos.add(entry.getString("e_agingrange"));
        }
        DynamicObject[] finBills = BusinessDataServiceHelper.load((String)"ar_finarbill", (String)"id,billno,asstacttype,asstact,bizdate", (QFilter[])new QFilter[]{new QFilter("billno", "in", srcBillNos)});
        HashMap<String, DynamicObject> billNoAndFinBill = new HashMap<String, DynamicObject>(8);
        HashSet<String> finBillNos = new HashSet<String>(8);
        for (DynamicObject finBill : finBills) {
            finBillNos.add(finBill.getString("billno"));
            billNoAndFinBill.put(finBill.getString("billno"), finBill);
        }
        DynamicObjectType dt = null;
        HashMap<String, DynamicObject> srcNoAndPerpareBill = new HashMap<String, DynamicObject>(8);
        Long orgId = value.getLong("org.id");
        DynamicObject initDO = initObjMap.get(orgId);
        for (DynamicObject entry : entries) {
            BigDecimal eOffsetAmt;
            BigDecimal eStandardAmt;
            BigDecimal curAccruedAmt;
            DynamicObject finBill;
            String srcBillno = entry.getString("e_agingrange");
            if (!finBillNos.contains(srcBillno) || (finBill = (DynamicObject)billNoAndFinBill.get(srcBillno)) == null || BigDecimal.ZERO.compareTo(curAccruedAmt = (eStandardAmt = entry.getBigDecimal("e_standardamt")).add(eOffsetAmt = entry.getBigDecimal("e_offsetamt"))) == 0) continue;
            DynamicObject result = (DynamicObject)srcNoAndPerpareBill.get(srcBillno);
            int i = 1;
            if (result == null) {
                result = BusinessDataServiceHelper.newDynamicObject((String)AR_BADDEBTPREPAREBILL);
                result.set("id", (Object)this.getUniqueKey());
                result.set("org", (Object)orgId);
                result.set("asstacttype", (Object)finBill.getString("asstacttype"));
                result.set("asstact", (Object)finBill.getDynamicObject("asstact"));
                result.set("billno", (Object)srcBillno);
                result.set("billstatus", (Object)value.getString("billstatus"));
                result.set("accrualdate", (Object)value.getDate("accrualdate"));
                result.set("accrualobj", (Object)1405616784618318848L);
                result.set("accrualmethod", (Object)value.getString("accrualmethod"));
                result.set("period", (Object)baddebtRecordPrePeriodMap.get(orgId));
                result.set("accrualfrequency", (Object)value.getString("accrualfrequency"));
                result.set("accrualpercent", (Object)entry.getBigDecimal("e_accrualpercent"));
                result.set("isoffset", (Object)false);
                result.set("remark", (Object)accrualTypeName);
                result.set("currency", (Object)value.getLong("currency.id"));
                result.set("basecurrency", (Object)initDO.getLong("standardcurrency.id"));
                result.set("exratetable", (Object)initDO.getLong("exratetable.id"));
                result.set("exratedate", (Object)value.getDate("exratedate"));
                result.set("quotation", (Object)value.getString("quotation"));
                result.set("exchangerate", (Object)value.getBigDecimal("exchangerate"));
                result.set("curaccruedamt", (Object)BigDecimal.ZERO);
                result.set("curaccruedlocalamt", (Object)BigDecimal.ZERO);
                result.set("curaccrualamt", (Object)BigDecimal.ZERO);
                result.set("curaccruallocalamt", (Object)BigDecimal.ZERO);
                result.set("sourcebillid", (Object)finBill.getLong("id"));
                result.set("sourcebilldate", (Object)finBill.getDate("bizdate"));
                result.set("sourcebilltype", (Object)"ar_finarbill");
                result.set("billsrctype", (Object)value.getString("billsrctype"));
                result.set("isvoucher", (Object)value.getBoolean("isvoucher"));
                result.set("creator", (Object)value.getLong("creator.id"));
                result.set("modifier", (Object)value.getLong("modifier.id"));
                result.set("auditor", (Object)value.getLong("auditor.id"));
                result.set("createtime", (Object)value.getDate("createtime"));
                result.set("modifytime", (Object)value.getDate("modifytime"));
                result.set("auditdate", (Object)value.getDate("auditdate"));
            } else {
                i = result.getDynamicObjectCollection(ENTRY).size() + 1;
            }
            if (dt == null) {
                EntryProp prop = (EntryProp)EntityMetadataCache.getDataEntityType((String)result.getDataEntityType().getName()).findProperty(ENTRY);
                dt = prop.getDynamicCollectionItemPropertyType();
            }
            DynamicObject entriesResult = new DynamicObject(dt);
            entriesResult.set("seq", (Object)i);
            entriesResult.set("e_accrualpercent", (Object)entry.getBigDecimal("e_accrualpercent"));
            entriesResult.set("e_curaccruedamt", (Object)curAccruedAmt);
            entriesResult.set("e_curaccrualamt", (Object)curAccruedAmt);
            BigDecimal exchangeRate = value.getBigDecimal("exchangerate");
            if (BigDecimal.ONE.equals(exchangeRate)) {
                entriesResult.set("e_curaccruedlocalamt", (Object)curAccruedAmt);
                entriesResult.set("e_curaccruallocalamt", (Object)curAccruedAmt);
            } else {
                int precision = initDO.getInt("standardcurrency.amtprecision");
                BigDecimal entryLocalAmt = curAccruedAmt.multiply(exchangeRate).setScale(precision, RoundingMode.HALF_UP);
                entriesResult.set("e_curaccruedlocalamt", (Object)entryLocalAmt);
                entriesResult.set("e_curaccruallocalamt", (Object)entryLocalAmt);
            }
            entriesResult.set("e_srcbillid", (Object)finBill.getLong("id"));
            entriesResult.set("e_srcentryid", (Object)entry.getLong("e_srcentryid"));
            entriesResult.set("e_srcsysbillid", (Object)entry.getString("e_srcsysbillid"));
            entriesResult.set("e_srcsysbillentryid", (Object)entry.getString("e_srcsysbillentryid"));
            BigDecimal headAmt = result.getBigDecimal("curaccruedamt").add(curAccruedAmt);
            BigDecimal headLocalAmt = result.getBigDecimal("curaccruedlocalamt").add(entriesResult.getBigDecimal("e_curaccruedlocalamt"));
            result.set("curaccruedamt", (Object)headAmt);
            result.set("curaccruedlocalamt", (Object)headLocalAmt);
            result.set("curaccrualamt", (Object)headAmt);
            result.set("curaccruallocalamt", (Object)headLocalAmt);
            result.getDynamicObjectCollection(ENTRY).add((Object)entriesResult);
            srcNoAndPerpareBill.put(srcBillno, result);
        }
        saveBillList.addAll(srcNoAndPerpareBill.values());
    }

    private void rebuildByCus(DynamicObject value, List<DynamicObject> saveBillList, Map<Long, Long> baddebtRecordPrePeriodMap, Map<Long, DynamicObject> initObjMap) {
        String accrualTypeName = ResManager.loadKDString((String)"\u6309\u5ba2\u6237\u8ba1\u63d0", (String)"BaddebtPrepareAfterProcess4EasOp_1", (String)"fi-arapcommon", (Object[])new Object[0]);
        DynamicObjectType dt = null;
        HashMap<Long, DynamicObject> customerIdAndPerpareBill = new HashMap<Long, DynamicObject>(8);
        Long orgId = value.getLong("org.id");
        DynamicObject initDO = initObjMap.get(orgId);
        DynamicObjectCollection entries = value.getDynamicObjectCollection(ENTRY);
        int billnoCount = 0;
        for (DynamicObject entry : entries) {
            DynamicObject result;
            BigDecimal eOffsetAmt;
            BigDecimal eStandardAmt;
            BigDecimal curAccruedAmt;
            Long eCustomerId = entry.getLong("e_srcbillid");
            if (eCustomerId == 0L || BigDecimal.ZERO.compareTo(curAccruedAmt = (eStandardAmt = entry.getBigDecimal("e_standardamt")).add(eOffsetAmt = entry.getBigDecimal("e_offsetamt"))) == 0 || (result = (DynamicObject)customerIdAndPerpareBill.get(eCustomerId)) != null) continue;
            ++billnoCount;
            result = BusinessDataServiceHelper.newDynamicObject((String)AR_BADDEBTPREPAREBILL);
            result.set("id", (Object)this.getUniqueKey());
            result.set("org", (Object)orgId);
            result.set("asstacttype", (Object)value.getString("asstacttype"));
            result.set("asstact", (Object)eCustomerId);
            result.set("billno", (Object)(value.getString("billno") + "_" + billnoCount));
            result.set("billstatus", (Object)value.getString("billstatus"));
            result.set("accrualdate", (Object)value.getDate("accrualdate"));
            result.set("accrualobj", (Object)1405616784618318848L);
            result.set("accrualmethod", (Object)value.getString("accrualmethod"));
            result.set("period", (Object)baddebtRecordPrePeriodMap.get(orgId));
            result.set("accrualfrequency", (Object)value.getString("accrualfrequency"));
            result.set("agingrange", (Object)entry.getString("e_agingrange"));
            result.set("accrualpercent", (Object)entry.getBigDecimal("e_accrualpercent"));
            result.set("isoffset", (Object)false);
            result.set("remark", (Object)accrualTypeName);
            result.set("currency", (Object)value.getLong("currency.id"));
            result.set("basecurrency", (Object)initDO.getLong("standardcurrency.id"));
            result.set("exratetable", (Object)initDO.getLong("exratetable.id"));
            result.set("exratedate", (Object)value.getDate("exratedate"));
            result.set("quotation", (Object)value.getString("quotation"));
            result.set("exchangerate", (Object)value.getBigDecimal("exchangerate"));
            result.set("sourcebilltype", (Object)"ar_finarbill");
            result.set("curaccruedamt", (Object)BigDecimal.ZERO);
            result.set("curaccruedlocalamt", (Object)BigDecimal.ZERO);
            result.set("curaccrualamt", (Object)BigDecimal.ZERO);
            result.set("curaccruallocalamt", (Object)BigDecimal.ZERO);
            result.set("billsrctype", (Object)value.getString("billsrctype"));
            result.set("isvoucher", (Object)value.getBoolean("isvoucher"));
            result.set("creator", (Object)value.getLong("creator.id"));
            result.set("modifier", (Object)value.getLong("modifier.id"));
            result.set("auditor", (Object)value.getLong("auditor.id"));
            result.set("createtime", (Object)value.getDate("createtime"));
            result.set("modifytime", (Object)value.getDate("modifytime"));
            result.set("auditdate", (Object)value.getDate("auditdate"));
            if (dt == null) {
                EntryProp prop = (EntryProp)EntityMetadataCache.getDataEntityType((String)result.getDataEntityType().getName()).findProperty(ENTRY);
                dt = prop.getDynamicCollectionItemPropertyType();
            }
            DynamicObject entriesResult = new DynamicObject(dt);
            entriesResult.set("seq", (Object)1);
            entriesResult.set("e_accrualpercent", (Object)entry.getBigDecimal("e_accrualpercent"));
            entriesResult.set("e_curaccruedamt", (Object)curAccruedAmt);
            entriesResult.set("e_curaccrualamt", (Object)curAccruedAmt);
            BigDecimal exchangeRate = value.getBigDecimal("exchangerate");
            if (BigDecimal.ONE.equals(exchangeRate)) {
                entriesResult.set("e_curaccruedlocalamt", (Object)curAccruedAmt);
                entriesResult.set("e_curaccruallocalamt", (Object)curAccruedAmt);
            } else {
                int precision = initDO.getInt("standardcurrency.amtprecision");
                BigDecimal entryLocalAmt = curAccruedAmt.multiply(exchangeRate).setScale(precision, RoundingMode.HALF_UP);
                entriesResult.set("e_curaccruedlocalamt", (Object)entryLocalAmt);
                entriesResult.set("e_curaccruallocalamt", (Object)entryLocalAmt);
            }
            entriesResult.set("e_srcsysbillid", (Object)entry.getString("e_srcsysbillid"));
            entriesResult.set("e_srcsysbillentryid", (Object)entry.getString("e_srcsysbillentryid"));
            BigDecimal headAmt = result.getBigDecimal("curaccruedamt").add(curAccruedAmt);
            BigDecimal headLocalAmt = result.getBigDecimal("curaccruedlocalamt").add(entriesResult.getBigDecimal("e_curaccruedlocalamt"));
            result.set("curaccruedamt", (Object)headAmt);
            result.set("curaccruedlocalamt", (Object)headLocalAmt);
            result.set("curaccrualamt", (Object)headAmt);
            result.set("curaccruallocalamt", (Object)headLocalAmt);
            result.getDynamicObjectCollection(ENTRY).add((Object)entriesResult);
            customerIdAndPerpareBill.put(eCustomerId, result);
        }
        saveBillList.addAll(customerIdAndPerpareBill.values());
    }

    private void rebuildByAnalys(DynamicObject value, List<DynamicObject> saveBillList, Map<Long, Long> baddebtRecordPrePeriodMap, Map<Long, DynamicObject> initObjMap) {
        String accrualTypeName = ResManager.loadKDString((String)"\u6309\u6c47\u603b\u8ba1\u63d0", (String)"BaddebtPrepareAfterProcess4EasOp_2", (String)"fi-arapcommon", (Object[])new Object[0]);
        BigDecimal standardAmt = value.getBigDecimal("standardamt");
        BigDecimal offsetAmt = value.getBigDecimal("offsetamt");
        BigDecimal curAccruedAmt = standardAmt.subtract(offsetAmt);
        Long orgId = value.getLong("org.id");
        DynamicObject initDO = initObjMap.get(orgId);
        value.set("accrualobj", (Object)1405616784618318848L);
        value.set("period", (Object)baddebtRecordPrePeriodMap.get(orgId));
        value.set("isoffset", (Object)false);
        value.set("remark", (Object)accrualTypeName);
        value.set("sourcebilltype", (Object)"ar_finarbill");
        value.set("basecurrency", (Object)initDO.getLong("standardcurrency.id"));
        value.set("exratetable", (Object)initDO.getLong("exratetable.id"));
        value.set("curaccruedamt", (Object)curAccruedAmt);
        value.set("curaccruedlocalamt", (Object)BigDecimal.ZERO);
        value.set("curaccrualamt", (Object)curAccruedAmt);
        value.set("curaccruallocalamt", (Object)BigDecimal.ZERO);
        BigDecimal exchangeRate = value.getBigDecimal("exchangerate");
        int precision = initDO.getInt("standardcurrency.amtprecision");
        boolean countLocalAmtTag = !BigDecimal.ONE.equals(exchangeRate);
        DynamicObjectCollection entries = value.getDynamicObjectCollection(ENTRY);
        DynamicObjectCollection saveEntries = new DynamicObjectCollection();
        int i = 0;
        for (DynamicObject entriesResult : entries) {
            BigDecimal eCuraccruedAmt = entriesResult.getBigDecimal("e_curaccruedamt");
            if (BigDecimal.ZERO.compareTo(eCuraccruedAmt) == 0) continue;
            entriesResult.set("seq", (Object)(++i));
            if (countLocalAmtTag) {
                BigDecimal entryLocalAmt = eCuraccruedAmt.multiply(exchangeRate).setScale(precision, RoundingMode.HALF_UP);
                entriesResult.set("e_curaccruedlocalamt", (Object)entryLocalAmt);
                entriesResult.set("e_curaccruallocalamt", (Object)entryLocalAmt);
            } else {
                entriesResult.set("e_curaccruedlocalamt", (Object)eCuraccruedAmt);
                entriesResult.set("e_curaccruallocalamt", (Object)eCuraccruedAmt);
            }
            BigDecimal headLocalAmt = value.getBigDecimal("curaccruedlocalamt").add(entriesResult.getBigDecimal("e_curaccruedlocalamt"));
            value.set("curaccruedlocalamt", (Object)headLocalAmt);
            value.set("curaccruallocalamt", (Object)headLocalAmt);
            saveEntries.add((Object)entriesResult);
        }
        value.set("standardamt", (Object)BigDecimal.ZERO);
        value.set("offsetamt", (Object)BigDecimal.ZERO);
        if (saveEntries.size() > 0) {
            entries.clear();
            entries.addAll((Collection)saveEntries);
            saveBillList.add(value);
        }
    }

    private List<DynamicObject> prepareDmwDynamicObject(List<DynamicObject> saveBillList) {
        ArrayList<DynamicObject> easIdChangeList = new ArrayList<DynamicObject>(8);
        for (DynamicObject xhBill : saveBillList) {
            DynamicObjectCollection entries = xhBill.getDynamicObjectCollection(ENTRY);
            if (entries.size() <= 0) continue;
            DynamicObject entry = (DynamicObject)entries.get(0);
            DynamicObject easIdChange = BusinessDataServiceHelper.newDynamicObject((String)DMW_EASIDCHANGE);
            easIdChange.set("bostype", (Object)EAS_AR_BADDEBT_BOSTYPE);
            easIdChange.set("easparentid", (Object)entry.getString("e_srcsysbillid"));
            easIdChange.set("easentryid", (Object)entry.getString("e_srcsysbillentryid"));
            easIdChange.set("conentity", (Object)AR_BADDEBTPREPAREBILL);
            easIdChange.set("conparentid", (Object)xhBill.getLong("id"));
            easIdChangeList.add(easIdChange);
        }
        return easIdChangeList;
    }

    private long getUniqueKey() {
        if (this.uniqueKeyIterator == null || !this.uniqueKeyIterator.hasNext()) {
            this.uniqueKeyIterator = Arrays.stream(DB.genGlobalLongIds((int)100)).iterator();
        }
        return this.uniqueKeyIterator.next();
    }
}

