/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.eas.opplugin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.arapcommon.eas.helper.EasSettleRecordHelper;
import kd.fi.arapcommon.enums.EasRecordToXhStatusEnum;

public class EasSettleRecordSaveOp
extends AbstractOperationServicePlugIn {
    private static final Log logger = LogFactory.getLog(EasSettleRecordSaveOp.class);

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        logger.info("EasSettleRecordSaveOp endOperationTransaction begin.");
        List easSettleRecordIds = Arrays.stream(e.getDataEntities()).map(bill -> bill.getLong("id")).collect(Collectors.toList());
        DynamicObject[] easSettleRecords = BusinessDataServiceHelper.load((String)"ap_eassettlerecord", (String)String.join((CharSequence)",", EasSettleRecordHelper.getEasSettleRecordSelectors()), (QFilter[])new QFilter[]{new QFilter("id", "in", easSettleRecordIds)});
        Map<Long, DynamicObject> billMap = this.getBillMap(easSettleRecords);
        block0: for (DynamicObject easSettleRecord : easSettleRecords) {
            DynamicObjectCollection entry = easSettleRecord.getDynamicObjectCollection("entry");
            for (DynamicObject row : entry) {
                easSettleRecord.set("xhrecordstatus", (Object)EasRecordToXhStatusEnum.UNPRODUCE.getValue());
                long billId = row.getLong("e_billid");
                DynamicObject bill2 = billMap.get(billId);
                if (bill2 == null) {
                    easSettleRecord.set("xhrecordstatus", (Object)EasRecordToXhStatusEnum.NONEEDPRODUCE.getValue());
                    continue block0;
                }
                row.set("e_basecurrency", bill2.get("basecurrency"));
                row.set("e_billno", bill2.get("billno"));
                row.set("e_currency", bill2.get("currency"));
                row.set("e_exchangerate", bill2.get("exchangerate"));
            }
        }
        SaveServiceHelper.save((DynamicObject[])easSettleRecords);
        logger.info("EasSettleRecordSaveOp endOperationTransaction end.");
    }

    private Map<Long, DynamicObject> getBillMap(DynamicObject[] easSettleRecords) {
        HashMap<String, List> billEntity4BillIdsMap = new HashMap<String, List>(8);
        for (DynamicObject easSettleRecord : easSettleRecords) {
            DynamicObjectCollection entry = easSettleRecord.getDynamicObjectCollection("entry");
            for (DynamicObject row : entry) {
                String billEntity = row.getString("e_billentity");
                if (ObjectUtils.isEmpty((Object)billEntity)) continue;
                List billIds = billEntity4BillIdsMap.getOrDefault(billEntity, new ArrayList(32));
                billIds.add(row.getLong("e_billid"));
                billEntity4BillIdsMap.put(billEntity, billIds);
            }
        }
        logger.info("EasSettleRecordSaveOp endOperationTransaction getBillMap billEntity4BillIdsMap is : " + billEntity4BillIdsMap.keySet());
        HashSet<String> needProcessEntitys = new HashSet<String>(8);
        needProcessEntitys.add("ap_finapbill");
        needProcessEntitys.add("ar_finarbill");
        needProcessEntitys.add("cas_recbill");
        needProcessEntitys.add("cas_paybill");
        needProcessEntitys.add("ar_receivedbill");
        needProcessEntitys.add("ap_paidbill");
        HashMap<Long, DynamicObject> billMap = new HashMap<Long, DynamicObject>(8);
        for (Map.Entry entrySet : billEntity4BillIdsMap.entrySet()) {
            DynamicObject[] bills;
            String billEntity = (String)entrySet.getKey();
            if (!needProcessEntitys.contains(billEntity)) continue;
            for (DynamicObject bill : bills = BusinessDataServiceHelper.load((String)billEntity, (String)String.join((CharSequence)",", this.getBillSelectors(billEntity)), (QFilter[])new QFilter[]{new QFilter("id", "in", entrySet.getValue())})) {
                billMap.put(bill.getLong("id"), bill);
            }
        }
        return billMap;
    }

    private Set<String> getBillSelectors(String billEntity) {
        HashSet<String> selectors = new HashSet<String>(16);
        selectors.add("currency");
        selectors.add("basecurrency");
        selectors.add("billno");
        selectors.add("exchangerate");
        return selectors;
    }
}

