/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.eas.opplugin;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.arapcommon.helper.PeriodHelper;
import kd.fi.arapcommon.util.DateUtils;
import kd.fi.arapcommon.util.EmptyUtils;

public class InitSettingAfterProcess4EasOp
extends AbstractOperationServicePlugIn {
    private static final Log logger = LogFactory.getLog(InitSettingAfterProcess4EasOp.class);

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("org");
        fieldKeys.add("periodtype");
        fieldKeys.add("startperiod");
        fieldKeys.add("curperiod");
        fieldKeys.add("currentdate");
        fieldKeys.add("exratetable");
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        boolean isAr = this.billEntityType.getName().startsWith("ar");
        DynamicObject[] dataEntities = e.getDataEntities();
        ArrayList<Long> orgIdForAccounts = new ArrayList<Long>(8);
        ArrayList<DynamicObject> closeRecords = new ArrayList<DynamicObject>(8);
        for (DynamicObject dataEntity : dataEntities) {
            Long orgId = dataEntity.getLong("org.id");
            orgIdForAccounts.add(orgId);
            List<Date> closeDates = this.getCloseDateList(dataEntity);
            for (Date closeDate : closeDates) {
                DynamicObject closeRecord = BusinessDataServiceHelper.newDynamicObject((String)(isAr ? "ar_closerecord" : "ap_closerecord"));
                closeRecord.set("org", (Object)orgId);
                closeRecord.set("closedate", (Object)closeDate);
                closeRecords.add(closeRecord);
            }
        }
        DeleteServiceHelper.delete((String)(isAr ? "ar_closerecord" : "ap_closerecord"), (QFilter[])new QFilter[]{new QFilter("org", "in", orgIdForAccounts)});
        if (closeRecords.isEmpty()) {
            return;
        }
        SaveServiceHelper.save((DynamicObject[])closeRecords.toArray(new DynamicObject[0]));
        if (!isAr) {
            return;
        }
        ArrayList<DynamicObject> badDebtAccrueRecords = new ArrayList<DynamicObject>(8);
        ArrayList<Long> orgIds = new ArrayList<Long>(8);
        HashMap<Long, DynamicObject> curPeriodLdAndPre = new HashMap<Long, DynamicObject>(8);
        ArrayList<Long> periodNullOrgIds = new ArrayList<Long>(8);
        ArrayList<Long> prePeriodNullOrgIds = new ArrayList<Long>(8);
        for (DynamicObject dataEntity : dataEntities) {
            Long orgId = dataEntity.getLong("org.id");
            orgIds.add(orgId);
            DynamicObject startPeriod = dataEntity.getDynamicObject("startperiod");
            DynamicObject currentPeriod = dataEntity.getDynamicObject("curperiod");
            DynamicObject exrateTable = dataEntity.getDynamicObject("exratetable");
            if (startPeriod == null || currentPeriod == null) {
                periodNullOrgIds.add(orgId);
                continue;
            }
            DynamicObject prePeriod = null;
            Long curPeriodId = currentPeriod.getLong("id");
            Boolean isNeedPeriod = PeriodHelper.identical(startPeriod, currentPeriod);
            if (!isNeedPeriod.booleanValue()) {
                DynamicObject pre = (DynamicObject)curPeriodLdAndPre.get(curPeriodId);
                if (pre == null) {
                    prePeriod = PeriodHelper.getPrevPeriodByDO(currentPeriod);
                    if (prePeriod == null) {
                        prePeriodNullOrgIds.add(orgId);
                        continue;
                    }
                    curPeriodLdAndPre.put(curPeriodId, prePeriod);
                } else {
                    prePeriod = pre;
                }
            }
            String beforePeriodName = isNeedPeriod != false ? ResManager.loadKDString((String)"\u671f\u521d", (String)"InitSettingAfterProcess4EasOp_0", (String)"fi-arapcommon", (Object[])new Object[0]) : prePeriod.getString("name");
            DynamicObject preRecord = this.insertNextPeriodBadDebtAccrue(orgId, isNeedPeriod != false ? 0L : prePeriod.getLong("id"), 0L, isNeedPeriod, beforePeriodName, exrateTable.getLong("id"), "1");
            DynamicObject record = this.insertNextPeriodBadDebtAccrue(orgId, curPeriodId, isNeedPeriod != false ? 0L : prePeriod.getLong("id"), Boolean.FALSE, currentPeriod.getString("name"), exrateTable.getLong("id"), "0");
            badDebtAccrueRecords.add(preRecord);
            badDebtAccrueRecords.add(record);
        }
        logger.info("InitSettingAfterProcess4EasOp.period_null:orgIds=" + String.join((CharSequence)",", ((Object)periodNullOrgIds).toString()));
        logger.info("InitSettingAfterProcess4EasOp.pre_period_null:orgIds=" + String.join((CharSequence)",", ((Object)prePeriodNullOrgIds).toString()));
        DeleteServiceHelper.delete((String)"ar_baddebtaccrue", (QFilter[])new QFilter[]{new QFilter("org", "in", orgIds)});
        SaveServiceHelper.save((DynamicObject[])badDebtAccrueRecords.toArray(new DynamicObject[0]));
    }

    private List<Date> getCloseDateList(DynamicObject dataEntity) {
        ArrayList<Date> result = new ArrayList<Date>(8);
        DynamicObject startPeriod = dataEntity.getDynamicObject("startperiod");
        DynamicObject currentPeriod = dataEntity.getDynamicObject("curperiod");
        if (startPeriod == null || currentPeriod == null) {
            return result;
        }
        Date date = dataEntity.getDate("startperiod.begindate");
        result.add(DateUtils.truncateDate(DateUtils.getLastDay(date, 1)));
        int startPeriodNumber = startPeriod.getInt("number");
        int currentPeriodNumber = currentPeriod.getInt("number");
        boolean periodNull = false;
        while (currentPeriodNumber > startPeriodNumber) {
            if (EmptyUtils.isNotEmpty(currentPeriod = PeriodHelper.getPrevPeriod(currentPeriod.getLong("id")))) {
                result.add(currentPeriod.getDate("enddate"));
                currentPeriodNumber = currentPeriod.getInt("number");
                continue;
            }
            periodNull = true;
            break;
        }
        if (periodNull) {
            logger.info("InitSettingAfterProcess4EasOp.getCloseDateList:period is null");
        }
        return result;
    }

    private DynamicObject insertNextPeriodBadDebtAccrue(Long orgId, Long periodId, Long prePeriodId, Boolean isPeriod, String periodName, Long exratetableId, String accrualStatus) {
        DynamicObject badDebtAccrue = BusinessDataServiceHelper.newDynamicObject((String)"ar_baddebtaccrue");
        badDebtAccrue.set("org", (Object)orgId);
        badDebtAccrue.set("period", (Object)periodId);
        badDebtAccrue.set("preperiod", (Object)prePeriodId);
        badDebtAccrue.set("accrualstatus", (Object)accrualStatus);
        badDebtAccrue.set("isperiod", (Object)isPeriod);
        badDebtAccrue.set("listperiod", (Object)periodName);
        badDebtAccrue.set("accrualscheme", (Object)0L);
        badDebtAccrue.set("exratetable", (Object)exratetableId);
        return badDebtAccrue;
    }
}

