/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.eas.opplugin;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.arapcommon.eas.helper.MoveEasCommonHelper;
import kd.fi.arapcommon.helper.BOTPHelper;
import kd.fi.arapcommon.helper.BillRelationBuilder;
import kd.fi.arapcommon.model.BillModel;
import kd.fi.arapcommon.model.BillModelFactory;

public class RevcfmAfterProcess4EasOp
extends AbstractOperationServicePlugIn {
    private static final Log logger = LogFactory.getLog(RevcfmAfterProcess4EasOp.class);

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("org");
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        logger.info("RevcfmAfterProcess4EasOp endOperationTransaction begin.");
        DynamicObject[] dataEntities = e.getDataEntities();
        HashSet<Long> orgIds = new HashSet<Long>(8);
        ArrayList<Long> billIds = new ArrayList<Long>(64);
        String entityName = this.billEntityType.getName();
        BillModel billModel = BillModelFactory.getModel(entityName);
        for (DynamicObject dataEntity : dataEntities) {
            orgIds.add(dataEntity.getLong(billModel.HEAD_ORG + ".id"));
            billIds.add(dataEntity.getLong("id"));
        }
        dataEntities = this.getRevcfmBills(entityName, billIds);
        Map<Long, DynamicObject> initObjMap = this.getInitObjMap(orgIds);
        Set<Long> sourceBillIdSet = Arrays.stream(dataEntities).map(data -> data.getLong("sourcebillid")).collect(Collectors.toSet());
        Map<Long, DynamicObject> finArBillMap = this.getSrcFinBills(sourceBillIdSet);
        List<Tuple<String, String>> sumAmtFieldList = this.getSumAmtFieldList();
        Map<String, Set<Long>> srcTypeAndSrcIdMap = MoveEasCommonHelper.buildSrcTypeAndSrcId(dataEntities, billModel);
        Map<String, Map<Long, String>> srcTypeAndBillNoMap = MoveEasCommonHelper.findSrcTypeAndBillNo(srcTypeAndSrcIdMap);
        ArrayList<Long> noSrcBillIds = new ArrayList<Long>(8);
        ArrayList<DynamicObject> saveDatas = new ArrayList<DynamicObject>(8);
        ArrayList<DynamicObject> writtenOffRevcfmList = new ArrayList<DynamicObject>(8);
        for (DynamicObject dataEntity : dataEntities) {
            long sourceBillId = dataEntity.getLong("sourcebillid");
            DynamicObject finArBil = finArBillMap.get(sourceBillId);
            if (finArBil != null) {
                long orgId = dataEntity.getLong("org.id");
                DynamicObject initObj = initObjMap.get(orgId);
                if (initObj != null) {
                    if (dataEntity.getDynamicObject(billModel.HEAD_EXRATETABLE) == null) {
                        dataEntity.set(billModel.HEAD_EXRATETABLE, (Object)initObj.getDynamicObject("exratetable"));
                    }
                    if (dataEntity.getDynamicObject(billModel.HEAD_BASECURRENCY) == null) {
                        dataEntity.set(billModel.HEAD_BASECURRENCY, (Object)initObj.getDynamicObject("standardcurrency"));
                    }
                }
                this.processRevcfmBill(dataEntity);
                MoveEasCommonHelper.entryAmtSumToHead(dataEntity, billModel.ENTRY, sumAmtFieldList);
                if (dataEntity.getBigDecimal(billModel.HEAD_UNVERIFYAMOUNT).compareTo(dataEntity.getBigDecimal(billModel.HEAD_AMOUNT)) == 0) {
                    dataEntity.set(billModel.HEAD_VERIFYSTATUS, (Object)"unverify");
                } else if (dataEntity.getBigDecimal(billModel.HEAD_UNVERIFYAMOUNT).compareTo(BigDecimal.ZERO) == 0) {
                    dataEntity.set(billModel.HEAD_VERIFYSTATUS, (Object)"verified");
                } else {
                    dataEntity.set(billModel.HEAD_VERIFYSTATUS, (Object)"partverify");
                }
                if (dataEntity.getBoolean(billModel.HEAD_ISWRITTENOFF)) {
                    writtenOffRevcfmList.add(dataEntity);
                }
                saveDatas.add(dataEntity);
            } else {
                noSrcBillIds.add(dataEntity.getLong("id"));
            }
            MoveEasCommonHelper.dealSrcBillNoSetValue(srcTypeAndBillNoMap, dataEntity, billModel);
        }
        logger.info("RevcfmAfterProcess4EasOp endOperationTransaction delete RevcfmBill Before WrittenOffed id is : " + ((Object)noSrcBillIds).toString());
        this.processRevcfmBillWrittenOff(writtenOffRevcfmList, finArBillMap, noSrcBillIds);
        if (!noSrcBillIds.isEmpty()) {
            HashMap<Long, Long> srcIdAndTargetIdMap = new HashMap<Long, Long>(dataEntities.length);
            for (DynamicObject dataEntity : dataEntities) {
                long finId;
                long revfmId = dataEntity.getLong("id");
                if (!noSrcBillIds.contains(revfmId) || (finId = dataEntity.getLong("sourcebillid")) == 0L) continue;
                srcIdAndTargetIdMap.put(finId, revfmId);
            }
            this.deleteRelation(srcIdAndTargetIdMap);
            logger.info("RevcfmAfterProcess4EasOp endOperationTransaction delete RevcfmBill After WrittenOffed id is : " + ((Object)noSrcBillIds).toString());
            DeleteServiceHelper.delete((String)this.billEntityType.getName(), (QFilter[])new QFilter[]{new QFilter("id", "in", noSrcBillIds)});
        }
        if (!saveDatas.isEmpty()) {
            SaveServiceHelper.save((DynamicObject[])saveDatas.toArray(new DynamicObject[0]));
        }
        this.buildRelation(dataEntities);
        logger.info("RevcfmAfterProcess4EasOp endOperationTransaction end.");
    }

    private void processRevcfmBillWrittenOff(List<DynamicObject> writtenOffRevcfmList, Map<Long, DynamicObject> finArBillMap, List<Long> noSrcBillIds) {
        HashSet<Long> srcIdSet = new HashSet<Long>(8);
        for (DynamicObject writtenOffRevcfm : writtenOffRevcfmList) {
            long sourceBillId = writtenOffRevcfm.getLong("sourcebillid");
            DynamicObject finArBill = finArBillMap.get(sourceBillId);
            if (finArBill == null) continue;
            srcIdSet.add(finArBill.getLong("sourcebillid"));
        }
        DynamicObjectCollection hadWrittenOffRecvfmColl = QueryServiceHelper.query((String)"ar_revcfmbill", (String)"id,sourcebillid,billno", (QFilter[])new QFilter[]{new QFilter("sourcebillid", "in", srcIdSet).and(new QFilter("hadwrittenoff", "=", (Object)true))});
        Map<Long, DynamicObject> hadWrittenOffRevcfmBillMap = hadWrittenOffRecvfmColl.stream().collect(Collectors.toMap(data -> data.getLong("sourcebillid"), data -> data));
        for (DynamicObject writtenOffRevcfm : writtenOffRevcfmList) {
            long sourceBillId = writtenOffRevcfm.getLong("sourcebillid");
            DynamicObject finArBill = finArBillMap.get(sourceBillId);
            if (finArBill == null) {
                noSrcBillIds.add(writtenOffRevcfm.getLong("id"));
                continue;
            }
            long finArSourceBillId = finArBill.getLong("sourcebillid");
            DynamicObject hadWrittenOffRevfmBill = hadWrittenOffRevcfmBillMap.get(finArSourceBillId);
            if (hadWrittenOffRevfmBill == null) {
                noSrcBillIds.add(writtenOffRevcfm.getLong("id"));
                continue;
            }
            long hadWRittenOffRevcfmBillId = hadWrittenOffRevfmBill.getLong("id");
            writtenOffRevcfm.set("sourcebillid", (Object)hadWRittenOffRevcfmBillId);
            writtenOffRevcfm.set("sourcebilltype", (Object)"ar_revcfmbill");
            writtenOffRevcfm.set("sourcebillno", (Object)hadWrittenOffRevfmBill.getString("billno"));
            DynamicObjectCollection entryColl = writtenOffRevcfm.getDynamicObjectCollection("entry");
            for (DynamicObject entry : entryColl) {
                entry.set("e_sourcebillid", (Object)hadWRittenOffRevcfmBillId);
            }
        }
    }

    private Map<Long, DynamicObject> getSrcFinBills(Set<Long> sourceBillIdSet) {
        Map<Long, Object> result = new HashMap<Long, DynamicObject>(8);
        DynamicObjectCollection finArBills = QueryServiceHelper.query((String)"ar_finarbill", (String)"id,sourcebillid,billno", (QFilter[])new QFilter[]{new QFilter("id", "in", sourceBillIdSet)});
        if (finArBills != null && finArBills.size() > 0) {
            result = finArBills.stream().collect(Collectors.toMap(e -> e.getLong("id"), Function.identity(), (v1, v2) -> v2));
        }
        return result;
    }

    private void buildRelation(DynamicObject[] dataEntities) {
        HashMap<Long, List> needSaveFinArBotpMap = new HashMap<Long, List>(dataEntities.length);
        HashMap<Long, List> needSaveArRevcfmBotpMap = new HashMap<Long, List>(dataEntities.length);
        HashMap<Long, Long> srcIdAndTargetIdMap = new HashMap<Long, Long>(dataEntities.length);
        for (DynamicObject dataEntity : dataEntities) {
            Long revfmId = dataEntity.getLong("id");
            Long finId = dataEntity.getLong("sourcebillid");
            String sourceBillType = dataEntity.getString("sourcebilltype");
            if (ObjectUtils.isEmpty((Object)finId) || finId == 0L) continue;
            srcIdAndTargetIdMap.put(finId, revfmId);
            if ("ar_finarbill".equals(sourceBillType)) {
                List finIdList = needSaveFinArBotpMap.getOrDefault(revfmId, new ArrayList(8));
                finIdList.add(finId);
                needSaveFinArBotpMap.put(revfmId, finIdList);
                continue;
            }
            if (!"ar_revcfmbill".equals(sourceBillType)) continue;
            List revcfmIdList = needSaveArRevcfmBotpMap.getOrDefault(revfmId, new ArrayList(8));
            revcfmIdList.add(finId);
            needSaveArRevcfmBotpMap.put(revfmId, revcfmIdList);
        }
        this.deleteRelation(srcIdAndTargetIdMap);
        BillRelationBuilder billFinArRelationBuilder = new BillRelationBuilder("ar_finarbill", "ar_revcfmbill");
        for (Map.Entry entrySet : needSaveFinArBotpMap.entrySet()) {
            billFinArRelationBuilder.saveRelation((Collection)entrySet.getValue(), (Long)entrySet.getKey());
        }
        BillRelationBuilder billRevcfmRelationBuilder = new BillRelationBuilder("ar_revcfmbill", "ar_revcfmbill");
        for (Map.Entry entrySet : needSaveArRevcfmBotpMap.entrySet()) {
            billRevcfmRelationBuilder.saveRelation((Collection)entrySet.getValue(), (Long)entrySet.getKey());
        }
    }

    private void deleteRelation(Map<Long, Long> srcIdAndTargetIdMap) {
        if (ObjectUtils.isEmpty(srcIdAndTargetIdMap)) {
            return;
        }
        logger.info("RevcfmAfterProcess4EasOp deleteRelation map is " + srcIdAndTargetIdMap.toString());
        for (Map.Entry<Long, Long> entry : srcIdAndTargetIdMap.entrySet()) {
            Long targetId = entry.getValue();
            Long sourceId = entry.getKey();
            BOTPHelper.deleteRelation("ar_revcfmbill", targetId, sourceId);
        }
    }

    private void processRevcfmBill(DynamicObject dataEntity) {
        int amtPrecision = dataEntity.getInt("currency.amtprecision");
        BigDecimal exchangeRate = dataEntity.getBigDecimal("exchangerate");
        DynamicObjectCollection entry = dataEntity.getDynamicObjectCollection("entry");
        for (DynamicObject detail : entry) {
            BigDecimal unverifyAmount = detail.getBigDecimal("e_unverifyamt").divide(exchangeRate, amtPrecision, RoundingMode.HALF_UP);
            detail.set("e_unverifyamt", (Object)unverifyAmount);
            detail.set("e_verifiedamt", (Object)detail.getBigDecimal("e_amount").subtract(unverifyAmount));
        }
    }

    private List<Tuple<String, String>> getSumAmtFieldList() {
        ArrayList<Tuple<String, String>> sumAmtFieldList = new ArrayList<Tuple<String, String>>(16);
        sumAmtFieldList.add(Tuple.create((Object)"e_amount", (Object)"amount"));
        sumAmtFieldList.add(Tuple.create((Object)"e_localamt", (Object)"localamt"));
        sumAmtFieldList.add(Tuple.create((Object)"e_tax", (Object)"tax"));
        sumAmtFieldList.add(Tuple.create((Object)"e_taxlocalamt", (Object)"taxlocamt"));
        sumAmtFieldList.add(Tuple.create((Object)"e_pricetaxtotal", (Object)"pricetaxtotal"));
        sumAmtFieldList.add(Tuple.create((Object)"e_pricetaxtotalbase", (Object)"pricetaxtotalbase"));
        sumAmtFieldList.add(Tuple.create((Object)"e_unverifyamt", (Object)"unverifyamt"));
        sumAmtFieldList.add(Tuple.create((Object)"e_confirmamt", (Object)"confirmamt"));
        sumAmtFieldList.add(Tuple.create((Object)"e_confirmlocamt", (Object)"confirmlocamt"));
        return sumAmtFieldList;
    }

    private DynamicObject[] getRevcfmBills(String entityName, List<Long> billIds) {
        String selectors = "e_amount,amount,e_localamt,localamt,e_tax,tax,e_taxlocalamt,taxlocamt,e_pricetaxtotal,pricetaxtotal,e_pricetaxtotalbase,pricetaxtotalbase,e_verifiedamt,e_unverifyamt,unverifyamt,exratetable,basecurrency,org,verifystatus,hadwrittenoff,iswrittenoff,sourcebillid,e_sourcebillid,e_sourcebillentryid,currency,exchangerate,taxrateid,e_taxrate,e_confirmamt,e_confirmrate,e_confirmlocamt,e_confirmtax,e_confirmloctax,e_cfmpricetax,e_cfmpricetaxbase,e_confirmqty,e_confirmbaseqty,confirmway,confirmrate,confirmamt,confirmlocamt,sourcebilltype,sourcebillno";
        return BusinessDataServiceHelper.load((String)entityName, (String)selectors, (QFilter[])new QFilter[]{new QFilter("id", "in", billIds)});
    }

    private Map<Long, DynamicObject> getInitObjMap(Set<Long> orgIds) {
        String entityName = this.billEntityType.getName();
        DynamicObject[] initObjs = BusinessDataServiceHelper.load((String)(entityName.contains("ap_") ? "ap_init" : "ar_init"), (String)"exratetable,standardcurrency,org", (QFilter[])new QFilter[]{new QFilter("org", "in", orgIds)});
        HashMap<Long, DynamicObject> initObjMap = new HashMap<Long, DynamicObject>(8);
        for (DynamicObject initObj : initObjs) {
            initObjMap.put(initObj.getLong("org.id"), initObj);
        }
        return initObjMap;
    }
}

