/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.eas.settle;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.fi.arapcommon.eas.settle.IEasSettleRecordAnalysis;
import kd.fi.arapcommon.service.helper.CommonSettleServiceHelper;
import kd.fi.arapcommon.vo.EasSettleRecordContext;
import kd.fi.arapcommon.vo.SettleRecordEntryVO;
import kd.fi.arapcommon.vo.SettleRecordVO;
import kd.fi.arapcommon.vo.SettleSchemeVO;

public abstract class AbstractEasSettleAnalysis
implements IEasSettleRecordAnalysis {
    @Override
    public final List<SettleRecordVO> analysis(DynamicObject easSettleRecord, EasSettleRecordContext recordContext) {
        ArrayList<SettleRecordVO> settleRecordVos = new ArrayList<SettleRecordVO>(64);
        Tuple<String, String> selfRelationTuple = this.getMainAndAsstSelfSettleRelation(easSettleRecord);
        this.preProcessEasRecord(easSettleRecord, recordContext);
        Tuple<List<DynamicObject>, List<DynamicObject>> tuple = this.separateMainAndAsstRows(easSettleRecord);
        List mainEasRecordRows = (List)tuple.item1;
        List asstEasRecordRows = (List)tuple.item2;
        if (selfRelationTuple != null) {
            settleRecordVos.addAll(this.analysisEasRecordBySelfSettle(easSettleRecord, mainEasRecordRows, (String)selfRelationTuple.item1));
            settleRecordVos.addAll(this.analysisEasRecordBySelfSettle(easSettleRecord, asstEasRecordRows, (String)selfRelationTuple.item2));
        }
        settleRecordVos.addAll(this.amountAllocation(easSettleRecord, this.getSettleRelation(easSettleRecord), mainEasRecordRows, asstEasRecordRows));
        this.processResolveSwapPL(settleRecordVos, easSettleRecord.getBoolean("issamecurreny"));
        return settleRecordVos;
    }

    private void processResolveSwapPL(List<SettleRecordVO> tempSettleRecordVos, boolean isSameCurrency) {
        for (SettleRecordVO tempSettleRecordVo : tempSettleRecordVos) {
            String settleRela = tempSettleRecordVo.getSettleRela();
            SettleSchemeVO scheme = new SettleSchemeVO();
            scheme.setSettleSelf(settleRela.contains("self") || settleRela.contains("writeoff"));
            if (isSameCurrency) {
                CommonSettleServiceHelper.resolveSwapPL(tempSettleRecordVo, scheme);
                continue;
            }
            CommonSettleServiceHelper.resolveSwapPLForDiffCurrencySettle(tempSettleRecordVo, scheme);
        }
    }

    protected abstract String getSettleRelation(DynamicObject var1);

    protected abstract boolean isMain(DynamicObject var1);

    protected Tuple<String, String> getMainAndAsstSelfSettleRelation(DynamicObject easSettleRecord) {
        return null;
    }

    protected void preProcessEasRecord(DynamicObject easSettleRecord, EasSettleRecordContext recordContext) {
    }

    private List<SettleRecordVO> analysisEasRecordBySelfSettle(DynamicObject easSettleRecord, List<DynamicObject> easRecordRows, String selfSettleRelation) {
        if (selfSettleRelation == null) {
            return new ArrayList<SettleRecordVO>(2);
        }
        ArrayList<SettleRecordVO> selfSettleRecordVos = new ArrayList<SettleRecordVO>(16);
        ArrayList<DynamicObject> mainSelfRecordRows = new ArrayList<DynamicObject>(8);
        ArrayList<DynamicObject> asstSelfRecordRows = new ArrayList<DynamicObject>(8);
        for (DynamicObject easRecordRow : easRecordRows) {
            BigDecimal settleAmt = easRecordRow.getBigDecimal("e_settleamt");
            if (settleAmt.compareTo(BigDecimal.ZERO) > 0) {
                mainSelfRecordRows.add(easRecordRow);
                continue;
            }
            asstSelfRecordRows.add(easRecordRow);
        }
        if (mainSelfRecordRows.isEmpty() || asstSelfRecordRows.isEmpty()) {
            return selfSettleRecordVos;
        }
        return this.amountAllocation(easSettleRecord, selfSettleRelation, mainSelfRecordRows, asstSelfRecordRows);
    }

    private List<SettleRecordVO> amountAllocation(DynamicObject easSettleRecord, String settleRelation, List<DynamicObject> mainRecordRows, List<DynamicObject> asstRecordRows) {
        boolean isSameCurrency;
        if (mainRecordRows.isEmpty() || asstRecordRows.isEmpty()) {
            return new ArrayList<SettleRecordVO>(2);
        }
        boolean bl = isSameCurrency = mainRecordRows.get(0).getLong("e_currency.id") == asstRecordRows.get(0).getLong("e_currency.id");
        if (isSameCurrency) {
            return this.sameCurrencySettle(easSettleRecord, settleRelation, mainRecordRows, asstRecordRows);
        }
        return this.diffCurrencySettle(easSettleRecord, settleRelation, mainRecordRows, asstRecordRows);
    }

    private List<SettleRecordVO> diffCurrencySettle(DynamicObject easSettleRecord, String settleRelation, List<DynamicObject> mainRecordRows, List<DynamicObject> asstRecordRows) {
        ArrayList<SettleRecordVO> settleRecordVOS = new ArrayList<SettleRecordVO>(32);
        BigDecimal mainSettleAmtSum = BigDecimal.ZERO;
        BigDecimal mainSettleAmtLocalSum = BigDecimal.ZERO;
        for (DynamicObject mainRecordRow : mainRecordRows) {
            mainSettleAmtSum = mainSettleAmtSum.add(mainRecordRow.getBigDecimal("e_settleamt"));
            mainSettleAmtLocalSum = mainSettleAmtLocalSum.add(mainRecordRow.getBigDecimal("e_settleamtlocal"));
        }
        HashMap<Long, Tuple> asstRemainSettleAmtMap = new HashMap<Long, Tuple>(8);
        for (int i = 0; i < mainRecordRows.size(); ++i) {
            DynamicObject mainRecordRow = mainRecordRows.get(i);
            BigDecimal eSettleAmt = mainRecordRow.getBigDecimal("e_settleamt");
            BigDecimal eSettleAmtLocal = mainRecordRow.getBigDecimal("e_settleamtlocal");
            BigDecimal proportion = eSettleAmt.divide(mainSettleAmtSum, 10, RoundingMode.HALF_UP);
            BigDecimal localProportion = eSettleAmtLocal.divide(mainSettleAmtLocalSum, 10, RoundingMode.HALF_UP);
            ArrayList<SettleRecordEntryVO> settleRecordEntryVOS = new ArrayList<SettleRecordEntryVO>(8);
            for (DynamicObject asstRecordRow : asstRecordRows) {
                long asstEntryId = asstRecordRow.getLong("e_billentryid");
                BigDecimal eAsstSettleAmt = asstRecordRow.getBigDecimal("e_settleamt");
                BigDecimal eAsstSettleAmtLocal = asstRecordRow.getBigDecimal("e_settleamtlocal");
                Tuple remainSettleAmtTuple = (Tuple)asstRemainSettleAmtMap.get(asstEntryId);
                if (remainSettleAmtTuple == null) {
                    remainSettleAmtTuple = Tuple.create((Object)eAsstSettleAmt, (Object)eAsstSettleAmtLocal);
                }
                BigDecimal asstRemainSettleAmt = (BigDecimal)remainSettleAmtTuple.item1;
                BigDecimal asstRemainSettleLocalAmt = (BigDecimal)remainSettleAmtTuple.item2;
                int currencyPrecision = asstRecordRow.getInt("e_currency.amtprecision");
                int baseCurrencyPrecision = asstRecordRow.getInt("e_basecurrency.amtprecision");
                BigDecimal asstCanSettleAmt = BigDecimal.ZERO;
                BigDecimal asstCanSettleAmtAnother = BigDecimal.ZERO;
                if (i == mainRecordRows.size() - 1) {
                    asstCanSettleAmt = asstRemainSettleAmt;
                    asstCanSettleAmtAnother = asstRemainSettleLocalAmt;
                } else {
                    asstCanSettleAmt = eAsstSettleAmt.multiply(proportion).setScale(currencyPrecision, RoundingMode.HALF_UP);
                    asstCanSettleAmtAnother = eAsstSettleAmtLocal.multiply(localProportion).setScale(baseCurrencyPrecision, RoundingMode.HALF_UP);
                }
                remainSettleAmtTuple = Tuple.create((Object)asstRemainSettleAmt.subtract(asstCanSettleAmt), (Object)asstRemainSettleLocalAmt.subtract(asstCanSettleAmtAnother));
                asstRemainSettleAmtMap.put(asstEntryId, remainSettleAmtTuple);
                SettleRecordEntryVO settleRecordEntryVO = new SettleRecordEntryVO();
                settleRecordEntryVO.setBillId(asstRecordRow.getLong("e_billid"));
                settleRecordEntryVO.setBillEntryId(asstEntryId);
                settleRecordEntryVO.setBillEntity(asstRecordRow.getString("e_billentity"));
                settleRecordEntryVO.setExchangeRate(asstRecordRow.getBigDecimal("e_exchangerate"));
                settleRecordEntryVO.setBasePrecision(asstRecordRow.getInt("e_basecurrency.amtprecision"));
                settleRecordEntryVO.setSettleAmt(asstCanSettleAmt);
                settleRecordEntryVO.setLocalSettleAmt(asstCanSettleAmtAnother);
                settleRecordEntryVOS.add(settleRecordEntryVO);
            }
            SettleRecordVO settleRecordVO = new SettleRecordVO();
            settleRecordVO.setSrcSettleRecordId(easSettleRecord.getLong("id"));
            settleRecordVO.setSettleRela(settleRelation);
            settleRecordVO.setMainBillId(mainRecordRow.getLong("e_billid"));
            settleRecordVO.setMainBillEntryId(mainRecordRow.getLong("e_billentryid"));
            settleRecordVO.setBillEntity(mainRecordRow.getString("e_billentity"));
            settleRecordVO.setBasePrecision(mainRecordRow.getInt("e_basecurrency.amtprecision"));
            settleRecordVO.setExchangeRate(mainRecordRow.getBigDecimal("e_exchangerate"));
            settleRecordVO.setEntrys(settleRecordEntryVOS);
            settleRecordVO.setTotalSettleAmt(eSettleAmt);
            settleRecordVO.setLocalTotalSettleamt(eSettleAmtLocal);
            settleRecordVOS.add(settleRecordVO);
        }
        return settleRecordVOS;
    }

    private List<SettleRecordVO> sameCurrencySettle(DynamicObject easSettleRecord, String settleRelation, List<DynamicObject> mainRecordRows, List<DynamicObject> asstRecordRows) {
        ArrayList<SettleRecordVO> settleRecordVOS = new ArrayList<SettleRecordVO>(32);
        Iterator<DynamicObject> asstRecordIterator = asstRecordRows.iterator();
        DynamicObject asstRecordRow = null;
        BigDecimal asstSettleAmt = BigDecimal.ZERO;
        while (asstRecordIterator.hasNext() && (asstSettleAmt = (asstRecordRow = asstRecordIterator.next()).getBigDecimal("e_settleamt")).compareTo(BigDecimal.ZERO) == 0) {
        }
        if (asstSettleAmt.compareTo(BigDecimal.ZERO) == 0) {
            return settleRecordVOS;
        }
        for (DynamicObject mainRecordRow : mainRecordRows) {
            BigDecimal mainSettleAmt = mainRecordRow.getBigDecimal("e_settleamt");
            if (mainSettleAmt.compareTo(BigDecimal.ZERO) == 0) continue;
            BigDecimal mainCanSettleAmt = BigDecimal.ZERO;
            ArrayList<SettleRecordEntryVO> settleRecordEntryVOS = new ArrayList<SettleRecordEntryVO>(8);
            while (asstRecordRow != null && mainSettleAmt.compareTo(BigDecimal.ZERO) != 0 && asstSettleAmt.compareTo(BigDecimal.ZERO) != 0) {
                BigDecimal asstCanSettleAmt = BigDecimal.ZERO;
                if (mainSettleAmt.signum() == asstSettleAmt.signum()) {
                    asstCanSettleAmt = mainSettleAmt.abs().compareTo(asstSettleAmt.abs()) > 0 ? asstSettleAmt : mainSettleAmt;
                    mainCanSettleAmt = mainCanSettleAmt.add(asstCanSettleAmt);
                    mainSettleAmt = mainSettleAmt.subtract(asstCanSettleAmt);
                } else {
                    asstCanSettleAmt = mainSettleAmt.abs().compareTo(asstSettleAmt.abs()) > 0 ? asstSettleAmt : mainSettleAmt.negate();
                    mainCanSettleAmt = mainCanSettleAmt.add(asstCanSettleAmt.negate());
                    mainSettleAmt = mainSettleAmt.add(asstCanSettleAmt);
                }
                asstSettleAmt = asstSettleAmt.subtract(asstCanSettleAmt);
                BigDecimal asstCanSettleAmtAnother = this.getCanLocalSettleAmtBySameSettle(asstRecordRow, asstCanSettleAmt);
                SettleRecordEntryVO settleRecordEntryVO = new SettleRecordEntryVO();
                settleRecordEntryVO.setBillId(asstRecordRow.getLong("e_billid"));
                settleRecordEntryVO.setBillEntryId(asstRecordRow.getLong("e_billentryid"));
                settleRecordEntryVO.setBillEntity(asstRecordRow.getString("e_billentity"));
                settleRecordEntryVO.setExchangeRate(asstRecordRow.getBigDecimal("e_exchangerate"));
                settleRecordEntryVO.setBasePrecision(asstRecordRow.getInt("e_basecurrency.amtprecision"));
                settleRecordEntryVO.setSettleAmt(asstCanSettleAmt);
                settleRecordEntryVO.setLocalSettleAmt(asstCanSettleAmtAnother);
                settleRecordEntryVOS.add(settleRecordEntryVO);
                if (asstSettleAmt.compareTo(BigDecimal.ZERO) != 0) continue;
                if (asstRecordIterator.hasNext()) {
                    asstRecordRow = asstRecordIterator.next();
                    asstSettleAmt = asstRecordRow.getBigDecimal("e_settleamt");
                    continue;
                }
                asstRecordRow = null;
            }
            if (settleRecordEntryVOS.isEmpty()) continue;
            BigDecimal mainCanSettleAmtAnother = this.getCanLocalSettleAmtBySameSettle(mainRecordRow, mainCanSettleAmt);
            SettleRecordVO settleRecordVO = new SettleRecordVO();
            settleRecordVO.setSrcSettleRecordId(easSettleRecord.getLong("id"));
            settleRecordVO.setSettleRela(settleRelation);
            settleRecordVO.setMainBillId(mainRecordRow.getLong("e_billid"));
            settleRecordVO.setMainBillEntryId(mainRecordRow.getLong("e_billentryid"));
            settleRecordVO.setBillEntity(mainRecordRow.getString("e_billentity"));
            settleRecordVO.setBasePrecision(mainRecordRow.getInt("e_basecurrency.amtprecision"));
            settleRecordVO.setExchangeRate(mainRecordRow.getBigDecimal("e_exchangerate"));
            settleRecordVO.setEntrys(settleRecordEntryVOS);
            settleRecordVO.setTotalSettleAmt(mainCanSettleAmt);
            settleRecordVO.setLocalTotalSettleamt(mainCanSettleAmtAnother);
            settleRecordVOS.add(settleRecordVO);
            if (asstRecordIterator.hasNext() || asstRecordRow != null) continue;
            break;
        }
        return settleRecordVOS;
    }

    private BigDecimal getCanLocalSettleAmtBySameSettle(DynamicObject recordRow, BigDecimal settleAmt) {
        BigDecimal canSettleAmtAnother = BigDecimal.ZERO;
        BigDecimal exchangeRate = recordRow.getBigDecimal("e_exchangerate");
        int baseCurrencyPrecision = recordRow.getInt("e_basecurrency.amtprecision");
        canSettleAmtAnother = settleAmt.multiply(exchangeRate).setScale(baseCurrencyPrecision, 4);
        if (settleAmt.compareTo(recordRow.getBigDecimal("e_settleamt")) == 0) {
            canSettleAmtAnother = recordRow.getBigDecimal("e_settleamtlocal");
        }
        recordRow.set("e_settleamt", (Object)recordRow.getBigDecimal("e_settleamt").subtract(settleAmt));
        recordRow.set("e_settleamtlocal", (Object)recordRow.getBigDecimal("e_settleamtlocal").subtract(canSettleAmtAnother));
        return canSettleAmtAnother;
    }

    private Tuple<List<DynamicObject>, List<DynamicObject>> separateMainAndAsstRows(DynamicObject easSettleRecord) {
        DynamicObjectCollection entry = easSettleRecord.getDynamicObjectCollection("entry");
        ArrayList<DynamicObject> mainEasRecordRows = new ArrayList<DynamicObject>(8);
        ArrayList<DynamicObject> asstEasRecordRows = new ArrayList<DynamicObject>(8);
        for (DynamicObject easRecordRow : entry) {
            BigDecimal settleAmtLocal = easRecordRow.getBigDecimal("e_settleamtlocal");
            if (settleAmtLocal.compareTo(BigDecimal.ZERO) == 0) continue;
            if (this.isMain(easRecordRow)) {
                mainEasRecordRows.add(easRecordRow);
                continue;
            }
            asstEasRecordRows.add(easRecordRow);
        }
        return Tuple.create(mainEasRecordRows, asstEasRecordRows);
    }
}

