/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.eas.settle;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.fi.arapcommon.eas.settle.IEasSettleRecordAnalysis;
import kd.fi.arapcommon.eas.settle.analysis.ApArEasRecordAnalysisImpl;
import kd.fi.arapcommon.eas.settle.analysis.ApEasRecordAnalysisImpl;
import kd.fi.arapcommon.eas.settle.analysis.ApPayEasRecordAnalysisImpl;
import kd.fi.arapcommon.eas.settle.analysis.ApRecEasRecordAnalysisImpl;
import kd.fi.arapcommon.eas.settle.analysis.ArEasRecordAnalysisImpl;
import kd.fi.arapcommon.eas.settle.analysis.ArPayEasRecordAnalysisImpl;
import kd.fi.arapcommon.eas.settle.analysis.ArRecEasRecordAnalysisImpl;
import kd.fi.arapcommon.eas.settle.analysis.InsertSettleRecordAnalysisImpl;
import kd.fi.arapcommon.eas.settle.analysis.PaidRecEasRecordAnalysisImpl;
import kd.fi.arapcommon.eas.settle.analysis.PayEasRecordAnalysisImpl;
import kd.fi.arapcommon.eas.settle.analysis.PayRecEasRecordAnalysisImpl;
import kd.fi.arapcommon.eas.settle.analysis.RecEasRecordAnalysisImpl;
import kd.fi.arapcommon.eas.settle.liquidate.ApEasSettleLiquidateImpl;
import kd.fi.arapcommon.eas.settle.liquidate.ArEasSettleLiquidateImpl;
import kd.fi.arapcommon.eas.settle.liquidate.PayEasSettleLiquidateImpl;
import kd.fi.arapcommon.eas.settle.liquidate.RecEasSettleLiquidateImpl;
import kd.fi.arapcommon.enums.SettleRelationEnum;

public class EasSettleAnalysisFactory {
    public static IEasSettleRecordAnalysis getIEasSettleAnalysisImpl(String billEntitys) {
        List billEntityList = Arrays.stream(billEntitys.trim().split("-")).collect(Collectors.toList());
        if (billEntityList.size() == 1) {
            String billEntity = (String)billEntityList.get(0);
            if ("ap_finapbill".equals(billEntity)) {
                return new ApEasRecordAnalysisImpl();
            }
            if ("ar_finarbill".equals(billEntity)) {
                return new ArEasRecordAnalysisImpl();
            }
            if ("cas_paybill".equals(billEntity) || "ap_paidbill".equals(billEntity)) {
                return new PayEasRecordAnalysisImpl();
            }
            if ("cas_recbill".equals(billEntity) || "ar_receivedbill".equals(billEntity)) {
                return new RecEasRecordAnalysisImpl();
            }
        } else if (billEntityList.size() == 2) {
            if (billEntityList.contains("ap_finapbill") && (billEntityList.contains("cas_paybill") || billEntityList.contains("ap_paidbill"))) {
                return new ApPayEasRecordAnalysisImpl();
            }
            if (billEntityList.contains("ar_finarbill") && (billEntityList.contains("cas_recbill") || billEntityList.contains("ar_receivedbill"))) {
                return new ArRecEasRecordAnalysisImpl();
            }
            if (billEntityList.contains("cas_paybill") && (billEntityList.contains("cas_recbill") || billEntityList.contains("ar_receivedbill"))) {
                return new PayRecEasRecordAnalysisImpl();
            }
            if (billEntityList.contains("ap_paidbill") && (billEntityList.contains("cas_recbill") || billEntityList.contains("ar_receivedbill"))) {
                return new PaidRecEasRecordAnalysisImpl();
            }
            if (billEntityList.contains("ap_finapbill") && billEntityList.contains("ar_finarbill")) {
                return new ApArEasRecordAnalysisImpl();
            }
            if (billEntityList.contains("ap_finapbill") && (billEntityList.contains("cas_recbill") || billEntityList.contains("ar_receivedbill"))) {
                return new ApRecEasRecordAnalysisImpl();
            }
            if (billEntityList.contains("ar_finarbill") && (billEntityList.contains("cas_paybill") || billEntityList.contains("ap_paidbill"))) {
                return new ArPayEasRecordAnalysisImpl();
            }
        }
        throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u5355\u636e\u7c7b\u578b\u201c%1$s\u201d\u672a\u627e\u5230\u9002\u914d\u7684\u7ed3\u7b97\u91d1\u989d\u89e3\u6790\u5b9e\u73b0\u7c7b\uff0c\u8bf7\u786e\u8ba4\u6570\u636e\u540e\u91cd\u8bd5\u3002", (String)"EasSettleAnalysisFactory_0", (String)"fi-arapcommon", (Object[])new Object[0]), billEntitys));
    }

    public static IEasSettleRecordAnalysis getIEasSettleAnalysisImplByFinSelf() {
        return new InsertSettleRecordAnalysisImpl();
    }

    public static IEasSettleRecordAnalysis getIEasSettleAnalysisImplByLiquidate(String settleRelation) {
        if (SettleRelationEnum.APLIQUIDATIONSETTLE.getValue().equals(settleRelation)) {
            return new ApEasSettleLiquidateImpl();
        }
        if (SettleRelationEnum.ARLIQUIDATIONSETTLE.getValue().equals(settleRelation)) {
            return new ArEasSettleLiquidateImpl();
        }
        if (SettleRelationEnum.RECCLEARINGSETTLE.getValue().equals(settleRelation)) {
            return new RecEasSettleLiquidateImpl();
        }
        if (SettleRelationEnum.PAYCLEARINGSETTLE.getValue().equals(settleRelation)) {
            return new PayEasSettleLiquidateImpl();
        }
        return null;
    }
}

