/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.eas.settle.liquidate;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.arapcommon.eas.helper.EasSettleBillInfoMakeupHelper;
import kd.fi.arapcommon.eas.settle.AbstractEasSettleAnalysis;
import kd.fi.arapcommon.enums.SettleRelationEnum;
import kd.fi.arapcommon.vo.EasSettleRecordContext;

public abstract class AbstractEasSettleLiquidate
extends AbstractEasSettleAnalysis {
    @Override
    protected String getSettleRelation(DynamicObject easSettleRecord) {
        return easSettleRecord.getString("settlerelation");
    }

    @Override
    protected void preProcessEasRecord(DynamicObject easSettleRecord, EasSettleRecordContext recordContext) {
        DynamicObject liquidateBill = this.createLiquidateBill(easSettleRecord, recordContext);
        DynamicObjectCollection entryEntity = liquidateBill.getDynamicObjectCollection("entryentity");
        entryEntity.clear();
        DynamicObjectCollection entry = easSettleRecord.getDynamicObjectCollection("entry");
        for (Object easRow : entry) {
            DynamicObject newRow = entryEntity.addNew();
            newRow.set("id", (Object)recordContext.getUniqueKey());
            newRow.set("unsettleamt", (Object)easRow.getBigDecimal("e_settleamt"));
            newRow.set("e_lqdlocalamt", (Object)easRow.getBigDecimal("e_settleamtlocal"));
            newRow.set("sourcebillid", (Object)easRow.getLong("e_billid"));
            newRow.set("sourceentryid", (Object)easRow.getLong("e_billentryid"));
        }
        EasSettleBillInfoMakeupHelper.liquidateBillInfoMakeUp(liquidateBill, recordContext);
        String liquidateName = liquidateBill.getDataEntityType().getName();
        for (DynamicObject liquidateRow : entryEntity) {
            DynamicObject newCasRow = entry.addNew();
            newCasRow.set("e_billid", liquidateBill.get("id"));
            newCasRow.set("e_billentryid", liquidateRow.get("id"));
            newCasRow.set("e_billentity", (Object)liquidateName);
            newCasRow.set("e_currency", liquidateBill.get("currency"));
            newCasRow.set("e_basecurrency", liquidateBill.get("basecurrency"));
            newCasRow.set("e_exchangerate", liquidateBill.get("exchangerate"));
            newCasRow.set("e_settleamt", liquidateRow.get("unsettleamt"));
            newCasRow.set("e_settleamtlocal", liquidateRow.get("e_lqdlocalamt"));
        }
        Map<String, List<DynamicObject>> needSaveOtherBillsMap = recordContext.getNeedSaveOtherBillsMap();
        List liquidateBills = needSaveOtherBillsMap.getOrDefault(liquidateName, new ArrayList(32));
        liquidateBills.add(liquidateBill);
        needSaveOtherBillsMap.put(liquidateName, liquidateBills);
    }

    private DynamicObject createLiquidateBill(DynamicObject easSettleRecord, EasSettleRecordContext recordContext) {
        String settleRelation = easSettleRecord.getString("settlerelation");
        String sourceBillType = SettleRelationEnum.getEntityByRelation(settleRelation).get(0);
        DynamicObject liquidateBill = "ap_finapbill".equals(sourceBillType) || "cas_paybill".equals(sourceBillType) ? BusinessDataServiceHelper.newDynamicObject((String)"ap_liquidation") : BusinessDataServiceHelper.newDynamicObject((String)"ar_liquidation");
        liquidateBill.set("id", (Object)recordContext.getUniqueKey());
        liquidateBill.set("sourcebilltype", (Object)sourceBillType);
        liquidateBill.set("liquidater", easSettleRecord.get("creator"));
        liquidateBill.set("liquidationdate", easSettleRecord.get("settledate"));
        return liquidateBill;
    }
}

