/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.excecontrol;

import java.math.BigDecimal;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.arapcommon.check.helper.AmountCompareHelper;
import kd.fi.arapcommon.check.helper.FinApBillCheckHelper;
import kd.fi.arapcommon.enums.BillStatusEnum;
import kd.fi.arapcommon.excecontrol.IExecCtrlService;
import kd.fi.arapcommon.exception.AmountCheckExecption;

public class FinApLockAmtCtrlService
implements IExecCtrlService<Object> {
    @Override
    public Object execute(Object ... param) {
        if (param == null || param.length != 1) {
            return null;
        }
        Set billIds = (Set)param[0];
        try {
            this.checkPremiumBill(billIds);
            FinApBillCheckHelper.checkLockAndSettleField(billIds);
        }
        catch (AmountCheckExecption e) {
            String message = e.getMessage();
            throw new KDBizException(ResManager.loadKDString((String)"\u4e0b\u63a8\u5931\u8d25\uff0c\u5e94\u4ed8\u5355\u4e0b\u63a8\u524d\u68c0\u67e5\u5b57\u6bb5\u5b58\u5728\u5f02\u5e38\uff0c\u5f02\u5e38\u539f\u56e0\uff1a%s", (String)"FinApLockAmtCtrlService_0", (String)"fi-arapcommon", (Object[])new Object[]{message}));
        }
        return null;
    }

    private void checkPremiumBill(Set<Long> ids) {
        DynamicObject[] bills;
        for (DynamicObject bill : bills = BusinessDataServiceHelper.load((String)"ap_finapbill", (String)"billno,billstatus,premiumamt,lockedamt,planlockedamt", (QFilter[])new QFilter[]{new QFilter("id", "in", ids)})) {
            boolean isPremium;
            String billno = bill.getString("billno");
            String billStatus = bill.getString("billstatus");
            BigDecimal premiumAmt = bill.getBigDecimal("premiumamt");
            boolean bl = isPremium = BillStatusEnum.AUDIT.getValue().equals(billStatus) && premiumAmt.compareTo(BigDecimal.ZERO) > 0;
            if (!isPremium) continue;
            DynamicObjectCollection detailEntrys = bill.getDynamicObjectCollection("detailentry");
            BigDecimal lockedAmtSum = BigDecimal.ZERO;
            for (DynamicObject detailEntry : detailEntrys) {
                lockedAmtSum = lockedAmtSum.add(detailEntry.getBigDecimal("lockedamt"));
            }
            AmountCompareHelper.compare(billno, lockedAmtSum, ResManager.loadKDString((String)"\u5df2\u5ba1\u6838\u4e14\u6709\u8d28\u4fdd\u91d1\uff0c\u660e\u7ec6\u5206\u5f55(\u5df2\u9501\u5b9a\u91d1\u989d)\u5408\u8ba1\u4e0d\u80fd\u7b49\u4e8e0\u3002", (String)"FinApLockAmtCtrlService_1", (String)"fi-arapcommon", (Object[])new Object[0]));
            DynamicObjectCollection planEntrys = bill.getDynamicObjectCollection("planentity");
            BigDecimal planLockedAmtSum = BigDecimal.ZERO;
            for (DynamicObject planEntry : planEntrys) {
                planLockedAmtSum = planLockedAmtSum.add(planEntry.getBigDecimal("planlockedamt"));
            }
            AmountCompareHelper.compare(billno, planLockedAmtSum, ResManager.loadKDString((String)"\u5df2\u5ba1\u6838\u4e14\u6709\u8d28\u4fdd\u91d1\uff0c\u8ba1\u5212\u884c\u5206\u5f55\u4e0a\u7684\u201c\u5df2\u9501\u5b9a\u91d1\u989d\u201d\u7684\u5408\u8ba1\u4e0d\u5e94\u4e3a0\u3002", (String)"FinApLockAmtCtrlService_2", (String)"fi-arapcommon", (Object[])new Object[0]));
        }
    }
}

