/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.excecontrol;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.arapcommon.excecontrol.IExecCtrlService;
import kd.fi.arapcommon.model.BillModel;
import kd.fi.arapcommon.model.BillModelFactory;

public class FinApQtyExcessService
implements IExecCtrlService<Object> {
    private static final Log logger = LogFactory.getLog(FinApQtyExcessService.class);
    protected String entityName = "ap_finapbill";
    protected BillModel billModel = BillModelFactory.getModel(this.entityName);

    @Override
    public List<String> execute(Object ... param) {
        if (param == null || param.length != 1) {
            return null;
        }
        logger.info("FinApQtyExcessService entityName is : " + this.entityName);
        List billIds = (List)param[0];
        if (ObjectUtils.isEmpty((Object)billIds)) {
            return null;
        }
        QFilter filter = new QFilter("id", "in", (Object)billIds);
        filter.and(this.billModel.HEAD_SOURCEBILLTYPE, "in", (Object)new String[]{"im_purinbill", "im_purreceivebill", "im_ospurinbill", "im_mdc_omcmplinbill"});
        filter.and(new QFilter("payproperty.isbasedonamt", "=", (Object)Boolean.FALSE));
        DynamicObject[] bills = BusinessDataServiceHelper.load((String)this.entityName, (String)String.join((CharSequence)",", this.preparePropertys()), (QFilter[])new QFilter[]{filter});
        return this.validate(bills);
    }

    public List<String> validate(DynamicObject[] apBills) {
        logger.info("FinApQtyExcessService validate size : " + apBills.length);
        List<String> errorMessages = new ArrayList<String>(16);
        if (ObjectUtils.isEmpty((Object[])apBills)) {
            return errorMessages;
        }
        errorMessages = this.directBillValidator(apBills);
        return errorMessages;
    }

    protected List<String> directBillValidator(DynamicObject[] directPurInEntities) {
        ArrayList<String> results = new ArrayList<String>(16);
        HashMap<String, HashSet<Long>> srcBillIdMap = new HashMap<String, HashSet<Long>>(16);
        HashMap<String, HashSet<Long>> srcEntryIdMap = new HashMap<String, HashSet<Long>>(16);
        HashSet<Long> orgIds = new HashSet<Long>(16);
        HashSet<Long> needRemoveFinApEntryIds = new HashSet<Long>(64);
        HashMap<Long, BigDecimal> calculatePurBillQtyMap = new HashMap<Long, BigDecimal>(64);
        for (DynamicObject bill : directPurInEntities) {
            DynamicObject detailRow;
            String sourceBillType = bill.getString(this.billModel.HEAD_SOURCEBILLTYPE);
            DynamicObject org = bill.getDynamicObject("org");
            orgIds.add(org.getLong("id"));
            DynamicObjectCollection detailEntry = bill.getDynamicObjectCollection(this.billModel.ENTRY);
            Iterator iterator = detailEntry.iterator();
            while (iterator.hasNext() && ObjectUtils.isEmpty((Object)(detailRow = (DynamicObject)iterator.next()).getString("e_expensebillids_tag"))) {
                needRemoveFinApEntryIds.add(detailRow.getLong("id"));
                long srcBillId = detailRow.getLong(this.billModel.E_SOURCEBILLID);
                long srcEntryId = detailRow.getLong(this.billModel.E_SOURCEBILLENTRYID);
                if (srcBillId == 0L || srcEntryId == 0L) continue;
                HashSet<Long> srcBillIds = (HashSet<Long>)srcBillIdMap.get(sourceBillType);
                if (srcBillIds == null) {
                    srcBillIds = new HashSet<Long>(16);
                    srcBillIds.add(srcBillId);
                    srcBillIdMap.put(sourceBillType, srcBillIds);
                } else {
                    srcBillIds.add(srcBillId);
                }
                HashSet<Long> srcEntryIds = (HashSet<Long>)srcEntryIdMap.get(sourceBillType);
                if (srcEntryIds == null) {
                    srcEntryIds = new HashSet<Long>(16);
                    srcEntryIds.add(srcEntryId);
                    srcEntryIdMap.put(sourceBillType, srcEntryIds);
                } else {
                    srcEntryIds.add(srcEntryId);
                }
                BigDecimal baseQty = calculatePurBillQtyMap.getOrDefault(srcEntryId, BigDecimal.ZERO);
                baseQty = baseQty.add(detailRow.getBigDecimal(this.billModel.E_BASEUNITQTY));
                calculatePurBillQtyMap.put(srcEntryId, baseQty);
            }
        }
        if (srcBillIdMap.isEmpty()) {
            return results;
        }
        HashMap<Long, String> srcEntryIdToBillNoMap = new HashMap<Long, String>(16);
        HashMap<Long, BigDecimal> srcUnVerifyQtyMap = new HashMap<Long, BigDecimal>(16);
        HashSet<String> srcEntryIds = new HashSet<String>(16);
        for (Map.Entry entrySet : srcBillIdMap.entrySet()) {
            String srcBillType = (String)entrySet.getKey();
            Set billIds = (Set)entrySet.getValue();
            Set entryIds = (Set)srcEntryIdMap.get(srcBillType);
            if (entryIds == null || entryIds.size() == 0) continue;
            QFilter filter = new QFilter("id", "in", (Object)billIds);
            filter.and(new QFilter("billentry.id", "in", (Object)entryIds));
            String selectors = this.getSrcBillSelector();
            DataSet srcBills = QueryServiceHelper.queryDataSet((String)"qtyexcess", (String)srcBillType, (String)selectors, (QFilter[])new QFilter[]{filter}, null);
            for (Row row : srcBills) {
                Long entryId = row.getLong("billentry.id");
                srcEntryIds.add(String.valueOf(entryId));
                srcEntryIdToBillNoMap.put(entryId, row.getString("billno"));
                srcUnVerifyQtyMap.put(entryId, row.getBigDecimal("qty"));
            }
        }
        this.calculateAllPurBillQtyMap(srcEntryIds, calculatePurBillQtyMap, orgIds, needRemoveFinApEntryIds);
        for (DynamicObject bill : directPurInEntities) {
            String sourceBillType = bill.getString(this.billModel.HEAD_SOURCEBILLTYPE);
            String srcBillName = "im_purinbill".equals(sourceBillType) ? ResManager.loadKDString((String)"\u91c7\u8d2d\u5165\u5e93\u5355", (String)"FinApQtyExcessService_0", (String)"fi-arapcommon", (Object[])new Object[0]) : ("im_purreceivebill".equals(sourceBillType) ? ResManager.loadKDString((String)"\u91c7\u8d2d\u6536\u8d27\u5355", (String)"FinApQtyExcessService_1", (String)"fi-arapcommon", (Object[])new Object[0]) : ("im_ospurinbill".equals(sourceBillType) ? ResManager.loadKDString((String)"\u59d4\u5916\u91c7\u8d2d\u5165\u5e93\u5355", (String)"FinApQtyExcessService_2", (String)"fi-arapcommon", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u59d4\u5916\u5b8c\u5de5\u5165\u5e93\u5355", (String)"FinApQtyExcessService_3", (String)"fi-arapcommon", (Object[])new Object[0])));
            DynamicObjectCollection detailEntry = bill.getDynamicObjectCollection(this.billModel.ENTRY);
            for (DynamicObject entry : detailEntry) {
                BigDecimal srcSumQty;
                BigDecimal srcEntryQty;
                Long srcEntryId = entry.getLong(this.billModel.E_SOURCEBILLENTRYID);
                String srcBillNo = (String)srcEntryIdToBillNoMap.get(srcEntryId);
                if (srcBillNo == null || (srcEntryQty = (BigDecimal)srcUnVerifyQtyMap.get(srcEntryId)) == null || (srcSumQty = calculatePurBillQtyMap.getOrDefault(srcEntryId, BigDecimal.ZERO)).abs().compareTo(srcEntryQty.abs()) <= 0 && srcSumQty.multiply(srcEntryQty).signum() >= 0) continue;
                String billNo = bill.getString(this.billModel.HEAD_BILLNO);
                int seq = entry.getInt("seq");
                if (srcEntryQty.compareTo(BigDecimal.ZERO) == 0) {
                    srcEntryQty = srcEntryQty.setScale(0, RoundingMode.HALF_UP);
                }
                String message = String.format(ResManager.loadKDString((String)"\u5b58\u5728\u8d85\u989d\u4e0b\u63a8\u98ce\u9669\uff0c\u5355\u636e\u7f16\u53f7%1$s\u5206\u5f55\u7b2c%2$s\u884c\u4e0a\u6e38%3$s%4$s\u6240\u5173\u8054\u7684\u8d22\u52a1\u5e94\u4ed8\u5355\u57fa\u672c\u6570\u91cf\u4e4b\u548c%5$s\u8d85\u8fc7%3$s\u672a\u6838\u9500\u57fa\u672c\u6570\u91cf%6$s\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"FinApQtyExcessService_4", (String)"fi-arapcommon", (Object[])new Object[0]), billNo, seq, srcBillName, srcBillNo, srcSumQty, srcEntryQty);
                results.add(message);
            }
        }
        return results;
    }

    protected String getSrcBillSelector() {
        return "billno,billentry.id,billentry.unverifybaseqty qty";
    }

    protected void calculateAllPurBillQtyMap(Set<String> srcEntryIds, Map<Long, BigDecimal> calculatePurBillQtyMap, Set<Long> orgIds, Set<Long> needRemoveFinApEntryIds) {
        ArrayList<String> selectors = new ArrayList<String>(8);
        selectors.add(this.billModel.ENTRY_PK);
        selectors.add(this.billModel.ENTRY + "." + this.billModel.E_SOURCEBILLENTRYID + " " + this.billModel.E_SOURCEBILLENTRYID);
        selectors.add(this.billModel.ENTRY + "." + this.billModel.E_BASEUNITQTY + " " + this.billModel.E_BASEUNITQTY);
        selectors.add("detailentry.e_expensebillids_tag e_expensebillids_tag");
        QFilter filter = new QFilter(this.billModel.HEAD_ORG, "in", orgIds);
        filter.and(new QFilter(this.billModel.ENTRY + "." + this.billModel.E_SOURCEBILLENTRYID, "in", srcEntryIds));
        filter.and(new QFilter(this.billModel.HEAD_BILLSTATUS, "in", (Object)new String[]{"A", "B"}));
        DataSet finApDataSet = QueryServiceHelper.queryDataSet((String)"queryBill", (String)this.entityName, (String)String.join((CharSequence)",", selectors), (QFilter[])new QFilter[]{filter}, (String)"");
        for (Row finApBill : finApDataSet) {
            Long finEntryId;
            if (!ObjectUtils.isEmpty((Object)finApBill.getString("e_expensebillids_tag")) || needRemoveFinApEntryIds.contains(finEntryId = finApBill.getLong(this.billModel.ENTRY_PK))) continue;
            Long srcBillEntryId = finApBill.getLong(this.billModel.E_SOURCEBILLENTRYID);
            BigDecimal finApQty = finApBill.getBigDecimal(this.billModel.E_BASEUNITQTY);
            BigDecimal srcSumQty = calculatePurBillQtyMap.getOrDefault(srcBillEntryId, BigDecimal.ZERO);
            calculatePurBillQtyMap.put(srcBillEntryId, srcSumQty.add(finApQty));
        }
    }

    protected Set<String> preparePropertys() {
        HashSet<String> selectors = new HashSet<String>(8);
        selectors.add(this.billModel.HEAD_ORG);
        selectors.add(this.billModel.HEAD_BILLNO);
        selectors.add(this.billModel.HEAD_SOURCEBILLTYPE);
        selectors.add(this.billModel.E_SEQ);
        selectors.add(this.billModel.E_SOURCEBILLID);
        selectors.add(this.billModel.E_SOURCEBILLENTRYID);
        selectors.add(this.billModel.E_BASEUNITQTY);
        selectors.add("e_expensebillids_tag");
        return selectors;
    }
}

