/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.excecontrol;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.arapcommon.excecontrol.IExecCtrlService;
import kd.fi.arapcommon.util.DateUtils;
import kd.fi.arapcommon.vo.SameBillVO;
import org.apache.commons.lang.StringUtils;

public class SameApBillWarnCtrlService
implements IExecCtrlService<Object> {
    private boolean isBus = false;

    @Override
    public Map<Long, List<String>> execute(Object ... params) {
        if (params == null || params.length == 0) {
            return new HashMap<Long, List<String>>(2);
        }
        DynamicObject bill = (DynamicObject)params[0];
        DataSet allSameBillData = this.getAllSameBillData(bill);
        if (allSameBillData == null || !allSameBillData.hasNext()) {
            return new HashMap<Long, List<String>>(2);
        }
        List<SameBillVO> sameBillVOS = this.processSearchData(allSameBillData);
        if (sameBillVOS.isEmpty()) {
            return new HashMap<Long, List<String>>(2);
        }
        return this.processOutputMessage(sameBillVOS, params);
    }

    private DataSet getAllSameBillData(DynamicObject bill) {
        long orgId = bill.getLong("org.id");
        long asstMasterId = bill.getLong("asstact.masterid");
        long currencyId = bill.getLong("currency.id");
        if (0L == orgId || 0L == asstMasterId || 0L == currencyId) {
            return null;
        }
        BigDecimal priceTaxTotal = bill.getBigDecimal("pricetaxtotal");
        String entityName = bill.getDynamicObjectType().getName();
        if ("ap_busbill".equals(entityName)) {
            this.isBus = true;
        }
        Date earlyDate = new Date();
        Date bizdate = bill.getDate("bizdate");
        if (bizdate != null && earlyDate.compareTo(bizdate) > 0) {
            earlyDate = bizdate;
        }
        QFilter filter = new QFilter("bizdate", ">=", (Object)DateUtils.getNextDay(earlyDate, -31));
        filter.and(new QFilter("org", "=", (Object)orgId));
        filter.and(new QFilter("currency", "=", (Object)currencyId));
        Map asstactMap = BusinessDataServiceHelper.loadFromCache((String)bill.getString("asstacttype"), (String)"id", (QFilter[])new QFilter[]{new QFilter("masterid", "=", (Object)asstMasterId)});
        filter.and(new QFilter("asstact.id", "in", asstactMap.keySet()));
        filter.and(new QFilter("pricetaxtotal", "=", (Object)priceTaxTotal));
        List<String> selectors = this.getSelector();
        if (this.isBus) {
            filter.and(new QFilter("billtype.number", "in", (Object)new String[]{"ap_busbill_purfee_BT_S", "ap_busbill_salefee_BT_S"}));
            selectors.add("billtype.number");
        }
        return QueryServiceHelper.queryDataSet((String)"queryDataSet", (String)entityName, (String)StringUtils.join((Object[])selectors.toArray(), (String)","), (QFilter[])new QFilter[]{filter}, (String)"bizdate");
    }

    private List<String> getSelector() {
        ArrayList<String> selector = new ArrayList<String>(10);
        selector.add("id");
        selector.add("billno");
        selector.add("bizdate");
        selector.add("org");
        selector.add("currency");
        selector.add("asstacttype");
        selector.add("asstact.masterid");
        selector.add("pricetaxtotal");
        return selector;
    }

    private List<SameBillVO> processSearchData(DataSet allSameBillData) {
        ArrayList<SameBillVO> sameBillVOS = new ArrayList<SameBillVO>(64);
        for (Row sameBill : allSameBillData) {
            SameBillVO sameBillVO;
            boolean isNull;
            long billId = sameBill.getLong("id");
            long org = sameBill.getLong("org");
            Long currency = sameBill.getLong("currency");
            BigDecimal priceTaxTotal = sameBill.getBigDecimal("pricetaxtotal");
            String key = String.valueOf(org).concat("_").concat("_").concat(String.valueOf(currency)).concat("_").concat(String.valueOf(priceTaxTotal));
            if (this.isBus) {
                String billTypeNum = sameBill.getString("billtype.number");
                key = key.concat("_").concat(billTypeNum);
            }
            boolean bl = isNull = (sameBillVO = SameBillVO.getSameBillByKey(key, sameBillVOS)) == null;
            if (isNull) {
                sameBillVO = new SameBillVO();
                sameBillVO.setBillInfo(key);
            }
            sameBillVO.getBizDateMap().put(billId, DateUtils.getDataFormat(sameBill.getDate("bizdate"), true));
            sameBillVO.getBillNoMap().put(billId, sameBill.getString("billno"));
            if (!isNull) continue;
            sameBillVOS.add(sameBillVO);
        }
        return sameBillVOS;
    }

    private Map<Long, List<String>> processOutputMessage(List<SameBillVO> sameBillVOS, Object[] params) {
        HashMap<Long, List<String>> result = new HashMap<Long, List<String>>(32);
        for (Object param : params) {
            SameBillVO sameBillVO;
            ArrayList<String> hasSameBillNos = new ArrayList<String>(64);
            DynamicObject finBill = (DynamicObject)param;
            long selfApplyId = finBill.getLong("id");
            Date bizDate = finBill.getDate("bizdate");
            long orgId = finBill.getLong("org.id");
            long currencyId = finBill.getLong("currency.id");
            BigDecimal priceTaxTotal = finBill.getBigDecimal("pricetaxtotal");
            String info = String.valueOf(orgId).concat("_").concat("_").concat(String.valueOf(currencyId)).concat("_").concat(String.valueOf(priceTaxTotal));
            if (this.isBus) {
                String billTypeNum = finBill.getString("billtype.number");
                info = info.concat("_").concat(billTypeNum);
            }
            if ((sameBillVO = SameBillVO.getSameBillByKey(info, sameBillVOS)) == null || bizDate == null) continue;
            Date lastMonth = DateUtils.getNextDay(bizDate, -31);
            for (Map.Entry<Long, Date> entrySet : sameBillVO.getBizDateMap().entrySet()) {
                String sameBillNo;
                Long sameBillId = entrySet.getKey();
                Date searchDate = entrySet.getValue();
                if (searchDate == null || searchDate.compareTo(lastMonth) < 0 || searchDate.compareTo(bizDate) > 0 || (sameBillNo = sameBillVO.getBillNoMap().get(sameBillId)) == null) continue;
                hasSameBillNos.add(sameBillNo);
            }
            hasSameBillNos.removeIf(str -> finBill.getString("billno").equals(str));
            if (hasSameBillNos.isEmpty()) continue;
            result.put(selfApplyId, hasSameBillNos);
        }
        return result;
    }
}

