/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.excecontrol;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.arapcommon.excecontrol.IExecCtrlService;
import kd.fi.arapcommon.util.DateUtils;
import kd.fi.arapcommon.vo.SameBillVO;

public class SameApplyBillWarnCtrlService
implements IExecCtrlService<Object> {
    @Override
    public Map<Long, List<String>> execute(Object ... params) {
        if (params == null || params.length == 0) {
            return new HashMap<Long, List<String>>(2);
        }
        HashMap<Long, DynamicObject> asstactMap = new HashMap<Long, DynamicObject>(8);
        DataSet allSameBillDataSet = this.getAllSameBillDataSet(params);
        if (!allSameBillDataSet.hasNext()) {
            return new HashMap<Long, List<String>>(2);
        }
        List<SameBillVO> sameBillVOS = this.processSearchData(asstactMap, allSameBillDataSet);
        if (sameBillVOS.isEmpty()) {
            return new HashMap<Long, List<String>>(2);
        }
        return this.processOutputMessage(sameBillVOS, params);
    }

    private Map<Long, List<String>> processOutputMessage(List<SameBillVO> sameBillVOS, Object[] params) {
        HashMap<Long, List<String>> result = new HashMap<Long, List<String>>(64);
        for (Object param : params) {
            ArrayList<String> hasSameBillNos = new ArrayList<String>(64);
            DynamicObject payApply = (DynamicObject)param;
            Date applyDate = payApply.getDate("applydate");
            long selfApplyId = payApply.getLong("id");
            long settleOrgId = payApply.getLong("settleorg.id");
            long payCurrencyId = payApply.getLong("paycurrency.id");
            long settleCurrencyId = payApply.getLong("settlecurrency.id");
            String info = String.valueOf(settleOrgId).concat("_").concat(String.valueOf(payCurrencyId)).concat("_").concat(String.valueOf(settleCurrencyId));
            SameBillVO sameBillVO = SameBillVO.getSameBillByKey(info, sameBillVOS);
            if (sameBillVO == null) continue;
            HashMap<Long, BigDecimal> selfAsstAmtMap = new HashMap<Long, BigDecimal>(8);
            DynamicObjectCollection entry = payApply.getDynamicObjectCollection("entry");
            for (DynamicObject detail : entry) {
                DynamicObject asstact = detail.getDynamicObject("e_asstact");
                if (asstact == null) continue;
                long asstId = asstact.getLong("masterid");
                BigDecimal totalAmt = selfAsstAmtMap.getOrDefault(asstId, BigDecimal.ZERO);
                totalAmt = totalAmt.add(detail.getBigDecimal("e_applyamount"));
                selfAsstAmtMap.put(asstId, totalAmt);
            }
            Map<Long, Date> bizDateMap = sameBillVO.getBizDateMap();
            if (bizDateMap.isEmpty() || applyDate == null) continue;
            Date lastMonth = DateUtils.getNextDay(applyDate, -31);
            for (Map.Entry<Long, Date> entrySet : bizDateMap.entrySet()) {
                String sameBillNo;
                Map<Long, BigDecimal> asstacAmtMap;
                Long sameBillId = entrySet.getKey();
                Date searchDate = entrySet.getValue();
                if (searchDate == null || searchDate.compareTo(lastMonth) < 0 || searchDate.compareTo(applyDate) > 0 || (asstacAmtMap = sameBillVO.getBillAsstactAmtMap().get(sameBillId)).size() != selfAsstAmtMap.size()) continue;
                boolean isSame = true;
                for (Map.Entry selfAsstEntrySet : selfAsstAmtMap.entrySet()) {
                    Long selfAssMasterId = (Long)selfAsstEntrySet.getKey();
                    BigDecimal assAmt = asstacAmtMap.get(selfAssMasterId);
                    if (assAmt != null && assAmt.compareTo((BigDecimal)selfAsstEntrySet.getValue()) == 0) continue;
                    isSame = false;
                    break;
                }
                if (!isSame || (sameBillNo = sameBillVO.getBillNoMap().get(sameBillId)) == null) continue;
                hasSameBillNos.add(sameBillNo);
            }
            hasSameBillNos.removeIf(str -> payApply.getString("billno").equals(str));
            if (hasSameBillNos.isEmpty()) continue;
            result.put(selfApplyId, hasSameBillNos);
        }
        return result;
    }

    private List<SameBillVO> processSearchData(Map<Long, DynamicObject> asstactMap, DataSet allSameBillDataSet) {
        ArrayList<SameBillVO> sameBillVOS = new ArrayList<SameBillVO>(64);
        for (Row applyRow : allSameBillDataSet) {
            boolean isNull;
            Long applyId = applyRow.getLong("id");
            Long settleOrgId = applyRow.getLong("settleorg");
            Long payCurrencyId = applyRow.getLong("paycurrency");
            Long settleCurrencyId = applyRow.getLong("settlecurrency");
            String info = String.valueOf(settleOrgId).concat("_").concat(String.valueOf(payCurrencyId)).concat("_").concat(String.valueOf(settleCurrencyId));
            SameBillVO sameBillVO = SameBillVO.getSameBillByKey(info, sameBillVOS);
            boolean bl = isNull = sameBillVO == null;
            if (isNull) {
                sameBillVO = new SameBillVO();
                sameBillVO.setBillInfo(info);
            }
            Map<Long, Map<Long, BigDecimal>> billAsstactAmtMap = sameBillVO.getBillAsstactAmtMap();
            Map asstactAmtMap = billAsstactAmtMap.getOrDefault(applyId, new HashMap(8));
            Long asstactId = applyRow.getLong("e_asstact");
            String asstactType = applyRow.getString("e_asstacttype");
            if (ObjectUtils.isEmpty((Object)asstactType) || ObjectUtils.isEmpty((Object)asstactId)) continue;
            DynamicObject asstact = asstactMap.get(asstactId);
            if (asstact == null) {
                asstact = BusinessDataServiceHelper.loadSingleFromCache((Object)asstactId, (String)asstactType, (String)"id,masterid");
                if (asstact == null) continue;
                asstactMap.put(asstactId, asstact);
            }
            long masterId = asstact.getLong("masterid");
            BigDecimal totalAmt = asstactAmtMap.getOrDefault(masterId, BigDecimal.ZERO);
            totalAmt = totalAmt.add(applyRow.getBigDecimal("e_applyamount"));
            asstactAmtMap.put(masterId, totalAmt);
            billAsstactAmtMap.put(applyId, asstactAmtMap);
            sameBillVO.getBillNoMap().put(applyId, applyRow.getString("billno"));
            sameBillVO.getBizDateMap().put(applyId, applyRow.getDate("applydate"));
            if (!isNull) continue;
            sameBillVOS.add(sameBillVO);
        }
        return sameBillVOS;
    }

    private DataSet getAllSameBillDataSet(Object ... params) {
        HashSet<Long> settleOrgIds = new HashSet<Long>(64);
        HashSet<Long> payCurrencyIds = new HashSet<Long>(64);
        HashSet<Long> settleCurrencyIds = new HashSet<Long>(64);
        Date earlyDate = new Date();
        for (Object param : params) {
            DynamicObject payApply = (DynamicObject)param;
            Date applyDate = payApply.getDate("applydate");
            if (applyDate != null && earlyDate.compareTo(applyDate) > 0) {
                earlyDate = payApply.getDate("applydate");
            }
            long settleOrgId = payApply.getLong("settleorg.id");
            settleOrgIds.add(settleOrgId);
            long payCurrencyId = payApply.getLong("paycurrency.id");
            payCurrencyIds.add(payCurrencyId);
            long settleCurrencyId = payApply.getLong("settlecurrency.id");
            settleCurrencyIds.add(settleCurrencyId);
        }
        QFilter filter = new QFilter("applydate", ">=", (Object)DateUtils.getNextDay(earlyDate, -31));
        filter.and(new QFilter("settleorg", "in", settleOrgIds));
        filter.and(new QFilter("paycurrency", "in", payCurrencyIds));
        filter.and(new QFilter("settlecurrency", "in", settleCurrencyIds));
        String selector = "id,applydate,settleorg,paycurrency,settlecurrency,billno,entry.e_asstact e_asstact,entry.e_asstacttype e_asstacttype,entry.e_applyamount e_applyamount";
        return QueryServiceHelper.queryDataSet((String)"getAllSameBillDataSet", (String)"ap_payapply", (String)selector, (QFilter[])new QFilter[]{filter}, (String)"applydate");
    }
}

