/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.excecontrol;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.arapcommon.excecontrol.IExecCtrlService;
import kd.fi.arapcommon.util.DateUtils;
import kd.fi.arapcommon.vo.SameBillVO;

public class SameArBillWarnCtrlService
implements IExecCtrlService<Object> {
    @Override
    public Map<Long, List<String>> execute(Object ... params) {
        if (params == null || params.length == 0) {
            return new HashMap<Long, List<String>>(2);
        }
        DataSet allSameBillDataSet = this.getAllSameBillDataSet(params);
        if (!allSameBillDataSet.hasNext()) {
            return new HashMap<Long, List<String>>(2);
        }
        List<SameBillVO> sameBillVOS = this.processSearchData(allSameBillDataSet);
        if (sameBillVOS.isEmpty()) {
            return new HashMap<Long, List<String>>(2);
        }
        return this.processOutputMessage(sameBillVOS, params);
    }

    private DataSet getAllSameBillDataSet(Object ... params) {
        HashSet<Long> orgIds = new HashSet<Long>(32);
        HashSet<Long> asstactIds = new HashSet<Long>(32);
        HashSet<Long> currencyIds = new HashSet<Long>(32);
        HashSet<BigDecimal> priceTaxTotals = new HashSet<BigDecimal>(32);
        String billNum = "ar_finarbill";
        Date earlyDate = new Date();
        for (Object param : params) {
            DynamicObject finBill = (DynamicObject)param;
            billNum = finBill.getDynamicObjectType().getName();
            long orgId = finBill.getLong("org.id");
            long asstMasterId = finBill.getLong("asstact.id");
            if (0L == asstMasterId) continue;
            if (earlyDate.compareTo(finBill.getDate("bizdate")) > 0) {
                earlyDate = finBill.getDate("bizdate");
            }
            long currencyId = finBill.getLong("currency.id");
            BigDecimal priceTaxTotal = finBill.getBigDecimal("recamount");
            orgIds.add(orgId);
            asstactIds.add(asstMasterId);
            currencyIds.add(currencyId);
            priceTaxTotals.add(priceTaxTotal);
        }
        QFilter filter = new QFilter("bizdate", ">=", (Object)DateUtils.getNextDay(earlyDate, -31));
        filter.and(new QFilter("org", "in", orgIds));
        filter.and(new QFilter("currency", "in", currencyIds));
        filter.and(new QFilter("asstact.id", "in", asstactIds));
        filter.and(new QFilter("recamount", "in", priceTaxTotals));
        filter.and(new QFilter("billtype.number", "in", (Object)new String[]{"arfin_other_BT_S", "ar_busbill_other_BT_S"}));
        return QueryServiceHelper.queryDataSet((String)"getAllSameBillDataSet", (String)billNum, (String)"id,billno,bizdate,org,currency,asstacttype,asstact.id,recamount,billtype.number", (QFilter[])new QFilter[]{filter}, (String)"");
    }

    private List<SameBillVO> processSearchData(DataSet allSameBillDataSet) {
        ArrayList<SameBillVO> sameBillVOS = new ArrayList<SameBillVO>(64);
        for (Row row : allSameBillDataSet) {
            boolean isNull;
            Long billId = row.getLong("id");
            Long org = row.getLong("org");
            Long masterId = row.getLong("asstact.id");
            String billTypeNum = row.getString("billtype.number");
            if (masterId == null || 0L == masterId) continue;
            Long currency = row.getLong("currency");
            BigDecimal priceTaxTotal = row.getBigDecimal("recamount");
            String key = String.valueOf(org).concat("_").concat(String.valueOf(masterId)).concat("_").concat(String.valueOf(currency)).concat("_").concat(String.valueOf(priceTaxTotal)).concat(billTypeNum);
            SameBillVO sameBillVO = SameBillVO.getSameBillByKey(key, sameBillVOS);
            boolean bl = isNull = sameBillVO == null;
            if (isNull) {
                sameBillVO = new SameBillVO();
                sameBillVO.setBillInfo(key);
            }
            sameBillVO.getBizDateMap().put(billId, row.getDate("bizdate"));
            sameBillVO.getBillNoMap().put(billId, row.getString("billno"));
            if (!isNull) continue;
            sameBillVOS.add(sameBillVO);
        }
        return sameBillVOS;
    }

    private Map<Long, List<String>> processOutputMessage(List<SameBillVO> sameBillVOS, Object[] params) {
        HashMap<Long, List<String>> result = new HashMap<Long, List<String>>(32);
        for (Object param : params) {
            ArrayList<String> hasSameBillNos = new ArrayList<String>(64);
            DynamicObject finBill = (DynamicObject)param;
            long selfApplyId = finBill.getLong("id");
            Date bizDate = finBill.getDate("bizdate");
            long orgId = finBill.getLong("org.id");
            long asstMasterId = finBill.getLong("asstact.id");
            if (0L == asstMasterId) continue;
            long currencyId = finBill.getLong("currency.id");
            BigDecimal priceTaxTotal = finBill.getBigDecimal("recamount");
            String billTypeNum = finBill.getString("billtype.number");
            String info = String.valueOf(orgId).concat("_").concat(String.valueOf(asstMasterId)).concat("_").concat(String.valueOf(currencyId)).concat("_").concat(String.valueOf(priceTaxTotal)).concat(billTypeNum);
            SameBillVO sameBillVO = SameBillVO.getSameBillByKey(info, sameBillVOS);
            if (sameBillVO == null) continue;
            Date lastMonth = DateUtils.getNextDay(bizDate, -31);
            for (Map.Entry<Long, Date> entrySet : sameBillVO.getBizDateMap().entrySet()) {
                String sameBillNo;
                Long sameBillId = entrySet.getKey();
                Date searchDate = entrySet.getValue();
                if (searchDate == null || searchDate.compareTo(lastMonth) < 0 || searchDate.compareTo(bizDate) > 0 || (sameBillNo = sameBillVO.getBillNoMap().get(sameBillId)) == null) continue;
                hasSameBillNos.add(sameBillNo);
            }
            hasSameBillNos.removeIf(str -> finBill.getString("billno").equals(str));
            if (hasSameBillNos.isEmpty()) continue;
            result.put(selfApplyId, hasSameBillNos);
        }
        return result;
    }
}

