/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.excecontrol;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.exception.KDBizException;
import kd.fi.arapcommon.excecontrol.ExecCtrlHelper;
import kd.fi.arapcommon.excecontrol.IExecCtrlService;
import kd.fi.arapcommon.exception.AmountCheckExecption;
import kd.fi.arapcommon.vo.BillSettleVO;

public class SettleCheckBillCtrlService
implements IExecCtrlService<Object> {
    @Override
    public Object execute(Object ... param) {
        if (param == null || param.length != 3) {
            return null;
        }
        List mainList = (List)param[0];
        List asstList = (List)param[1];
        boolean beforeSettle = (Boolean)param[2];
        if (ObjectUtils.isEmpty((Object)mainList) || ObjectUtils.isEmpty((Object)asstList)) {
            return null;
        }
        Map<String, List<BillSettleVO>> mainSettleMap = mainList.stream().collect(Collectors.groupingBy(BillSettleVO::getBillEntity));
        Map<String, List<BillSettleVO>> asstSettleMap = asstList.stream().collect(Collectors.groupingBy(BillSettleVO::getBillEntity));
        this.doCheck(beforeSettle, mainSettleMap);
        this.doCheck(beforeSettle, asstSettleMap);
        return null;
    }

    private void doCheck(boolean beforeSettle, Map<String, List<BillSettleVO>> billSettleMap) {
        billSettleMap.forEach((entity, mainSettles) -> {
            Set<Long> billIds = mainSettles.stream().map(BillSettleVO::getId).collect(Collectors.toSet());
            try {
                ExecCtrlHelper.checkBillAmount(entity, billIds);
            }
            catch (AmountCheckExecption e) {
                if (beforeSettle) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u7ed3\u7b97\u5931\u8d25\uff0c\u7ed3\u7b97\u524d\u68c0\u67e5\u5355\u636e\u5b57\u6bb5\u5f02\u5e38\uff1a%s", (String)"SettleCheckBillCtrlService_0", (String)"fi-arapcommon", (Object[])new Object[]{e.getMessage()}));
                }
                throw new KDBizException(ResManager.loadKDString((String)"\u7ed3\u7b97\u5931\u8d25\uff0c\u7ed3\u7b97\u540e\u68c0\u67e5\u5355\u636e\u5b57\u6bb5\u53cd\u5199\u5f02\u5e38\uff1a%s", (String)"SettleCheckBillCtrlService_1", (String)"fi-arapcommon", (Object[])new Object[]{e.getMessage()}));
            }
        });
    }
}

