/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.excecontrol;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.arapcommon.consts.BillTypeConsts;
import kd.fi.arapcommon.excecontrol.IExecCtrlService;

public class VerifyCheckBillCtrlService
implements IExecCtrlService<Object> {
    @Override
    public Object execute(Object ... param) {
        if (param == null || param.length != 2) {
            return null;
        }
        String billEntity = (String)param[0];
        Set billIds = (Set)param[1];
        if (ObjectUtils.isEmpty((Object)billIds)) {
            return null;
        }
        HashSet<String> billNos = new HashSet<String>(2);
        HashMap<Long, String> srcBillIdToBillNoMap = new HashMap<Long, String>(2);
        String unVerifyQtyFiled = "detailentry.unverifyquantity";
        if ("ar_revcfmbill".equals(billEntity)) {
            unVerifyQtyFiled = "entry.e_unverifyqty";
        }
        DataSet rows = QueryServiceHelper.queryDataSet((String)"queryUnVerify", (String)billEntity, (String)("id,billno,verifystatus,sourcebillid," + unVerifyQtyFiled), (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)billIds)}, (String)"");
        for (Row row : rows) {
            String verifyStatus = row.getString("verifystatus");
            BigDecimal unVerifyQty = row.getBigDecimal(unVerifyQtyFiled);
            if (!"10".equals(verifyStatus) && !"unverify".equals(verifyStatus) && unVerifyQty.compareTo(BigDecimal.ZERO) == 0) continue;
            billNos.add(row.getString("billno"));
            srcBillIdToBillNoMap.put(row.getLong("sourcebillid"), row.getString("billno"));
        }
        if ("ar_revcfmbill".equals(billEntity)) {
            DynamicObjectCollection finArBills = QueryServiceHelper.query((String)"ar_finarbill", (String)"id,billtype", (QFilter[])new QFilter[]{new QFilter("id", "in", srcBillIdToBillNoMap.keySet())});
            for (DynamicObject bill : finArBills) {
                if (BillTypeConsts.ARFIN_BORROW.longValue() != bill.getLong("billtype")) continue;
                billNos.remove(srcBillIdToBillNoMap.get(bill.getLong("id")));
            }
        }
        if (!billNos.isEmpty()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5355\u636e\u5ba1\u6838\u5931\u8d25\uff1a[%s]\u672a\u4e0e\u4e0a\u6e38\u5e93\u5b58\u5355\u636e\u5b8c\u5168\u6838\u9500\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"VerifyCheckBillCtrlService_0", (String)"fi-arapcommon", (Object[])new Object[]{String.join((CharSequence)",", billNos)}));
        }
        return null;
    }
}

