/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.factory;

import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.TypesContainer;
import kd.bos.dataentity.resource.ResManager;
import kd.fi.arapcommon.api.param.ServiceNameEnum;
import kd.fi.arapcommon.api.push.IPushBillService;
import kd.fi.arapcommon.api.settle.ISettleService;
import kd.fi.arapcommon.api.settle.IUnSettleService;
import kd.fi.arapcommon.api.settle.IUpdateSettleDateService;
import kd.fi.arapcommon.api.verify.IVerifyService;
import kd.fi.arapcommon.enums.ApInvoiceServiceEnum;
import kd.fi.arapcommon.enums.VerifyRelationEnum;
import kd.fi.arapcommon.service.ArApServiceProxy;

public class ArApServiceAPIFactory {
    private static final Map<String, String> serviceMap = new HashMap<String, String>();

    public static ISettleService getSettleService(String serviceName) {
        return (ISettleService)ArApServiceAPIFactory.getService(serviceName);
    }

    public static IVerifyService getVerifyService(String serviceName) {
        return (IVerifyService)ArApServiceAPIFactory.getService(serviceName);
    }

    public static IUpdateSettleDateService getUpdateSettleDateService(String serviceName) {
        return (IUpdateSettleDateService)ArApServiceAPIFactory.getService(serviceName);
    }

    public static IPushBillService getPushBillService(String serviceName) {
        String className = serviceMap.get(serviceName);
        if (className == null) {
            throw new RuntimeException(String.format(ResManager.loadKDString((String)"%s\u5bf9\u5e94\u7684\u670d\u52a1\u5b9e\u73b0\u672a\u627e\u5230\u3002", (String)"SettleServiceFactory_0", (String)"fi-arapcommon", (Object[])new Object[0]), serviceName));
        }
        return (IPushBillService)TypesContainer.createInstance((String)className);
    }

    public static IUnSettleService getUnSettleService(String serviceName) {
        return (IUnSettleService)ArApServiceAPIFactory.getService(serviceName);
    }

    public static <T> T getService(String serviceName) {
        String className = serviceMap.get(serviceName);
        if (className == null) {
            throw new RuntimeException(String.format(ResManager.loadKDString((String)"%s\u5bf9\u5e94\u7684\u670d\u52a1\u5b9e\u73b0\u672a\u627e\u5230\u3002", (String)"SettleServiceFactory_0", (String)"fi-arapcommon", (Object[])new Object[0]), serviceName));
        }
        return (T)new ArApServiceProxy(TypesContainer.createInstance((String)className), serviceName).createObj();
    }

    static {
        serviceMap.put(ServiceNameEnum.APPAYSETTLE.getValue(), "kd.fi.ap.mservice.api.settle.ApPaySettleServiceImpl");
        serviceMap.put(ServiceNameEnum.APSELFSETTLE.getValue(), "kd.fi.ap.mservice.api.settle.ApSelfSettleServiceImpl");
        serviceMap.put(ServiceNameEnum.PAYSELFSETTLE.getValue(), "kd.fi.ap.mservice.api.settle.PaySelfSettleServiceImpl");
        serviceMap.put(ServiceNameEnum.APARSETTLE.getValue(), "kd.fi.ap.mservice.api.settle.ApArSettleServiceImpl");
        serviceMap.put(ServiceNameEnum.PAYRECSETTLE.getValue(), "kd.fi.ap.mservice.api.settle.PayRecSettleServiceImpl");
        serviceMap.put(ServiceNameEnum.ARRECSETTLE.getValue(), "kd.fi.ar.mservice.api.settle.ArRecSettleServiceImpl");
        serviceMap.put(ServiceNameEnum.ARSELFSETTLE.getValue(), "kd.fi.ar.mservice.api.settle.ArSelfSettleServiceImpl");
        serviceMap.put(ServiceNameEnum.RECSELFSETTLE.getValue(), "kd.fi.ar.mservice.api.settle.RecSelfSettleServiceImpl");
        serviceMap.put(ServiceNameEnum.ARAPSETTLE.getValue(), "kd.fi.ar.mservice.api.settle.ArApSettleServiceImpl");
        serviceMap.put(ServiceNameEnum.RECPAYSETTLE.getValue(), "kd.fi.ar.mservice.api.settle.RecPaySettleServiceImpl");
        serviceMap.put(ServiceNameEnum.APUPDATESETTLEDATE.getValue(), "kd.fi.ap.mservice.api.settle.ApUpdateSettleDateServiceImpl");
        serviceMap.put(ServiceNameEnum.ARUPDATESETTLEDATE.getValue(), "kd.fi.ar.mservice.api.settle.ArUpdateSettleDateServiceImpl");
        serviceMap.put(ServiceNameEnum.PUSHFINAP.getValue(), "kd.fi.ap.mservice.api.push.PushFinApBillServiceImpl");
        serviceMap.put(ServiceNameEnum.PUSHBUSAP.getValue(), "kd.fi.ap.mservice.api.push.PushBusApBillServiceImpl");
        serviceMap.put(ServiceNameEnum.BUSAPWOFF.getValue(), "kd.fi.ap.mservice.api.push.BusBillWoffServiceImpl");
        serviceMap.put(ServiceNameEnum.PUSHBUSAR.getValue(), "kd.fi.ar.mservice.api.push.PushBusArBillServiceImpl");
        serviceMap.put(ServiceNameEnum.PUSHFINAR.getValue(), "kd.fi.ar.mservice.api.push.PushFinArBillServiceImpl");
        serviceMap.put(ServiceNameEnum.BUSARWOFF.getValue(), "kd.fi.ar.mservice.api.push.BusBillWoffServiceImpl");
        serviceMap.put(ServiceNameEnum.FINARTRANSFER.getValue(), "kd.fi.ar.mservice.api.push.FinArTransferServiceImpl");
        serviceMap.put(ServiceNameEnum.FINAPTRANSFER.getValue(), "kd.fi.ap.mservice.api.push.FinApTransferServiceImpl");
        serviceMap.put(ServiceNameEnum.ARUNSETTLE.getValue(), "kd.fi.ar.mservice.api.settle.ArUnSettleServiceImpl");
        serviceMap.put(ServiceNameEnum.APUNSETTLE.getValue(), "kd.fi.ap.mservice.api.settle.ApUnSettleServiceImpl");
        serviceMap.put(ServiceNameEnum.PUSHAPLIQUIDATION.getValue(), "kd.fi.ap.mservice.api.push.PushApLiquidationBillServiceImpl");
        serviceMap.put(ServiceNameEnum.PUSHARLIQUIDATION.getValue(), "kd.fi.ar.mservice.api.push.PushArLiquidationBillServiceImpl");
        serviceMap.put(ServiceNameEnum.PUSHFINADJUSTAP.getValue(), "kd.fi.ap.mservice.api.push.FinApAdjustServiceImpl");
        serviceMap.put(ServiceNameEnum.PUSHFINADJUSTAR.getValue(), "kd.fi.ar.mservice.api.push.FinArAdjustServiceImpl");
        serviceMap.put(ServiceNameEnum.INVOICESIGN.getValue(), "kd.fi.ap.mservice.api.push.InvoiceSignServiceImpl");
        serviceMap.put(ServiceNameEnum.FINAPWRITEOFF.getValue(), "kd.fi.ap.mservice.api.writeoff.ApWriteOffServiceImpl");
        serviceMap.put(ServiceNameEnum.FINARWRITEOFF.getValue(), "kd.fi.ar.mservice.api.writeoff.ArWriteOffServiceImpl");
        serviceMap.put(ServiceNameEnum.REVCFMWRITEOFF.getValue(), "kd.fi.ar.mservice.api.writeoff.RevcfmWriteOffServiceImpl");
        serviceMap.put(ServiceNameEnum.ARPAYSETTLE.getValue(), "kd.fi.ar.mservice.api.settle.ArPaySettleServiceImpl");
        serviceMap.put(ServiceNameEnum.APRECSETTLE.getValue(), "kd.fi.ap.mservice.api.settle.ApRecSettleServiceImpl");
        serviceMap.put(ServiceNameEnum.ARRECCLAIMSETTLE.getValue(), "kd.fi.ar.mservice.api.settle.ArRecClaimSettleServiceImpl");
        serviceMap.put(ApInvoiceServiceEnum.NOSRCCOLLECT.getValue(), "kd.fi.ap.business.invoice.collect.NoSrcCollectInvServiceImpl");
        serviceMap.put(ApInvoiceServiceEnum.FINAPCOLLECT.getValue(), "kd.fi.ap.business.invoice.collect.FinApCollectInvServiceImpl");
        serviceMap.put(ApInvoiceServiceEnum.PAYAPPLYCOLLECT.getValue(), "kd.fi.ap.business.invoice.collect.PayApplyCollectInvServiceImpl");
        serviceMap.put(ApInvoiceServiceEnum.REPLACEINVCOLLECT.getValue(), "kd.fi.ap.business.invoice.collect.ReplaceApplyCollectInvServiceImpl");
        serviceMap.put(ApInvoiceServiceEnum.ASSGININVOICE.getValue(), "kd.fi.ap.business.invoice.InvoiceAssignService");
        serviceMap.put(ApInvoiceServiceEnum.INVOCIEADJUST.getValue(), "kd.fi.ap.business.invoice.InvoiceAdjustDiffService");
        serviceMap.put(ApInvoiceServiceEnum.SYNATTACHMENT.getValue(), "kd.fi.ap.business.invoice.InvoiceSynAttachmentService");
        serviceMap.put(ApInvoiceServiceEnum.CLOUDJSONRESOLVE.getValue(), "kd.fi.ap.business.invoice.Invoice4CloudResolveService");
        serviceMap.put(ApInvoiceServiceEnum.APPLYDELETEINVROW.getValue(), "kd.fi.ap.business.invoice.delinv.ApplyInvEntryDeleteServiceImpl");
        serviceMap.put(ApInvoiceServiceEnum.APPLYASSIGNINVOICE.getValue(), "kd.fi.ap.business.invoice.assign.ApplyAssignInvoiceServiceImpl");
        serviceMap.put(ApInvoiceServiceEnum.FINAPASSIGNINVOICE.getValue(), "kd.fi.ap.business.invoice.assign.FinApAssignInvoiceServiceImpl");
        serviceMap.put(ApInvoiceServiceEnum.INVOICEASSIGNFINAP.getValue(), "kd.fi.ap.business.invoice.assign.InvoiceAssignFinApServiceImpl");
        serviceMap.put(ApInvoiceServiceEnum.FINAPDELETEINVROW.getValue(), "kd.fi.ap.business.invoice.delinv.FinApInvEntryDeleteServiceImpl");
        serviceMap.put(ApInvoiceServiceEnum.REPLACEDELETEINVROW.getValue(), "kd.fi.ap.business.invoice.delinv.ReplaceInvEntryDeleteServiceImpl");
        serviceMap.put(ApInvoiceServiceEnum.INVOICEARTICULATEFINAP.getValue(), "kd.fi.ap.business.invoice.articulate.FinApInvoiceArticulateServiceImpl");
        serviceMap.put(ApInvoiceServiceEnum.COORDINATIONINVOICE.getValue(), "kd.fi.ap.business.invoice.CoordinationInvoiceService");
        serviceMap.put(VerifyRelationEnum.APPURIN.getValue(), "kd.fi.ap.mservice.api.verify.ApPurInVerifyServiceImpl");
        serviceMap.put(VerifyRelationEnum.APPURRETURN.getValue(), "kd.fi.ap.mservice.api.verify.ApPurOutVerifyServiceImpl");
        serviceMap.put(VerifyRelationEnum.APPURRECED.getValue(), "kd.fi.ap.mservice.api.verify.ApPurRecedAutoVerifyServiceImpl");
        serviceMap.put(VerifyRelationEnum.APOMIN.getValue(), "kd.fi.ap.mservice.api.verify.ApOminAutoVerifyServiceImpl");
        serviceMap.put(VerifyRelationEnum.APOMINRETURN.getValue(), "kd.fi.ap.mservice.api.verify.ApOmiReturnAutoVerifyServiceImpl");
        serviceMap.put(VerifyRelationEnum.ARSALOUT.getValue(), "kd.fi.ar.mservice.api.verify.ArSaloutVerifyServiceImpl");
        serviceMap.put(VerifyRelationEnum.ARSALRETURN.getValue(), "kd.fi.ar.mservice.api.verify.ArSaloutReturnVerifyServiceImpl");
    }
}

