/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.filterscheme;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.control.FilterGrid;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class FilterSchemeHelper {
    private static final String SCHEME_ENTITY = "ap_queryscheme";
    private String formId;

    public FilterSchemeHelper(String formId) {
        this.formId = formId;
    }

    public FilterSchemeHelper() {
    }

    public DynamicObject buildScheme(String schemeStr, String name) {
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)SCHEME_ENTITY);
        DynamicObject scheme = new DynamicObject((DynamicObjectType)dataEntityType);
        scheme.set("id", (Object)DB.genLongId((String)dataEntityType.getAlias()));
        scheme.set("number", (Object)name);
        scheme.set("name", (Object)name);
        scheme.set("formid", (Object)this.formId);
        scheme.set("org", (Object)RequestContext.get().getOrgId());
        scheme.set("schemestr_tag", (Object)schemeStr);
        scheme.set("creator", (Object)RequestContext.get().getCurrUserId());
        Date now = new Date();
        scheme.set("createtime", (Object)now);
        scheme.set("modifytime", (Object)now);
        scheme.set("status", (Object)"C");
        scheme.set("enable", (Object)"1");
        return scheme;
    }

    public long saveScheme(DynamicObject scheme) {
        this.checkSchemeName(scheme);
        OperationResult result = OperationServiceHelper.executeOperate((String)"save", (String)SCHEME_ENTITY, (DynamicObject[])new DynamicObject[]{scheme}, (OperateOption)OperateOption.create());
        List errors = result.getAllErrorOrValidateInfo();
        if (!result.isSuccess()) {
            StringBuilder tmpMsg = new StringBuilder();
            for (IOperateInfo error : errors) {
                OperateInfo operror = (OperateInfo)error;
                tmpMsg.append(operror.getMessage()).append('\n');
            }
            if (errors.isEmpty()) {
                tmpMsg.append(result.getMessage()).append('\n');
            }
            String msg = ResManager.loadKDString((String)"\u4fdd\u5b58\u65b9\u6848\u5931\u8d25\uff0c%s", (String)"FilterSchemeHelper_0", (String)"fi-arapcommon", (Object[])new Object[]{tmpMsg.toString()});
            throw new KDBizException(msg);
        }
        return (Long)result.getSuccessPkIds().get(0);
    }

    private void checkSchemeName(DynamicObject scheme) {
        String name = scheme.getString("name");
        if (StringUtils.isEmpty((CharSequence)name)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4fdd\u5b58\u65b9\u6848\u5931\u8d25\uff0c\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"FilterSchemeHelper_1", (String)"fi-arapcommon", (Object[])new Object[0]));
        }
        QFilter formIdFilter = new QFilter("formid", "=", (Object)this.formId);
        QFilter nameFilter = new QFilter("name", "=", (Object)name);
        QFilter idFilter = new QFilter("id", "<>", (Object)scheme.getLong("id"));
        QFilter creatorFilter = new QFilter("creator", "=", (Object)RequestContext.get().getCurrUserId());
        if (QueryServiceHelper.exists((String)SCHEME_ENTITY, (QFilter[])new QFilter[]{formIdFilter, nameFilter, idFilter, creatorFilter})) {
            String msg = ResManager.loadKDString((String)"\u4fdd\u5b58\u65b9\u6848\u5931\u8d25\uff0c%s: \u201c\u540d\u79f0\u201d \u91cd\u590d\u3002", (String)"FilterSchemeHelper_2", (String)"fi-arapcommon", (Object[])new Object[0]);
            msg = String.format(msg, scheme.getString("name"));
            throw new KDBizException(msg);
        }
    }

    public void updateScheme(String name, String schemeStr, long schemeId) {
        DynamicObject scheme = BusinessDataServiceHelper.loadSingle((String)SCHEME_ENTITY, (String)"id,name,schemestr_tag,modifytime", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)schemeId)});
        scheme.set("name", (Object)name);
        scheme.set("schemestr_tag", (Object)schemeStr);
        scheme.set("modifytime", (Object)new Date());
        this.checkSchemeName(scheme);
        SaveServiceHelper.update((DynamicObject)scheme);
    }

    public DynamicObjectCollection getAllSchemes() {
        QFilter formIdFilter = new QFilter("formid", "=", (Object)this.formId);
        QFilter creatorFilter = new QFilter("creator", "=", (Object)RequestContext.get().getCurrUserId());
        return QueryServiceHelper.query((String)SCHEME_ENTITY, (String)"id,name,isdefault,schemestr_tag", (QFilter[])new QFilter[]{formIdFilter, creatorFilter});
    }

    public void filterSchemes(DynamicObjectCollection schemes, IDataModel model) {
        if (ObjectUtils.isEmpty((Object)schemes) || model == null) {
            return;
        }
        if ("ap_settlequery".equals(this.formId) || "ar_settlequery".equals(this.formId)) {
            DynamicObject org = (DynamicObject)model.getValue("settleorg");
            String orgId = org.getString("id");
            String settleRelation = (String)model.getValue("settlerelation");
            Iterator iterator = schemes.iterator();
            while (iterator.hasNext()) {
                DynamicObject scheme = (DynamicObject)iterator.next();
                String schemeStr = scheme.getString("schemestr_tag");
                Map schemeMap = (Map)SerializationUtils.fromJsonString((String)schemeStr, Map.class);
                String schemeOrgPk = schemeMap.get("org").toString();
                String schemeSettleRelation = (String)schemeMap.get("settlerelation");
                if (orgId.equals(schemeOrgPk) && settleRelation.equals(schemeSettleRelation)) continue;
                iterator.remove();
            }
        }
    }

    public void setComboItems(DynamicObjectCollection schemes, IFormView view) {
        if (view == null) {
            return;
        }
        ComboEdit comboEdit = (ComboEdit)view.getControl("schemes");
        ArrayList<ComboItem> items = new ArrayList<ComboItem>(2);
        for (DynamicObject scheme : schemes) {
            String caption = scheme.getString("name");
            long value = scheme.getLong("id");
            items.add(new ComboItem(new LocaleString(caption), Long.toString(value)));
        }
        comboEdit.setComboItems(items);
    }

    public void deleteScheme(long schemeId) {
        DeleteServiceHelper.delete((String)SCHEME_ENTITY, (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)schemeId)});
    }

    public DynamicObject queryScheme(long schemeId) {
        QFilter idFilter = new QFilter("id", "=", (Object)schemeId);
        return QueryServiceHelper.queryOne((String)SCHEME_ENTITY, (String)"id,name,schemestr_tag,isdefault", (QFilter[])new QFilter[]{idFilter});
    }

    public void setDefault(long schemeId) {
        DynamicObject[] schemes;
        HashSet<Long> schemeIds = new HashSet<Long>(2);
        schemeIds.add(schemeId);
        QFilter formIdFilter = new QFilter("formid", "=", (Object)this.formId);
        QFilter creatorFilter = new QFilter("creator", "=", (Object)RequestContext.get().getCurrUserId());
        QFilter isDefaultFilter = new QFilter("isdefault", "=", (Object)Boolean.TRUE);
        DynamicObjectCollection currentDefalutSchemes = QueryServiceHelper.query((String)SCHEME_ENTITY, (String)"id", (QFilter[])new QFilter[]{formIdFilter, creatorFilter, isDefaultFilter});
        for (DynamicObject currentDefalutScheme : currentDefalutSchemes) {
            schemeIds.add(currentDefalutScheme.getLong("id"));
        }
        for (DynamicObject scheme : schemes = BusinessDataServiceHelper.load((String)SCHEME_ENTITY, (String)"id,isdefault", (QFilter[])new QFilter[]{new QFilter("id", "in", schemeIds)})) {
            if (schemeId == scheme.getLong("id")) {
                scheme.set("isdefault", (Object)Boolean.TRUE);
                continue;
            }
            scheme.set("isdefault", (Object)Boolean.FALSE);
        }
        SaveServiceHelper.update((DynamicObject[])schemes);
    }

    public void cancelDefault(long schemeId) {
        DynamicObject[] schemes;
        QFilter idFilter = new QFilter("id", "=", (Object)schemeId);
        for (DynamicObject scheme : schemes = BusinessDataServiceHelper.load((String)SCHEME_ENTITY, (String)"id,isdefault", (QFilter[])new QFilter[]{idFilter})) {
            scheme.set("isdefault", (Object)Boolean.FALSE);
        }
        SaveServiceHelper.update((DynamicObject[])schemes);
    }

    public void setButtonVisible(boolean isDefault, IFormView view) {
        view.setVisible(Boolean.valueOf(!isDefault), new String[]{"setdefault"});
        view.setVisible(Boolean.valueOf(isDefault), new String[]{"canceldefault"});
    }

    public void parseFilterScheme(DynamicObject scheme, IFormView view) {
        String schemeName = scheme.getString("name");
        String schemeStr = scheme.getString("schemestr_tag");
        Map schemeMap = (Map)SerializationUtils.fromJsonString((String)schemeStr, Map.class);
        IDataModel model = view.getModel();
        if (!"ap_settlequery".equals(this.formId) && !"ar_settlequery".equals(this.formId)) {
            model.setValue("org", schemeMap.get("org"));
            model.setValue("settlerelation", schemeMap.get("settlerelation"));
            model.setValue("asstactvalue", schemeMap.get("asstactvalue"));
        }
        Object mainFilterStr = schemeMap.get("mainfilter");
        FilterCondition mainFilter = (FilterCondition)SerializationUtils.fromJsonString((String)((String)mainFilterStr), FilterCondition.class);
        FilterGrid mainFilterGrid = (FilterGrid)view.getControl("mainfiltergrid");
        mainFilterGrid.SetValue(mainFilter);
        Object asstFilterStr = schemeMap.get("asstfilter");
        if (asstFilterStr != null) {
            FilterCondition asstFilter = (FilterCondition)SerializationUtils.fromJsonString((String)((String)asstFilterStr), FilterCondition.class);
            FilterGrid asstFilterGrid = (FilterGrid)view.getControl("asstfiltergrid");
            asstFilterGrid.SetValue(asstFilter);
        }
        model.setValue("schemename", (Object)schemeName);
        model.setValue("schemes", (Object)scheme.getLong("id"));
        this.setButtonVisible(scheme.getBoolean("isdefault"), view);
    }

    public DynamicObject getDefaultSchemeStr() {
        QFilter formIdFilter = new QFilter("formid", "=", (Object)this.formId);
        QFilter creatorFilter = new QFilter("creator", "=", (Object)RequestContext.get().getCurrUserId());
        QFilter isDefaultFilter = new QFilter("isdefault", "=", (Object)Boolean.TRUE);
        return QueryServiceHelper.queryOne((String)SCHEME_ENTITY, (String)"id,schemestr_tag,name", (QFilter[])new QFilter[]{formIdFilter, creatorFilter, isDefaultFilter});
    }
}

