/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.filterscheme;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.fi.arapcommon.filterscheme.FilterSchemeHelper;
import kd.fi.arapcommon.filterscheme.IFilterSchemeCallBack;
import kd.fi.arapcommon.filterscheme.IFilterSchemeService;

public class FilterSchemeService
implements IFilterSchemeService {
    private IFilterSchemeCallBack callBack;
    private IFormView view;

    public FilterSchemeService() {
    }

    public FilterSchemeService(IFilterSchemeCallBack callBack, IFormView view) {
        this.callBack = callBack;
        this.view = view;
    }

    @Override
    public void add() {
        this.callBack.onAdd();
    }

    @Override
    public void save() {
        IDataModel model = this.view.getModel();
        String schemeIdStr = (String)model.getValue("schemes");
        String schemeName = model.getDataEntity().getString("schemename");
        String schemeStr = this.callBack.onSave();
        FilterSchemeHelper helper = new FilterSchemeHelper(this.view.getEntityId());
        if (ObjectUtils.isEmpty((Object)schemeIdStr)) {
            DynamicObject scheme = helper.buildScheme(schemeStr, schemeName);
            long schemeId = helper.saveScheme(scheme);
            schemeIdStr = String.valueOf(schemeId);
        } else {
            helper.updateScheme(schemeName, schemeStr, Long.parseLong(schemeIdStr));
        }
        DynamicObjectCollection existsSchemes = helper.getAllSchemes();
        helper.filterSchemes(existsSchemes, model);
        helper.setComboItems(existsSchemes, this.view);
        model.setValue("schemes", (Object)schemeIdStr);
    }

    @Override
    public void delete() {
        IDataModel model = this.view.getModel();
        String schemeId = (String)model.getValue("schemes");
        if (ObjectUtils.isEmpty((Object)schemeId)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u65b9\u6848\u3002", (String)"FilterSchemeService_1", (String)"fi-arapcommon", (Object[])new Object[0]));
        }
        String formId = this.view.getEntityId();
        FilterSchemeHelper helper = new FilterSchemeHelper(formId);
        helper.deleteScheme(Long.parseLong(schemeId));
        this.callBack.onDelete();
        DynamicObjectCollection schemes = helper.getAllSchemes();
        helper.filterSchemes(schemes, model);
        helper.setComboItems(schemes, this.view);
        model.setValue("schemename", null);
        model.setValue("schemes", null);
    }

    @Override
    public void setDefault() {
        IDataModel model = this.view.getModel();
        String schemeId = (String)model.getValue("schemes");
        if (ObjectUtils.isEmpty((Object)schemeId)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u4fdd\u5b58\u65b9\u6848\u3002", (String)"FilterSchemeService_0", (String)"fi-arapcommon", (Object[])new Object[0]));
        }
        FilterSchemeHelper helper = new FilterSchemeHelper(this.view.getEntityId());
        helper.setDefault(Long.parseLong(schemeId));
        helper.setButtonVisible(true, this.view);
        this.callBack.onSetDefault();
    }

    @Override
    public void cancelDefault() {
        IDataModel model = this.view.getModel();
        String schemeId = (String)model.getValue("schemes");
        if (ObjectUtils.isEmpty((Object)schemeId)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u4fdd\u5b58\u65b9\u6848\u3002", (String)"FilterSchemeService_0", (String)"fi-arapcommon", (Object[])new Object[0]));
        }
        FilterSchemeHelper helper = new FilterSchemeHelper(this.view.getEntityId());
        helper.cancelDefault(Long.parseLong(schemeId));
        helper.setButtonVisible(false, this.view);
        this.callBack.onCancelDefault();
    }
}

