/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.form;

import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportColumnGroup;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.field.BasedataEdit;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.report.events.CreateColumnEvent;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.fi.arapcommon.util.DateUtils;
import kd.fi.arapcommon.util.EmptyUtils;

public abstract class AbstractARAPReportFormPlugin
extends AbstractReportFormPlugin {
    private final Log logger = LogFactory.getLog(AbstractARAPReportFormPlugin.class);

    protected abstract List<Long> getOrgIds();

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit orgCtrl = (BasedataEdit)this.getControl("orgs");
        orgCtrl.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            showParameter.getListFilterParameter().setFilter(new QFilter("id", "in", this.getOrgIds()));
        });
    }

    public void initDefaultQueryParam(ReportQueryParam queryParam) {
        List<Long> orgIds;
        super.initDefaultQueryParam(queryParam);
        if (EmptyUtils.isEmpty(this.getModel().getValue("orgs")) && (orgIds = this.getOrgIds()) != null && orgIds.size() > 0) {
            long orgId = RequestContext.get().getOrgId();
            if (!orgIds.contains(orgId)) {
                orgId = orgIds.get(0);
            }
            this.getModel().setValue("orgs", (Object)new Object[]{orgId});
        }
        if (EmptyUtils.isEmpty(this.getModel().getValue("startdate"))) {
            Date newDate = new Date();
            this.getModel().setValue("startdate", (Object)DateUtils.getMinMonthDate(newDate));
            this.getModel().setValue("stopdate", (Object)newDate);
        }
    }

    public boolean verifyQuery(ReportQueryParam queryParam) {
        FilterInfo filterInfo = queryParam.getFilter();
        this.logger.info("AbstractARAPReportFormPlugin : go in filterInfo");
        if (filterInfo != null) {
            DynamicObjectCollection org = (DynamicObjectCollection)filterInfo.getValue("orgs");
            if (org == null || org.size() < 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u7ed3\u7b97\u7ec4\u7ec7\u201d\u3002", (String)"AbstractARAPReportFormPlugin_0", (String)"fi-arapcommon", (Object[])new Object[0]), Integer.valueOf(3000));
                return false;
            }
            Date startDate = filterInfo.getDate("startdate");
            this.logger.info("AbstractARAPReportFormPlugin : get startDate , " + startDate);
            if (startDate == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u65e5\u671f\u8303\u56f4\u201d\u7684\u5f00\u59cb\u65e5\u671f\u3002", (String)"AbstractARAPReportFormPlugin_1", (String)"fi-arapcommon", (Object[])new Object[0]), Integer.valueOf(3000));
                this.logger.info("AbstractARAPReportFormPlugin : startDate not int warning");
                return false;
            }
            Date stopDate = filterInfo.getDate("stopdate");
            this.logger.info("AbstractARAPReportFormPlugin : get stopDate , " + stopDate);
            if (stopDate == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u65e5\u671f\u8303\u56f4\u201d\u7684\u7ed3\u675f\u65e5\u671f\u3002", (String)"AbstractARAPReportFormPlugin_2", (String)"fi-arapcommon", (Object[])new Object[0]), Integer.valueOf(3000));
                this.logger.info("AbstractARAPReportFormPlugin : stopDate not int warning");
                return false;
            }
            return super.verifyQuery(queryParam);
        }
        return false;
    }

    public void afterCreateColumn(CreateColumnEvent event) {
        Boolean isContainsPre;
        super.afterCreateColumn(event);
        List cols = event.getColumns();
        Boolean showMainCurrency = (Boolean)this.getModel().getValue("showmaincurrency");
        if (!showMainCurrency.booleanValue()) {
            for (int i = cols.size() - 1; i >= 0; --i) {
                AbstractReportColumn col = (AbstractReportColumn)cols.get(i);
                if (!ResManager.loadKDString((String)"\u672c\u4f4d\u5e01", (String)"AbstractARAPReportFormPlugin_3", (String)"fi-arapcommon", (Object[])new Object[0]).equals(col.getCaption().toString())) continue;
                cols.remove(i);
            }
        }
        if (!(isContainsPre = (Boolean)this.getModel().getValue(this.getContainsPreFieldKey())).booleanValue()) {
            List<String> hideColKeys = this.getHideColKeys();
            for (int i = cols.size() - 1; i >= 0; --i) {
                AbstractReportColumn col = (AbstractReportColumn)cols.get(i);
                if (!(col instanceof ReportColumnGroup)) continue;
                List children = ((ReportColumnGroup)col).getChildren();
                for (int j = children.size() - 1; j >= 0; --j) {
                    ReportColumn child = (ReportColumn)children.get(j);
                    if (!hideColKeys.contains(child.getFieldKey())) continue;
                    children.remove(j);
                }
            }
        }
    }

    private String getContainsPreFieldKey() {
        String fieldKey = "containsprepaid";
        String name = this.getModel().getDataEntityType().getName();
        if ("ar_sumrpt_new".equals(name) || "ar_detailrpt_new".equals(name)) {
            fieldKey = "containsreceived";
        } else if ("arap_asstact_summarize".equals(name) || "arap_asstact_detail".equals(name)) {
            fieldKey = "containspre";
        }
        return fieldKey;
    }

    private List<String> getHideColKeys() {
        ArrayList<String> hideColKeys = new ArrayList<String>(20);
        hideColKeys.add("prepaidamt");
        hideColKeys.add("localprepaidamt");
        hideColKeys.add("paysettleamt");
        hideColKeys.add("localpaysettleamt");
        hideColKeys.add("recamt");
        hideColKeys.add("localrecamt");
        hideColKeys.add("recsettleamt");
        hideColKeys.add("localrecsettleamt");
        hideColKeys.add("prepaidamt");
        hideColKeys.add("localprepaidamt");
        hideColKeys.add("paysettleamt");
        hideColKeys.add("recsettleamt");
        hideColKeys.add("localpaysettleamt");
        hideColKeys.add("localrecsettleamt");
        hideColKeys.add("receivedamt");
        hideColKeys.add("offset");
        hideColKeys.add("recoffset");
        hideColKeys.add("localreceivedamt");
        hideColKeys.add("localoffset");
        hideColKeys.add("localrecoffset");
        return hideColKeys;
    }
}

