/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.form;

import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.CRCondition;
import kd.bos.entity.datamodel.IBillModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.filter.SimpleFilterRow;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.lang.Lang;
import kd.bos.license.api.LicenseCheckResult;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.license.LicenseServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.arapcommon.enums.SettleRelationEnum;
import kd.fi.arapcommon.helper.OrgHelper;
import kd.fi.arapcommon.helper.RPASettleSchemeDefaultValueHelper;
import kd.fi.arapcommon.helper.SystemParameterHelper;
import kd.fi.arapcommon.util.StdConfig;
import kd.fi.arapcommon.vo.RPAExecuteTaskParam;

public abstract class AbstractRPASettleSchemeEdit
extends AbstractBillPlugIn {
    private static final String groupNumber = "PRO_ISR";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.filterOrg();
        this.addClickListeners(new String[]{"addcard", "addimg", "modifycard", "addlabel", "deleterule", "exceplan", "deletecardentry"});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.initUserInfo();
        this.initOrgEntry();
        LicenseCheckResult result = LicenseServiceHelper.checkPerformGroup((String)groupNumber);
        if (!result.getHasLicense().booleanValue()) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"conentpanel", "titleapanel"});
            this.getView().showMessage(result.getMsg());
        }
    }

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        LicenseCheckResult result = LicenseServiceHelper.checkPerformGroup((String)groupNumber);
        if (!result.getHasLicense().booleanValue()) {
            e.setCancel(true);
            e.setCancelMessage(result.getMsg());
        }
    }

    public void afterLoadData(EventObject e) {
        super.afterLoadData(e);
        this.initUserInfo();
    }

    public void click(EventObject evt) {
        Object enable = this.getModel().getValue("enable");
        Long id = (Long)this.getModel().getValue("id");
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        String key = ((Control)evt.getSource()).getKey();
        if ("1".equals(enable) && id > 0L && OperationStatus.EDIT.equals((Object)status)) {
            if ("modifycard".equals(key)) {
                this.modifyRule("view");
            }
            return;
        }
        if ("addimg".equals(key) || "addcard".equals(key) || "addlabel".equals(key)) {
            this.addRule();
        } else if ("deleterule".equals(key) || "deletecardentry".equals(key)) {
            this.deleteRule();
        } else if ("modifycard".equals(key)) {
            this.modifyRule("modify");
        } else if ("exceplan".equals(key)) {
            this.showExcePlanPage();
        }
    }

    protected int getSettleModel() {
        int settleModel = 1;
        int entryRowCount = this.getModel().getEntryRowCount("orgentry");
        if (entryRowCount > 0) {
            for (int i = 0; i < entryRowCount; ++i) {
                if (ObjectUtils.isEmpty((Object)this.getModel().getValue("settlemodel", i))) continue;
                int dynamicSettleModel = Integer.parseInt((String)this.getModel().getValue("settlemodel", i));
                if (i == 0) {
                    settleModel = dynamicSettleModel;
                    continue;
                }
                if (settleModel == dynamicSettleModel) continue;
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7ed3\u7b97\u6a21\u578b\u4e00\u81f4\u7684\u7ec4\u7ec7\u3002", (String)"AbstractRPASettleSchemeEdit_0", (String)"fi-arapcommon", (Object[])new Object[0]));
            }
        }
        return settleModel;
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        if (e.getReturnData() != null) {
            String actionId = e.getActionId();
            if ("newrule".equals(actionId)) {
                Map returnData = (Map)e.getReturnData();
                this.newRuleCloseCallBack(returnData);
            } else if ("modifyrule".equals(actionId)) {
                Map returnData = (Map)e.getReturnData();
                this.modifyRuleCloseCallBack(returnData);
            } else if ("newshedule".equals(actionId)) {
                DynamicObject scheduleInfo = (DynamicObject)e.getReturnData();
                this.newScheduleCloseCallBack(scheduleInfo);
            }
        }
    }

    private void filterOrg() {
        BasedataEdit orgCtrl = (BasedataEdit)this.getControl("org");
        orgCtrl.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            List<Long> idList = OrgHelper.getAuthorizedBankOrgIds(this.getView().getFormShowParameter().getAppId(), this.settleSchemeEntity(), "47156aff000000ac");
            QFilter qFilter = new QFilter("id", "in", idList);
            showParameter.getListFilterParameter().setFilter(qFilter);
        });
    }

    private void initUserInfo() {
        DynamicObject user;
        long id = (Long)this.getModel().getValue("id");
        if (id != 0L) {
            user = (DynamicObject)this.getModel().getValue("modifier");
            this.getView().setVisible(Boolean.FALSE, new String[]{"creatoravatar"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"modifieravatar"});
        } else {
            user = (DynamicObject)this.getModel().getValue("creator");
            this.getView().setVisible(Boolean.TRUE, new String[]{"creatoravatar"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"modifieravatar"});
        }
        if (user != null) {
            ((Label)this.getControl("personname")).setText(user.getString("name"));
            DynamicObjectCollection entrys = user.getDynamicObjectCollection("entryentity");
            if (entrys != null && entrys.size() > 0) {
                ((Label)this.getControl("persondpt")).setText(((DynamicObject)entrys.get(0)).getString("dpt.name"));
            }
            ((Label)this.getControl("personphone")).setText(user.getString("phone"));
        }
    }

    private void initOrgEntry() {
        Long defaultOrgId = this.getDefaultOrgId();
        this.getModel().setValue("org", (Object)defaultOrgId, 0);
    }

    protected Long getDefaultOrgId() {
        Long defaultOrgId = RequestContext.get().getOrgId();
        List<Long> idList = OrgHelper.getAuthorizedBankOrgIds(this.getView().getFormShowParameter().getAppId(), this.settleSchemeEntity(), "47156aff000000ac");
        if (!idList.isEmpty() && !idList.contains(defaultOrgId)) {
            defaultOrgId = idList.get(0);
        }
        return defaultOrgId;
    }

    private void addRule() {
        int settleModel = this.getSettleModel();
        HashMap<String, Object> curRuleData = new HashMap<String, Object>(8);
        curRuleData.put("oper", "new");
        curRuleData.put("settleModel", settleModel);
        Object org = this.getModel().getValue("org");
        Long orgId = org != null ? Long.valueOf(((DynamicObject)org).getLong("id")) : this.getDefaultOrgId();
        curRuleData.put("orgId", orgId.toString());
        this.showSettleRulePage("newrule", curRuleData);
    }

    private void deleteRule() {
        CardEntry operEntry = (CardEntry)this.getControl("ruleentry");
        this.getModel().deleteEntryRow("ruleentry", operEntry.getEntryState().getFocusRow());
    }

    private void modifyRule(String openMode) {
        Object org;
        int settleModel = this.getSettleModel();
        IDataModel model = this.getModel();
        int index = model.getEntryCurrentRowIndex("ruleentry");
        HashMap<String, Object> curRuleData = new HashMap<String, Object>(12);
        curRuleData.put("settlerelation", model.getValue("settlerelation", index));
        curRuleData.put("timeorder", model.getValue("timeorder", index));
        curRuleData.put("description", model.getValue("description", index));
        curRuleData.put("matchfieldinfo", model.getValue("matchfieldinfo", index));
        curRuleData.put("mainbill", model.getValue("mainbill", index));
        curRuleData.put("asstbill", model.getValue("asstbill", index));
        curRuleData.put("mainfilter_tag", model.getValue("mainfilter_tag", index));
        curRuleData.put("asstfilter_tag", model.getValue("asstfilter_tag", index));
        curRuleData.put("maindatesrc", model.getValue("maindatesrc", index));
        curRuleData.put("asstdatesrc", model.getValue("asstdatesrc", index));
        curRuleData.put("currencymatch", model.getValue("currencymatch", index));
        curRuleData.put("asstactmatch", model.getValue("asstactmatch", index));
        curRuleData.put("oper", "modify");
        curRuleData.put("settleModel", settleModel);
        if ("view".equals(openMode)) {
            curRuleData.put("openMode", "view");
        }
        Long orgId = (org = this.getModel().getValue("org")) != null ? Long.valueOf(((DynamicObject)org).getLong("id")) : this.getDefaultOrgId();
        curRuleData.put("orgId", orgId);
        this.showSettleRulePage("modifyrule", curRuleData);
    }

    private void showSettleRulePage(String closeActionID, Map<String, Object> customParam) {
        FormShowParameter parameter = new FormShowParameter();
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setFormId(this.settleSchemeRuleEntity());
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, closeActionID));
        parameter.setCustomParams(customParam);
        this.getView().showForm(parameter);
    }

    private void showExcePlanPage() {
        String appId;
        IBillModel billmodel = (IBillModel)this.getModel();
        long id = (Long)billmodel.getValue("id");
        if (StringUtils.isBlank((Object)id) || id == 0L) {
            String tableName = billmodel.getDataEntityType().getAlias();
            long[] ids = DBServiceHelper.genLongIds((String)tableName, (int)1);
            id = ids[0];
            billmodel.getDataEntity().set("id", (Object)id);
        }
        BillShowParameter parameter = new BillShowParameter();
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setFormId("sch_schedule");
        String scheduleId = (String)this.getView().getModel().getValue("sheduleplanid");
        String string = appId = "ap_rpa_settlescheme".equals(this.settleSchemeEntity()) ? "ap" : "ar";
        if (scheduleId != null && scheduleId.trim().length() != 0) {
            parameter.setPkId((Object)scheduleId);
            parameter.setStatus(OperationStatus.EDIT);
        } else {
            parameter.setStatus(OperationStatus.ADDNEW);
            RPAExecuteTaskParam param = new RPAExecuteTaskParam(Collections.singletonList(id), appId);
            parameter.setCustomParam("paramjsonstr", (Object)SerializationUtils.toJsonString((Object)param));
            parameter.setCustomParam("taskclassname", (Object)"kd.fi.arapcommon.task.RPASettleSchemeExecuteTask");
            parameter.setCustomParam("taskname", (Object)ResManager.loadKDString((String)"RPA\u7ed3\u7b97\u65b9\u6848\u6267\u884c\u8ba1\u5212", (String)"AbstractRPASettleSchemeEdit_1", (String)"fi-arapcommon", (Object[])new Object[0]));
            parameter.setCustomParam("tasknumber", (Object)("rpa_settleexec" + System.currentTimeMillis()));
            DynamicObject executor = (DynamicObject)billmodel.getValue("executor");
            if (executor != null) {
                parameter.setCustomParam("executor", executor.get("id"));
            }
        }
        parameter.setCustomParam("taskappnumber", (Object)appId);
        parameter.setCustomParam("taskdefineid", (Object)this.getExecClassName(appId));
        parameter.setHasRight(true);
        parameter.setCustomParam("frombiz", (Object)"true");
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "newshedule"));
        StyleCss css1 = new StyleCss();
        css1.setWidth("1000");
        css1.setHeight("700");
        parameter.getOpenStyle().setInlineStyleCss(css1);
        this.getView().showForm((FormShowParameter)parameter);
    }

    private String getExecClassName(String appId) {
        String taskdefineid;
        QFilter filter = new QFilter("classname", "=", (Object)"kd.fi.arapcommon.task.RPASettleSchemeExecuteTask");
        filter.and("appid", "=", (Object)appId);
        DynamicObject[] taskDefines = BusinessDataServiceHelper.load((String)"sch_taskdefine", (String)"id", (QFilter[])filter.toArray(), null);
        if (null != taskDefines && taskDefines.length > 0) {
            taskdefineid = taskDefines[0].getString("id");
        } else {
            DynamicObject taskDyn = BusinessDataServiceHelper.newDynamicObject((String)"sch_taskdefine");
            taskDyn.set("appid", (Object)appId);
            taskDyn.set("name", (Object)ResManager.loadKDString((String)"RPA\u7ed3\u7b97\u65b9\u6848\u8c03\u5ea6\u4f5c\u4e1a", (String)"AbstractRPASettleSchemeEdit_2", (String)"fi-arapcommon", (Object[])new Object[0]));
            taskDyn.set("number", (Object)("RPASettleSchemeExceTask-" + appId));
            taskDyn.set("classname", (Object)"kd.fi.arapcommon.task.RPASettleSchemeExecuteTask");
            DynamicObject[] result = (DynamicObject[])SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{taskDyn});
            taskdefineid = result[0].getString("id");
        }
        return taskdefineid;
    }

    private void newRuleCloseCallBack(Map<String, Object> returnData) {
        int rowIndex = this.getModel().createNewEntryRow("ruleentry");
        this.putRuleRowData(rowIndex, returnData);
    }

    private void modifyRuleCloseCallBack(Map<String, Object> returnData) {
        int rowIndex = this.getModel().getEntryCurrentRowIndex("ruleentry");
        this.putRuleRowData(rowIndex, returnData);
    }

    private void putRuleRowData(int rowIndex, Map<String, Object> data) {
        IDataModel model = this.getModel();
        for (Map.Entry<String, Object> entry : data.entrySet()) {
            model.setValue(entry.getKey(), entry.getValue(), rowIndex);
        }
    }

    private void newScheduleCloseCallBack(DynamicObject scheduleInfo) {
        if (scheduleInfo != null) {
            String planid = (String)scheduleInfo.get("id");
            this.getModel().setValue("sheduleplanid", (Object)planid);
            String txtdesc = (String)scheduleInfo.get("txtdesc");
            if (StringUtils.isNotEmpty((CharSequence)txtdesc) && txtdesc.length() > 153) {
                txtdesc = txtdesc.substring(0, 150) + "...";
            }
            this.getModel().setValue("exceplan", (Object)txtdesc);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        String operateKey;
        super.afterDoOperation(e);
        OperationResult operationResult = e.getOperationResult();
        if (operationResult != null && operationResult.isSuccess() && "save".equals(operateKey = e.getOperateKey())) {
            String sheduleplanid = (String)this.getModel().getValue("sheduleplanid");
            if (StringUtils.isBlank((CharSequence)sheduleplanid)) {
                return;
            }
            DynamicObject sch = BusinessDataServiceHelper.loadSingle((Object)sheduleplanid, (String)"sch_schedule");
            sch.set("name", this.getModel().getValue("name"));
            DynamicObject schJob = sch.getDynamicObject("job");
            if (schJob == null) {
                return;
            }
            DynamicObject job = BusinessDataServiceHelper.loadSingle((Object)schJob.get("id"), (String)"sch_job");
            if (job == null) {
                return;
            }
            Lang lang = RequestContext.get().getLang();
            job.set("runbylang", (Object)lang.toString());
            job.set("runconcurrent", (Object)Boolean.FALSE);
            job.set("classname", (Object)"ap");
            job.set("taskclassname", (Object)this.getExecClassName("ap"));
            IDataModel dataModel = this.getModel();
            DynamicObject executor = (DynamicObject)dataModel.getValue("executor");
            MainEntityType userType = EntityMetadataCache.getDataEntityType((String)"bos_user");
            DynamicObject userInfo = new DynamicObject((DynamicObjectType)userType);
            userInfo.set("id", executor.getPkValue());
            job.set("name", this.getModel().getValue("name"));
            job.set("runbyuser", (Object)userInfo);
            OperationServiceHelper.executeOperate((String)"save", (String)"sch_schedule", (DynamicObject[])new DynamicObject[]{sch}, (OperateOption)OperateOption.create());
            OperationServiceHelper.executeOperate((String)"save", (String)"sch_job", (DynamicObject[])new DynamicObject[]{job}, (OperateOption)OperateOption.create());
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate op = (AbstractOperate)args.getSource();
        String key = op.getOperateKey();
        if ("enable".equals(key) && this.getModel().getDataChanged()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u4fdd\u5b58\u3002", (String)"AbstractRPASettleSchemeEdit_3", (String)"fi-arapcommon", (Object[])new Object[0]));
            args.setCancel(true);
        }
    }

    protected abstract String settleSchemeEntity();

    protected abstract String settleSchemeRuleEntity();

    protected int getApSettleModel(Long orgId) {
        Object value = SystemParameterHelper.getAPAppParameter(orgId, "ap_003");
        if (value == null) {
            return 1;
        }
        return Integer.parseInt(value.toString());
    }

    protected int getArSettleModel(Long orgId) {
        Object value = SystemParameterHelper.getARAppParameter(orgId, "ar_003");
        if (value == null) {
            return 1;
        }
        return Integer.parseInt(value.toString());
    }

    protected void orgChangeUpdateDefalutFilter(DynamicObject org) {
        String noUpdatePreSetValue = StdConfig.get("noupdatepresetvalue");
        if ("true".equals(noUpdatePreSetValue)) {
            return;
        }
        int apSettleModel = this.getApSettleModel(org.getLong("id"));
        int arSettleModel = this.getArSettleModel(org.getLong("id"));
        DynamicObjectCollection ruleEntryColl = this.getModel().getEntryEntity("ruleentry");
        boolean isAp = "ap_rpa_settlescheme".equals(this.settleSchemeEntity());
        if (!ObjectUtils.isEmpty((Object)ruleEntryColl)) {
            for (int i = 0; i < ruleEntryColl.size(); ++i) {
                DynamicObject ruleEntry = (DynamicObject)ruleEntryColl.get(i);
                String settleRelation = ruleEntry.getString("settlerelation");
                Tuple<Integer, Integer> settleModelTuple = this.setMainAndAsstSettleModel(apSettleModel, arSettleModel, settleRelation);
                String mainExpression = ruleEntry.getString("mainfilter_tag");
                CRCondition mainCondition = (CRCondition)SerializationUtils.fromJsonString((String)mainExpression, CRCondition.class);
                FilterCondition mainFilterConditon = mainCondition.getFilterCondition();
                List mainFilterRowList = mainFilterConditon.getFilterRow();
                for (SimpleFilterRow mainFilterRow : mainFilterRowList) {
                    String mainFiledName = mainFilterRow.getFieldName();
                    boolean mainLockEnd = mainFiledName.endsWith("lockamt");
                    if (!mainLockEnd) continue;
                    if ((Integer)settleModelTuple.item1 == 1) {
                        if (isAp) {
                            mainFilterRow.setFieldName("unlockamt");
                            break;
                        }
                        mainFilterRow.setFieldName("e_unlockamt");
                        break;
                    }
                    mainFilterRow.setFieldName("unplanlockamt");
                    break;
                }
                String newMainExpression = SerializationUtils.toJsonString((Object)mainCondition);
                String asstExpression = ruleEntry.getString("asstfilter_tag");
                CRCondition asstCondition = (CRCondition)SerializationUtils.fromJsonString((String)asstExpression, CRCondition.class);
                FilterCondition asstFilterConditon = asstCondition.getFilterCondition();
                List asstFilterRowList = asstFilterConditon.getFilterRow();
                for (SimpleFilterRow asstFilterRow : asstFilterRowList) {
                    String asstFiledName = asstFilterRow.getFieldName();
                    boolean asstLockEnd = asstFiledName.endsWith("lockamt");
                    if (!asstLockEnd) continue;
                    if ((Integer)settleModelTuple.item2 == 1) {
                        if (isAp) {
                            asstFilterRow.setFieldName("e_unlockamt");
                            break;
                        }
                        asstFilterRow.setFieldName("unlockamt");
                        break;
                    }
                    asstFilterRow.setFieldName("unplanlockamt");
                    break;
                }
                String newAsstExpression = SerializationUtils.toJsonString((Object)asstCondition);
                String matchFieldInfo = (String)this.getModel().getValue("matchfieldinfo");
                if (matchFieldInfo != null && !"".equals(matchFieldInfo.trim())) {
                    List<String> relationList = SettleRelationEnum.getEntityByRelation(settleRelation);
                    String mainEntityKey = relationList.get(0);
                    String asstEntityKey = relationList.get(1);
                    List<Map<String, Object>> defaultEntryList = RPASettleSchemeDefaultValueHelper.getDefaultEntryMap(settleRelation, mainEntityKey, asstEntityKey);
                    List fieldEntryList = (List)SerializationUtils.fromJsonString((String)matchFieldInfo, List.class);
                    for (Map fieldEntry : fieldEntryList) {
                        boolean preference = (Boolean)fieldEntry.get("preference");
                        if (preference) continue;
                        defaultEntryList.add(fieldEntry);
                    }
                    String newMatchFieldInfo = SerializationUtils.toJsonString(defaultEntryList);
                    this.getModel().setValue("matchfieldinfo", (Object)newMatchFieldInfo, i);
                }
                this.getModel().setValue("asstfilter_tag", (Object)newAsstExpression, i);
                this.getModel().setValue("mainfilter_tag", (Object)newMainExpression, i);
            }
        }
    }

    private Tuple<Integer, Integer> setMainAndAsstSettleModel(int apSettleModel, int arSettleModel, String settleRelation) {
        int mainSettleModel = 1;
        int asstSettleModel = 1;
        if ("ap_rpa_settlescheme".equals(this.settleSchemeEntity())) {
            mainSettleModel = apSettleModel;
            asstSettleModel = SettleRelationEnum.APARSETTLE.getValue().equals(settleRelation) ? arSettleModel : apSettleModel;
        } else {
            mainSettleModel = arSettleModel;
            asstSettleModel = SettleRelationEnum.ARAPSETTLE.getValue().equals(settleRelation) ? apSettleModel : arSettleModel;
        }
        return Tuple.create((Object)mainSettleModel, (Object)asstSettleModel);
    }
}

