/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.form;

import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.license.api.LicenseCheckResult;
import kd.bos.list.BillList;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.license.LicenseServiceHelper;

public abstract class AbstractRPASettleSchemeList
extends AbstractListPlugin {
    private static final Log logger = LogFactory.getLog(AbstractRPASettleSchemeList.class);
    private static final String groupNumber = "PRO_ISR";

    public void registerListener(EventObject e) {
        super.registerListener(e);
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        if ("viewlog".equals(evt.getItemKey())) {
            BillList list = (BillList)this.getView().getControl("billlistap");
            ListSelectedRowCollection selectedRows = list.getSelectedRows();
            logger.info("\u9009\u4e2d\u884cselectedRows:" + selectedRows.size());
            Object[] primaryKeys = selectedRows.getPrimaryKeyValues();
            logger.info("\u9009\u4e2d\u884cprimaryKeys\u6570\u7ec4:" + primaryKeys.length);
            if (primaryKeys.length == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"AbstractRPASettleSchemeList_0", (String)"fi-arapcommon", (Object[])new Object[0]));
            } else if (primaryKeys.length > 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5355\u6761\u6570\u636e\u8054\u67e5\u3002", (String)"AbstractRPASettleSchemeList_1", (String)"fi-arapcommon", (Object[])new Object[0]));
            } else {
                DynamicObject[] rpaSchemes = BusinessDataServiceHelper.load((String)this.settleSchemeEntity(), (String)"orgentry.org", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)primaryKeys)});
                DynamicObjectCollection orgEntrys = rpaSchemes[0].getDynamicObjectCollection("orgentry");
                List orgIds = orgEntrys.stream().map(t -> t.getString("org.id")).collect(Collectors.toList());
                ListShowParameter listShowParameter = new ListShowParameter();
                HashMap customParams = new HashMap();
                customParams.put("orgIds", orgIds);
                listShowParameter.setCustomParams(customParams);
                listShowParameter.setBillFormId(this.settleLogEntity());
                listShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                long pk = (Long)selectedRows.get(0).getPrimaryKeyValue();
                listShowParameter.setCustomParam("schemePk", (Object)pk);
                this.getView().showForm((FormShowParameter)listShowParameter);
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        if ("settle".equals(args.getOperateKey()) && args.getOperationResult().isSuccess()) {
            BillList list = (BillList)this.getView().getControl("billlistap");
            ListSelectedRowCollection selectedRows = list.getSelectedRows();
            if (selectedRows != null) {
                Object[] pks = selectedRows.getPrimaryKeyValues();
                Map schemeMap = BusinessDataServiceHelper.loadFromCache((Object[])pks, (String)this.settleSchemeEntity());
                for (Map.Entry entry : schemeMap.entrySet()) {
                    DynamicObject scheme = (DynamicObject)entry.getValue();
                    if (scheme.getBoolean("enable")) continue;
                    return;
                }
            }
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u7ed3\u7b97\u65b9\u6848\u6267\u884c\u6210\u529f\u3002", (String)"AbstractRPASettleSchemeList_2", (String)"fi-arapcommon", (Object[])new Object[0]));
        }
    }

    protected abstract String settleSchemeEntity();

    protected abstract String settleLogEntity();

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        LicenseCheckResult result;
        super.beforeDoOperation(e);
        AbstractOperate op = (AbstractOperate)e.getSource();
        String operateKey = op.getOperateKey();
        if ("new".equals(operateKey) && !(result = LicenseServiceHelper.checkPerformGroup((String)groupNumber)).getHasLicense().booleanValue()) {
            this.getView().showMessage(result.getMsg());
            e.setCancel(true);
        }
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        LicenseCheckResult result = LicenseServiceHelper.checkPerformGroup((String)groupNumber);
        if (!result.getHasLicense().booleanValue()) {
            this.getView().showMessage(result.getMsg());
            e.getQFilters().add(new QFilter("1", "!=", (Object)"1"));
        }
    }

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        LicenseCheckResult result = LicenseServiceHelper.checkPerformGroup((String)groupNumber);
        if (!result.getHasLicense().booleanValue()) {
            e.setCancel(true);
            e.setCancelMessage(result.getMsg());
            e.setCancelFormShowParameter(result.getCancelFormShowParameter());
        }
    }
}

