/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.form;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityTypeUtil;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.FilterField;
import kd.bos.entity.property.DateProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.IFieldHandle;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Control;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.LargeTextEdit;
import kd.bos.form.plugin.AbstractFormPlugin;

public class AbstractSettleSchemeRulePlugin
extends AbstractFormPlugin {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btncancel", "btnok"});
    }

    public void afterCreateNewData(EventObject e) {
        String asstEntityKey;
        String mainEntityKey;
        String oper;
        super.afterCreateNewData(e);
        FormShowParameter showParam = this.getView().getFormShowParameter();
        Map customParams = showParam.getCustomParams();
        Object openMode = customParams.get("openMode");
        if ("view".equals(openMode)) {
            this.getModel().setValue("openMode", (Object)"view");
        }
        if ("modify".equals(oper = (String)customParams.get("oper"))) {
            IDataModel model = this.getModel();
            model.setValue("description", customParams.get("description"));
            model.setValue("settlerelation", customParams.get("settlerelation"));
            model.setValue("timeorder", customParams.get("timeorder"));
            model.setValue("mainbill", customParams.get("mainbill"));
            model.setValue("asstbill", customParams.get("asstbill"));
            String matchFieldInfo = (String)customParams.get("matchfieldinfo");
            if (matchFieldInfo != null && !"".equals(matchFieldInfo.trim())) {
                List fieldEntrys = (List)SerializationUtils.fromJsonString((String)matchFieldInfo, List.class);
                this.setEntryValue(fieldEntrys);
            }
            String mainFilterJson = (String)customParams.get("mainfilter_tag");
            model.setValue("mainfilter_tag", (Object)mainFilterJson);
            String asstFilterJson = (String)customParams.get("asstfilter_tag");
            model.setValue("asstfilter_tag", (Object)asstFilterJson);
            model.setValue("maindatesrc", customParams.get("maindatesrc"));
            model.setValue("asstdatesrc", customParams.get("asstdatesrc"));
        }
        if (!ObjectUtils.isEmpty((Object)(mainEntityKey = (String)this.getModel().getValue("mainbill")))) {
            this.initMainOrAsstBillEnable(mainEntityKey, "mainbill");
            this.initFieldColumn(mainEntityKey, "mainfield");
            this.initDateSrc(mainEntityKey, "maindatesrc");
        }
        if (!ObjectUtils.isEmpty((Object)(asstEntityKey = (String)this.getModel().getValue("asstbill")))) {
            this.initMainOrAsstBillEnable(asstEntityKey, "asstbill");
            this.initFieldColumn(asstEntityKey, "asstfield");
            this.initDateSrc(asstEntityKey, "asstdatesrc");
        }
    }

    protected void setEntryValue(List<Map<String, Object>> fieldEntrys) {
        for (Map<String, Object> map : fieldEntrys) {
            int index = this.getModel().createNewEntryRow("entryentity");
            for (Map.Entry<String, Object> entry : map.entrySet()) {
                this.getModel().setValue(entry.getKey(), entry.getValue(), index);
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if ("btnok".equals(key)) {
            if (this.verify()) {
                Map<String, Object> data = this.getData();
                this.getView().returnDataToParent(data);
                this.getView().close();
            }
        } else if ("btncancel".equals(key)) {
            this.getView().close();
        }
    }

    protected boolean verify() {
        String settleRelation = (String)this.getModel().getValue("settlerelation");
        if (settleRelation == null || settleRelation.trim().equals("")) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u7ed3\u7b97\u5173\u7cfb\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AbstractSettleSchemeRulePlugin_0", (String)"fi-arapcommon", (Object[])new Object[0]));
            return false;
        }
        DynamicObjectCollection entryEntitys = this.getModel().getEntryEntity("entryentity");
        for (DynamicObject entry : entryEntitys) {
            Object mainField = entry.get("mainfield");
            Object asstField = entry.get("asstfield");
            if (mainField != null && asstField != null && !"".equals(mainField) && !"".equals(asstField)) continue;
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e3b\u65b9\u5339\u914d\u5b57\u6bb5\u548c\u8f85\u65b9\u5339\u914d\u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AbstractSettleSchemeRulePlugin_1", (String)"fi-arapcommon", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    protected Map<String, Object> getData() {
        HashMap<String, Object> data = new HashMap<String, Object>(12);
        IDataModel model = this.getModel();
        String relation = (String)model.getValue("settlerelation");
        data.put("timeorder", model.getValue("timeorder"));
        data.put("settlerelation", relation);
        data.put("description", model.getValue("description"));
        DynamicObjectCollection entryEntitys = model.getEntryEntity("entryentity");
        if (entryEntitys != null && entryEntitys.size() > 0) {
            ArrayList<Map<String, Object>> ruleEntryList = new ArrayList<Map<String, Object>>(entryEntitys.size());
            for (DynamicObject entry : entryEntitys) {
                Map<String, Object> entryMap = this.getEntryMap(entry);
                ruleEntryList.add(entryMap);
            }
            String matchfieldinfo = SerializationUtils.toJsonString(ruleEntryList);
            data.put("matchfieldinfo", matchfieldinfo);
        } else {
            data.put("matchfieldinfo", null);
        }
        LargeTextEdit mainLargeTextEdit = (LargeTextEdit)this.getView().getControl("mainfilter");
        data.put("mainfilter_tag", model.getValue(mainLargeTextEdit.getTagFieldKey()));
        LargeTextEdit asstLargeTextEdit = (LargeTextEdit)this.getView().getControl("asstfilter");
        data.put("asstfilter_tag", model.getValue(asstLargeTextEdit.getTagFieldKey()));
        data.put("maindatesrc", model.getValue("maindatesrc"));
        data.put("asstdatesrc", model.getValue("asstdatesrc"));
        return data;
    }

    protected Map<String, Object> getEntryMap(DynamicObject entry) {
        HashMap<String, Object> entryMap = new HashMap<String, Object>(4);
        entryMap.put("mainfield", entry.get("mainfield"));
        entryMap.put("asstfield", entry.get("asstfield"));
        entryMap.put("matchrelation", entry.get("matchrelation"));
        entryMap.put("isnullmatch", entry.get("isnullmatch"));
        return entryMap;
    }

    protected void initDateSrc(String entityName, String dateSrc) {
        ComboEdit fields = (ComboEdit)this.getControl(dateSrc);
        ArrayList<ComboItem> items = new ArrayList<ComboItem>(64);
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entityName);
        Map allFields = entityType.getAllFields();
        allFields.forEach((key, value) -> {
            if (value instanceof DateProp || value instanceof DateTimeProp) {
                FilterField field = ((IFieldHandle)value).createFilterField(entityType, key);
                LocaleString caption = field.getCaption();
                String fullFieldName = field.getFullFieldName();
                ComboItem item = new ComboItem(caption, fullFieldName);
                items.add(item);
            }
        });
        fields.setComboItems(items);
        String dateSrcValue = (String)this.getModel().getValue(dateSrc);
        if (StringUtils.isEmpty((CharSequence)dateSrcValue) || !this.isExistForComboItems(dateSrcValue, items)) {
            this.getModel().setValue(dateSrc, (Object)"bizdate");
        }
    }

    protected boolean isExistForComboItems(String srcValue, List<ComboItem> items) {
        int length = items.size();
        for (int i = 0; i < length; ++i) {
            String value = items.get(i).getValue();
            if (!value.equals(srcValue)) continue;
            return true;
        }
        return false;
    }

    protected void initFieldColumn(String entityName, String controlName) {
        ComboEdit fields = (ComboEdit)this.getControl(controlName);
        ArrayList<ComboItem> items = new ArrayList<ComboItem>(64);
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entityName);
        EntityTypeUtil entityTypeUtil = new EntityTypeUtil();
        List filterFields = entityTypeUtil.getFilterFields((IDataEntityType)entityType);
        for (FilterField field : filterFields) {
            LocaleString caption = field.getCaption();
            String fullFieldName = field.getFullFieldName();
            ComboItem item = new ComboItem(caption, fullFieldName);
            items.add(item);
        }
        fields.setComboItems(items);
    }

    protected void initMainOrAsstBillEnable(String entityName, String billFieldTag) {
        if ("cas_paybill".equals(entityName) || "ap_paidbill".equals(entityName) || "cas_recbill".equals(entityName) || "ar_receivedbill".equals(entityName)) {
            this.getView().setEnable(Boolean.TRUE, new String[]{billFieldTag});
        } else {
            this.getView().setEnable(Boolean.FALSE, new String[]{billFieldTag});
        }
    }
}

