/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.form;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageTypes;
import kd.bos.form.ShowType;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.UploadEvent;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.impt.ExcelReader;
import kd.bos.impt.SheetHandler;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.arapcommon.util.EmptyUtils;

public class AllocEntryImport
extends AbstractFormPlugin
implements UploadListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btnresetfile", "download", "btn_upload"});
        Button fileLabel = (Button)this.getControl("btnupload");
        fileLabel.addUploadListener((UploadListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.getView().setVisible(Boolean.FALSE, new String[]{"filepanel"});
        this.getView().setEnable(Boolean.FALSE, new String[]{"btn_upload"});
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control contol = (Control)evt.getSource();
        String key = contol.getKey();
        int arg4 = -1;
        switch (key) {
            case "btn_upload": {
                arg4 = 2;
                break;
            }
            case "btnresetfile": {
                arg4 = 1;
                break;
            }
            case "download": {
                arg4 = 0;
            }
        }
        switch (arg4) {
            case 0: {
                FormShowParameter currShowParameter = this.getView().getFormShowParameter();
                Object billFormId = currShowParameter.getCustomParam("BillFormId");
                FormShowParameter showParameter = new FormShowParameter();
                showParameter.setFormId("bos_downloadtemplate");
                showParameter.getOpenStyle().setShowType(ShowType.Modal);
                showParameter.setCustomParam("BillFormId", billFormId);
                showParameter.setCustomParam("TemplateType", (Object)"IMPT");
                this.getView().showForm(showParameter);
                break;
            }
            case 1: {
                this.getModel().setValue("filename", (Object)"");
                this.getModel().setValue("filepath", (Object)"");
                this.getView().setVisible(Boolean.FALSE, new String[]{"filepanel"});
                this.getView().setVisible(Boolean.TRUE, new String[]{"uploadpanel"});
                this.getView().setEnable(Boolean.FALSE, new String[]{"btn_upload"});
                break;
            }
            case 2: {
                this.uploadData();
            }
        }
    }

    private void uploadData() {
        String rowDataString = this.getPageCache().get("rowDatas");
        List rowDatas = (List)SerializationUtils.fromJsonString((String)rowDataString, List.class);
        Object importMethod = this.getModel().getValue("imptmethod");
        HashMap<String, Object> returnData = new HashMap<String, Object>(10);
        returnData.put("imptmethod", importMethod);
        returnData.put("rowDatas", rowDatas);
        this.getView().returnDataToParent(returnData);
        this.getView().close();
    }

    public void upload(UploadEvent evt) {
        Object[] urls = evt.getUrls();
        String url = (String)urls[0];
        FileService service = FileServiceFactory.getAttachmentFileService();
        final ArrayList sourceDatas = new ArrayList(100);
        ArrayList<String> errorInfos = new ArrayList<String>(100);
        final HashMap columnDefineMap = new HashMap(16);
        InputStream inputStream = service.getInputStream(url);
        try {
            new ExcelReader().read(inputStream, new SheetHandler(){

                public void handleRow(SheetHandler.ParsedRow arg0) {
                    Map rowData;
                    String templateName;
                    int rowIndex = arg0.getRowNum();
                    if (rowIndex == 0 && !(templateName = arg0.get(Integer.valueOf(0))).contains("allocationentry")) {
                        return;
                    }
                    if (rowIndex == 2) {
                        rowData = arg0.getData();
                        Integer[] columnNums = rowData.keySet().toArray(new Integer[0]);
                        for (int i = 0; i < columnNums.length; ++i) {
                            String columnName = (String)rowData.get(columnNums[i]);
                            columnDefineMap.put(columnNums[i], columnName);
                        }
                    }
                    if (rowIndex > 3) {
                        rowData = arg0.getData();
                        HashMap rowDataMap = new HashMap(10);
                        Integer[] columnNums = rowData.keySet().toArray(new Integer[0]);
                        for (int i = 0; i < columnNums.length; ++i) {
                            Integer columnIndex = columnNums[i];
                            rowDataMap.put(columnDefineMap.get(columnIndex), rowData.get(columnIndex));
                        }
                        rowDataMap.put("rowIndex", rowIndex - 3);
                        sourceDatas.add(rowDataMap);
                    }
                }
            });
        }
        catch (Exception e) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u6587\u6863\u89e3\u6790\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"AllocEntryImport_0", (String)"fi-arapcommon", (Object[])new Object[0]), e.getMessage(), MessageTypes.Default);
            return;
        }
        if (EmptyUtils.isEmpty(sourceDatas)) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u672a\u89e3\u6790\u5230\u5408\u6cd5\u6570\u636e\u3002", (String)"AllocEntryImport_1", (String)"fi-arapcommon", (Object[])new Object[0]));
        }
        ArrayList<Map> enableSourceDatas = new ArrayList<Map>(100);
        for (Map rowData : sourceDatas) {
            String message = this.checkAndGetMessage(rowData);
            if (EmptyUtils.isEmpty(message)) {
                enableSourceDatas.add(rowData);
                continue;
            }
            String rowMessage = String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c%2$s", (String)"AllocEntryImport_6", (String)"fi-arapcommon", (Object[])new Object[0]), rowData.get("rowIndex"), message);
            errorInfos.add(rowMessage);
        }
        if (errorInfos.size() > 0) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u6587\u6863\u89e3\u6790\u6709\u8bef\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"AllocEntryImport_3", (String)"fi-arapcommon", (Object[])new Object[0]), ((Object)errorInfos).toString(), MessageTypes.Default);
        }
        String arg30 = SerializationUtils.toJsonString(enableSourceDatas);
        this.getPageCache().put("rowDatas", arg30);
        this.getView().setVisible(Boolean.TRUE, new String[]{"filepanel"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"uploadpanel"});
        this.getModel().setValue("filename", (Object)url.substring(url.lastIndexOf(47) + 1));
        this.getModel().setValue("filepath", (Object)url);
        this.getView().setEnable(Boolean.TRUE, new String[]{"btn_upload"});
        super.upload(evt);
    }

    private String checkAndGetMessage(Map<String, Object> rowData) {
        String expenseNumber = (String)rowData.get("expenseNumber");
        String costCenterNumber = (String)rowData.get("costCenterNumber");
        String message = this.checkAndGetExpenseMessage("er_expenseitemedit", expenseNumber, ResManager.loadKDString((String)"\u8d39\u7528\u9879\u76ee\u57fa\u7840\u8d44\u6599\u4e0d\u53ef\u7528\u3002", (String)"AllocEntryImport_4", (String)"fi-arapcommon", (Object[])new Object[0]));
        if (!EmptyUtils.isEmpty(message)) {
            return message;
        }
        return this.checkAndGettMessageByNumber("bos_costcenter", costCenterNumber, ResManager.loadKDString((String)"\u6210\u672c\u4e2d\u5fc3\u57fa\u7840\u8d44\u6599\u4e0d\u53ef\u7528\u3002", (String)"AllocEntryImport_5", (String)"fi-arapcommon", (Object[])new Object[0]));
    }

    private String checkAndGettMessageByNumber(String entityName, String number, String errorMessage) {
        if (EmptyUtils.isEmpty(number)) {
            return "";
        }
        Optional<DynamicObject> dataOptional = this.getDynamicObjectByNumber(entityName, number);
        if (dataOptional.isPresent()) {
            return "";
        }
        return errorMessage;
    }

    private Optional<DynamicObject> getDynamicObjectByNumber(String entityName, String number) {
        QFilter[] filters = new QFilter[]{new QFilter("number", "=", (Object)number), new QFilter("enable", "=", (Object)Boolean.TRUE)};
        DynamicObject result = BusinessDataServiceHelper.loadSingleFromCache((String)entityName, (String)"id,number", (QFilter[])filters);
        return Optional.ofNullable(result);
    }

    private String checkAndGetExpenseMessage(String entityName, String number, String errorMessage) {
        DynamicObject[] result;
        if (EmptyUtils.isEmpty(number)) {
            return "";
        }
        QFilter[] itemFilters = new QFilter[]{new QFilter("number", "=", (Object)number), new QFilter("enable", "=", (Object)Boolean.TRUE), new QFilter("isleaf", "=", (Object)Boolean.TRUE)};
        DynamicObject itemResult = BusinessDataServiceHelper.loadSingleFromCache((String)entityName, (String)"id,number", (QFilter[])itemFilters);
        if (EmptyUtils.isEmpty(itemResult)) {
            return errorMessage;
        }
        long expenseItemId = itemResult.getLong("id");
        String entityId = EmptyUtils.isEmpty(this.getView().getParentView().getEntityId()) ? "" : this.getView().getParentView().getEntityId();
        QFilter[] filters = new QFilter[]{new QFilter("expenseitem", "=", (Object)expenseItemId), new QFilter("enable", "=", (Object)Boolean.TRUE)};
        for (DynamicObject entity : result = BusinessDataServiceHelper.load((String)"er_expenseitembill", (String)"expenseitem, billtype", (QFilter[])filters)) {
            DynamicObject billType = entity.getDynamicObject("billtype");
            String billEntityId = billType.getString("number");
            if (!entityId.equals(billEntityId)) continue;
            return "";
        }
        return errorMessage;
    }
}

