/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.form;

import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dlock.DLock;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.cache.AppCache;
import kd.bos.entity.cache.CacheKeyUtil;
import kd.bos.entity.cache.IAppCache;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.arapcommon.service.concurrency.AppCacheLockParam;
import kd.fi.arapcommon.service.concurrency.ConcurrencyCtrlUtil;
import kd.fi.arapcommon.util.StringUtils;

public class AppCacheLockFormPlugin
extends AbstractFormPlugin {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbarap"});
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String itemKey = evt.getItemKey();
        if ("query".equals(itemKey)) {
            this.query();
        } else if ("clear".equals(itemKey)) {
            this.clear();
            this.query();
        }
    }

    private void query() {
        this.getModel().deleteEntryData("entry");
        this.getModel().setValue("description", (Object)"");
        String biz = (String)this.getModel().getValue("biz");
        if (StringUtils.isEmpty(biz)) {
            this.getModel().setValue("description", (Object)"biz is null");
            return;
        }
        IAppCache cache = AppCache.get((String)"ap");
        Map<String, List<AppCacheLockParam>> lockMap = ConcurrencyCtrlUtil.getCacheLockMapByBiz(cache, biz);
        if (lockMap == null || lockMap.isEmpty()) {
            this.getModel().setValue("description", (Object)"biz no lock bils");
            return;
        }
        this.filterLockData(cache, lockMap);
        StringBuilder description = new StringBuilder();
        TableValueSetter setter = new TableValueSetter(new String[]{"billentity", "billid", "billno", "createtime", "traceid"});
        for (Map.Entry<String, List<AppCacheLockParam>> entry : lockMap.entrySet()) {
            String billEntity = entry.getKey();
            List<AppCacheLockParam> billLockList = entry.getValue();
            description.append(billEntity).append(':').append(billLockList.size()).append(';');
            if (billLockList.size() > 50000) {
                billLockList = billLockList.subList(0, 50000);
            }
            HashMap<Long, String> idBillNoMap = new HashMap<Long, String>(billLockList.size());
            MainEntityType dt = MetadataServiceHelper.getDataEntityType((String)billEntity);
            if (dt != null && dt.getProperty("billno") != null) {
                Set billIdSet = billLockList.stream().map(AppCacheLockParam::getId).collect(Collectors.toSet());
                DataSet rows = QueryServiceHelper.queryDataSet((String)"querybillno", (String)billEntity, (String)"id,billno", (QFilter[])new QFilter[]{new QFilter("id", "in", billIdSet)}, (String)"");
                for (Row row : rows) {
                    idBillNoMap.put(row.getLong("id"), row.getString("billno"));
                }
            }
            for (AppCacheLockParam param : billLockList) {
                Object[] row = new Object[]{billEntity, param.getId(), idBillNoMap.get(param.getId()), param.getLockTime(), param.getTraceId()};
                setter.addRow(row);
            }
        }
        this.getModel().setValue("description", (Object)description.toString());
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.beginInit();
        model.batchCreateNewEntryRow("entry", setter);
        model.endInit();
        this.getView().updateView("entry");
    }

    private void filterLockData(IAppCache cache, Map<String, List<AppCacheLockParam>> lockMap) {
        Date date;
        Date beginTime;
        String traceid;
        List billLockList;
        String billno;
        String billId = (String)this.getModel().getValue("idfilter");
        if (!StringUtils.isEmpty(billId)) {
            long id = Long.parseLong(billId);
            for (Map.Entry<String, List<AppCacheLockParam>> entry : lockMap.entrySet()) {
                List<AppCacheLockParam> list = entry.getValue();
                if (list == null) continue;
                list.removeIf(billLockParam -> id != billLockParam.getId());
            }
        }
        if (!StringUtils.isEmpty(billno = (String)this.getModel().getValue("billnofilter"))) {
            for (Map.Entry<String, List<AppCacheLockParam>> entry : lockMap.entrySet()) {
                String string = entry.getKey();
                List list = QueryServiceHelper.queryPrimaryKeys((String)string, (QFilter[])new QFilter[]{new QFilter("billno", "like", (Object)(billno + "%"))}, (String)"", (int)-1);
                if (ObjectUtils.isEmpty((Object)list) || (billLockList = (List)entry.getValue()) == null) continue;
                billLockList.removeIf(billLockParam -> !ids.contains(billLockParam.getId()));
            }
        }
        if (StringUtils.isNotEmpty(traceid = (String)this.getModel().getValue("traceidfilter"))) {
            for (Map.Entry entry : lockMap.entrySet()) {
                List list = (List)entry.getValue();
                if (list == null) continue;
                list.removeIf(billLockParam -> !traceid.equals(billLockParam.getTraceId()));
            }
        }
        if ((beginTime = (Date)this.getModel().getValue("begintime")) != null) {
            for (Map.Entry<String, List<AppCacheLockParam>> entry : lockMap.entrySet()) {
                billLockList = entry.getValue();
                if (billLockList == null) continue;
                billLockList.removeIf(billLockParam -> billLockParam.getLockTime().before(beginTime));
            }
        }
        if ((date = (Date)this.getModel().getValue("endtime")) != null) {
            for (Map.Entry<String, List<AppCacheLockParam>> entry : lockMap.entrySet()) {
                List<AppCacheLockParam> billLockList3 = entry.getValue();
                if (billLockList3 == null) continue;
                billLockList3.removeIf(billLockParam -> billLockParam.getLockTime().after(endTime));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clear() {
        String biz = (String)this.getModel().getValue("biz");
        if (StringUtils.isEmpty(biz)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e1a\u52a1\u3002", (String)"AppCacheLockFormPlugin_0", (String)"fi-arapcommon", (Object[])new Object[0]));
            return;
        }
        EntryGrid mainGrid = (EntryGrid)this.getControl("entry");
        int[] selectRows = mainGrid.getSelectRows();
        IAppCache cache = AppCache.get((String)"ap");
        if (selectRows.length == 0) {
            cache.remove(biz);
        } else {
            HashMap<String, HashSet<Long>> billIdMap = new HashMap<String, HashSet<Long>>(2);
            for (int i = 0; i < selectRows.length; ++i) {
                DynamicObject row = this.getModel().getEntryRowEntity("entry", selectRows[i]);
                String billEntity = row.getString("billentity.number");
                long billId = row.getLong("billid");
                HashSet<Long> billIdSet = (HashSet<Long>)billIdMap.get(billEntity);
                if (billIdSet == null) {
                    billIdSet = new HashSet<Long>(8);
                    billIdSet.add(billId);
                } else {
                    billIdSet.add(billId);
                }
                billIdMap.put(billEntity, billIdSet);
            }
            String dLockKey = "arap-lockctrl-" + CacheKeyUtil.getAcctId();
            DLock lock = DLock.createReentrant((String)(dLockKey + "-" + biz));
            lock.fastMode();
            lock.lock();
            try {
                Map<String, List<AppCacheLockParam>> lockMap = ConcurrencyCtrlUtil.getCacheLockMapByBiz(cache, biz);
                if (lockMap != null && lockMap.size() > 0) {
                    for (Map.Entry entry : billIdMap.entrySet()) {
                        String billEntity = (String)entry.getKey();
                        Set billIds = (Set)entry.getValue();
                        List<AppCacheLockParam> billLockParamList = lockMap.get(billEntity);
                        if (billLockParamList == null) continue;
                        billLockParamList.removeIf(billLockParam -> billIds.contains(billLockParam.getId()));
                        lockMap.put(billEntity, billLockParamList);
                        cache.put(biz, (Object)SerializationUtils.toJsonString(lockMap), 86400);
                    }
                }
            }
            finally {
                lock.unlock();
            }
        }
        this.getView().showTipNotification("clear success");
    }
}

