/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.form;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.entity.list.column.DynamicTextColumnDesc;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.list.BillList;
import kd.bos.list.DynamicTextListColumn;
import kd.bos.list.IListColumn;
import kd.bos.list.ListColumn;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.workflow.WorkflowServiceHelper;
import kd.bos.workflow.api.BizProcessStatus;
import kd.fi.arapcommon.helper.BizExtendHelper;
import kd.fi.arapcommon.util.StringUtils;

public class ApproverSettingList
extends AbstractListPlugin {
    private static Log log = LogFactory.getLog(ApproverSettingList.class);
    private Map<String, String> auditorsNameMap = new HashMap<String, String>();

    public void beforeCreateListColumns(BeforeCreateListColumnsArgs args) {
        super.beforeCreateListColumns(args);
        this.getModel();
        DynamicTextListColumn col = new DynamicTextListColumn();
        String caption = ResManager.loadKDString((String)"\u5f53\u524d\u5904\u7406\u4eba", (String)"ApproverSettingList_0", (String)"fi-arapcommon", (Object[])new Object[0]);
        String captionExt = BizExtendHelper.showApproverCaptionExt();
        caption = ObjectUtils.isEmpty((Object)captionExt) ? caption : captionExt;
        col.setCaption(new LocaleString(caption));
        col.setKey("approver");
        col.setFieldName("approver");
        col.setSeq(2);
        args.getDynamicTextListColumns().add(col);
        int insertIndex = 0;
        List listColumns = args.getListColumns();
        for (int i = 0; i < listColumns.size(); ++i) {
            String key;
            IListColumn column = (IListColumn)listColumns.get(i);
            if (!(column instanceof ListColumn) || !"creator.name".equals(key = ((ListColumn)column).getFieldKey())) continue;
            insertIndex = i;
            break;
        }
        listColumns.add(insertIndex, col);
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        super.beforeCreateListDataProvider(args);
        QFilter qFilter = new QFilter("entrabill", "=", (Object)((BillList)args.getSource()).getBillFormId());
        qFilter = qFilter.and("enable", "=", (Object)"enable");
        if (QueryServiceHelper.exists((String)"wf_processdefinition", (QFilter[])new QFilter[]{qFilter})) {
            args.setListDataProvider((IListDataProvider)new ListDataProvider(){

                public DynamicObjectCollection getData(int arg0, int arg1) {
                    long t1 = System.currentTimeMillis();
                    DynamicObjectCollection collection = super.getData(arg0, arg1);
                    ArrayList pkId = new ArrayList();
                    collection.forEach(v -> pkId.add(String.valueOf(v.getPkValue())));
                    if (pkId.size() > 0) {
                        try {
                            ApproverSettingList.this.setNextAuditor(collection, pkId);
                        }
                        catch (Exception e) {
                            log.info("ApproverSettingList >>>>> \u8bbe\u7f6e\u5ba1\u6279\u4eba\u65f6\u51fa\u73b0\u5f02\u5e38");
                        }
                    }
                    long t2 = System.currentTimeMillis();
                    log.info("\u5ba1\u6838\u4eba\u6570\u636e\u52a0\u8f7dB \u7528\u65f6\uff1a " + (t2 - t1) + "ms");
                    return collection;
                }

                protected boolean isOnlyPK4SelectedAllRows() {
                    ListShowParameter listShowParameter = (ListShowParameter)ApproverSettingList.this.getView().getFormShowParameter();
                    return !listShowParameter.isLookUp();
                }
            });
        }
    }

    private void setNextAuditor(DynamicObjectCollection collection, List<String> pkId) {
        this.auditorsNameMap = this.getNextAuditor(pkId);
    }

    private Map<String, String> getNextAuditor(List<String> pkIds) {
        HashMap<String, String> nodeMap = new HashMap<String, String>(8);
        String[] ids = new String[pkIds.size()];
        pkIds.toArray(ids);
        Map allPro = WorkflowServiceHelper.getBizProcessStatus((String[])ids);
        for (Map.Entry entry : allPro.entrySet()) {
            List node = (List)entry.getValue();
            int count = 0;
            String nodeName = "";
            StringBuilder participantName = new StringBuilder();
            StringBuilder msg = new StringBuilder();
            try {
                for (BizProcessStatus e : node) {
                    nodeName = e.getCurrentNodeName();
                    String auditor = e.getParticipantName();
                    e.getProcessStatus();
                    if (auditor == null || "".equals(auditor.trim())) continue;
                    participantName.append(',');
                    participantName.append(auditor);
                    if (++count != 3) continue;
                    participantName.append("...");
                    break;
                }
                if (!StringUtils.isEmpty(nodeName)) {
                    msg.append(nodeName);
                    if (!ObjectUtils.isEmpty((Object)participantName)) {
                        msg.append('/');
                        msg.append(participantName.toString().replaceFirst(",", ""));
                    }
                }
            }
            catch (Exception e) {
                log.info("ErWorkFlowFlexListForOtherPlugin>>>\u83b7\u53d6\u5ba1\u6279\u4eba\u51fa\u73b0\u5f02\u5e38: " + e.getMessage());
            }
            nodeMap.put((String)entry.getKey(), msg.toString());
        }
        Map<String, String> nodeExtMap = BizExtendHelper.showApproverExt(pkIds);
        if (nodeExtMap.size() == 0) {
            return nodeMap;
        }
        nodeMap.putAll(nodeExtMap);
        return nodeMap;
    }

    public void packageData(PackageDataEvent e) {
        String key;
        super.packageData(e);
        Object source = e.getSource();
        if (source instanceof DynamicTextColumnDesc && "approver".equals(key = ((DynamicTextColumnDesc)source).getKey())) {
            DynamicObject rowData = e.getRowData();
            Object pk = rowData.get("id");
            e.setFormatValue((Object)this.auditorsNameMap.get(String.valueOf(pk)));
        }
    }
}

