/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.form;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.property.BooleanProp;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.fi.arapcommon.util.AllocationUtils;
import kd.fi.arapcommon.util.EmptyUtils;

public class ArApBaseAllocationPlugin
extends AbstractBillPlugIn {
    private static final String IMPORT_EXPENSE_ITEM_NUMBER = "a_expenseitem.number";
    private static final String IMPORT_COSTCENTER_NUMBER = "a_costcenter.number";
    private static final String IMPORT_ALLOC_PER = "a_allocationper";
    private static final String IMPORT_ALLOC_AMT = "a_allocationamt";

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        String opKey = afterDoOperationEventArgs.getOperateKey();
        if ("allocentryimport".equals(opKey)) {
            String entityNumber = this.getView().getFormShowParameter().getFormConfig().getEntityTypeId();
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId("ap_allocentry_import");
            showParameter.setCustomParam("BillFormId", (Object)entityNumber);
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "allocentryimport"));
            this.getView().showForm(showParameter);
        }
        super.afterDoOperation(afterDoOperationEventArgs);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String opKey = closedCallBackEvent.getActionId();
        if (!"allocentryimport".equals(opKey)) {
            return;
        }
        if (EmptyUtils.isEmpty(closedCallBackEvent.getReturnData())) {
            return;
        }
        Map returnData = (Map)closedCallBackEvent.getReturnData();
        List importDatas = (List)returnData.get("rowDatas");
        boolean allocateByPer = this.isAllocationByPercent();
        boolean isInTax = this.isInTax();
        BigDecimal headAmount = isInTax ? (BigDecimal)this.getModel().getValue("pricetaxtotal") : (BigDecimal)this.getModel().getValue("amount");
        EntityType allocEntryMeta = (EntityType)this.getModel().getDataEntityType().getAllEntities().get("allocationentry");
        for (Map newRow : importDatas) {
            String[] columns;
            for (String column : columns = newRow.keySet().toArray(new String[0])) {
                DynamicProperty property;
                if ("a_expenseitem.number;a_expenseitem.name;a_costcenter.number;a_costcenter.name;a_allocationper;a_allocationamt;rowIndex;".indexOf(column) >= 0) continue;
                String propertyName = column;
                if (column.indexOf(46) > 0) {
                    if (!column.endsWith(".number")) continue;
                    propertyName = column.substring(0, column.indexOf(46));
                }
                if ((property = allocEntryMeta.getProperty(propertyName)) != null) continue;
                throw new KDBizException(ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u7684\u5b57\u6bb5\uff1a%s\u3002", (String)"ArApBaseAllocationPlugin_0", (String)"fi-arapcommon", (Object[])new Object[]{propertyName}));
            }
        }
        for (Map newRow : importDatas) {
            String[] columns;
            this.getModel().setValue("allocatebyper", (Object)allocateByPer);
            int rowIndex = this.getModel().createNewEntryRow("allocationentry");
            this.getModel().setEntryCurrentRowIndex("allocationentry", rowIndex);
            if (!EmptyUtils.isEmpty(newRow.get(IMPORT_EXPENSE_ITEM_NUMBER))) {
                this.getModel().setItemValueByNumber("a_expenseitem", newRow.get(IMPORT_EXPENSE_ITEM_NUMBER).toString(), rowIndex);
            }
            if (!EmptyUtils.isEmpty(newRow.get(IMPORT_COSTCENTER_NUMBER))) {
                this.getModel().setItemValueByNumber("a_costcenter", newRow.get(IMPORT_COSTCENTER_NUMBER).toString(), rowIndex);
            }
            if (allocateByPer) {
                if (EmptyUtils.isEmpty(newRow.get(IMPORT_ALLOC_PER))) {
                    this.getModel().setValue("allocatebyper", (Object)Boolean.FALSE);
                    if (!EmptyUtils.isEmpty(newRow.get(IMPORT_ALLOC_AMT))) {
                        this.getModel().setValue(IMPORT_ALLOC_AMT, newRow.get(IMPORT_ALLOC_AMT), rowIndex);
                    }
                    this.calculateByAllocationAmt(headAmount, true);
                } else {
                    if (!EmptyUtils.isEmpty(newRow.get(IMPORT_ALLOC_PER))) {
                        this.getModel().setValue(IMPORT_ALLOC_PER, newRow.get(IMPORT_ALLOC_PER), rowIndex);
                    }
                    this.calculateByAllocationPercent(headAmount, true);
                }
            } else if (EmptyUtils.isEmpty(newRow.get(IMPORT_ALLOC_AMT))) {
                this.getModel().setValue("allocatebyper", (Object)Boolean.TRUE);
                if (!EmptyUtils.isEmpty(newRow.get(IMPORT_ALLOC_PER))) {
                    this.getModel().setValue(IMPORT_ALLOC_PER, newRow.get(IMPORT_ALLOC_PER), rowIndex);
                }
                this.calculateByAllocationPercent(headAmount, true);
            } else {
                if (!EmptyUtils.isEmpty(newRow.get(IMPORT_ALLOC_AMT))) {
                    this.getModel().setValue(IMPORT_ALLOC_AMT, newRow.get(IMPORT_ALLOC_AMT), rowIndex);
                }
                this.calculateByAllocationAmt(headAmount, true);
            }
            for (String column : columns = newRow.keySet().toArray(new String[0])) {
                if ("a_expenseitem.number;a_expenseitem.name;a_costcenter.number;a_costcenter.name;a_allocationper;a_allocationamt;rowIndex;".indexOf(column) >= 0) continue;
                String propertyName = column;
                if (column.indexOf(46) > 0) {
                    if (!column.endsWith(".number")) continue;
                    propertyName = column.substring(0, column.indexOf(46));
                }
                DynamicProperty property = allocEntryMeta.getProperty(propertyName);
                if (column.indexOf(46) > 0) {
                    this.getModel().setItemValueByNumber(propertyName, newRow.get(column).toString(), rowIndex);
                    continue;
                }
                if (property instanceof BooleanProp) {
                    Object value = newRow.get(column);
                    if (ResManager.loadKDString((String)"\u662f", (String)"ArApBaseAllocationPlugin_1", (String)"fi-arapcommon", (Object[])new Object[0]).equals(value)) {
                        value = Boolean.TRUE;
                        this.getModel().setValue(propertyName, value, rowIndex);
                        continue;
                    }
                    if (!ResManager.loadKDString((String)"\u5426", (String)"ArApBaseAllocationPlugin_2", (String)"fi-arapcommon", (Object[])new Object[0]).equals(value)) continue;
                    value = Boolean.FALSE;
                    this.getModel().setValue(propertyName, value, rowIndex);
                    continue;
                }
                this.getModel().setValue(propertyName, newRow.get(column), rowIndex);
            }
        }
        this.getModel().setValue("allocatebyper", (Object)allocateByPer);
    }

    protected void calculateAllocationDetail() {
        IDataModel model = this.getModel();
        boolean expenseAlloc = (Boolean)model.getValue("isexpensealloc");
        if (!expenseAlloc) {
            return;
        }
        boolean wholeAlloc = (Boolean)model.getValue("iswholealloc");
        if (wholeAlloc) {
            this.calculateWholeAllocation();
            return;
        }
        String entityName = this.getModel().getDataEntityType().getName();
        String detailEntryName = AllocationUtils.getBillDetailPropertyName(entityName);
        int rowCount = this.getModel().getEntryRowCount(detailEntryName);
        for (int i = 0; i < rowCount; ++i) {
            this.getModel().setEntryCurrentRowIndex(detailEntryName, i);
        }
    }

    protected void calculateWholeAllocation() {
        boolean allocateByPer = this.isAllocationByPercent();
        boolean isInTax = this.isInTax();
        BigDecimal headAmount = isInTax ? (BigDecimal)this.getModel().getValue("pricetaxtotal") : (BigDecimal)this.getModel().getValue("amount");
        int rowCount = this.getModel().getEntryRowCount("allocationentry");
        for (int i = 0; i < rowCount; ++i) {
            this.getModel().setEntryCurrentRowIndex("allocationentry", i);
            if (allocateByPer) {
                this.calculateByAllocationPercent(headAmount, true);
                continue;
            }
            this.calculateByAllocationAmt(headAmount, true);
        }
    }

    protected void calculateDetailAllocation() {
        boolean allocateByPer = this.isAllocationByPercent();
        BigDecimal detailAmt = this.getDetailRowAmt();
        if (allocateByPer) {
            this.calculateByAllocationPercent(detailAmt, false);
            return;
        }
        this.calculateByAllocationAmt(detailAmt, false);
    }

    protected BigDecimal getRemainPercentAmt() {
        boolean wholeAlloc = (Boolean)this.getModel().getValue("iswholealloc");
        if (wholeAlloc) {
            return this.getRemainPercentAmt("allocationentry", IMPORT_ALLOC_PER);
        }
        return this.getRemainPercentAmt("detailallocentry", "a_detailallocationper");
    }

    protected BigDecimal getRemainPercentAmt(String entryName, String propertyName) {
        int rowCount = this.getModel().getEntryRowCount(entryName);
        BigDecimal totalPercent = BigDecimal.ZERO;
        for (int i = 0; i < rowCount; ++i) {
            BigDecimal rowPercent = (BigDecimal)this.getModel().getValue(propertyName, i);
            totalPercent = totalPercent.add(rowPercent);
        }
        return BigDecimal.valueOf(100L).subtract(totalPercent);
    }

    protected void calculateDefaultRow() {
        IDataModel model = this.getModel();
        boolean expenseAlloc = (Boolean)model.getValue("isexpensealloc");
        if (!expenseAlloc) {
            return;
        }
        boolean wholeAlloc = (Boolean)model.getValue("iswholealloc");
        BigDecimal amount = (BigDecimal)this.getModel().getValue("amount");
        if (wholeAlloc) {
            this.calculateDefaultRow(amount, wholeAlloc);
            return;
        }
        String entityName = this.getModel().getDataEntityType().getName();
        String detailEntryName = AllocationUtils.getBillDetailPropertyName(entityName);
        int detailRowCount = this.getModel().getEntryRowCount(detailEntryName);
        for (int i = 0; i < detailRowCount; ++i) {
            this.getModel().setEntryCurrentRowIndex(detailEntryName, i);
            amount = (BigDecimal)this.getModel().getValue("e_amount", i);
            this.calculateDefaultRow(amount, wholeAlloc);
        }
    }

    private void calculateDefaultRow(BigDecimal amount, boolean wholeAlloc) {
        Map<String, String> allocProperties = AllocationUtils.getAllocProperties(wholeAlloc);
        String entryName = allocProperties.get("entry");
        int rowCount = this.getModel().getEntryRowCount(entryName);
        if (rowCount == 1) {
            this.getModel().deleteEntryRow(entryName, 0);
        }
        this.getModel().insertEntryRow(entryName, 0);
        String allocPer = allocProperties.get("percent");
        String allocAmt = allocProperties.get("amount");
        String localAmt = allocProperties.get("localAmt");
        BigDecimal headAmt = EmptyUtils.isEmpty(amount) ? BigDecimal.ZERO : amount;
        BigDecimal exchangerate = (BigDecimal)this.getModel().getValue("exchangerate");
        this.getModel().setValue(allocPer, (Object)BigDecimal.valueOf(100L), 0);
        this.getModel().setValue(allocAmt, (Object)headAmt, 0);
        String quotation = (String)this.getModel().getValue("quotation");
        BigDecimal locAmt = "1".equals(quotation) ? headAmt.divide(exchangerate, this.getBaseCurrencyPrecision(), RoundingMode.HALF_UP) : headAmt.multiply(exchangerate).setScale(this.getBaseCurrencyPrecision(), RoundingMode.HALF_UP);
        this.getModel().setValue(localAmt, (Object)locAmt, 0);
        this.getModel().updateCache();
    }

    protected boolean isAllocationByPercent() {
        String entityName = this.getModel().getDataEntityType().getName();
        boolean wholeAlloc = (Boolean)this.getModel().getValue("iswholealloc");
        if (!"ap_finapbill".equals(entityName)) {
            return true;
        }
        if (wholeAlloc) {
            return (Boolean)this.getModel().getValue("allocatebyper");
        }
        return (Boolean)this.getModel().getValue("detailallocatebyper");
    }

    protected boolean isInTax() {
        String entityName = this.getModel().getDataEntityType().getName();
        if (!"ap_finapbill".equals(entityName)) {
            return false;
        }
        return (Boolean)this.getModel().getValue("isintax");
    }

    protected void calculateByAllocationPercent(BigDecimal amount, boolean wholeAlloc) {
        Map<String, String> allocProperties = AllocationUtils.getAllocProperties(wholeAlloc);
        String entryName = allocProperties.get("entry");
        String allocPerName = allocProperties.get("percent");
        String allocAmtName = allocProperties.get("amount");
        int currentIndex = this.getModel().getEntryCurrentRowIndex(entryName);
        BigDecimal rowAllocAmt = this.calculateEntryRowAllocAmt(amount, allocPerName, currentIndex);
        this.getModel().setValue(allocAmtName, (Object)rowAllocAmt, currentIndex);
    }

    protected void calculateByAllocationPercent(BigDecimal amount, boolean wholeAlloc, int index) {
        Map<String, String> allocProperties = AllocationUtils.getAllocProperties(wholeAlloc);
        String allocPerName = allocProperties.get("percent");
        String allocAmtName = allocProperties.get("amount");
        BigDecimal rowAllocAmt = this.calculateEntryRowAllocAmt(amount, allocPerName, index);
        this.getModel().setValue(allocAmtName, (Object)rowAllocAmt, index);
    }

    protected void calculateByAllocationAmt(BigDecimal amount, boolean wholeAlloc) {
        BigDecimal currentRowAllocAmt;
        Map<String, String> allocProperties = AllocationUtils.getAllocProperties(wholeAlloc);
        String entryName = allocProperties.get("entry");
        String allocPerName = allocProperties.get("percent");
        String allocAmtName = allocProperties.get("amount");
        int currentIndex = this.getModel().getEntryCurrentRowIndex(entryName);
        if (BigDecimal.ZERO.compareTo(amount) == 0) {
            return;
        }
        BigDecimal rowAllocAmt = (BigDecimal)this.getModel().getValue(IMPORT_ALLOC_AMT, currentIndex);
        if (BigDecimal.ZERO.compareTo(rowAllocAmt) == 0) {
            this.getModel().setValue(IMPORT_ALLOC_AMT, (Object)amount, currentIndex);
        }
        if (BigDecimal.ZERO.compareTo((currentRowAllocAmt = (BigDecimal)this.getModel().getValue(IMPORT_ALLOC_AMT, currentIndex)).multiply(amount)) > 0) {
            this.getModel().setValue(IMPORT_ALLOC_AMT, (Object)currentRowAllocAmt.negate(), currentIndex);
        }
        BigDecimal rowAllocPer = this.calculateEntryRowAllocPer(amount, allocAmtName, currentIndex);
        this.getModel().setValue(allocPerName, (Object)rowAllocPer, currentIndex);
    }

    protected void calculateByAllocationAmt(BigDecimal amount, boolean wholeAlloc, int index) {
        BigDecimal currentRowAllocAmt;
        Map<String, String> allocProperties = AllocationUtils.getAllocProperties(wholeAlloc);
        String allocPerName = allocProperties.get("percent");
        String allocAmtName = allocProperties.get("amount");
        if (BigDecimal.ZERO.compareTo(amount) == 0) {
            return;
        }
        BigDecimal rowAllocAmt = (BigDecimal)this.getModel().getValue(IMPORT_ALLOC_AMT, index);
        if (BigDecimal.ZERO.compareTo(rowAllocAmt) == 0) {
            this.getModel().setValue(IMPORT_ALLOC_AMT, (Object)amount, index);
        }
        if (BigDecimal.ZERO.compareTo((currentRowAllocAmt = (BigDecimal)this.getModel().getValue(IMPORT_ALLOC_AMT, index)).multiply(amount)) > 0) {
            this.getModel().setValue(IMPORT_ALLOC_AMT, (Object)currentRowAllocAmt.negate(), index);
        }
        BigDecimal rowAllocPer = this.calculateEntryRowAllocPer(amount, allocAmtName, index);
        this.getModel().setValue(allocPerName, (Object)rowAllocPer, index);
    }

    private BigDecimal calculateEntryRowAllocPer(BigDecimal amount, String propertyName, int rowIndex) {
        BigDecimal rowAllocAmt = (BigDecimal)this.getModel().getValue(propertyName, rowIndex);
        return rowAllocAmt.divide(amount, 10, RoundingMode.HALF_UP).multiply(BigDecimal.valueOf(100L));
    }

    private BigDecimal calculateEntryRowAllocAmt(BigDecimal amount, String propertyName, int rowIndex) {
        BigDecimal rowAllocPer = (BigDecimal)this.getModel().getValue(propertyName, rowIndex);
        int precision = this.getHeadCurrencyPrecision();
        return amount.multiply(rowAllocPer.divide(BigDecimal.valueOf(100L), 10, RoundingMode.HALF_UP)).setScale(precision, RoundingMode.HALF_UP);
    }

    private BigDecimal calculateEntryRowLocalAmt(String propertyName, int rowIndex) {
        BigDecimal exchangerate = (BigDecimal)this.getModel().getValue("exchangerate");
        BigDecimal rowAllocAmt = (BigDecimal)this.getModel().getValue(propertyName, rowIndex);
        int precision = this.getBaseCurrencyPrecision();
        String quotation = (String)this.getModel().getValue("quotation");
        BigDecimal entryRowLocalAmt = "1".equals(quotation) ? rowAllocAmt.divide(exchangerate, precision, RoundingMode.HALF_UP) : rowAllocAmt.multiply(exchangerate).setScale(precision, RoundingMode.HALF_UP);
        return entryRowLocalAmt;
    }

    protected BigDecimal getDetailRowAmt() {
        String entityName = this.getModel().getDataEntityType().getName();
        String detailEntryName = AllocationUtils.getBillDetailPropertyName(entityName);
        int currentDetailRowIndex = this.getModel().getEntryCurrentRowIndex(detailEntryName);
        return (BigDecimal)this.getModel().getValue("e_amount", currentDetailRowIndex);
    }

    private int getBaseCurrencyPrecision() {
        DynamicObject baseCurrency = (DynamicObject)this.getModel().getValue("basecurrency");
        if (baseCurrency == null) {
            BigDecimal headAmount = (BigDecimal)this.getModel().getValue("amount");
            return headAmount.scale();
        }
        return baseCurrency.getInt("amtprecision");
    }

    private int getHeadCurrencyPrecision() {
        DynamicObject headCurrency = (DynamicObject)this.getModel().getValue("currency");
        if (headCurrency == null) {
            return this.getBaseCurrencyPrecision();
        }
        return headCurrency.getInt("amtprecision");
    }

    protected void calculateAllocationLocDetail() {
        IDataModel model = this.getModel();
        String entityName = model.getDataEntityType().getName();
        BigDecimal billHeadAmtLoc = "ap_finapbill".equals(entityName) ? (BigDecimal)model.getValue("amountbase") : (BigDecimal)model.getValue("localamt");
        BigDecimal billHeadPriceTaxLoc = (BigDecimal)model.getValue("pricetaxtotalbase");
        BigDecimal allocLocAmt = this.isInTax() ? billHeadPriceTaxLoc : billHeadAmtLoc;
        DynamicObject bill = model.getDataEntity(true);
        BigDecimal exchangeRate = bill.getBigDecimal("exchangerate");
        boolean expenseAlloc = bill.getBoolean("isexpensealloc");
        if (expenseAlloc) {
            int i;
            DynamicObjectCollection allocationEntryColl = bill.getDynamicObjectCollection("allocationentry");
            int baseCurrencyPrecision = AllocationUtils.getBaseCurrencyPrecision(bill);
            HashMap<Integer, Object> rowIndexAndLocAmtMap = new HashMap<Integer, Object>(allocationEntryColl.size());
            BigDecimal allRowPer = BigDecimal.ZERO;
            String quotation = (String)model.getValue("quotation");
            for (i = 0; i < allocationEntryColl.size(); ++i) {
                DynamicObject allocRow = (DynamicObject)allocationEntryColl.get(i);
                BigDecimal allocRowAmt = allocRow.getBigDecimal(IMPORT_ALLOC_AMT);
                Object allocRowLocalAmt = BigDecimal.ZERO;
                if ("1".equals(quotation)) {
                    if (exchangeRate == null || exchangeRate.compareTo(BigDecimal.ZERO) == 0) {
                        exchangeRate = BigDecimal.ONE;
                    }
                    allocRowLocalAmt = allocRowAmt.divide(exchangeRate, baseCurrencyPrecision, RoundingMode.HALF_UP);
                } else {
                    allocRowLocalAmt = allocRowAmt.multiply(exchangeRate).setScale(baseCurrencyPrecision, RoundingMode.HALF_UP);
                }
                BigDecimal bigDecimal = allocRow.getBigDecimal(IMPORT_ALLOC_PER);
                rowIndexAndLocAmtMap.put(i, allocRowLocalAmt);
                allRowPer = allRowPer.add(bigDecimal);
            }
            if (allRowPer.compareTo(new BigDecimal("100")) == 0) {
                for (i = allocationEntryColl.size() - 1; i >= 0; --i) {
                    BigDecimal localAmt = (BigDecimal)rowIndexAndLocAmtMap.get(i);
                    BigDecimal tempLocalAmt = BigDecimal.ZERO;
                    for (Map.Entry entry : rowIndexAndLocAmtMap.entrySet()) {
                        tempLocalAmt = tempLocalAmt.add((BigDecimal)entry.getValue());
                    }
                    BigDecimal localAmtDifference = allocLocAmt.subtract(tempLocalAmt);
                    BigDecimal bigDecimal = localAmt.add(localAmtDifference);
                    if (bigDecimal.multiply(allocLocAmt).signum() > 0) {
                        rowIndexAndLocAmtMap.put(i, bigDecimal.setScale(baseCurrencyPrecision, RoundingMode.HALF_UP));
                        break;
                    }
                    rowIndexAndLocAmtMap.put(i, BigDecimal.ZERO);
                }
            }
            for (i = 0; i < allocationEntryColl.size(); ++i) {
                BigDecimal rowLocAmt = (BigDecimal)rowIndexAndLocAmtMap.get(i);
                model.setValue("a_localamt", (Object)rowLocAmt, i);
            }
        }
    }
}

