/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.form;

import java.math.BigDecimal;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Objects;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.datamodel.IBillModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.Save;
import kd.bos.entity.operate.Submit;
import kd.bos.entity.operate.SubmitAndNew;
import kd.bos.entity.property.EntryProp;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.DateEdit;
import kd.bos.form.operate.formop.DeleteEntry;
import kd.fi.arapcommon.dev.BeanFactory;
import kd.fi.arapcommon.service.plan.FinPlanRowService;
import kd.fi.arapcommon.service.plan.PlanRow;
import kd.fi.arapcommon.util.DateUtils;
import kd.fi.arapcommon.util.EmptyUtils;

public class ArApBillPlanEdit
extends AbstractBillPlugIn {
    public void registerListener(EventObject e) {
        super.registerListener(e);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setPlanDuedateRange();
    }

    private void setPlanDuedateRange() {
        DateEdit plandutedate = (DateEdit)this.getView().getControl("planduedate");
        Date maxDate = (Date)this.getModel().getValue("duedate");
        if (maxDate != null) {
            plandutedate.setMaxDate(maxDate);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key = e.getProperty().getName();
        ChangeData[] changeData = e.getChangeSet();
        Object newValue = changeData[0].getNewValue();
        Object oldValue = changeData[0].getOldValue();
        int currentindex = changeData[0].getRowIndex();
        if (newValue == oldValue) {
            return;
        }
        switch (key) {
            case "planpricetax": {
                this.entryAmtChanged((BigDecimal)newValue, currentindex);
                break;
            }
            case "pricetaxtotal": 
            case "recamount": 
            case "paycond": 
            case "bizdate": {
                this.changedByCond();
                break;
            }
            case "duedate": {
                this.setPlanDuedateRange();
                if (newValue == null) {
                    this.getModel().setValue("duedate", this.getModel().getValue("bizdate"));
                    break;
                }
                this.duedateChanged((Date)newValue);
                break;
            }
            case "exchangerate": {
                this.exchangeRateChanged();
            }
        }
    }

    private void exchangeRateChanged() {
        this.calculateLocalAmount();
    }

    private void calculateLocalAmount() {
        IDataModel m = this.getModel();
        int count = m.getEntryRowCount("planentity");
        if (count == 1) {
            if ("ap_finapbill".equals(m.getDataEntityType().getName())) {
                m.setValue("planpricetax", m.getValue("pricetaxtotal"), 0);
                m.setValue("planpricetaxloc", m.getValue("pricetaxtotalbase"), 0);
                m.setValue("unplanlockamt", m.getValue("pricetaxtotal"), 0);
                m.setValue("unplansettleamt", m.getValue("pricetaxtotal"), 0);
                m.setValue("unplansettlelocamt", m.getValue("pricetaxtotalbase"), 0);
            } else {
                m.setValue("planpricetax", m.getValue("recamount"), 0);
                m.setValue("planpricetaxloc", m.getValue("reclocalamt"), 0);
                m.setValue("unplanlockamt", m.getValue("recamount"), 0);
                m.setValue("unplansettleamt", m.getValue("unsettleamount"), 0);
                m.setValue("unplansettlelocamt", m.getValue("unsettlelocalamt"), 0);
            }
        }
        BigDecimal exchangeRate = (BigDecimal)m.getValue("exchangerate");
        for (int rowIndex = count - 1; rowIndex >= 0; --rowIndex) {
            this.setEntryBase("planpricetax", "planpricetaxloc", rowIndex, exchangeRate);
            this.setEntryBase("unplansettleamt", "unplansettlelocamt", rowIndex, exchangeRate);
            this.setEntryBase("plansettledamt", "plansettledlocamt", rowIndex, exchangeRate);
        }
    }

    private void setEntryBase(String fieldName, String localFieldName, int rowIndex, BigDecimal exchangeRate) {
        IDataModel model = this.getModel();
        BigDecimal amount = (BigDecimal)model.getValue(fieldName, rowIndex);
        amount = amount == null ? BigDecimal.ZERO : amount;
        BigDecimal localAmount = amount.multiply(exchangeRate);
        model.setValue(localFieldName, (Object)localAmount, rowIndex);
    }

    private void changedByCond() {
        if (((Boolean)this.getModel().getValue("iswrittenoff")).booleanValue()) {
            return;
        }
        List<PlanRow> planRows = this.calculatePlanRow();
        int currentRowCount = this.getModel().getEntryRowCount("planentity");
        int diffRowCount = planRows.size() - currentRowCount;
        if (diffRowCount > 0) {
            this.getModel().batchCreateNewEntryRow("planentity", diffRowCount);
        } else if (diffRowCount < 0) {
            int[] deleteRowIndexs = new int[Math.abs(diffRowCount)];
            for (int i = 0; i < Math.abs(diffRowCount); ++i) {
                deleteRowIndexs[i] = currentRowCount - i - 1;
            }
            this.getModel().deleteEntryRows("planentity", deleteRowIndexs);
        }
        this.updateByPlanList(planRows);
    }

    private void updateByPlanList(List<PlanRow> planRows) {
        IDataModel model = this.getModel();
        Date planMaxDuedate = null;
        Object settlementType = model.getValue("settlementtype");
        if (settlementType instanceof DynamicObject) {
            DynamicObject obj = (DynamicObject)settlementType;
            settlementType = obj.getPkValue();
        }
        BigDecimal amt = BigDecimal.ZERO;
        int amtprecision = 2;
        DynamicObject currency = (DynamicObject)this.getModel().getValue("currency");
        if (!ObjectUtils.isEmpty((Object)currency)) {
            amtprecision = currency.getInt("amtprecision");
        }
        for (int i = 0; i < planRows.size(); ++i) {
            PlanRow planRow = planRows.get(i);
            Date palnDuedate = planRow.getDueDate();
            BigDecimal planAmt = planRow.getPlanAmt();
            amt = amt.add(planAmt.setScale(amtprecision, 4));
            if (i == planRows.size() - 1) {
                BigDecimal price;
                BigDecimal pricetaxtotal = (BigDecimal)this.getModel().getValue(this.getAmountKey());
                if (amt.compareTo(pricetaxtotal) > 0) {
                    price = amt.subtract(pricetaxtotal);
                    planAmt = planAmt.subtract(price);
                } else if (amt.compareTo(pricetaxtotal) < 0) {
                    price = pricetaxtotal.subtract(amt);
                    planAmt = planAmt.add(price);
                }
            }
            this.getModel().setValue("planpricetax", (Object)planAmt, i);
            this.getModel().setValue("unplanlockamt", (Object)planAmt, i);
            this.getModel().setValue("unplansettleamt", (Object)planAmt, i);
            this.getModel().setValue("planduedate", (Object)palnDuedate, i);
            if (EmptyUtils.isEmpty(this.getModel().getValue("plansettletype", i))) {
                this.getModel().setValue("plansettletype", settlementType, i);
            }
            if (planMaxDuedate == null) {
                planMaxDuedate = palnDuedate;
                continue;
            }
            if (palnDuedate == null) continue;
            planMaxDuedate = palnDuedate.after(planMaxDuedate) ? palnDuedate : planMaxDuedate;
        }
        if (planMaxDuedate != null) {
            model.setValue("duedate", planMaxDuedate);
        }
    }

    protected List<PlanRow> calculatePlanRow() {
        FinPlanRowService planRowService = BeanFactory.getBean(FinPlanRowService.class, new Object[0]);
        return planRowService.calculatePlanRows(this.getModel().getDataEntity());
    }

    private void entryAmtChanged(BigDecimal newValue, int currententry) {
        BigDecimal exchangeRate = (BigDecimal)this.getModel().getValue("exchangerate");
        BigDecimal localamount = null;
        localamount = newValue.multiply(exchangeRate);
        this.getModel().setValue("planpricetaxloc", (Object)localamount, currententry);
        this.getModel().setValue("unplansettlelocamt", (Object)localamount, currententry);
        this.getModel().setValue("unplansettleamt", (Object)newValue, currententry);
        this.getModel().setValue("unplanlockamt", (Object)newValue, currententry);
    }

    private String getAmountKey() {
        if (this.isAp()) {
            return "pricetaxtotal";
        }
        return "recamount";
    }

    private boolean isAp() {
        String entityName = this.getModel().getDataEntity().getDataEntityType().getName();
        return entityName.contains("ap_");
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        super.afterAddRow(e);
        EntryProp entryProp = e.getEntryProp();
        if ("planentity".equals(entryProp.getName())) {
            RowDataEntity[] rowDataEntities;
            for (RowDataEntity row : rowDataEntities = e.getRowDataEntities()) {
                this.createPlanRow(row.getRowIndex());
            }
        }
    }

    private void createPlanRow(int i) {
        Object settlementType;
        Date dutedate = (Date)this.getModel().getValue("duedate");
        Date bizdate = (Date)this.getModel().getValue("bizdate");
        if (this.getModel().getValue("planduedate", i) == null) {
            this.getModel().setValue("planduedate", (Object)dutedate, i);
        }
        if ((settlementType = this.getModel().getValue("settlementtype")) != null) {
            DynamicObject obj = (DynamicObject)settlementType;
            settlementType = obj.getPkValue();
        }
        this.getModel().setValue("plansettletype", settlementType, i);
        DateEdit plandutedate = (DateEdit)this.getView().getControl("planduedate");
        if (dutedate != null && bizdate != null) {
            plandutedate.setMaxDate(DateUtils.getDataFormat(dutedate, true));
        }
    }

    public void afterCopyData(EventObject e) {
        super.afterCopyData(e);
        IBillModel model = (IBillModel)this.getModel();
        BigDecimal exchangerate = (BigDecimal)model.getValue("exchangerate");
        int count = model.getEntryRowCount("planentity");
        for (int i = 0; i < count; ++i) {
            BigDecimal entryTotalPriceTax = (BigDecimal)model.getValue("planpricetax", i);
            model.setValue("unplansettlelocamt", (Object)entryTotalPriceTax.multiply(exchangerate), i);
            model.setValue("unplansettleamt", (Object)entryTotalPriceTax, i);
            model.setValue("unplanlockamt", (Object)entryTotalPriceTax, i);
            model.setValue("planduedate", (Object)new Date(), i);
        }
        this.duedateChanged((Date)this.getModel().getValue("bizdate"));
    }

    private void duedateChanged(Date duedate) {
        this.setPlanDuedateRange();
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        Object source = args.getSource();
        if (source instanceof Save || source instanceof Submit || source instanceof SubmitAndNew) {
            this.checkAmount(args);
        }
        if (source instanceof DeleteEntry && Objects.equals("deleteplanentry", ((DeleteEntry)source).getOperateKey())) {
            int planRowCount = this.getModel().getEntryRowCount("planentity");
            args.setCancel(planRowCount == 1);
        }
    }

    private void checkAmount(BeforeDoOperationEventArgs args) {
        BigDecimal sumpricetax = (BigDecimal)this.getModel().getValue(this.getAmountKey());
        int count = this.getModel().getEntryRowCount("planentity");
        BigDecimal pricetax = BigDecimal.ZERO;
        Object source = args.getSource();
        String operte = ResManager.loadKDString((String)"\u63d0\u4ea4", (String)"ArApBillPlanEdit_0", (String)"fi-arapcommon", (Object[])new Object[0]);
        if (source instanceof Save) {
            operte = ResManager.loadKDString((String)"\u4fdd\u5b58", (String)"ArApBillPlanEdit_1", (String)"fi-arapcommon", (Object[])new Object[0]);
        }
        for (int i = 0; i < count; ++i) {
            pricetax = pricetax.add((BigDecimal)this.getModel().getValue("planpricetax", i));
        }
        if (sumpricetax.compareTo(pricetax) != 0) {
            if ("ap_finapbill".equals(this.getModel().getDataEntityType().getName())) {
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u4ed8\u6b3e\u8ba1\u5212\u4e2d\u201c\u5e94\u4ed8\u91d1\u989d\u201d\u5408\u8ba1\u4e0e\u6574\u5355\u201c\u5e94\u4ed8\u91d1\u989d\u201d\u4e00\u81f4\u624d\u80fd%s\uff0c\u8bf7\u4fee\u6539\u540e\u91cd\u8bd5\u3002", (String)"ArApBillPlanEdit_2", (String)"fi-arapcommon", (Object[])new Object[0]), operte));
            } else {
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u6536\u6b3e\u8ba1\u5212\u4e2d\u201c\u5e94\u6536\u91d1\u989d\u201d\u5408\u8ba1\u4e0e\u6574\u5355\u201c\u5e94\u6536\u91d1\u989d\u201d\u4e00\u81f4\u624d\u80fd\u6267\u884c\u201c%s\u201d\u64cd\u4f5c\uff0c\u8bf7\u4fee\u6539\u540e\u91cd\u8bd5\u3002", (String)"ArApBillPlanEdit_3", (String)"fi-arapcommon", (Object[])new Object[0]), operte));
            }
            args.setCancel(true);
            return;
        }
        this.reCalcPlanAmt();
    }

    public void reCalcPlanAmt() {
        String billstatus = (String)this.getModel().getValue("billstatus");
        if (!"A".equals(billstatus)) {
            return;
        }
        int planentityRowCount = this.getModel().getEntryRowCount("planentity");
        if (planentityRowCount > 1) {
            BigDecimal headPricetax = (BigDecimal)this.getModel().getValue(this.getAmountKey());
            BigDecimal headPricetaxloc = (BigDecimal)this.getModel().getValue(this.getAmountLocKey());
            BigDecimal planPricetax = BigDecimal.ZERO;
            BigDecimal planPricetaxloc = BigDecimal.ZERO;
            int endRowNumber = planentityRowCount - 1;
            for (int i = 0; i < endRowNumber; ++i) {
                planPricetax = planPricetax.add((BigDecimal)this.getModel().getValue("planpricetax", i));
                planPricetaxloc = planPricetaxloc.add((BigDecimal)this.getModel().getValue("planpricetaxloc", i));
            }
            BigDecimal endRowPlanPricetax = headPricetax.subtract(planPricetax);
            BigDecimal endRowPlanPricetaxloc = headPricetaxloc.subtract(planPricetaxloc);
            this.getModel().setValue("planpricetax", (Object)endRowPlanPricetax, endRowNumber);
            this.getModel().setValue("planpricetaxloc", (Object)endRowPlanPricetaxloc, endRowNumber);
            this.getModel().setValue("unplanlockamt", (Object)endRowPlanPricetax, endRowNumber);
            this.getModel().setValue("unplansettleamt", (Object)endRowPlanPricetax, endRowNumber);
            this.getModel().setValue("unplansettlelocamt", (Object)endRowPlanPricetaxloc, endRowNumber);
        }
    }

    private String getAmountLocKey() {
        String Entityname = this.getModel().getDataEntity().getDataEntityType().getName();
        if (Entityname.contains("ar_")) {
            return "localamt";
        }
        return "amountbase";
    }
}

