/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.form;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.license.api.LicenseCheckResult;
import kd.bos.list.BillList;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.license.LicenseServiceHelper;
import kd.fi.arapcommon.util.DateUtils;
import kd.fi.arapcommon.util.EmptyUtils;
import kd.fi.arapcommon.util.StringUtils;

public abstract class BaseRPASettleLogList
extends AbstractListPlugin {
    private static final String groupNumber = "PRO_ISR";

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        List orgIds = (List)this.getView().getFormShowParameter().getCustomParam("orgIds");
        if (EmptyUtils.isEmpty(orgIds)) {
            return;
        }
        for (FilterColumn filterColumn : args.getFilterContainerInitEvent().getCommonFilterColumns()) {
            CommonFilterColumn commonFilter = (CommonFilterColumn)filterColumn;
            if (!commonFilter.getFieldName().equals("org.name")) continue;
            commonFilter.setDefaultValues(orgIds);
            break;
        }
    }

    public void filterContainerSearchClick(FilterContainerSearchClickArgs args) {
        super.filterContainerSearchClick(args);
        QFilter starttimeFilter = args.getQFilter("starttime");
        if (EmptyUtils.isNotEmpty(starttimeFilter)) {
            String starteTime = DateUtils.formatString((Date)starttimeFilter.getValue(), "yyyy-MM-dd HH:mm:ss");
            List dateNets = starttimeFilter.getNests(false);
            QFilter endTimeFilter = ((QFilter.QFilterNest)dateNets.get(0)).getFilter();
            String endTime = DateUtils.formatString((Date)endTimeFilter.getValue(), "yyyy-MM-dd HH:mm:ss");
            this.getPageCache().put("startTime", starteTime);
            this.getPageCache().put("endTime", endTime);
        } else {
            this.getPageCache().remove("startTime");
            this.getPageCache().remove("endTime");
        }
    }

    private void fillSettleProgress(List<QFilter> filters) {
        List orgIdsStr = this.getControlFilters().getFilter("org.id");
        if (EmptyUtils.isNotEmpty(orgIdsStr) && StringUtils.isNotEmpty(orgIdsStr.get(0).toString())) {
            ArrayList<Long> orgIds = new ArrayList<Long>(10);
            for (Object orgId : orgIdsStr) {
                orgIds.add(Long.parseLong(orgId.toString()));
            }
            filters.add(new QFilter("org.id", "in", orgIds));
        }
        DynamicObjectCollection settleLogs = QueryServiceHelper.query((String)this.rpaSttleEntityMap().get("rpaSttleLogEntity"), (String)"mainbillentity,asstbillentity,mainsettleamt,asstsettleamt,maincount,asstcount,settlerecordcount,mainexecutedcount,asstexecutedcount", (QFilter[])filters.toArray(new QFilter[0]));
        BigDecimal sumFinAmt = BigDecimal.ZERO;
        BigDecimal sumCastAmt = BigDecimal.ZERO;
        BigDecimal sumSettleAmt = BigDecimal.ZERO;
        BigDecimal sumFinQty = BigDecimal.ZERO;
        BigDecimal sumCasQty = BigDecimal.ZERO;
        BigDecimal sumSettleQty = BigDecimal.ZERO;
        if (settleLogs.size() > 0) {
            String finFormId = this.rpaSttleEntityMap().get("finBillEntity");
            String casFormId = this.rpaSttleEntityMap().get("casBillEntity");
            for (DynamicObject obj : settleLogs) {
                sumSettleAmt = sumSettleAmt.add(obj.getBigDecimal("mainsettleamt"));
                sumSettleQty = sumSettleQty.add(obj.getBigDecimal("settlerecordcount"));
                if (finFormId.equals(obj.getString("mainbillentity"))) {
                    sumFinAmt = sumFinAmt.add(obj.getBigDecimal("mainsettleamt"));
                    sumFinQty = sumFinQty.add(obj.getBigDecimal("mainexecutedcount"));
                } else if (casFormId.equals(obj.getString("mainbillentity"))) {
                    sumCastAmt = sumCastAmt.add(obj.getBigDecimal("mainsettleamt"));
                    sumCasQty = sumCasQty.add(obj.getBigDecimal("mainexecutedcount"));
                }
                if (finFormId.equals(obj.getString("asstbillentity"))) {
                    sumFinAmt = sumFinAmt.add(obj.getBigDecimal("asstsettleamt"));
                    sumFinQty = sumFinQty.add(obj.getBigDecimal("asstexecutedcount"));
                    continue;
                }
                if (!casFormId.equals(obj.getString("asstbillentity"))) continue;
                sumCastAmt = sumCastAmt.add(obj.getBigDecimal("asstsettleamt"));
                sumCasQty = sumCasQty.add(obj.getBigDecimal("asstexecutedcount"));
            }
        }
        DecimalFormat df = new DecimalFormat("###,##0.##");
        this.getModel().setValue("fin_num", (Object)sumFinQty.intValue());
        this.getModel().setValue("fin_amt", (Object)df.format(sumFinAmt));
        this.getModel().setValue("cas_num", (Object)sumCasQty.intValue());
        this.getModel().setValue("cas_amt", (Object)df.format(sumCastAmt));
        this.getModel().setValue("settle_num", (Object)sumSettleQty.intValue());
        this.getModel().setValue("settle_amt", (Object)df.format(sumSettleAmt));
        this.getView().updateView("settleprogress_panel");
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"font_refresh", "finnum_panel", "finamt_panel", "casnum_panel", "casamt_panel", "settlenum_panel", "settleamt_panel"});
    }

    public void openSettleRecordList(String settleRelations, String formId) {
        List orgIdsStr = this.getControlFilters().getFilter("org.id");
        ListShowParameter parameter = new ListShowParameter();
        parameter.setBillFormId(formId);
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        ListFilterParameter param = new ListFilterParameter();
        QFilter apSettleFilter = new QFilter("settletype", "=", (Object)"rpamatch");
        if (StringUtils.isNotEmpty(settleRelations)) {
            apSettleFilter.and("settlerelation", "in", (Object)settleRelations.split(","));
        }
        if (EmptyUtils.isNotEmpty(orgIdsStr) && StringUtils.isNotEmpty(orgIdsStr.get(0).toString())) {
            ArrayList<Long> orgIds = new ArrayList<Long>(10);
            for (Object orgId : orgIdsStr) {
                orgIds.add(Long.parseLong(orgId.toString()));
            }
            apSettleFilter.and("org.id", "in", orgIds);
        }
        String startTime = this.getPageCache().get("startTime");
        String endTime = this.getPageCache().get("endTime");
        if (StringUtils.isNotEmpty(startTime)) {
            apSettleFilter.and("createtime", ">=", (Object)DateUtils.parseDate(startTime, "yyyy-MM-dd HH:mm:ss")).and("createtime", "<", (Object)DateUtils.parseDate(endTime, "yyyy-MM-dd HH:mm:ss"));
        }
        DataSet settleRecords = QueryServiceHelper.queryDataSet((String)"querysettlerecord", (String)formId, (String)"id", (QFilter[])new QFilter[]{apSettleFilter}, (String)"", (int)100000);
        HashSet<Long> recordIds = new HashSet<Long>(64);
        for (Row record : settleRecords) {
            recordIds.add(record.getLong("id"));
        }
        param.setFilter(new QFilter("id", "in", recordIds));
        parameter.setCustomParam("checkKey", (Object)Boolean.TRUE);
        parameter.setListFilterParameter(param);
        this.getView().showForm((FormShowParameter)parameter);
    }

    public void setFilter(SetFilterEvent e) {
        List filters = e.getQFilters();
        filters.add(new QFilter("id", "!=", (Object)0));
        Object schemePk = this.getView().getFormShowParameter().getCustomParam("schemePk");
        if (schemePk != null) {
            e.getQFilters().add(new QFilter("schemeid", "=", schemePk));
        }
        this.fillSettleProgress(filters);
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        super.billListHyperLinkClick(args);
        String fieldName = args.getHyperLinkClickEvent().getFieldName();
        BillList billList = (BillList)args.getHyperLinkClickEvent().getSource();
        Object pkId = billList.getFocusRowPkId();
        switch (fieldName) {
            case "schemenumber": {
                args.setCancel(true);
                DynamicObject rowData = BusinessDataServiceHelper.loadSingle((Object)pkId, (String)this.rpaSttleEntityMap().get("rpaSttleLogEntity"), (String)"id,schemeid");
                BillShowParameter param = new BillShowParameter();
                param.setPkId(rowData.get("schemeid"));
                param.setStatus(OperationStatus.VIEW);
                param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                param.setFormId(this.rpaSttleEntityMap().get("schemeBillEntity"));
                this.getView().showForm((FormShowParameter)param);
                break;
            }
            case "settlerecordcount": {
                args.setCancel(true);
                ListShowParameter listShowParameter = new ListShowParameter();
                listShowParameter.setBillFormId(this.rpaSttleEntityMap().get("settleRecord"));
                listShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                ListFilterParameter filterParam = new ListFilterParameter();
                QFilter qFilter = new QFilter("settlelogentryid", "=", pkId);
                DataSet settleRecords = QueryServiceHelper.queryDataSet((String)"querysettlerecord", (String)this.rpaSttleEntityMap().get("settleRecord"), (String)"id", (QFilter[])new QFilter[]{qFilter}, (String)"", (int)100000);
                HashSet<Long> recordIds = new HashSet<Long>(64);
                for (Row record : settleRecords) {
                    recordIds.add(record.getLong("id"));
                }
                filterParam.setFilter(new QFilter("id", "in", recordIds));
                listShowParameter.setCustomParam("checkKey", (Object)Boolean.TRUE);
                listShowParameter.setListFilterParameter(filterParam);
                this.getView().showForm((FormShowParameter)listShowParameter);
            }
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String key = evt.getItemKey();
        if ("reexescheme".equals(key)) {
            ListSelectedRowCollection colls = this.getSelectedRows();
            if (colls != null && colls.size() == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"BaseRPASettleLogList_0", (String)"fi-arapcommon", (Object[])new Object[0]));
                return;
            }
            this.openSchemeListView();
        }
    }

    public void openSchemeListView() {
        ListSelectedRowCollection selectedRows = this.getSelectedRows();
        Object[] pkIds = selectedRows.getPrimaryKeyValues();
        DynamicObject[] rpaLogs = BusinessDataServiceHelper.load((String)this.rpaSttleEntityMap().get("rpaSttleLogEntity"), (String)"schemeid", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)pkIds)});
        List schemeIds = Arrays.stream(rpaLogs).map(t -> t.getLong("schemeid")).collect(Collectors.toList());
        ListShowParameter listShowParameter = new ListShowParameter();
        listShowParameter.setBillFormId(this.rpaSttleEntityMap().get("schemeBillEntity"));
        listShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        ListFilterParameter filterParam = new ListFilterParameter();
        QFilter qFilter = new QFilter("id", "in", schemeIds);
        filterParam.setFilter(qFilter);
        listShowParameter.setListFilterParameter(filterParam);
        this.getView().showForm((FormShowParameter)listShowParameter);
    }

    protected abstract Map<String, String> rpaSttleEntityMap();

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        Object op = e.getSource();
        String key = ((AbstractOperate)op).getOperateKey();
        if ("stopexecute".equals(key) && e.getOperationResult().isSuccess()) {
            this.getView().invokeOperation("refresh");
        }
    }

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        LicenseCheckResult result = LicenseServiceHelper.checkPerformGroup((String)groupNumber);
        if (!result.getHasLicense().booleanValue()) {
            e.setCancel(true);
            e.setCancelMessage(result.getMsg());
        }
    }
}

