/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.form;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityType;
import kd.bos.entity.EntityTypeUtil;
import kd.bos.entity.EntryEntityDto;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.arapcommon.service.helper.OpLogServiceHelper;
import kd.fi.arapcommon.service.log.LogUtil;
import kd.fi.arapcommon.service.settle.SettleVersionServiceHelper;
import kd.fi.arapcommon.util.EmptyUtils;
import kd.fi.arapcommon.util.EntityMetadataUtils;
import kd.fi.arapcommon.util.InstantUtils;
import kd.fi.arapcommon.util.JsonUtils;
import kd.fi.arapcommon.vo.log.BillLogInfo;
import kd.fi.arapcommon.vo.log.PropertyChangeLogInfo;
import kd.fi.arapcommon.vo.log.PropertyTypeEnum;

public class BillEditLogPlugin
extends AbstractBillPlugIn
implements ItemClickListener {
    private static final Log LOGGER = LogFactory.getLog(BillEditLogPlugin.class);
    private static final int MAXENTRYCOUNT = 500;
    private static final Set<String> listenAmountFields = new HashSet<String>(Arrays.asList("e_amount", "e_amountbase", "e_localamt", "e_tax", "e_taxlocalamt", "e_pricetaxtotal", "e_recamount", "e_reclocalamt", "e_pricetaxtotalbase"));
    private static final Set<String> listenFxButtons = new HashSet<String>(Arrays.asList("isfx", "isfxpricetaxtotal", "isfxlocal"));

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"advcontoolbarap"});
    }

    public void afterLoadData(EventObject e) {
        super.afterLoadData(e);
        this.setShortCuts();
    }

    public void customEvent(CustomEventArgs e) {
        super.customEvent(e);
        if (e.getEventName().equalsIgnoreCase("shortCuts")) {
            String key;
            switch (key = e.getEventArgs()) {
                case "[17,16,76]": {
                    String entityId = this.getView().getEntityId();
                    String billNo = (String)this.getModel().getValue("billno");
                    ListShowParameter listShowParameter = new ListShowParameter();
                    listShowParameter.setBillFormId("ap_oplog");
                    listShowParameter.setCustomParam("bizobj", (Object)entityId);
                    listShowParameter.setCustomParam("billNo", (Object)billNo);
                    listShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                    this.getView().showForm((FormShowParameter)listShowParameter);
                    break;
                }
                case "[17,16,81]": {
                    DynamicObject obj = this.getModel().getDataEntity(true);
                    if (obj != null) {
                        EntityType dataEntityType = (EntityType)obj.getDataEntityType();
                        List entryEntities = EntityTypeUtil.getEntryEntities((EntityType)dataEntityType);
                        for (EntryEntityDto entryDto : entryEntities) {
                            DynamicObjectCollection entryColl;
                            if (!EntityMetadataUtils.isExistProperty(obj, entryDto.getKey()) || (entryColl = obj.getDynamicObjectCollection(entryDto.getKey())) == null || entryColl.size() <= 500) continue;
                            for (int i = 500; i < entryColl.size(); ++i) {
                                entryColl.remove(i);
                            }
                        }
                        FormShowParameter showParameter = new FormShowParameter();
                        showParameter.setFormId("ap_querymodel");
                        showParameter.getOpenStyle().setShowType(ShowType.Modal);
                        showParameter.setCustomParam("obj", (Object)obj);
                        StyleCss inlineStyleCss = new StyleCss();
                        inlineStyleCss.setHeight("600");
                        inlineStyleCss.setWidth("800");
                        showParameter.getOpenStyle().setInlineStyleCss(inlineStyleCss);
                        this.getView().showForm(showParameter);
                        break;
                    }
                    this.getView().showMessage(ResManager.loadKDString((String)"\u5355\u636e\u4fe1\u606f\u4e3a\u7a7a\u3002", (String)"BillEditLogPlugin_0", (String)"fi-arapcommon", (Object[])new Object[0]));
                    break;
                }
                case "[17,16,83]": {
                    DynamicObject finBill = this.getModel().getDataEntity(true);
                    String entityName = finBill.getDataEntityType().getName();
                    if (!"ap_finapbill".equals(entityName) && !"ar_finarbill".equals(entityName)) break;
                    boolean oldVersion = SettleVersionServiceHelper.isOldVersion(finBill);
                    if (oldVersion) {
                        this.getView().showMessage("use old settle");
                        break;
                    }
                    this.getView().showMessage("use new settle");
                }
            }
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String key = evt.getItemKey();
        if ("editinbulk".equals(key)) {
            OpLogServiceHelper.addLog(this.getView(), key);
        }
        if ("bar_log".equals(key)) {
            String entityId = this.getView().getEntityId();
            String billNo = (String)this.getModel().getValue("billno");
            ListShowParameter listShowParameter = new ListShowParameter();
            listShowParameter.setBillFormId("ap_oplog");
            listShowParameter.setCustomParam("bizobj", (Object)entityId);
            listShowParameter.setCustomParam("billNo", (Object)billNo);
            listShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            this.getView().showForm((FormShowParameter)listShowParameter);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String entityName = this.getModel().getDataEntityType().getName();
        if ("ap_invoice".equals(entityName) || "ar_invoice".equals(entityName)) {
            this.addLogForFxAmt(e);
        }
    }

    public void initPropertyChanged(PropertyChangedArgs e) {
        super.initPropertyChanged(e);
        String entityName = this.getModel().getDataEntityType().getName();
        if ("ap_finapbill".equals(entityName) || "ar_finarbill".equals(entityName)) {
            this.addLogForFxAmt(e);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs evt) {
        boolean logUsable;
        super.afterDoOperation(evt);
        String key = evt.getOperateKey();
        boolean bl = logUsable = Arrays.asList("save", "submit").contains(key) && evt.getOperationResult().isSuccess();
        if (!logUsable) {
            return;
        }
        if (!Arrays.asList("save", "submit").contains(key)) {
            return;
        }
        List<BillLogInfo> billLog = this.listBillLogFromCache();
        if (EmptyUtils.isEmpty(billLog)) {
            return;
        }
        DynamicObject dataEntity = this.getModel().getDataEntity();
        LogUtil.addOpLog(dataEntity.getDataEntityType().getName(), dataEntity.getString("billno"), "fxpropertyChanged", JsonUtils.objToJson(billLog), true);
        this.getView().getPageCache().remove("EDIT_LOG" + this.getView().getPageId());
    }

    private void addLogForFxAmt(PropertyChangedArgs e) {
        String key = e.getProperty().getName();
        ChangeData[] changeDataArray = e.getChangeSet();
        Set allFieldNames = this.getModel().getDataEntityType().getAllFields().keySet();
        ArrayList<String> isFxOpenFields = new ArrayList<String>(4);
        for (String listenFxButton : listenFxButtons) {
            if (!allFieldNames.contains(listenFxButton) || !((Boolean)this.getModel().getValue(listenFxButton)).booleanValue()) continue;
            isFxOpenFields.add(listenFxButton);
        }
        if (isFxOpenFields.isEmpty() || !listenAmountFields.contains(key)) {
            return;
        }
        try {
            Instant time = Instant.now();
            List<BillLogInfo> billLogList = this.listBillLogFromCache();
            String parentName = e.getProperty().getParent().getName();
            for (ChangeData changeData : changeDataArray) {
                if (billLogList.size() > 500) break;
                PropertyChangeLogInfo logInfo = new PropertyChangeLogInfo();
                logInfo.setPropertyName(e.getProperty().getName());
                logInfo.setFxButton(((Object)isFxOpenFields).toString());
                logInfo.setOriginValue(changeData.getOldValue());
                logInfo.setGenerateValue(changeData.getNewValue());
                logInfo.setTime(InstantUtils.getInstantString(time, "yyyy-MM-dd HH:mm:ss"));
                logInfo.setPropertyType(PropertyTypeEnum.FIELD);
                logInfo.setParentName(parentName);
                if (!this.getModel().getDataEntityType().getName().equals(parentName)) {
                    logInfo.setRowNumber(this.getModel().getEntryCurrentRowIndex(parentName) + 1);
                }
                billLogList.add(logInfo);
            }
            this.getView().getPageCache().put("EDIT_LOG" + this.getView().getPageId(), SerializationUtils.toJsonString(billLogList));
        }
        catch (Exception e1) {
            LOGGER.info("add field Log error :" + e1);
        }
    }

    private void setShortCuts() {
        JSONArray arrayItem = new JSONArray();
        JSONObject item = new JSONObject();
        item.put("type", (Object)"keyUp");
        item.put("shortCuts", (Object)"ctrl+shift+l");
        arrayItem.add((Object)item);
        item = new JSONObject();
        item.put("type", (Object)"keyUp");
        item.put("shortCuts", (Object)"ctrl+shift+q");
        arrayItem.add((Object)item);
        item = new JSONObject();
        item.put("type", (Object)"keyUp");
        item.put("shortCuts", (Object)"ctrl+shift+s");
        arrayItem.add((Object)item);
        IFormView formView = this.getView();
        IClientViewProxy clientViewProxy = (IClientViewProxy)formView.getService(IClientViewProxy.class);
        JSONArray action = new JSONArray();
        action.add((Object)arrayItem);
        clientViewProxy.addAction("setShortCuts", (Object)action);
    }

    private List<BillLogInfo> listBillLogFromCache() {
        try {
            String cacheValue = this.getView().getPageCache().get("EDIT_LOG" + this.getView().getPageId());
            if (EmptyUtils.isEmpty(cacheValue)) {
                return new ArrayList<BillLogInfo>(16);
            }
            Object result = JSONObject.parse((String)cacheValue);
            return (List)result;
        }
        catch (Exception e) {
            return new ArrayList<BillLogInfo>(16);
        }
    }
}

