/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.form;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.fi.arapcommon.util.EmptyUtils;
import kd.fi.arapcommon.util.EntityMetadataUtils;

public class BillFieldMappingEdit
extends AbstractFormPlugin {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"srcbillentity", "targetbillentity"});
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key = e.getProperty().getName();
        Object newValue = e.getChangeSet()[0].getNewValue();
        switch (key) {
            case "srcbillentity": {
                this.clearFieldAndSiteList(true);
                this.setFieldList((String)newValue, "e_srcfield", true);
                break;
            }
            case "targetbillentity": {
                this.clearFieldAndSiteList(false);
                this.setFieldList((String)newValue, "e_targetfield", false);
                break;
            }
            case "e_srcfield": {
                this.setSiteList((String)newValue, true);
                Object targetBillEntity = this.getModel().getValue("targetbillentity");
                if (targetBillEntity == null) break;
                this.setFieldList(targetBillEntity.toString(), "e_targetfield", false);
                break;
            }
            case "e_targetfield": {
                this.setSiteList((String)newValue, false);
            }
        }
    }

    private void clearFieldAndSiteList(boolean isSrcBill) {
        int entryRowCount = this.getModel().getEntryRowCount("entry");
        if (isSrcBill) {
            for (int i = 0; i < entryRowCount; ++i) {
                this.getModel().setValue("e_srcfield", null, i);
                this.getModel().setValue("e_srcfieldsite", null, i);
            }
        } else {
            for (int i = 0; i < entryRowCount; ++i) {
                this.getModel().setValue("e_targetfield", null, i);
                this.getModel().setValue("e_targetfieldsite", null, i);
            }
        }
    }

    private void setFieldList(String entityKey, String field, boolean isSrc) {
        int rowIndex = this.getModel().getEntryCurrentRowIndex("entry");
        String srcBillEntity = (String)this.getModel().getValue("srcbillentity");
        String srcField = (String)this.getModel().getValue("e_srcfield", rowIndex);
        List<IDataEntityProperty> properties = EntityMetadataUtils.getProperties(entityKey);
        HashMap<String, String> fieldPositionMap = new HashMap<String, String>(properties.size());
        HashMap<String, String> fieldTypeMap = new HashMap<String, String>(properties.size());
        ArrayList<ComboItem> items = new ArrayList<ComboItem>(properties.size());
        HashSet<String> adjExchBillField = new HashSet<String>(Arrays.asList("billno,billstatus,org,sourcebilltype,sourcebilldate,bizdate,period,asstacttype,asstact,department,remark,isincludeentry,isvoucher,createtime,currency,basecurrency,exratetable,exchangerate,quotation,lastexchangerate,srcbillquotation,balance,localbalance,curlocalbalance,curgainloss,lastgainloss,gainloss,auditdate,modifytime,modifier,creator,auditor,sourcebillid,bizsystem".split(",")));
        adjExchBillField.addAll(Arrays.asList("e_material,e_spectype,e_expenseitem,e_srcbillid,e_srcentryid,e_balance,e_localbalance,e_curlocalbalance,e_curgainloss,e_lastgainloss,e_gainloss,project".split(",")));
        Map pageCacheAll = this.getPageCache().getAll();
        for (IDataEntityProperty prop : properties) {
            String key;
            String alias;
            LocaleString displayName = prop.getDisplayName();
            if (displayName == null || EmptyUtils.isEmpty(alias = prop.getAlias()) || ("ap_adjexchbill".equals(entityKey) || "ar_adjustexchbill".equals(entityKey)) && "e_targetfield".equals(field) && adjExchBillField.contains(prop.getName()) || !isSrc && EmptyUtils.isNotEmpty(srcBillEntity) && EmptyUtils.isNotEmpty(srcField) && (pageCacheAll.get(key = srcBillEntity + srcField + "type") == null || !((String)pageCacheAll.get(key)).equals(prop.getPropertyType().toString()))) continue;
            LocaleString dis = new LocaleString(displayName.getLocaleValue() + "(" + prop.getName() + ")");
            items.add(new ComboItem(dis, prop.getName()));
            if (EmptyUtils.isEmpty(prop.getParent())) continue;
            fieldPositionMap.put(entityKey + prop.getName(), prop.getParent().getName());
            if (!isSrc || prop.getPropertyType() == null) continue;
            fieldTypeMap.put(entityKey + prop.getName() + "type", prop.getPropertyType().toString());
        }
        ComboEdit edit = (ComboEdit)this.getControl(field);
        edit.setComboItems(items.stream().distinct().collect(Collectors.toList()));
        this.getPageCache().put(fieldPositionMap);
        this.getPageCache().put(fieldTypeMap);
    }

    private void setSiteList(String fieldValue, boolean isSrcBill) {
        int entryCurrentRowIndex = this.getModel().getEntryCurrentRowIndex("entry");
        if (EmptyUtils.isEmpty(fieldValue)) {
            return;
        }
        String entityName = (String)this.getModel().getValue(isSrcBill ? "srcbillentity" : "targetbillentity");
        String site = this.getPageCache().get(entityName + fieldValue);
        if (EmptyUtils.isNotEmpty(site)) {
            this.getModel().setValue(isSrcBill ? "e_srcfieldsite" : "e_targetfieldsite", (Object)site, entryCurrentRowIndex);
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u83b7\u53d6\u5230\u5b57\u6bb5\u6240\u5728\u7684\u4f4d\u7f6e", (String)"BillFieldMappingEdit_0", (String)"fi-arapcommon", (Object[])new Object[0]));
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate op = (AbstractOperate)args.getSource();
        String key = op.getOperateKey();
        if ("newentry".equals(key)) {
            DynamicObjectCollection entries = this.getModel().getEntryEntity("entry");
            for (DynamicObject entry : entries) {
                Object e_srcfield = entry.get("e_srcfield");
                Object e_targetfield = entry.get("e_targetfield");
                if (!EmptyUtils.isEmpty(e_srcfield) && !EmptyUtils.isEmpty(e_targetfield)) continue;
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u5206\u5f55\u4e2d\u7684\u7a7a\u503c\u4e4b\u540e\u518d\u65b0\u589e\u5206\u5f55\u884c\u3002", (String)"BillFieldMappingEdit_1", (String)"fi-arapcommon", (Object[])new Object[0]));
            }
        }
    }
}

