/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.form;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.kdtx.sdk.check.TxCheckUtil;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.arapcommon.service.log.LogUtil;

public class BotpReSettlePlugin
extends AbstractFormPlugin {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbarap"});
        this.addClickListeners(new String[]{"billnodesc"});
    }

    public void propertyChanged(PropertyChangedArgs e) {
        ChangeData[] changeData = e.getChangeSet();
        Object newValue = changeData[0].getNewValue();
        String name = e.getProperty().getName();
        if ("billnodesc".equals(name)) {
            this.getModel().setValue("billnovalue", newValue);
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        IDataModel m = this.getModel();
        FormShowParameter parameter = this.getView().getFormShowParameter();
        boolean isAr = parameter.getAppId().equals("ar");
        String billentity = "cas_paybill";
        if (isAr) {
            billentity = "cas_recbill";
        }
        m.setValue("billentity", (Object)billentity);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        String returnData = (String)closedCallBackEvent.getReturnData();
        if ("billnodesc".equals(actionId) && StringUtils.isNotBlank((CharSequence)returnData)) {
            this.getModel().setValue("billnodesc", (Object)returnData);
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        String key = source.getKey();
        if ("billnodesc".equals(key)) {
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId("bos_multitext");
            ArrayList<Object> params = new ArrayList<Object>();
            params.add(this.getModel().getValue("billnovalue"));
            showParameter.getCustomParams().put("params", params);
            showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "billnodesc"));
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            showParameter.setCaption(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7", (String)"BotpReSettlePlugin_8", (String)"fi-arapcommon", (Object[])new Object[0]));
            this.getView().showForm(showParameter);
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        if ("settle".equals(evt.getItemKey())) {
            this.resettle(evt);
        }
    }

    public void resettle(ItemClickEvent evt) {
        Collection payBillIds;
        IDataModel m = this.getModel();
        String billentity = String.valueOf(m.getValue("billentity"));
        String billnoJson = String.valueOf(m.getValue("billnovalue"));
        Object[] billNos = StringUtils.split((String)billnoJson, (String)"\n");
        String operationKey = evt.getOperationKey();
        LogUtil.addOpLog("ap_resettle", billNos[0], operationKey, "billnos\uff1a" + Arrays.toString(billNos) + " execute resettle\uff1a" + operationKey, true);
        String priceTaxTatol = "cas_paybill".equals(billentity) ? "entry.e_payableamt" : "entry.e_receivableamt";
        DynamicObjectCollection bills = QueryServiceHelper.query((String)billentity, (String)("id,billno,billstatus,entry.e_settledamt,entry.e_unsettledamt," + priceTaxTatol), (QFilter[])new QFilter[]{new QFilter("billno", "in", (Object)billNos)});
        if (bills.size() == 0) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5355\u636e\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"BotpReSettlePlugin_0", (String)"fi-arapcommon", (Object[])new Object[0]));
            return;
        }
        for (DynamicObject bill : bills) {
            if (!"D".equals(bill.getString("billstatus"))) {
                if ("cas_paybill".equals(billentity)) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"%s\u5355\u636e\u72b6\u6001\u975e\u5df2\u4ed8\u6b3e\uff0c\u4e0d\u5141\u8bb8\u6267\u884c\u7ed3\u7b97\u8865\u507f\u3002", (String)"BotpReSettlePlugin_1", (String)"fi-arapcommon", (Object[])new Object[]{bill.getString("billno")}));
                } else {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"%s\u5355\u636e\u72b6\u6001\u975e\u5df2\u6536\u6b3e\uff0c\u4e0d\u5141\u8bb8\u6267\u884c\u7ed3\u7b97\u8865\u507f\u3002", (String)"BotpReSettlePlugin_2", (String)"fi-arapcommon", (Object[])new Object[]{bill.getString("billno")}));
                }
                return;
            }
            if (bill.getBigDecimal("entry.e_settledamt").compareTo(BigDecimal.ZERO) != 0) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"%s\u5df2\u7ed3\u7b97\u91d1\u989d\u5b58\u5728\u5f02\u5e38\uff0c\u4e0d\u5141\u8bb8\u6267\u884c\u7ed3\u7b97\u8865\u507f\u3002", (String)"BotpReSettlePlugin_3", (String)"fi-arapcommon", (Object[])new Object[]{bill.getString("billno")}));
                return;
            }
            if (bill.getBigDecimal("entry.e_unsettledamt").compareTo(bill.getBigDecimal(priceTaxTatol)) == 0) continue;
            this.getView().showErrorNotification(ResManager.loadKDString((String)"%s\u672a\u7ed3\u7b97\u91d1\u989d\u5b58\u5728\u5f02\u5e38\uff0c\u4e0d\u5141\u8bb8\u6267\u884c\u7ed3\u7b97\u8865\u507f\u3002", (String)"BotpReSettlePlugin_4", (String)"fi-arapcommon", (Object[])new Object[]{bill.getString("billno")}));
            return;
        }
        DynamicObjectCollection settleRecordsAsMain = QueryServiceHelper.query((String)"ap_settlerecord", (String)"billno", (QFilter[])new QFilter[]{new QFilter("billno", "in", (Object)billNos)});
        DynamicObjectCollection settleRecordsAsAsst = QueryServiceHelper.query((String)"ap_settlerecord", (String)"entry.billnum", (QFilter[])new QFilter[]{new QFilter("entry.billnum", "in", (Object)billNos)});
        if (settleRecordsAsMain.size() > 0) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"%s\u5b58\u5728\u7ed3\u7b97\u8bb0\u5f55\uff0c\u4e0d\u5141\u8bb8\u6267\u884c\u7ed3\u7b97\u8865\u507f\u3002", (String)"BotpReSettlePlugin_5", (String)"fi-arapcommon", (Object[])new Object[]{StringUtils.join((Object[])settleRecordsAsMain.stream().map(e -> e.getString("billno")).distinct().toArray(), (String)",")}));
            return;
        }
        if (settleRecordsAsAsst.size() > 0) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"%s\u5b58\u5728\u7ed3\u7b97\u8bb0\u5f55\uff0c\u4e0d\u5141\u8bb8\u6267\u884c\u7ed3\u7b97\u8865\u507f\u3002", (String)"BotpReSettlePlugin_5", (String)"fi-arapcommon", (Object[])new Object[]{StringUtils.join((Object[])settleRecordsAsAsst.stream().map(e -> e.getString("entry.billnum")).distinct().toArray(), (String)",")}));
            return;
        }
        List billIds = bills.stream().map(e -> e.getString("id")).collect(Collectors.toList());
        List lockedIds = TxCheckUtil.getLocked(billIds);
        if (lockedIds.size() > 0) {
            HashSet<String> errBillNos = new HashSet<String>(lockedIds.size());
            for (DynamicObject bill : bills) {
                if (!lockedIds.contains(bill.getString("id"))) continue;
                errBillNos.add(bill.getString("billno"));
            }
            this.getView().showErrorNotification(ResManager.loadKDString((String)"%s\u5b58\u5728\u672a\u5b8c\u6210\u7684\u5206\u5e03\u5f0f\u4e8b\u52a1\uff0c\u4e0d\u5141\u8bb8\u6267\u884c\u7ed3\u7b97\u8865\u507f\u3002", (String)"BotpReSettlePlugin_6", (String)"fi-arapcommon", (Object[])new Object[]{StringUtils.join((Object[])errBillNos.toArray(), (String)",")}));
            return;
        }
        if ("cas_recbill".equals(billentity)) {
            payBillIds = bills.stream().map(e -> e.getLong("id")).collect(Collectors.toList());
            DispatchServiceHelper.invokeBizService((String)"fi", (String)"ar", (String)"RecBillListener", (String)"rec", (Object[])new Object[]{payBillIds});
        }
        if ("cas_paybill".equals(billentity)) {
            payBillIds = bills.stream().map(e -> e.getLong("id")).collect(Collectors.toSet());
            ArrayList payParamList = new ArrayList(1);
            for (Long payBillId : payBillIds) {
                HashMap<String, Long> paramMap = new HashMap<String, Long>(1);
                paramMap.put("targetpk", payBillId);
                payParamList.add(paramMap);
            }
            DispatchServiceHelper.invokeBizService((String)"fi", (String)"ap", (String)"PayBillListener", (String)"paySuccess", (Object[])new Object[]{payParamList});
        }
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u672c\u6b21\u7ed3\u7b97\u5b8c\u6210\u3002", (String)"BotpReSettlePlugin_7", (String)"fi-arapcommon", (Object[])new Object[0]));
    }
}

