/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.form;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.BillStatusProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.arapcommon.enums.SettleRelationEnum;
import kd.fi.arapcommon.helper.SystemParameterHelper;
import kd.fi.arapcommon.service.manualsettle.AbstractSettleBillProvider;
import kd.fi.arapcommon.service.manualsettle.IManualSettleBillProvider;
import kd.fi.arapcommon.service.manualsettle.ManualProviderParam;
import kd.fi.arapcommon.service.manualsettle.ManualSettleFinApBillProvider;
import kd.fi.arapcommon.service.manualsettle.ManualSettleFinArBillProvider;
import kd.fi.arapcommon.service.manualsettle.ManualSettleLossBillProvider;
import kd.fi.arapcommon.service.manualsettle.ManualSettlePaidBillProvider;
import kd.fi.arapcommon.service.manualsettle.ManualSettlePayBillProvider;
import kd.fi.arapcommon.service.manualsettle.ManualSettleRecBillProvider;
import kd.fi.arapcommon.service.manualsettle.ManualSettleRecedBillProvider;

public class CheckVerifyBillPlugin
extends AbstractFormPlugin {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbarap"});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        IDataModel m = this.getModel();
        FormShowParameter parameter = this.getView().getFormShowParameter();
        Map custParams = parameter.getCustomParams();
        Object bustype = custParams.get("bustype");
        Object org = custParams.get("org");
        m.setValue("bustype", bustype);
        m.setValue("org", org);
        m.setValue("settlerelation", custParams.get("settlerelation"));
        boolean isAr = parameter.getAppId().equals("ar");
        String billentity = "ap_finapbill";
        if (isAr) {
            billentity = "ar_finarbill";
        }
        m.setValue("billentity", (Object)billentity);
        this.displayCheckItem();
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        switch (evt.getItemKey()) {
            case "checkbar": {
                this.checkBill();
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        if ("billentity".equals(key)) {
            this.clearEntryData();
            this.displayCheckItem();
        }
    }

    private void displayCheckItem() {
        IDataModel m = this.getModel();
        String billentity = String.valueOf(m.getValue("billentity"));
        DynamicObject org = (DynamicObject)m.getValue("org");
        ManualProviderParam param = new ManualProviderParam();
        param.setSettleRelation(String.valueOf(m.getValue("settlerelation")));
        param.setOrgPk(org.getPkValue());
        param.setSubmitSettle(this.getSubmitSettleParam());
        IManualSettleBillProvider billProvider = this.getBillProvider(billentity, param);
        if (billProvider == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u627e\u5230\u5bf9\u5e94\u5355\u636e\u7684\u5b9e\u73b0\u3002", (String)"CheckVerifyBillPlugin_0", (String)"fi-arapcommon", (Object[])new Object[0]));
            return;
        }
        QFilter qFilter = billProvider.getQueryFilter(null);
        List<QFilter> qFilters = this.getQFilters(qFilter);
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)billentity);
        for (int i = 0; i < qFilters.size(); ++i) {
            this.addEntryData();
            QFilter filter = qFilters.get(i);
            String property = filter.getProperty();
            Object value = filter.getValue();
            String cp = filter.getCP();
            String fieldDisplayName = this.getFieldDisplayName(dataEntityType, property);
            String valueDisplayName = this.getValDisplayName(dataEntityType, property, value);
            String checkMsg = fieldDisplayName + this.getCpDisplayName(cp) + valueDisplayName;
            m.setValue("checkscope", (Object)checkMsg, i);
            m.setValue("result", (Object)2, i);
        }
    }

    public void checkBill() {
        IDataModel m = this.getModel();
        String billentity = String.valueOf(m.getValue("billentity"));
        String billno = String.valueOf(m.getValue("billno"));
        DynamicObject org = (DynamicObject)m.getValue("org");
        ManualProviderParam param = new ManualProviderParam();
        param.setSettleRelation(String.valueOf(m.getValue("settlerelation")));
        param.setOrgPk(org.getPkValue());
        param.setSubmitSettle(this.getSubmitSettleParam());
        IManualSettleBillProvider billProvider = this.getBillProvider(billentity, param);
        if (billProvider == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u627e\u5230\u5bf9\u5e94\u5355\u636e\u7684\u5b9e\u73b0\u3002", (String)"CheckVerifyBillPlugin_0", (String)"fi-arapcommon", (Object[])new Object[0]));
            return;
        }
        QFilter qFilter = billProvider.getQueryFilter(null);
        List<QFilter> qFilters = this.getQFilters(qFilter);
        ArrayList<String> selector = new ArrayList<String>(qFilters.size());
        for (QFilter selectorFilter : qFilters) {
            selector.add(selectorFilter.getProperty());
        }
        DynamicObjectCollection bills = QueryServiceHelper.query((String)billentity, (String)String.join((CharSequence)",", selector), (QFilter[])new QFilter[]{new QFilter("billno", "=", (Object)billno)});
        if (bills == null || bills.size() < 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5355\u636e\u4e0d\u5b58\u5728\u3002", (String)"CheckVerifyBillPlugin_1", (String)"fi-arapcommon", (Object[])new Object[0]));
            return;
        }
        for (int i = 0; i < qFilters.size(); ++i) {
            QFilter filter = qFilters.get(i);
            String property = filter.getProperty();
            Object value = filter.getValue();
            String cp = filter.getCP();
            boolean result = false;
            for (DynamicObject bill : bills) {
                if (this.checkVal(bill.get(property), value, cp)) {
                    result = true;
                }
                if (property.contains(".")) continue;
                break;
            }
            if (result) {
                m.setValue("result", (Object)0, i);
                continue;
            }
            m.setValue("result", (Object)1, i);
        }
    }

    private IManualSettleBillProvider getBillProvider(String billentity, ManualProviderParam param) {
        AbstractSettleBillProvider billProvider = null;
        switch (billentity) {
            case "ap_paidbill": {
                billProvider = new ManualSettlePaidBillProvider(param);
                break;
            }
            case "ar_receivedbill": {
                billProvider = new ManualSettleRecedBillProvider(param);
                break;
            }
            case "ap_finapbill": {
                billProvider = new ManualSettleFinApBillProvider(param);
                break;
            }
            case "ar_baddebtlossbill": {
                billProvider = new ManualSettleLossBillProvider(param);
                break;
            }
            case "ar_finarbill": {
                billProvider = new ManualSettleFinArBillProvider(param);
                break;
            }
            case "cas_paybill": {
                billProvider = new ManualSettlePayBillProvider(param);
                break;
            }
            case "cas_recbill": {
                billProvider = new ManualSettleRecBillProvider(param);
            }
        }
        return billProvider;
    }

    private boolean checkVal(Object srcValue, Object tagValue, String cp) {
        BigDecimal srcVal = BigDecimal.ZERO;
        if (srcValue instanceof BigDecimal) {
            srcVal = (BigDecimal)srcValue;
        }
        boolean result = false;
        switch (cp) {
            case "in": {
                if (tagValue instanceof List) {
                    List values = (List)tagValue;
                    tagValue = values.get(0);
                }
                if (tagValue instanceof String[]) {
                    String[] vals;
                    for (String val : vals = (String[])tagValue) {
                        if (!val.equals(srcValue)) continue;
                        result = true;
                        break;
                    }
                    return result;
                }
                result = String.valueOf(srcValue).equals(String.valueOf(tagValue));
                break;
            }
            case "=": {
                result = String.valueOf(srcValue).equals(String.valueOf(tagValue));
                break;
            }
            case ">": {
                result = srcVal.compareTo(BigDecimal.ZERO) > 0;
                break;
            }
            case "<": {
                result = srcVal.compareTo(BigDecimal.ZERO) < 0;
                break;
            }
            case "<>": {
                result = srcVal.compareTo(BigDecimal.ZERO) != 0;
                break;
            }
            case "not in": {
                if (!(tagValue instanceof List)) break;
                result = true;
                List vals = (List)tagValue;
                for (String val : vals) {
                    if (!val.equals(srcValue)) continue;
                    result = false;
                    break;
                }
                return result;
            }
        }
        return result;
    }

    private String getFieldDisplayName(MainEntityType dataEntityType, String property) {
        IDataEntityProperty dataEntityProperty;
        String displayName = "";
        if (property.contains(".")) {
            String[] propertys = property.split("\\.");
            IDataEntityProperty dataEntityProperty2 = dataEntityType.findProperty(propertys[0]);
            if (dataEntityProperty2 != null) {
                displayName = dataEntityProperty2.getDisplayName().getLocaleValue();
            }
            if (dataEntityProperty2 instanceof BasedataProp) {
                BasedataProp basedataProp = (BasedataProp)dataEntityProperty2;
                property = basedataProp.getBaseEntityId();
                dataEntityType = EntityMetadataCache.getDataEntityType((String)property);
            }
            property = propertys[1];
        }
        if ((dataEntityProperty = dataEntityType.findProperty(property)) != null) {
            if (!displayName.equals("")) {
                displayName = displayName + ".";
            }
            displayName = displayName + dataEntityProperty.getDisplayName().getLocaleValue();
        }
        if (displayName.equals("")) {
            displayName = property;
        }
        return displayName;
    }

    private List<QFilter> getQFilters(QFilter qFilter) {
        List nests = qFilter.getNests(true);
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(nests.size() + 1);
        qFilters.add(new QFilter(qFilter.getProperty(), qFilter.getCP(), qFilter.getValue()));
        for (QFilter.QFilterNest nest : nests) {
            qFilters.add(new QFilter(nest.getFilter().getProperty(), nest.getFilter().getCP(), nest.getFilter().getValue()));
        }
        return qFilters;
    }

    private String getValDisplayName(MainEntityType dataEntityType, String property, Object value) {
        Object values;
        IDataModel m;
        if (value instanceof Integer) {
            return String.valueOf(value);
        }
        if (value instanceof Boolean) {
            if (Boolean.parseBoolean(String.valueOf(value))) {
                return ResManager.loadKDString((String)"\u662f", (String)"CheckVerifyBillPlugin_2", (String)"fi-arapcommon", (Object[])new Object[0]);
            }
            return ResManager.loadKDString((String)"\u5426", (String)"CheckVerifyBillPlugin_3", (String)"fi-arapcommon", (Object[])new Object[0]);
        }
        if (value instanceof List) {
            if ("payertype".equals(property) || "payeetype".equals(property)) {
                IDataEntityProperty dataEntityProperty = dataEntityType.findProperty(property);
                ComboProp comboProp = (ComboProp)dataEntityProperty;
                List mapItems = comboProp.getComboItems();
                List values2 = (List)value;
                ArrayList<String> localValue = new ArrayList<String>(8);
                block0: for (String val : values2) {
                    for (ValueMapItem mapItem : mapItems) {
                        if (!mapItem.getValue().equals(val)) continue;
                        localValue.add(mapItem.getName().getLocaleValue());
                        continue block0;
                    }
                }
                return String.join((CharSequence)ResManager.loadKDString((String)"\u6216", (String)"CheckVerifyBillPlugin_4", (String)"fi-arapcommon", (Object[])new Object[0]), localValue);
            }
            m = this.getModel();
            if (m.getValue("asstactvalue") != null) {
                DynamicObject asstact = (DynamicObject)m.getValue("asstactvalue");
                values = (List)value;
                if (asstact.getLong("id") == ((Long)values.get(0)).longValue()) {
                    return asstact.getString("name");
                }
            }
        } else if (value instanceof Long && (m = this.getModel()).getValue("org") != null) {
            DynamicObject org = (DynamicObject)m.getValue("org");
            values = (Long)value;
            if (org.getLong("id") == ((Long)values).longValue()) {
                return org.getString("name");
            }
        }
        IDataEntityProperty dataEntityProperty = dataEntityType.findProperty(property);
        if (value instanceof String[]) {
            String[] vals = (String[])value;
            ArrayList<String> localValue = new ArrayList<String>(vals.length);
            BillStatusProp billStatusProp = (BillStatusProp)dataEntityProperty;
            List mapItems = billStatusProp.getComboItems();
            block2: for (String val : vals) {
                for (ValueMapItem mapItem : mapItems) {
                    if (!mapItem.getValue().equals(val)) continue;
                    localValue.add(mapItem.getName().getLocaleValue());
                    continue block2;
                }
            }
            return String.join((CharSequence)ResManager.loadKDString((String)"\u6216", (String)"CheckVerifyBillPlugin_4", (String)"fi-arapcommon", (Object[])new Object[0]), localValue);
        }
        if (dataEntityProperty instanceof BillStatusProp) {
            BillStatusProp billStatusProp = (BillStatusProp)dataEntityProperty;
            List mapItems = billStatusProp.getComboItems();
            for (ValueMapItem mapItem : mapItems) {
                if (!mapItem.getValue().equals(value)) continue;
                return mapItem.getName().getLocaleValue();
            }
        }
        return String.valueOf(value);
    }

    private void clearEntryData() {
        this.getModel().deleteEntryData("entryentity");
    }

    private void addEntryData() {
        this.getModel().createNewEntryRow("entryentity");
    }

    private String getCpDisplayName(String cp) {
        String cpDisplayName = cp;
        switch (cp) {
            case ">": {
                cpDisplayName = ResManager.loadKDString((String)"\u5927\u4e8e", (String)"CheckVerifyBillPlugin_5", (String)"fi-arapcommon", (Object[])new Object[0]);
                break;
            }
            case "<": {
                cpDisplayName = ResManager.loadKDString((String)"\u5c0f\u4e8e", (String)"CheckVerifyBillPlugin_6", (String)"fi-arapcommon", (Object[])new Object[0]);
                break;
            }
            case "=": {
                cpDisplayName = ResManager.loadKDString((String)"\u7b49\u4e8e", (String)"CheckVerifyBillPlugin_7", (String)"fi-arapcommon", (Object[])new Object[0]);
                break;
            }
            case "in": {
                cpDisplayName = ResManager.loadKDString((String)"\u7b49\u4e8e", (String)"CheckVerifyBillPlugin_7", (String)"fi-arapcommon", (Object[])new Object[0]);
                break;
            }
            case "<>": {
                cpDisplayName = ResManager.loadKDString((String)"\u4e0d\u7b49\u4e8e", (String)"CheckVerifyBillPlugin_8", (String)"fi-arapcommon", (Object[])new Object[0]);
                break;
            }
            case "not in": {
                cpDisplayName = ResManager.loadKDString((String)"\u4e0d\u7b49\u4e8e", (String)"CheckVerifyBillPlugin_8", (String)"fi-arapcommon", (Object[])new Object[0]);
            }
        }
        return cpDisplayName;
    }

    protected boolean getSubmitSettleParam() {
        DynamicObject org;
        boolean flag = false;
        String settleRelation = (String)this.getModel().getValue("settlerelation");
        if (SettleRelationEnum.APPAYSETTLE.getValue().equals(settleRelation)) {
            DynamicObject org2 = (DynamicObject)this.getModel().getValue("org");
            if (org2 != null) {
                flag = SystemParameterHelper.getAPBooleanParam(org2.getLong("id"), "ap_016");
            }
        } else if (SettleRelationEnum.RECSETTLE.getValue().equals(settleRelation) && (org = (DynamicObject)this.getModel().getValue("org")) != null) {
            flag = SystemParameterHelper.getARBooleanParam(org.getLong("id"), "ar_016");
        }
        return flag;
    }
}

