/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.form;

import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.field.DateEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.arapcommon.util.DateUtils;
import kd.fi.arapcommon.util.StringUtils;

public class CloseAccountSettingPluginBase
extends AbstractFormPlugin
implements ClickListener {
    protected static final String OP_CLOSE_ACCOUNT = "closeaccount";
    protected static final String OP_ANTI_CLOSE_ACCOUNT = "anticloseaccount";
    private DynamicObject[] closeAccountInfos;

    private DynamicObject[] getCloseAccountInfos() {
        if (this.closeAccountInfos == null) {
            List pks = (List)this.getView().getFormShowParameter().getCustomParam("pks");
            this.closeAccountInfos = BusinessDataServiceHelper.load((String)this.getCloseAccountEntity(), (String)this.getSelectors(), (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)pks)});
        }
        return this.closeAccountInfos;
    }

    protected String getCloseAccountEntity() {
        throw new RuntimeException(ResManager.loadKDString((String)"\u5b50\u7c7b\u8981\u8986\u5199\uff0c\u8fd4\u56de\u5173\u8d26\u5b9e\u4f53\u6807\u8bc6\uff0c\u77e5\u9053\u4e86\u5417\uff1f", (String)"CloseAccountSettingPluginBase_0", (String)"fi-arapcommon", (Object[])new Object[0]));
    }

    private boolean isCloseAcountOperation() {
        String operation = (String)this.getView().getFormShowParameter().getCustomParam("operation");
        return OP_CLOSE_ACCOUNT.equals(operation);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        DynamicObject[] closeAccountInfos = this.getCloseAccountInfos();
        ArrayList<Long> orgIds = new ArrayList<Long>(64);
        for (DynamicObject info : closeAccountInfos) {
            orgIds.add(info.getDynamicObject("org").getLong("id"));
        }
        this.getModel().setValue("org", (Object)orgIds.toArray());
        if (this.isCloseAcountOperation()) {
            this.closeAccountFormInit(closeAccountInfos);
        } else {
            this.antiCloseAccountFormInit(closeAccountInfos);
        }
    }

    private void closeAccountFormInit(DynamicObject[] closeAccountInfos) {
        Date maxCurrentDate = this.getExtremeDate(closeAccountInfos, "currentdate", true);
        Date defaultCloseDate = DateUtils.getMaxMonthDate(maxCurrentDate);
        this.getModel().setValue("closedate", (Object)defaultCloseDate);
        if (closeAccountInfos.length == 1) {
            DateEdit closeDateEdit = (DateEdit)this.getControl("closedate");
            closeDateEdit.setMinDate(maxCurrentDate);
        }
        Label notice = (Label)this.getControl("notice");
        notice.setText(ResManager.loadKDString((String)"\u63d0\u793a\uff1a\u6240\u9009\u7ec4\u7ec7\u6267\u884c\u5173\u8d26\u540e\uff0c\u5c06\u4e0d\u80fd\u7ef4\u62a4\u5173\u8d26\u65e5\u671f\u4e4b\u524d\u7684\u4e1a\u52a1\u3002", (String)"CloseAccountSettingPluginBase_1", (String)"fi-arapcommon", (Object[])new Object[0]));
    }

    private void antiCloseAccountFormInit(DynamicObject[] closeAccountInfos) {
        Date minMonthDate;
        Date maxStartDate = this.getExtremeDate(closeAccountInfos, "startdate", true);
        Date minCurrentDate = this.getExtremeDate(closeAccountInfos, "currentdate", false);
        minCurrentDate = DateUtils.getLastDay(minCurrentDate, 1);
        maxStartDate = DateUtils.getLastDay(maxStartDate, 1);
        Date defaultAntiCloseDate = null;
        defaultAntiCloseDate = minCurrentDate.before(maxStartDate) ? maxStartDate : (maxStartDate.after(defaultAntiCloseDate = DateUtils.getLastDay(minMonthDate = DateUtils.getMinMonthDate(minCurrentDate), 1)) ? maxStartDate : defaultAntiCloseDate);
        this.getModel().setValue("closedate", (Object)defaultAntiCloseDate);
        DateEdit aimDateEdit = (DateEdit)this.getControl("closedate");
        aimDateEdit.setCaption(new LocaleString(ResManager.loadKDString((String)"\u53cd\u5173\u8d26\u65e5\u671f", (String)"CloseAccountSettingPluginBase_2", (String)"fi-arapcommon", (Object[])new Object[0])));
        if (closeAccountInfos.length == 1) {
            aimDateEdit.setMinDate(maxStartDate);
            aimDateEdit.setMaxDate(minCurrentDate);
        }
        Label notice = (Label)this.getControl("notice");
        notice.setText(ResManager.loadKDString((String)"\u63d0\u793a\uff1a\u6240\u9009\u7ec4\u7ec7\u6267\u884c\u201c\u53cd\u5173\u8d26\u201d\u540e\uff0c\u201c\u5f53\u524d\u65e5\u671f\u201d\u5c06\u66f4\u65b0\u5230\u201c\u53cd\u5173\u8d26\u65e5\u671f\u201d\u7684\u540e\u4e00\u5929\uff0c\u53ef\u7ef4\u62a4\u201c\u5f53\u524d\u65e5\u671f\u201d\u4e4b\u524d\u7684\u4e1a\u52a1\u3002", (String)"CloseAccountSettingPluginBase_3", (String)"fi-arapcommon", (Object[])new Object[0]));
    }

    private Date getExtremeDate(DynamicObject[] closeAccountInfos, String dateName, boolean getMax) {
        Date aimDate = null;
        for (DynamicObject info : closeAccountInfos) {
            Date date = info.getDate(dateName);
            if (date == null) continue;
            if (aimDate != null) {
                if (getMax) {
                    aimDate = aimDate.after(date) ? aimDate : date;
                    continue;
                }
                aimDate = aimDate.before(date) ? aimDate : date;
                continue;
            }
            aimDate = date;
        }
        return aimDate;
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"confirm", "cancel"});
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        String key = source.getKey();
        if ("confirm".equals(key)) {
            this.confirm();
        }
    }

    private void confirm() {
        Date aimDate = (Date)this.getModel().getValue("closedate");
        this.getView().returnDataToParent((Object)aimDate);
        this.getView().close();
    }

    private String getSelectors() {
        ArrayList<String> selectors = new ArrayList<String>();
        selectors.add("org");
        selectors.add("isfinishinit");
        selectors.add("currentdate");
        selectors.add("startdate");
        selectors.add("entryentity");
        selectors.add("entryentity.failedmessage");
        selectors.add("entryentity.billtype");
        selectors.add("entryentity.count");
        selectors.add("entryentity.duedate");
        selectors.add("entryentity.status");
        return StringUtils.listToString(selectors);
    }
}

