/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.form;

import java.util.EventObject;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.CRCondition;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.LargeTextEdit;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.metadata.treebuilder.FormTreeBuilder;

public class DataCheckItemEdit
extends AbstractBillPlugIn {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"customdesc"});
    }

    public void afterBindData(EventObject e) {
        String checktype = (String)this.getModel().getValue("checktype");
        this.setStatusByCheckType(checktype);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String name = e.getProperty().getName();
        ChangeData[] changeData = e.getChangeSet();
        Object newValue = changeData[0].getNewValue();
        if ("checktype".equals(name)) {
            this.setStatusByCheckType(newValue.toString());
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if ("customdesc".equals(key)) {
            DynamicObject bizobj = (DynamicObject)this.getModel().getValue("bizobj");
            if (bizobj == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5de1\u67e5\u5bf9\u8c61\u3002", (String)"DataCheckItemEdit_0", (String)"fi-arapcommon", (Object[])new Object[0]));
                return;
            }
            MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)bizobj.getString("id"));
            TreeNode srcBillNode = FormTreeBuilder.buildDynamicPropertyTree((MainEntityType)mainType, null);
            String fldNodes = SerializationUtils.toJsonString((Object)srcBillNode);
            LargeTextEdit largeTextEdit = (LargeTextEdit)this.getView().getControl("customfilter");
            String conditionJson = (String)this.getModel().getValue(largeTextEdit.getTagFieldKey());
            this.showConditionForm(conditionJson, mainType.getName(), false, fldNodes, key);
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        String returnData = (String)closedCallBackEvent.getReturnData();
        if ("customdesc".equals(actionId) && StringUtils.isNotBlank((CharSequence)returnData)) {
            CRCondition condition = (CRCondition)SerializationUtils.fromJsonString((String)returnData, CRCondition.class);
            this.getModel().setValue("customfilter_tag", (Object)returnData);
            if (condition.getExprDesc().length() > 255) {
                this.getModel().setValue("customdesc", (Object)condition.getExprDesc().substring(0, 255));
            } else {
                this.getModel().setValue("customdesc", (Object)condition.getExprDesc());
            }
        }
    }

    private void setStatusByCheckType(String checkType) {
        if ("plugin".equals(checkType)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"plugin"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"customdesc", "tips"});
            this.getModel().setValue("customdesc", null);
            this.getModel().setValue("customfilter", null);
            this.getModel().setValue("tips", null);
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{"plugin"});
            this.getModel().setValue("plugin", (Object)"kd.fi.arapcommon.check.impl.CustomCheckDefaultService");
            this.getView().setEnable(Boolean.FALSE, new String[]{"plugin"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"customdesc", "tips"});
        }
    }

    private void showConditionForm(String conditionJson, String entityNumber, boolean onlyHeadFields, String fieldNodes, String sourceCtrlKey) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("botp_condition");
        showParameter.getCustomParams().put("formula", conditionJson);
        showParameter.getCustomParams().put("entitynumber", entityNumber);
        showParameter.getCustomParams().put("onlyheadfield", String.valueOf(onlyHeadFields));
        showParameter.getCustomParams().put("treenodes", fieldNodes);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, sourceCtrlKey));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(showParameter);
    }
}

