/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.form;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.lang.Lang;
import kd.bos.list.BillList;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.JobType;
import kd.bos.schedule.form.JobForm;
import kd.bos.schedule.form.JobFormInfo;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.arapcommon.check.helper.DataCheckHelper;
import kd.fi.arapcommon.check.param.DataCheckExecStatusEnum;
import kd.fi.arapcommon.check.param.DataCheckTaskParam;

public class DataCheckResultList
extends AbstractListPlugin {
    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        String key = e.getOperateKey();
        if ("beforeexecute".equalsIgnoreCase(key)) {
            this.openFilterView();
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String actionId = closedCallBackEvent.getActionId();
        if ("checkcondition".equals(actionId)) {
            HashMap returnData = (HashMap)closedCallBackEvent.getReturnData();
            if (returnData != null) {
                Date bizBeginDate = (Date)returnData.get("startdate");
                Date bizEndDate = (Date)returnData.get("enddate");
                BillList billList = (BillList)this.getView().getControl("billlistap");
                ListSelectedRowCollection selectedRows = billList.getSelectedRows();
                Object[] primaryKeyValues = selectedRows.getPrimaryKeyValues();
                Object[] results = BusinessDataServiceHelper.load((String)"ap_datacheckresult", (String)"org,bizobj,bizbegindate,bizenddate,execstatus,checkresult,checkdate,traceid,checktime,checkendtime,e_checkitem,e_execbegintime,e_execendtime,e_execstatus,e_cost,e_traceid,e_checkresult,e_billcount,e_errorcount,e_exception,e_exception_tag,s_billno", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)primaryKeyValues)});
                if (ObjectUtils.isEmpty((Object[])results)) {
                    return;
                }
                for (Object result : results) {
                    result.set("bizbegindate", (Object)bizBeginDate);
                    result.set("bizenddate", (Object)bizEndDate);
                    result.set("execstatus", (Object)DataCheckExecStatusEnum.WAIT.getValue());
                    result.set("checkresult", (Object)" ");
                    result.set("checkdate", (Object)new Date());
                    result.set("traceid", (Object)RequestContext.get().getTraceId());
                    result.set("checktime", null);
                    result.set("checkendtime", null);
                    DynamicObjectCollection entries = result.getDynamicObjectCollection("entry");
                    for (DynamicObject entry : entries) {
                        entry.set("e_execbegintime", null);
                        entry.set("e_execendtime", null);
                        entry.set("e_execstatus", (Object)DataCheckExecStatusEnum.WAIT.getValue());
                        entry.set("e_cost", (Object)0);
                        entry.set("e_traceid", (Object)" ");
                        entry.set("e_checkresult", (Object)" ");
                        entry.set("e_billcount", (Object)0);
                        entry.set("e_errorcount", (Object)0);
                        entry.set("e_exception", (Object)" ");
                        entry.set("e_exception_tag", null);
                        entry.getDynamicObjectCollection("subentry").clear();
                    }
                }
                DynamicObject[] newResults = (DynamicObject[])SaveServiceHelper.save((DynamicObject[])results);
                this.getView().invokeOperation("refresh");
                List<DataCheckTaskParam> taskParamList = DataCheckHelper.convertTaskParam(newResults);
                this.execBigJob(taskParamList);
            }
        } else if ("jobcloseback".equals(actionId)) {
            this.getView().invokeOperation("refresh");
        }
    }

    private void openFilterView() {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("ap_helathcondition");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "checkcondition"));
        this.getView().showForm(showParameter);
    }

    private void execBigJob(List<DataCheckTaskParam> taskParamList) {
        JobInfo jobInfo = new JobInfo();
        jobInfo.setRunByLang(Lang.get());
        jobInfo.setAppId(this.getView().getFormShowParameter().getAppId());
        jobInfo.setJobType(JobType.REALTIME);
        jobInfo.setName("datacheck job");
        jobInfo.setTaskClassname("kd.fi.arapcommon.check.impl.DataCheckExecTask");
        jobInfo.setId(UUID.randomUUID().toString());
        HashMap<String, String> parameterMap = new HashMap<String, String>(16);
        parameterMap.put("taskParamList", SerializationUtils.toJsonString(taskParamList));
        jobInfo.setParams(parameterMap);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "jobcloseback");
        JobFormInfo formInfo = new JobFormInfo(jobInfo);
        formInfo.setCloseCallBack(closeCallBack);
        formInfo.setCanBackground(true);
        formInfo.setCanStop(true);
        formInfo.setTimeout(3600000);
        JobForm.dispatch((JobFormInfo)formInfo, (IFormView)this.getView());
    }
}

