/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.form;

import java.math.BigDecimal;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.fi.arapcommon.business.price.AbstractPriceCalculator;
import kd.fi.arapcommon.business.price.PriceLocalCalculator;
import kd.fi.arapcommon.business.price.PriceTaxTotalCalculator;
import kd.fi.arapcommon.business.price.TaxUnitPriceCalculator;
import kd.fi.arapcommon.business.price.UnitPriceCalculator;
import kd.fi.arapcommon.helper.BaseDataHelper;
import kd.fi.arapcommon.service.EditInBulkService;

public class EditInBulkPlugin
extends AbstractFormPlugin {
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        FormShowParameter parameter = this.getView().getFormShowParameter();
        String parentEntityId = (String)parameter.getCustomParam("parentEntityId");
        if (ObjectUtils.isEmpty((Object)parentEntityId)) {
            this.initEntry();
            parentEntityId = this.getView().getParentView().getEntityId();
        }
        EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
        if ("ar_finarbill".equals(parentEntityId)) {
            entryGrid.setColumnProperty("e_pricetaxtotal", "header", (Object)new LocaleString(ResManager.loadKDString((String)"\u5e94\u6536\u91d1\u989d", (String)"EditInBulkPlugin_0", (String)"fi-arapcommon", (Object[])new Object[0])));
        } else if ("ap_finapbill".equals(parentEntityId)) {
            entryGrid.setColumnProperty("e_pricetaxtotal", "header", (Object)new LocaleString(ResManager.loadKDString((String)"\u5e94\u4ed8\u91d1\u989d", (String)"EditInBulkPlugin_1", (String)"fi-arapcommon", (Object[])new Object[0])));
        }
    }

    private void initEntry() {
        EditInBulkService EditInBulkService2 = new EditInBulkService(this.getView());
        Map<String, List<Integer>> srcEntryRowMap = EditInBulkService2.prepareData();
        this.getPageCache().put("srcEntryRowMap", SerializationUtils.toJsonString(srcEntryRowMap));
        EditInBulkService2.fillentry();
        for (int i = 0; i < this.getModel().getEntryRowCount("entryentity"); ++i) {
            this.calculatorEntryPrice(i, false);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        ChangeData[] changeData = e.getChangeSet();
        Object newValue = changeData[0].getNewValue();
        int index = changeData[0].getRowIndex();
        this.getModel().setValue("e_ischange", (Object)Boolean.TRUE, index);
        switch (e.getProperty().getName()) {
            case "e_discountmode": {
                if ("NULL".equals(newValue) || ObjectUtils.isEmpty((Object)newValue)) {
                    this.getModel().setValue("e_discountrate", (Object)BigDecimal.ZERO, index);
                    return;
                }
            }
            case "e_discountrate": {
                BigDecimal discountrate;
                String discountmode = (String)this.getModel().getValue("e_discountmode", index);
                if ("PERCENT".equals(discountmode) && (discountrate = (BigDecimal)this.getModel().getValue("e_discountrate", index)).compareTo(new BigDecimal(100)) > 0) {
                    this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u5f55\u5165\u4e0d\u8d85\u8fc7100\u7684\u6570\u5b57\u3002", (String)"EditInBulkPlugin_2", (String)"fi-arapcommon", (Object[])new Object[0]));
                    this.getModel().setValue("e_discountrate", (Object)BigDecimal.ZERO, index);
                    return;
                }
                this.calculatorEntryAmt(index);
                break;
            }
            case "e_taxrateid": {
                if (!ObjectUtils.isEmpty((Object)newValue)) {
                    this.getModel().setValue("e_taxrate", (Object)((DynamicObject)newValue).getBigDecimal("taxrate"));
                } else {
                    this.getModel().setValue("e_taxrate", (Object)0);
                }
            }
            case "e_unitprice": 
            case "e_taxunitprice": {
                this.calculatorEntryAmt(index);
                break;
            }
            case "e_amount": 
            case "e_pricetaxtotal": {
                this.calculatorEntryPrice(index, true);
            }
        }
    }

    protected void calculatorEntryAmt(int index) {
        IDataModel m = this.getModel();
        boolean includeTax = (Boolean)m.getValue("isincludetax");
        DynamicObject currency = (DynamicObject)m.getValue("currency");
        int precision = currency.getInt("amtprecision");
        BigDecimal qty = (BigDecimal)m.getValue("e_quantity", index);
        BigDecimal taxRate = (BigDecimal)m.getValue("e_taxrate", index);
        String discountMode = (String)m.getValue("e_discountmode", index);
        BigDecimal discountRate = (BigDecimal)m.getValue("e_discountrate", index);
        AbstractPriceCalculator calculator = null;
        if (includeTax) {
            BigDecimal taxUnitPrice = (BigDecimal)m.getValue("e_taxunitprice", index);
            calculator = new TaxUnitPriceCalculator(qty, taxUnitPrice, taxRate, discountMode, discountRate, precision);
        } else {
            BigDecimal unitPrice = (BigDecimal)m.getValue("e_unitprice", index);
            calculator = new UnitPriceCalculator(qty, unitPrice, taxRate, discountMode, discountRate, precision);
        }
        PriceLocalCalculator localCalculator = new PriceLocalCalculator(calculator, BigDecimal.ONE, 10);
        localCalculator.calculate();
        this.resetEntryProp(localCalculator, index, true);
    }

    private void calculatorEntryPrice(int index, boolean isAddTaxAndAmount) {
        IDataModel m = this.getModel();
        boolean includeTax = (Boolean)m.getValue("isincludetax");
        int precision = 2;
        DynamicObject currency = (DynamicObject)m.getValue("currency");
        if (!ObjectUtils.isEmpty((Object)currency)) {
            precision = currency.getInt("amtprecision");
        }
        BigDecimal qty = (BigDecimal)m.getValue("e_quantity", index);
        BigDecimal taxRate = (BigDecimal)m.getValue("e_taxrate", index);
        String discountMode = (String)m.getValue("e_discountmode", index);
        BigDecimal discountRate = (BigDecimal)m.getValue("e_discountrate", index);
        PriceTaxTotalCalculator calculator = null;
        if (includeTax) {
            BigDecimal pricetaxtotal = (BigDecimal)m.getValue("e_pricetaxtotal", index);
            calculator = new PriceTaxTotalCalculator(qty, pricetaxtotal, taxRate, discountMode, discountRate, precision);
        }
        PriceLocalCalculator localCalculator = new PriceLocalCalculator(calculator, BigDecimal.ONE, 10);
        localCalculator.calculate();
        this.resetEntryProp(localCalculator, index, isAddTaxAndAmount);
    }

    private void resetEntryProp(PriceLocalCalculator localCalculator, int index, boolean isAddTaxAndAmount) {
        IDataModel m = this.getModel();
        m.beginInit();
        m.setValue("e_unitprice", (Object)localCalculator.getUnitprice(), index);
        m.setValue("e_taxunitprice", (Object)localCalculator.getTaxunitprice(), index);
        m.setValue("e_discountamount", (Object)localCalculator.getDiscountamount(), index);
        if (isAddTaxAndAmount) {
            m.setValue("e_tax", (Object)localCalculator.getTax(), index);
            m.setValue("e_amount", (Object)localCalculator.getAmount(), index);
        }
        m.setValue("e_pricetaxtotal", (Object)localCalculator.getPricetaxtotal(), index);
        m.endInit();
        this.getView().updateView("entryentity", index);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btnok"});
        this.taxratefilter();
    }

    private void taxratefilter() {
        Date bizdate = (Date)this.getModel().getValue("bizdate");
        BasedataEdit taxrateF7 = (BasedataEdit)this.getControl("e_taxrateid");
        BaseDataHelper.taxratefilter(bizdate, taxrateF7);
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        String key = source.getKey();
        if ("btnok".equals(key)) {
            DynamicObjectCollection entrys = this.getModel().getEntryEntity("entryentity");
            HashMap<String, Object> returnData = new HashMap<String, Object>();
            returnData.put("entrys", entrys);
            Map srcEntryRowMap = (Map)SerializationUtils.fromJsonString((String)this.getPageCache().get("srcEntryRowMap"), Map.class);
            returnData.put("srcEntryRowMap", srcEntryRowMap);
            this.getView().returnDataToParent(returnData);
            this.getView().close();
        }
    }
}

