/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.form;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.arapcommon.business.price.AbstractPriceCalculator;
import kd.fi.arapcommon.business.price.FxLocalCalculator;
import kd.fi.arapcommon.business.price.PriceTaxTotalCalculator;
import kd.fi.arapcommon.business.price.PriceTotalCalculator;
import kd.fi.arapcommon.business.price.TaxUnitPriceCalculator;
import kd.fi.arapcommon.business.price.UnitPriceCalculator;
import kd.fi.arapcommon.model.BillModelFactory;
import kd.fi.arapcommon.model.FinBillModel;
import kd.fi.arapcommon.service.ToleranceMatchService;
import kd.fi.arapcommon.util.EntityMetadataUtils;

public class FxLocalAmtHandler {
    private DynamicObject toleranceScheme;
    private String entityKey;
    private FinBillModel billModel;
    private boolean isTaxLocal;
    private boolean isAmtLocal;
    private boolean isPriceTaxLocal;
    private Map<Long, List<Long>> materialIdToMaterialgroup = new HashMap<Long, List<Long>>(16);

    public FxLocalAmtHandler(String entityKey) {
        this.entityKey = entityKey;
        this.billModel = (FinBillModel)BillModelFactory.getModel(entityKey);
    }

    public DynamicObject getToleranceScheme() {
        if (this.toleranceScheme == null) {
            boolean isAp = "ap_finapbill".equals(this.entityKey);
            this.toleranceScheme = BusinessDataServiceHelper.loadSingleFromCache((String)"ap_tolerancescheme", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)(isAp ? "RC079" : "RC080")), new QFilter("enable", "=", (Object)Boolean.TRUE)});
        }
        return this.toleranceScheme;
    }

    public boolean getFormToleranceServiceResult(int index, String key, BigDecimal newValue, IDataModel model) {
        this.getToleranceScheme();
        if (ObjectUtils.isEmpty((Object)this.toleranceScheme)) {
            return false;
        }
        if (this.isToToleranceValidator()) {
            return false;
        }
        this.materialIdToMaterialgroup = this.buildMaterialGroupMap(model);
        Map<String, BigDecimal> amountLocalMap = this.buildOldAmountLocalMap(model, index);
        List<Object> taxLocalToleranceParams = new ArrayList(8);
        List<Object> amtLocalToleranceParams = new ArrayList(8);
        List<Object> priceTaxLocalToleranceParams = new ArrayList(8);
        if (this.isTaxLocal) {
            taxLocalToleranceParams = this.buildFormToleranceCompareParam(model, index, amountLocalMap, this.billModel.E_TAXLOCALAMT, key, newValue);
        }
        if (this.isAmtLocal) {
            amtLocalToleranceParams = this.buildFormToleranceCompareParam(model, index, amountLocalMap, this.billModel.E_LOCALAMT, key, newValue);
        }
        if (this.isPriceTaxLocal) {
            priceTaxLocalToleranceParams = this.buildFormToleranceCompareParam(model, index, amountLocalMap, this.billModel.E_PRICETAXTOTALLOC, key, newValue);
        }
        List<Object> taxLocalToleranceResult = new ArrayList(16);
        List<Object> amtLocalToleranceResult = new ArrayList(16);
        List<Object> priceTaxLocalToleranceResult = new ArrayList(16);
        ToleranceMatchService service = new ToleranceMatchService();
        if (taxLocalToleranceParams.size() > 0 && this.isTaxLocal) {
            taxLocalToleranceResult = service.matchAndCompareComm(this.toleranceScheme, this.billModel.E_TAXLOCALAMT, this.billModel.E_TAXLOCALAMT, taxLocalToleranceParams);
        }
        if (amtLocalToleranceParams.size() > 0 && this.isAmtLocal) {
            amtLocalToleranceResult = service.matchAndCompareComm(this.toleranceScheme, this.billModel.E_LOCALAMT, this.billModel.E_LOCALAMT, amtLocalToleranceParams);
        }
        if (priceTaxLocalToleranceParams.size() > 0 && this.isPriceTaxLocal) {
            priceTaxLocalToleranceResult = service.matchAndCompareComm(this.toleranceScheme, this.billModel.E_PRICETAXTOTALLOC, this.billModel.E_PRICETAXTOTALLOC, priceTaxLocalToleranceParams);
        }
        HashSet<Integer> overSeqSet = new HashSet<Integer>(2);
        for (Map map : taxLocalToleranceResult) {
            overSeqSet.add((Integer)map.get("pk"));
        }
        for (Map map : amtLocalToleranceResult) {
            overSeqSet.add((Integer)map.get("pk"));
        }
        for (Map map : priceTaxLocalToleranceResult) {
            overSeqSet.add((Integer)map.get("pk"));
        }
        return !ObjectUtils.isEmpty(overSeqSet);
    }

    public boolean getImportToleranceServiceResult(int index, IDataModel model) {
        this.getToleranceScheme();
        if (ObjectUtils.isEmpty((Object)this.toleranceScheme)) {
            return false;
        }
        if (this.isToToleranceValidator()) {
            return false;
        }
        this.materialIdToMaterialgroup = this.buildMaterialGroupMap(model);
        Map<String, BigDecimal> amountLocalMap = this.buildOldAmountLocalMap(model, index);
        List<Object> taxLocalToleranceParams = new ArrayList(8);
        List<Object> amtLocalToleranceParams = new ArrayList(8);
        List<Object> priceTaxLocalToleranceParams = new ArrayList(8);
        if (this.isTaxLocal) {
            taxLocalToleranceParams = this.buildImportToleranceCompareParam(model, index, amountLocalMap, this.billModel.E_TAXLOCALAMT);
        }
        if (this.isAmtLocal) {
            amtLocalToleranceParams = this.buildImportToleranceCompareParam(model, index, amountLocalMap, this.billModel.E_LOCALAMT);
        }
        if (this.isPriceTaxLocal) {
            priceTaxLocalToleranceParams = this.buildImportToleranceCompareParam(model, index, amountLocalMap, this.billModel.E_PRICETAXTOTALLOC);
        }
        List<Object> taxLocalToleranceResult = new ArrayList(16);
        List<Object> amtLocalToleranceResult = new ArrayList(16);
        List<Object> priceTaxLocalToleranceResult = new ArrayList(16);
        ToleranceMatchService service = new ToleranceMatchService();
        if (taxLocalToleranceParams.size() > 0 && this.isTaxLocal) {
            taxLocalToleranceResult = service.matchAndCompareComm(this.toleranceScheme, this.billModel.E_TAXLOCALAMT, this.billModel.E_TAXLOCALAMT, taxLocalToleranceParams);
        }
        if (amtLocalToleranceParams.size() > 0 && this.isAmtLocal) {
            amtLocalToleranceResult = service.matchAndCompareComm(this.toleranceScheme, this.billModel.E_LOCALAMT, this.billModel.E_LOCALAMT, amtLocalToleranceParams);
        }
        if (priceTaxLocalToleranceParams.size() > 0 && this.isPriceTaxLocal) {
            priceTaxLocalToleranceResult = service.matchAndCompareComm(this.toleranceScheme, this.billModel.E_PRICETAXTOTALLOC, this.billModel.E_PRICETAXTOTALLOC, priceTaxLocalToleranceParams);
        }
        HashSet<Integer> overSeqSet = new HashSet<Integer>(2);
        for (Map map : taxLocalToleranceResult) {
            overSeqSet.add((Integer)map.get("pk"));
        }
        for (Map map : amtLocalToleranceResult) {
            overSeqSet.add((Integer)map.get("pk"));
        }
        for (Map map : priceTaxLocalToleranceResult) {
            overSeqSet.add((Integer)map.get("pk"));
        }
        return !ObjectUtils.isEmpty(overSeqSet);
    }

    private Map<String, BigDecimal> buildOldAmountLocalMap(IDataModel model, int index) {
        BigDecimal amountLocal;
        BigDecimal taxLocal;
        BigDecimal priceTaxTotalLocal;
        boolean includeTax = (Boolean)model.getValue(this.billModel.HEAD_ISINCLUDETAX);
        BigDecimal exchangeRate = (BigDecimal)model.getValue(this.billModel.HEAD_EXCHANGERATE);
        String quotation = (String)model.getValue(this.billModel.HEAD_QUOTATION);
        DynamicObject baseCurrency = (DynamicObject)model.getValue(this.billModel.HEAD_BASECURRENCY);
        BigDecimal adjustamount = (BigDecimal)model.getValue(this.billModel.E_ADJUSTAMOUNT, index);
        if ("1".equals(quotation) && exchangeRate.compareTo(BigDecimal.ZERO) == 0) {
            quotation = "0";
        }
        int localPrecision = 2;
        if (!ObjectUtils.isEmpty((Object)baseCurrency)) {
            localPrecision = baseCurrency.getInt("amtprecision");
        }
        BigDecimal tax = (BigDecimal)model.getValue(this.billModel.E_TAX, index);
        BigDecimal amount = (BigDecimal)model.getValue(this.billModel.E_AMOUNT, index);
        BigDecimal priceTaxTotal = (BigDecimal)model.getValue(this.billModel.E_PRICETAXTOTAL, index);
        HashMap<String, BigDecimal> amountLocalMap = new HashMap<String, BigDecimal>(4);
        if (includeTax) {
            BigDecimal adjustAmtLocal;
            if ("1".equals(quotation)) {
                priceTaxTotalLocal = priceTaxTotal.divide(exchangeRate, localPrecision, RoundingMode.HALF_UP);
                taxLocal = tax.divide(exchangeRate, localPrecision, RoundingMode.HALF_UP);
                adjustAmtLocal = adjustamount.divide(exchangeRate, localPrecision, RoundingMode.HALF_UP);
            } else {
                priceTaxTotalLocal = priceTaxTotal.multiply(exchangeRate).setScale(localPrecision, RoundingMode.HALF_UP);
                taxLocal = tax.multiply(exchangeRate).setScale(localPrecision, RoundingMode.HALF_UP);
                adjustAmtLocal = adjustamount.multiply(exchangeRate).setScale(localPrecision, RoundingMode.HALF_UP);
            }
            amountLocal = priceTaxTotalLocal.subtract(taxLocal).subtract(adjustAmtLocal).setScale(localPrecision, RoundingMode.HALF_UP);
        } else {
            BigDecimal adjustAmtLocal;
            if ("1".equals(quotation)) {
                taxLocal = tax.divide(exchangeRate, localPrecision, RoundingMode.HALF_UP);
                amountLocal = amount.divide(exchangeRate, localPrecision, RoundingMode.HALF_UP);
                adjustAmtLocal = adjustamount.divide(exchangeRate, localPrecision, RoundingMode.HALF_UP);
            } else {
                taxLocal = tax.multiply(exchangeRate).setScale(localPrecision, RoundingMode.HALF_UP);
                amountLocal = amount.multiply(exchangeRate).setScale(localPrecision, RoundingMode.HALF_UP);
                adjustAmtLocal = adjustamount.multiply(exchangeRate).setScale(localPrecision, RoundingMode.HALF_UP);
            }
            priceTaxTotalLocal = amountLocal.add(taxLocal).add(adjustAmtLocal).setScale(localPrecision, RoundingMode.HALF_UP);
        }
        amountLocalMap.put("taxlocal", taxLocal);
        amountLocalMap.put("amtlocal", amountLocal);
        amountLocalMap.put("pricetaxtotallocal", priceTaxTotalLocal);
        return amountLocalMap;
    }

    private Map<String, Object> buildParam(IDataModel model, int index) {
        Object tempMaterial = model.getValue(this.billModel.E_MATERIAL);
        Long orgId = model.getValue(this.billModel.HEAD_ORG) == null ? null : Long.valueOf(((DynamicObject)model.getValue(this.billModel.HEAD_ORG)).getLong("id"));
        String asstactType = model.getValue(this.billModel.HEAD_ASSTACTTYPE) == null ? null : (String)model.getValue(this.billModel.HEAD_ASSTACTTYPE);
        Long asstactId = model.getValue(this.billModel.HEAD_ASSTACT) == null ? null : Long.valueOf(((DynamicObject)model.getValue(this.billModel.HEAD_ASSTACT)).getLong("id"));
        Long currencyId = model.getValue(this.billModel.HEAD_CURRENCY) == null ? null : Long.valueOf(((DynamicObject)model.getValue(this.billModel.HEAD_CURRENCY)).getLong("id"));
        Integer amtPrecision = model.getValue(this.billModel.HEAD_CURRENCY) == null ? null : Integer.valueOf(((DynamicObject)model.getValue(this.billModel.HEAD_CURRENCY)).getInt("amtprecision"));
        Integer entrySeq = (Integer)model.getValue(this.billModel.E_SEQ, index);
        HashMap<String, Object> paramMap = new HashMap<String, Object>(16);
        long materialId = 0L;
        if (tempMaterial != null) {
            DynamicObject material = (DynamicObject)tempMaterial;
            materialId = material.getLong("id");
        }
        if (asstactType != null) {
            if ("bd_supplier".equals(asstactType)) {
                paramMap.put("bd_supplier", asstactId);
                paramMap.put("bd_customer", null);
            } else {
                paramMap.put("bd_customer", asstactId);
                paramMap.put("bd_supplier", null);
            }
        } else {
            paramMap.put("bd_customer", null);
            paramMap.put("bd_supplier", null);
        }
        paramMap.put("bd_currency", currencyId);
        paramMap.put("bd_material", materialId);
        paramMap.put("bd_materialgroup", this.materialIdToMaterialgroup.get(materialId));
        paramMap.put("bos_org", orgId);
        paramMap.put("precision", amtPrecision);
        paramMap.put("pk", entrySeq);
        return paramMap;
    }

    private List<Map<String, Object>> buildFormToleranceCompareParam(IDataModel model, int index, Map<String, BigDecimal> amountLocalMap, String compareKey, String key, BigDecimal newValue) {
        BigDecimal contrastValue;
        BigDecimal controlValue;
        FxLocalCalculator fxLocalCalculator = this.buildNewAmountLocalCalcutor(model, key, index, newValue);
        fxLocalCalculator.calculate();
        Map<String, Object> paramMap = this.buildParam(model, index);
        ArrayList<Map<String, Object>> resultMap = new ArrayList<Map<String, Object>>(8);
        if (this.billModel.E_TAXLOCALAMT.equals(compareKey)) {
            controlValue = fxLocalCalculator.getTaxLocal();
            contrastValue = amountLocalMap.get("taxlocal");
        } else if (this.billModel.E_LOCALAMT.equals(compareKey)) {
            controlValue = fxLocalCalculator.getAmountLocal();
            contrastValue = amountLocalMap.get("amtlocal");
        } else {
            controlValue = fxLocalCalculator.getPriceTaxTotalLocal();
            contrastValue = amountLocalMap.get("pricetaxtotallocal");
        }
        paramMap.put("controlvalue", controlValue);
        paramMap.put("contrastvalue", contrastValue);
        resultMap.add(paramMap);
        return resultMap;
    }

    private List<Map<String, Object>> buildImportToleranceCompareParam(IDataModel model, int index, Map<String, BigDecimal> amountLocalMap, String compareKey) {
        BigDecimal contrastValue;
        BigDecimal controlValue;
        BigDecimal oldTaxLocal = (BigDecimal)model.getValue(this.billModel.E_TAXLOCALAMT, index);
        BigDecimal oldAmountLocal = (BigDecimal)model.getValue(this.billModel.E_LOCALAMT, index);
        BigDecimal oldPriceTaxLocal = (BigDecimal)model.getValue(this.billModel.E_PRICETAXTOTALLOC, index);
        ArrayList<Map<String, Object>> resultMap = new ArrayList<Map<String, Object>>(8);
        Map<String, Object> paramMap = this.buildParam(model, index);
        if (this.billModel.E_TAXLOCALAMT.equals(compareKey)) {
            controlValue = oldTaxLocal;
            contrastValue = amountLocalMap.get("taxlocal");
        } else if (this.billModel.E_LOCALAMT.equals(compareKey)) {
            controlValue = oldAmountLocal;
            contrastValue = amountLocalMap.get("amtlocal");
        } else {
            controlValue = oldPriceTaxLocal;
            contrastValue = amountLocalMap.get("pricetaxtotallocal");
        }
        paramMap.put("controlvalue", controlValue);
        paramMap.put("contrastvalue", contrastValue);
        resultMap.add(paramMap);
        return resultMap;
    }

    private FxLocalCalculator buildNewAmountLocalCalcutor(IDataModel model, String key, int index, BigDecimal newValue) {
        boolean isFX = (Boolean)model.getValue(this.billModel.HEAD_ISFX);
        boolean isFXLocal = (Boolean)model.getValue(this.billModel.HEAD_ISFXLOCAL);
        boolean isFXPriceTaxTotal = (Boolean)model.getValue(this.billModel.HEAD_ISFXPRICETAXTOTAL);
        boolean inputTax = this.billModel.E_TAXLOCALAMT.equals(key);
        boolean inputAmount = this.billModel.E_LOCALAMT.equals(key);
        BigDecimal oldTaxLocal = (BigDecimal)model.getValue(this.billModel.E_TAXLOCALAMT, index);
        BigDecimal oldAmountLocal = (BigDecimal)model.getValue(this.billModel.E_LOCALAMT, index);
        BigDecimal entryTaxLocal = inputTax ? newValue : oldTaxLocal;
        BigDecimal entryAmountLocal = inputAmount ? newValue : oldAmountLocal;
        BigDecimal entryPriceTaxLocal = (BigDecimal)model.getValue(this.billModel.E_PRICETAXTOTALLOC, index);
        BigDecimal entryAdjustlocalamt = (BigDecimal)model.getValue(this.billModel.E_ADJUSTLOCALAMT, index);
        return new FxLocalCalculator(entryTaxLocal, entryAmountLocal, entryPriceTaxLocal, entryAdjustlocalamt, isFX, isFXPriceTaxTotal, isFXLocal, inputTax, inputAmount);
    }

    private AbstractPriceCalculator buildAmountCalcutor(IDataModel model, DynamicObject currency, boolean includeTax, boolean isPriceTotal, int index, String key, BigDecimal newValue) {
        AbstractPriceCalculator calculator;
        boolean isPresent = (Boolean)model.getValue(this.billModel.E_ISPRESENT, index);
        BigDecimal qty = (BigDecimal)model.getValue(this.billModel.E_QUANTITY, index);
        BigDecimal taxRate = (BigDecimal)model.getValue(this.billModel.E_TAXRATE, index);
        String discountMode = (String)model.getValue(this.billModel.E_DISCOUNTMODE, index);
        BigDecimal discountRate = (BigDecimal)model.getValue(this.billModel.E_DISCOUNTRATE, index);
        BigDecimal discountAmt = (BigDecimal)model.getValue(this.billModel.E_DISCOUNTAMOUNT, index);
        DynamicObject entry = (DynamicObject)model.getEntryEntity(this.billModel.ENTRY).get(0);
        boolean existProperty = EntityMetadataUtils.isExistProperty(entry, this.billModel.E_ADJUSTAMOUNT);
        BigDecimal adjustamount = BigDecimal.ZERO;
        if (existProperty) {
            adjustamount = (BigDecimal)model.getValue(this.billModel.E_ADJUSTAMOUNT, index);
        }
        int precision = 2;
        if (currency != null) {
            precision = currency.getInt("amtprecision");
        }
        if (includeTax) {
            if (isPriceTotal && !isPresent) {
                BigDecimal priceTaxTotal = (BigDecimal)model.getValue(this.billModel.E_PRICETAXTOTAL, index);
                calculator = new PriceTaxTotalCalculator(qty, priceTaxTotal, taxRate, discountMode, discountRate, precision, adjustamount, discountAmt);
            } else {
                BigDecimal taxUnitPrice = (BigDecimal)model.getValue(this.billModel.E_TAXUNITPRICE, index);
                calculator = new TaxUnitPriceCalculator(qty, taxUnitPrice, taxRate, discountMode, discountRate, precision, adjustamount, discountAmt);
            }
        } else if (isPriceTotal && !isPresent) {
            BigDecimal amount = this.billModel.E_AMOUNT.equals(key) ? newValue : (BigDecimal)model.getValue(this.billModel.E_AMOUNT, index);
            calculator = new PriceTotalCalculator(qty, amount, taxRate, discountMode, discountRate, precision, adjustamount, discountAmt);
        } else {
            BigDecimal unitPrice = (BigDecimal)model.getValue(this.billModel.E_UNITPRICE, index);
            calculator = new UnitPriceCalculator(qty, unitPrice, taxRate, discountMode, discountRate, precision, adjustamount, discountAmt);
        }
        return calculator;
    }

    private Map<Long, List<Long>> buildMaterialGroupMap(IDataModel model) {
        DynamicObject materialGroup;
        DynamicObject material;
        long materialId;
        Object value = model.getValue(this.billModel.E_MATERIAL);
        if (value != null && !this.materialIdToMaterialgroup.containsKey(materialId = (material = (DynamicObject)value).getLong("id")) && materialId != 0L && !ObjectUtils.isEmpty((Object)(materialGroup = QueryServiceHelper.queryOne((String)"bd_materialgroupdetail", (String)"material,group", (QFilter[])new QFilter[]{new QFilter("material", "=", (Object)materialId)})))) {
            Long queryMaterialId = materialGroup.getLong("material");
            List<Long> materialGroupIds = this.materialIdToMaterialgroup.get(queryMaterialId);
            if (materialGroupIds == null) {
                materialGroupIds = new ArrayList<Long>(16);
                materialGroupIds.add(materialGroup.getLong("group"));
                this.materialIdToMaterialgroup.put(queryMaterialId, materialGroupIds);
            } else {
                materialGroupIds.add(materialGroup.getLong("group"));
            }
        }
        return this.materialIdToMaterialgroup;
    }

    private boolean isToToleranceValidator() {
        this.isTaxLocal = this.isToToleranceTypeValidator(this.billModel.E_TAXLOCALAMT, this.billModel.E_TAXLOCALAMT);
        this.isAmtLocal = this.isToToleranceTypeValidator(this.billModel.E_LOCALAMT, this.billModel.E_LOCALAMT);
        this.isPriceTaxLocal = this.isToToleranceTypeValidator(this.billModel.E_PRICETAXTOTALLOC, this.billModel.E_PRICETAXTOTALLOC);
        return !this.isTaxLocal && !this.isAmtLocal && !this.isPriceTaxLocal;
    }

    private boolean isToToleranceTypeValidator(String controlitem, String contrastitem) {
        DynamicObjectCollection entryColl = this.toleranceScheme.getDynamicObjectCollection("entry");
        boolean enable = false;
        for (DynamicObject entry : entryColl) {
            DynamicObject toleranceType = entry.getDynamicObject("e_tolerancetypeid");
            String queryControlitem = toleranceType.getString("controlitem");
            String queryContrastitem = toleranceType.getString("contrastitem");
            if (!contrastitem.equals(queryContrastitem) || !controlitem.equals(queryControlitem)) continue;
            enable = toleranceType.getBoolean("enable");
            break;
        }
        return enable;
    }
}

