/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.form;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.filter.SchemeFilterColumn;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.list.BillList;
import kd.bos.list.IListColumn;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.arapcommon.helper.FilterColumnHelper;
import kd.fi.arapcommon.util.EmptyUtils;
import kd.fi.arapcommon.vo.FilterColumnSetting;

public class GlImportLogList
extends AbstractListPlugin {
    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        Object schemePk = this.getView().getFormShowParameter().getCustomParam("schemeid");
        if (schemePk != null) {
            e.getQFilters().add(new QFilter("schemeid", "=", schemePk));
        }
    }

    public void beforeCreateListColumns(BeforeCreateListColumnsArgs args) {
        super.beforeCreateListColumns(args);
        String appid = this.getView().getFormShowParameter().getAppId();
        List listColumns = args.getListColumns();
        for (int i = listColumns.size() - 1; i >= 0; --i) {
            IListColumn column = (IListColumn)listColumns.get(i);
            if ("ap".equals(appid) && ("arbusbillcount".equals(column.getListFieldKey()) || "arfinbillcount".equals(column.getListFieldKey()) || "receivedbillcount".equals(column.getListFieldKey()))) {
                listColumns.remove(column);
            }
            if (!"ar".equals(appid) || !"apbusbillcount".equals(column.getListFieldKey()) && !"apfinbillcount".equals(column.getListFieldKey()) && !"paidbillcount".equals(column.getListFieldKey())) continue;
            listColumns.remove(column);
        }
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        super.billListHyperLinkClick(args);
        String fieldName = args.getHyperLinkClickEvent().getFieldName();
        BillList billList = (BillList)args.getHyperLinkClickEvent().getSource();
        Object pkId = billList.getFocusRowPkId();
        DynamicObject rowData = QueryServiceHelper.queryOne((String)"ar_glimportlog", (String)"schemeid,org", (QFilter[])new QFilter[]{new QFilter("id", "=", pkId)});
        long orgid = rowData.getLong("org");
        long schemePk = rowData.getLong("schemeid");
        String entitykey = GlImportLogList.getImpCountFieldMapping().get(fieldName);
        if (EmptyUtils.isNotEmpty(entitykey)) {
            args.setCancel(true);
            DynamicObjectCollection billdatas = QueryServiceHelper.query((String)"ar_glimportbill", (String)"billid", (QFilter[])new QFilter[]{new QFilter("schemeid", "=", (Object)schemePk), new QFilter("entitykey", "=", (Object)entitykey)});
            List billids = billdatas.stream().map(e -> e.getLong("billid")).collect(Collectors.toList());
            ListShowParameter listShowParameter = new ListShowParameter();
            listShowParameter.setBillFormId(entitykey);
            listShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            ListFilterParameter filterParam = new ListFilterParameter();
            ArrayList<QFilter> filters = new ArrayList<QFilter>();
            filters.add(new QFilter("id", "in", billids));
            filters.add(new QFilter("org", "=", (Object)orgid));
            filterParam.setQFilters(filters);
            listShowParameter.setListFilterParameter(filterParam);
            HashMap<String, Object> customParams = new HashMap<String, Object>();
            customParams.put("commonfiltercolumns", FilterColumnHelper.toMap(this.setCommonFilterSetting(entitykey, filters)));
            customParams.put("isopenbyhyperlink", Boolean.TRUE);
            customParams.put("isPeriod", "true");
            listShowParameter.setCustomParams(customParams);
            this.getView().showForm((FormShowParameter)listShowParameter);
        }
        if ("schemeid_number".equals(fieldName)) {
            args.setCancel(true);
            BillShowParameter param = new BillShowParameter();
            param.setPkId((Object)schemePk);
            param.setStatus(OperationStatus.VIEW);
            param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            param.setFormId("ar_glimportscheme");
            this.getPageCache().put("createOrg", String.valueOf(orgid));
            this.getView().showForm((FormShowParameter)param);
        }
    }

    private static Map<String, String> getImpCountFieldMapping() {
        HashMap<String, String> fieldMapping = new HashMap<String, String>(6);
        fieldMapping.put("apbusbillcount", "ap_busbill");
        fieldMapping.put("apfinbillcount", "ap_finapbill");
        fieldMapping.put("paidbillcount", "ap_paidbill");
        fieldMapping.put("arbusbillcount", "ar_busbill");
        fieldMapping.put("arfinbillcount", "ar_finarbill");
        fieldMapping.put("receivedbillcount", "ar_receivedbill");
        return fieldMapping;
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        String appid = this.getView().getFormShowParameter().getAppId();
        List schemeFilterColumns = args.getFilterContainerInitEvent().getSchemeFilterColumns();
        Iterator schemeIterator = schemeFilterColumns.iterator();
        while (schemeIterator.hasNext()) {
            SchemeFilterColumn filterColumn = (SchemeFilterColumn)schemeIterator.next();
            String fieldName = filterColumn.getFieldName();
            if ("ap".equals(appid) && ("arbusbillcount".equals(fieldName) || "arfinbillcount".equals(fieldName) || "receivedbillcount".equals(fieldName))) {
                schemeIterator.remove();
            }
            if (!"ar".equals(appid) || !"apbusbillcount".equals(fieldName) && !"apfinbillcount".equals(fieldName) && !"paidbillcount".equals(fieldName)) continue;
            schemeIterator.remove();
        }
    }

    private List<FilterColumnSetting> setCommonFilterSetting(String entityKey, List<QFilter> filters) {
        ArrayList<FilterColumnSetting> filterInfos = new ArrayList<FilterColumnSetting>();
        for (QFilter filter : filters) {
            FilterColumnSetting filterInfo;
            String property = filter.getProperty();
            if (!"org".equals(property) || (filterInfo = FilterColumnHelper.createCommonFilterSetting(filter, entityKey)) == null) continue;
            filterInfos.add(filterInfo);
        }
        return filterInfos;
    }
}

