/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.form;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.list.column.AbstractColumnDesc;
import kd.bos.entity.operate.result.OperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.list.BillList;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.arapcommon.util.EmptyUtils;

public class GlImportSchemeList
extends AbstractListPlugin {
    private static final Log logger = LogFactory.getLog(GlImportSchemeList.class);

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String key = evt.getItemKey();
        switch (key.toLowerCase(Locale.ENGLISH)) {
            case "bar_execute": {
                this.invokeExecute();
                break;
            }
            case "viewlog": {
                BillList list = (BillList)this.getView().getControl("billlistap");
                ListSelectedRowCollection selectedRows = list.getSelectedRows();
                Object[] primaryKeys = selectedRows.getPrimaryKeyValues();
                if (primaryKeys.length == 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"GlImportSchemeList_3", (String)"fi-arapcommon", (Object[])new Object[0]));
                    break;
                }
                if (primaryKeys.length > 1) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5355\u6761\u6570\u636e\u8054\u67e5\u3002", (String)"GlImportSchemeList_4", (String)"fi-arapcommon", (Object[])new Object[0]));
                    break;
                }
                ListShowParameter listShowParameter = new ListShowParameter();
                listShowParameter.setBillFormId("ar_glimportlog");
                listShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                long pk = (Long)selectedRows.get(0).getPrimaryKeyValue();
                listShowParameter.setCustomParam("schemeid", (Object)pk);
                this.getView().showForm((FormShowParameter)listShowParameter);
            }
        }
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        String appid = this.getView().getFormShowParameter().getAppId();
        List qFilters = e.getQFilters();
        QFilter q = new QFilter("appid", "=", (Object)appid);
        qFilters.add(q);
    }

    private void invokeExecute() {
        BillList billList = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        Set pkSet = selectedRows.stream().map(ListSelectedRow::getPrimaryKeyValue).collect(Collectors.toSet());
        if (pkSet.size() != 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5355\u6761\u6570\u636e\u64cd\u4f5c\u3002", (String)"GlImportSchemeList_0", (String)"fi-arapcommon", (Object[])new Object[0]));
            return;
        }
        String createOrg = this.getPageCache().get("createOrg");
        if (EmptyUtils.isEmpty(createOrg)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u201c\u7ed3\u7b97\u7ec4\u7ec7\u201d\u4e3a\u7a7a\uff0c\u8bf7\u7ef4\u62a4\u3002", (String)"GlImportSchemeList_1", (String)"fi-arapcommon", (Object[])new Object[0]));
            return;
        }
        long createOrgId = Long.parseLong(createOrg);
        DynamicObject useorg = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_org", (String)"name", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)createOrgId)});
        DynamicObjectCollection datas = QueryServiceHelper.query((String)"ar_glimportscheme", (String)"entry.e_account.id", (QFilter[])new QFilter[]{new QFilter("id", "in", pkSet)});
        Set accountPks = datas.stream().map(i -> i.getLong("entry.e_account.id")).collect(Collectors.toSet());
        QFilter qFilter = new QFilter("org", "=", (Object)createOrgId);
        QFilter acFilter = new QFilter("account", "in", accountPks);
        DynamicObjectCollection glimports = QueryServiceHelper.query((String)"ar_glimportbill", (String)"account.fullname,entitykey,billid", (QFilter[])new QFilter[]{qFilter, acFilter});
        if (glimports.size() > 0) {
            Set accounts = glimports.stream().map(e -> e.getString("account.fullname")).collect(Collectors.toSet());
            this.getView().showConfirm(String.format(ResManager.loadKDString((String)"\u7ed3\u7b97\u7ec4\u7ec7\uff1a%1$s \u5df2\u5b58\u5728\u4ece\u79d1\u76ee%2$s\u5bfc\u5165\u7684\u671f\u521d\u5355\u636e\uff0c\u518d\u6b21\u5bfc\u5165\u5c06\u5220\u9664\u8fd9\u4e9b\u5355\u636e\u91cd\u65b0\u751f\u6210\u3002\u662f\u5426\u7ee7\u7eed\u5bfc\u5165\uff1f", (String)"GlImportSchemeList_2", (String)"fi-arapcommon", (Object[])new Object[0]), useorg.getString("name"), String.join((CharSequence)",", accounts)), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("execute"));
        } else {
            OperateOption option = OperateOption.create();
            option.setVariableValue("useorg", this.getPageCache().get("createOrg"));
            this.getView().invokeOperation("execute", option);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        super.confirmCallBack(e);
        String callBackID = e.getCallBackId();
        boolean isOK = Objects.equals(MessageBoxResult.Yes, e.getResult());
        if (Objects.equals(callBackID, "execute") && isOK) {
            OperateOption option = OperateOption.create();
            option.setVariableValue("useorg", this.getPageCache().get("createOrg"));
            this.getView().invokeOperation("execute", option);
        }
    }

    public void packageData(PackageDataEvent e) {
        super.packageData(e);
        AbstractColumnDesc column = (AbstractColumnDesc)e.getSource();
        String columnName = column.getFieldKey();
        String createOrg = this.getPageCache().get("createOrg");
        if ("useorg.name".equals(columnName) && EmptyUtils.isNotEmpty(createOrg)) {
            long createOrgId = Long.parseLong(createOrg);
            QFilter qFilter = new QFilter("id", "=", (Object)createOrgId);
            DynamicObject useorg = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_org", (String)"name", (QFilter[])new QFilter[]{qFilter});
            e.setFormatValue((Object)useorg.getString("name"));
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        AbstractOperate op = (AbstractOperate)args.getSource();
        OperationResult opResult = args.getOperationResult();
        String operateKey = op.getOperateKey().toLowerCase(Locale.ENGLISH);
        if ("execute".equals(operateKey) && !opResult.isShowMessage()) {
            if (opResult.isSuccess()) {
                this.getView().showSuccessNotification(opResult.getMessage());
            } else {
                HashMap<String, Object> customParam = new HashMap<String, Object>(2);
                customParam.put("title", opResult.getMessage());
                customParam.put("errorMsg", opResult.getAllErrorInfo().stream().map(OperateInfo::getMessage).collect(Collectors.toList()));
                FormShowParameter parameter = new FormShowParameter();
                parameter.setFormId("bos_operationresult");
                parameter.getOpenStyle().setShowType(ShowType.Modal);
                parameter.getCustomParams().putAll(customParam);
                parameter.setShowTitle(false);
                this.getView().showForm(parameter);
            }
        }
    }
}

