/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.form;

import java.util.EventObject;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.report.ReportShowParameter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.arapcommon.util.EmptyUtils;

public class HealthCheckFormPlugin
extends AbstractFormPlugin
implements HyperLinkClickListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entry");
        entryGrid.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void hyperLinkClick(HyperLinkClickEvent arg0) {
        Integer rowIndex = arg0.getRowIndex();
        Object billId = this.getModel().getValue("e_billid", rowIndex.intValue());
        Object billType = this.getModel().getValue("e_billtype");
        if (EmptyUtils.isNotEmpty(billId) && EmptyUtils.isNotEmpty(billType)) {
            if (billType.equals("ccm_analyse_sum_rpt")) {
                DynamicObjectCollection bills = QueryServiceHelper.query((String)"ccm_archive", (String)"scheme.id,dimension.id,role0,role1,role2,role3", (QFilter[])new QFilter[]{new QFilter("id", "=", billId)});
                if (bills.size() > 0) {
                    DynamicObject bill = (DynamicObject)bills.get(0);
                    Long schemeid = bill.getLong("scheme.id");
                    Long dimensionId = bill.getLong("dimension.id");
                    Long role0 = bill.getLong("role0");
                    Long role1 = bill.getLong("role1");
                    Long role2 = bill.getLong("role2");
                    Long role3 = bill.getLong("role3");
                    ReportShowParameter parameter = new ReportShowParameter();
                    parameter.setFormId(billType.toString());
                    parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                    ReportQueryParam queryParam = new ReportQueryParam();
                    FilterInfo filterInfo = queryParam.getFilter();
                    filterInfo.addFilterItem("scheme_s", (Object)schemeid, "=");
                    filterInfo.addFilterItem("dimension_s", (Object)dimensionId, "=");
                    filterInfo.addFilterItem("role0_s", (Object)role0, "=");
                    filterInfo.addFilterItem("role1_s", (Object)role1, "=");
                    filterInfo.addFilterItem("role2_s", (Object)role2, "=");
                    filterInfo.addFilterItem("role3_s", (Object)role3, "=");
                    parameter.setQueryParam(queryParam);
                    parameter.setHasRight(true);
                    this.getView().showForm((FormShowParameter)parameter);
                }
            } else {
                BillShowParameter formshowParameter = new BillShowParameter();
                formshowParameter.setFormId(billType.toString());
                formshowParameter.getOpenStyle().setInlineStyleCss(new StyleCss());
                formshowParameter.setPkId(billId);
                formshowParameter.getOpenStyle().setShowType(ShowType.Modal);
                formshowParameter.setBillStatus(BillOperationStatus.VIEW);
                this.getView().showForm((FormShowParameter)formshowParameter);
            }
        }
    }
}

